/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;

public class PmpmTaskListFormPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(PmpmTaskListFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map paramMap = showParameter.getCustomParams();
        String projectId = (String)paramMap.get("projectId");
        String completionStatus = (String)paramMap.get("completionStatus");
        if (StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue()) || StringUtils.equals((CharSequence)completionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"percent"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"realendtime", "realtimedeviation"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"percent"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"realendtime", "realtimedeviation"});
        }
        QFilter commonFilter = this.getCommonFilter();
        QFilter completionStatusFilter = new QFilter("completionstatus", "=", (Object)completionStatus);
        Object controlLevels = paramMap.get("controllevels");
        QFilter planEndTimeFilter = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Object beginDate = paramMap.get("beginDate");
        Object endDate = paramMap.get("endDate");
        if (beginDate != null && endDate != null) {
            try {
                beginDate = sdf.parse((String)beginDate);
                endDate = sdf.parse((String)endDate);
            }
            catch (ParseException e1) {
                logger.error((Throwable)e1);
            }
            QFilter largeFirstDayOfRange = new QFilter("planendtime", ">=", beginDate);
            QFilter lessLastDayOfRange = new QFilter("planendtime", "<=", endDate);
            planEndTimeFilter = largeFirstDayOfRange.and(lessLastDayOfRange);
        }
        QFilter controlLevelsFilter = null;
        if (controlLevels != null) {
            controlLevelsFilter = new QFilter("controllevel", "in", controlLevels);
        }
        QFilter planTypeFilter = null;
        Object planTypes = paramMap.get("plantypes");
        if (planTypes != null) {
            planTypeFilter = new QFilter("belongplantype.plantype", "in", planTypes);
        }
        QFilter taskTypeFilter = null;
        Object taskTypes = paramMap.get("tasktypes");
        if (taskTypes != null) {
            taskTypeFilter = new QFilter("tasktype", "in", taskTypes);
        }
        if (projectId == null) {
            DynamicObject[] taskArr;
            String[] dutyArr;
            String orgId = (String)paramMap.get("orgId");
            boolean containsub = (Boolean)paramMap.get("containsub");
            List<Long> orgIdList = new ArrayList<Long>();
            orgIdList.add(Long.valueOf(orgId));
            if (containsub) {
                orgIdList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgIdList, (boolean)true);
            }
            String dutys = (String)paramMap.get("dutys");
            QFilter orgFilter = null;
            if (StringUtils.isNotBlank((CharSequence)dutys) && (dutyArr = dutys.split(",")).length == 0) {
                QFilter responsibleDeptFilter = new QFilter("responsibledept", "in", orgIdList);
                QFilter cooperationdeptFilter = new QFilter("cooperationdept", "in", orgIdList);
                orgFilter = responsibleDeptFilter.or(cooperationdeptFilter);
            }
            if (dutys == null || StringUtils.contains((CharSequence)dutys, (CharSequence)"1") && StringUtils.contains((CharSequence)dutys, (CharSequence)"2")) {
                QFilter responsibleDeptFilter = new QFilter("responsibledept", "in", orgIdList);
                DynamicObject[] cooperationdeptFilter = new QFilter("cooperationdept", "in", orgIdList);
                orgFilter = responsibleDeptFilter.or((QFilter)cooperationdeptFilter);
            } else if (StringUtils.contains((CharSequence)dutys, (CharSequence)"1")) {
                orgFilter = new QFilter("responsibledept", "in", orgIdList);
            } else if (StringUtils.contains((CharSequence)dutys, (CharSequence)"2")) {
                orgFilter = new QFilter("cooperationdept", "in", orgIdList);
            }
            for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,name,percent", (QFilter[])new QFilter[]{completionStatusFilter, orgFilter, controlLevelsFilter, planTypeFilter, commonFilter, taskTypeFilter, planEndTimeFilter})) {
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("task", dynamicObject.getPkValue(), rowIndex);
                this.getModel().setValue("percent", (Object)dynamicObject.getBigDecimal("percent").divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), rowIndex);
            }
        } else {
            DynamicObject[] taskArr;
            QFilter notFenJieFilter = new QFilter("belongplantype.plantype", "!=", (Object)PlanTypeEnum.DEPTFENJIEPLAN.getValue());
            QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
            for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,name,percent", (QFilter[])new QFilter[]{completionStatusFilter, projectFilter, controlLevelsFilter, planTypeFilter, taskTypeFilter, notFenJieFilter, planEndTimeFilter, commonFilter})) {
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("task", dynamicObject.getPkValue(), rowIndex);
                this.getModel().setValue("percent", (Object)dynamicObject.getBigDecimal("percent").divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), rowIndex);
            }
        }
        this.getView().updateView("entryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent paramHyperLinkClickEvent) {
        String fieldName = paramHyperLinkClickEvent.getFieldName();
        int rowIndex = paramHyperLinkClickEvent.getRowIndex();
        if (StringUtils.equals((CharSequence)"task", (CharSequence)fieldName)) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            DynamicObject task = (DynamicObject)this.getModel().getValue("task", rowIndex);
            if (task != null) {
                paramMap.put("formId", "pmpm_reporttaskview");
                paramMap.put("pkId", String.valueOf(task.getPkValue()));
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    private QFilter getCommonFilter() {
        QFilter sourceTaskFilter = new QFilter("sourcetask", "=", (Object)"0");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        return sourceTaskFilter.and(statusFilter);
    }
}

