/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.model.pmpm.PmpmWorkhoursConstant;
import kd.pmgt.pmbs.business.model.pmpm.PmpmWorkhoursListConstant;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmpm.formplugin.model.PlanTaskModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class PmpmWorkHoursListPlugin
extends AbstractListPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(PmpmWorkHoursListPlugin.class);
    private static final String BUTTONSTATUSPREFIX = "btn_status_";
    private static final String BUTTONPLANFINISHDATEPREFIX = "btn_planfinishdate_";
    private static final String BUTTONFROMTYPEPREFIX = "btn_fromtype_";
    private static final String DATERANGEPREFIX = "daterangefield_";
    private static final String ENTRYCOLUMNKEYPREFIX = "day_";
    private static final String PLANENDTIMEBEGIN = "planendtime_begin";
    private static final String PLANENDTIMEEND = "planendtime_end";
    private static final String BUTTONREFRESH = "buttonrefresh";
    private static final String BUTTONLASTWEEK = "buttonlastweek";
    private static final String BUTTONTHISWEEK = "buttonthisweek";
    private static final String BUTTONNEXTWEEK = "buttonnextweek";
    private static final List<String> PLAN_FINISHDATE_LIST = Stream.of("btn_planfinishdate_0", "btn_planfinishdate_1", "btn_planfinishdate_2", "btn_planfinishdate_3", "btn_planfinishdate_4").collect(Collectors.toList());

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String oldWeek = this.getPageCache().get("week");
        if (StringUtils.isEmpty((CharSequence)oldWeek)) {
            this.setPageCache("week", PmpmWorkhoursListConstant.WeekParam.THISWEEK.getValue());
            this.setWeekDaysCache();
            this.updateWeekButtonStyle(PmpmWorkhoursListConstant.WeekParam.THISWEEK);
            this.initQueryBtnSelected();
        }
        this.refreshDataGrid();
    }

    private void initQueryBtnSelected() {
        int i;
        this.getPageCache().put("btn_status_0", "false");
        this.getPageCache().put("btn_planfinishdate_0", "true");
        this.getPageCache().put("btn_fromtype_0", "true");
        this.updateBtnSelectedStyle("btn_status_0", false);
        this.updateBtnSelectedStyle("btn_planfinishdate_0", true);
        this.updateBtnSelectedStyle("btn_fromtype_0", true);
        this.getPageCache().put("btn_status_2", "true");
        this.getPageCache().put("btn_status_3", "true");
        this.getPageCache().put("btn_status_6", "true");
        for (i = 1; i <= 6; ++i) {
            if (i == 2 || i == 3 || i == 6) {
                this.updateBtnSelectedStyle(BUTTONSTATUSPREFIX + i, true);
                continue;
            }
            this.updateBtnSelectedStyle(BUTTONSTATUSPREFIX + i, false);
        }
        for (i = 1; i <= 5; ++i) {
            this.updateBtnSelectedStyle(BUTTONPLANFINISHDATEPREFIX + i, false);
        }
        for (i = 1; i <= 5; ++i) {
            this.updateBtnSelectedStyle(BUTTONFROMTYPEPREFIX + i, false);
        }
    }

    public void registerListener(EventObject e) {
        int i;
        super.registerListener(e);
        Button button1 = (Button)this.getView().getControl(BUTTONREFRESH);
        button1.addClickListener((ClickListener)this);
        Button button2 = (Button)this.getView().getControl(BUTTONLASTWEEK);
        button2.addClickListener((ClickListener)this);
        Button button3 = (Button)this.getView().getControl(BUTTONTHISWEEK);
        button3.addClickListener((ClickListener)this);
        Button button4 = (Button)this.getView().getControl(BUTTONNEXTWEEK);
        button4.addClickListener((ClickListener)this);
        for (i = 0; i <= 6; ++i) {
            Button status = (Button)this.getView().getControl(BUTTONSTATUSPREFIX + i);
            status.addClickListener((ClickListener)this);
        }
        for (i = 0; i <= 5; ++i) {
            Button planfinishdate = (Button)this.getView().getControl(BUTTONPLANFINISHDATEPREFIX + i);
            planfinishdate.addClickListener((ClickListener)this);
        }
        for (i = 0; i <= 5; ++i) {
            Button fromtype = (Button)this.getView().getControl(BUTTONFROMTYPEPREFIX + i);
            fromtype.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BUTTONREFRESH.equals(key)) {
            this.refreshDataGrid();
        } else if (BUTTONLASTWEEK.equals(key)) {
            this.handleLastWeekClickEvent();
            this.refreshDataGrid();
        } else if (BUTTONTHISWEEK.equals(key)) {
            this.handleThisWeekClickEvent();
            this.refreshDataGrid();
        } else if (BUTTONNEXTWEEK.equals(key)) {
            this.handleNextWeekClickEvent();
            this.refreshDataGrid();
        } else if (key != null && key.startsWith(BUTTONSTATUSPREFIX)) {
            boolean flag = this.getInvertSelectdValue(key);
            if (!flag && "btn_status_0".equals(key)) {
                this.getPageCache().put(key, "true");
            } else {
                this.handleStatusChangeEvent(key, flag);
                this.refreshDataGrid();
            }
        } else if (key != null && key.startsWith(BUTTONPLANFINISHDATEPREFIX)) {
            if ("btn_planfinishdate_5".equals(key)) {
                return;
            }
            boolean flag = this.getInvertSelectdValue(key);
            if (!flag && "btn_planfinishdate_0".equals(key)) {
                this.getPageCache().put(key, "true");
            } else {
                this.handlePlanfinishdateChangeEvent(key, flag);
                this.refreshDataGrid();
            }
        } else if (key != null && key.startsWith(BUTTONFROMTYPEPREFIX)) {
            boolean flag = this.getInvertSelectdValue(key);
            if (!flag && "btn_fromtype_0".equals(key)) {
                this.getPageCache().put(key, "true");
            } else {
                this.handleFromTypeChangeEvent(key, flag);
                this.refreshDataGrid();
            }
        }
    }

    private boolean getInvertSelectdValue(String key) {
        boolean flag;
        String s = this.getPageCache().get(key);
        if ("true".equals(s)) {
            flag = false;
            this.getPageCache().put(key, "false");
        } else {
            flag = true;
            this.getPageCache().put(key, "true");
        }
        return flag;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name == null) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        if (name.startsWith(ENTRYCOLUMNKEYPREFIX)) {
            int rowIndex = valueSet[0].getRowIndex();
            DynamicObject task = (DynamicObject)this.getModel().getValue("task", rowIndex);
            Object pkValue = task.getPkValue();
            Object newValue = valueSet[0].getNewValue();
            if (newValue != null) {
                this.saveOrUpdateWorkHour(pkValue, name, (BigDecimal)newValue);
            }
            BigDecimal sum = BigDecimal.ZERO;
            for (int i = 1; i <= 7; ++i) {
                String columKey = ENTRYCOLUMNKEYPREFIX + i;
                BigDecimal hour = (BigDecimal)this.getModel().getValue(columKey, rowIndex);
                sum = sum.add(hour);
            }
            this.getModel().setValue("daysum", (Object)sum, rowIndex);
        } else if (name.startsWith(DATERANGEPREFIX)) {
            this.refreshDataGrid();
        }
    }

    private void saveOrUpdateWorkHour(Object pkValue, String name, BigDecimal workhour) {
        String userId = RequestContext.get().getUserId();
        Date workdate = this.getChangedColumnDate(Integer.parseInt(name.split(ENTRYCOLUMNKEYPREFIX)[1]));
        ArrayList<QFilter> qlist = new ArrayList<QFilter>(10);
        qlist.add(new QFilter("workdate", "=", (Object)workdate));
        qlist.add(new QFilter("creator", "=", (Object)userId));
        qlist.add(new QFilter("task", "=", pkValue));
        DynamicObject[] old = BusinessDataServiceHelper.load((String)"pmpm_workhours", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,task,workdate,hour", (QFilter[])qlist.toArray(new QFilter[qlist.size()]), (String)"modifytime desc");
        DynamicObject workHourObject = new DynamicObject(PmpmWorkhoursConstant.dt);
        Date currentDate = DateUtil.getCurrentDate();
        if (old.length > 0) {
            workHourObject = old[0];
            workHourObject.set("hour", (Object)workhour);
            workHourObject.set("modifier", (Object)userId);
            workHourObject.set("modifytime", (Object)currentDate);
        } else {
            workHourObject.set("hour", (Object)workhour);
            workHourObject.set("modifytime", (Object)currentDate);
            workHourObject.set("modifier", (Object)userId);
            workHourObject.set("creator", (Object)userId);
            workHourObject.set("createtime", (Object)currentDate);
            workHourObject.set("enable", (Object)EnableEnum.ENABLE.getValue());
            workHourObject.set("workdate", (Object)workdate);
            workHourObject.set("status", (Object)StatusEnum.CHECKED.getValue());
            workHourObject.set("task", pkValue);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{workHourObject});
    }

    private Date getChangedColumnDate(int column) {
        String daysStr = "";
        String week = this.getPageCache().get("week");
        if (week.equals(PmpmWorkhoursListConstant.WeekParam.THISWEEK.getValue())) {
            daysStr = this.getPageCache().get("THIS_WEEK_DAYS");
        } else if (week.equals(PmpmWorkhoursListConstant.WeekParam.NEXTWEEK.getValue())) {
            daysStr = this.getPageCache().get("NEXT_WEEK_DAYS");
        } else if (week.equals(PmpmWorkhoursListConstant.WeekParam.LASTWEEK.getValue())) {
            daysStr = this.getPageCache().get("LAST_WEEK_DAYS");
        }
        return DateUtil.parseShortDate((String)daysStr.split(",")[column - 1]);
    }

    private void setHeaderTitle() {
        Object s;
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        List fieldEdits = grid.getFieldEdits();
        ArrayList<LocaleString> titles = new ArrayList<LocaleString>(10);
        String[] split = null;
        String week = this.getPageCache().get("week");
        if (week.equals(PmpmWorkhoursListConstant.WeekParam.THISWEEK.getValue())) {
            s = this.getPageCache().get("THIS_WEEK_DAYS_SHORT");
            split = ((String)s).split(",");
        } else if (week.equals(PmpmWorkhoursListConstant.WeekParam.LASTWEEK.getValue())) {
            s = this.getPageCache().get("LAST_WEEK_DAYS_SHORT");
            split = ((String)s).split(",");
        } else if (week.equals(PmpmWorkhoursListConstant.WeekParam.NEXTWEEK.getValue())) {
            s = this.getPageCache().get("NEXT_WEEK_DAYS_SHORT");
            split = ((String)s).split(",");
        }
        if (split != null) {
            for (String dayShort : split) {
                titles.add(new LocaleString("zh_CN", dayShort));
            }
            for (int i = 0; i < 7; ++i) {
                FieldEdit fieldEdit = (FieldEdit)fieldEdits.get(i + 4);
                grid.setColumnProperty(fieldEdit.getFieldKey(), "header", titles.get(i));
            }
        }
    }

    private void refreshDataGrid() {
        this.updatePlanEndRangeFilter();
        this.setHeaderTitle();
        LinkedHashMap<String, Object> filterMap = new LinkedHashMap<String, Object>();
        List<QFilter> filters = this.getQueryFilter(filterMap);
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,controllevel,majortype,tasktype,absoluteduration,pretask,logical,relativeduration,responsibleperson,responsibledept,taskresultdocentry.id,taskresultdocentry.seq,taskresultdocentry.resultname,taskresultdocentry.force,taskresultdocentry.frequency,taskresultdocentry.resultdescription,taskreferdocentry.id,taskreferdocentry.attachmentfield,taskreferdocentry.description,taskreferdocentry.referdocname,taskreferdocentry.seq,project,plans,sourcetask,prechangetask,sharer,comment,percent,completionstatus,taskseq,achievementnode,realendtime,comptimedeviation,resultdoc,version,planstarttime,planendtime,aimfinishtime,cooperationperson,cooperationdept,belongplantype,realtimedeviation", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        List<PlanTaskModel> firstTaskList = this.queryTaskWithReport(filterMap);
        List<PlanTaskModel> secondTaskIds = this.getSortedTaskDynamicObject(dynamicObject);
        List<PlanTaskModel> thirdTaskList = this.queryTaskWithDelayedTasked(filterMap);
        List<PlanTaskModel> tasks = this.getUnionTasks(firstTaskList, secondTaskIds, thirdTaskList);
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        for (PlanTaskModel task : tasks) {
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("task", (Object)task.getId(), row);
            this.getModel().setValue("majortype", (Object)task.getPlanTypeView(), row);
            this.getModel().setValue("completionstatus", (Object)task.getCompleteStatus(), row);
            DynamicObject[] taskHours = this.queryTaskHours(task.getId());
            this.fillCellValueAndStyle(row, taskHours);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private List<PlanTaskModel> queryTaskWithDelayedTasked(Map<String, Object> filterMap) {
        Date planendtimeend;
        Date planendtimebegin;
        Object majortypes;
        Date begin = DateUtil.parseShortDate((String)this.getPageCache().get("WEEKFIRSTDAY"));
        StringBuilder sql = new StringBuilder("SELECT tab.FID,tab.FPLANSTARTTIME,tab.FPLANENDTIME,tab.FCOMPLETIONSTATUS,tab.FREALENDTIME,tab.FPLANTYPE,tab.FREALPLANCOMPLETETIME FROM ( select a.FID,a.FPLANSTARTTIME,a.FPLANENDTIME,a.FCOMPLETIONSTATUS,a.FREALENDTIME,m.FPLANTYPE,max(r.FCOMPLETETIME) as FREALPLANCOMPLETETIME from T_PMPM_TASK a LEFT JOIN T_PMPM_MAJORTYPE m ON a.FBELONGPLANTYPEID=m.FID LEFT JOIN T_PMPM_TASKREPORT r ON a.FID=r.FTASKID AND r.FLATEST='1' WHERE a.FCREATORID=? and a.FSOURCETASKID=0 and a.FSTATUS='C' AND a.FPLANENDTIME<? ");
        String weekQuery = this.getPageCache().get("week");
        boolean isNextWeek = false;
        if (weekQuery.equals(PmpmWorkhoursListConstant.WeekParam.NEXTWEEK.getValue())) {
            isNextWeek = true;
        }
        String groupBySql = " GROUP BY a.FID,a.FPLANSTARTTIME,a.FPLANENDTIME,a.FCOMPLETIONSTATUS,a.FREALENDTIME,m.FPLANTYPE ) tab WHERE (tab.FREALENDTIME  >= ?  OR (TAB.FREALENDTIME IS NULL AND  TAB.FREALPLANCOMPLETETIME IS null ) OR (TAB.FREALENDTIME IS NULL AND     TAB.FREALPLANCOMPLETETIME IS NOT null" + (isNextWeek ? "   AND (TAB.FREALPLANCOMPLETETIME >= ? OR TAB.FREALPLANCOMPLETETIME <= ? )" : " ") + " )) ";
        ArrayList<Comparable<Long>> paramsList = new ArrayList<Comparable<Long>>(10);
        paramsList.add(Long.valueOf(RequestContext.get().getUserId()));
        paramsList.add(begin);
        Object statuses = filterMap.get("completionstatus");
        if (statuses != null) {
            sql.append(" AND a.FCOMPLETIONSTATUS in (").append(StringUtils.join((Iterable)((List)statuses), (char)',')).append(')');
        }
        if ((majortypes = filterMap.get("majortype")) != null) {
            sql.append(" AND m.FPLANTYPE in (").append(StringUtils.join((Iterable)((List)majortypes), (char)',')).append(')');
        }
        if ((planendtimebegin = (Date)filterMap.get(PLANENDTIMEBEGIN)) != null) {
            sql.append(" AND a.FPLANENDTIME >? ");
            paramsList.add(planendtimebegin);
        }
        if ((planendtimeend = (Date)filterMap.get(PLANENDTIMEEND)) != null) {
            sql.append(" AND a.FPLANENDTIME <? ");
            paramsList.add(planendtimeend);
        }
        sql.append(groupBySql);
        paramsList.add(begin);
        if (isNextWeek) {
            paramsList.add(begin);
            paramsList.add(DateUtil.parseShortDate((String)DateUtil.formatShortDate((Date)DateUtil.getCurrentDate())));
        }
        Object[] params = paramsList.toArray(new Object[paramsList.size()]);
        String dbRouteKey = PmpmWorkhoursConstant.dt.getDBRouteKey();
        List taskList = (List)DB.query((DBRoute)new DBRoute(dbRouteKey), (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<PlanTaskModel>>(){

            public List<PlanTaskModel> handle(ResultSet rs) throws Exception {
                ArrayList<PlanTaskModel> result = new ArrayList<PlanTaskModel>(10);
                while (rs.next()) {
                    PlanTaskModel temp = new PlanTaskModel();
                    temp.setId(rs.getLong("fid"));
                    temp.setPlanEndDate(rs.getDate("fplanendtime"));
                    temp.setPlanStartDate(rs.getDate("fplanstarttime"));
                    temp.setCompleteStatus(rs.getString("fcompletionstatus"));
                    temp.setPlanType(rs.getString("fplantype"));
                    result.add(temp);
                }
                return result;
            }
        });
        return taskList;
    }

    private List<PlanTaskModel> getUnionTasks(List<PlanTaskModel> firstTasks, List<PlanTaskModel> secondTasks, List<PlanTaskModel> thirdTaskList) {
        TreeSet<PlanTaskModel> set = new TreeSet<PlanTaskModel>((o1, o2) -> {
            if ((int)(o1.getPlanStartDate().getTime() - o2.getPlanStartDate().getTime()) == 0) {
                return o1.getId().compareTo(o2.getId());
            }
            return (int)(o1.getPlanStartDate().getTime() - o2.getPlanStartDate().getTime());
        });
        ArrayList<PlanTaskModel> tasks = new ArrayList<PlanTaskModel>(10);
        if (thirdTaskList != null && thirdTaskList.size() > 0) {
            set.addAll(thirdTaskList);
        }
        if (firstTasks != null && firstTasks.size() > 0) {
            set.addAll(firstTasks);
        }
        if (secondTasks != null && secondTasks.size() > 0) {
            set.addAll(secondTasks);
        }
        tasks.addAll(set);
        return tasks;
    }

    private List<PlanTaskModel> getSortedTaskDynamicObject(DynamicObject[] dynamicObject) {
        List<Object> list = new ArrayList(10);
        ArrayList<PlanTaskModel> tasks = new ArrayList<PlanTaskModel>(10);
        if (dynamicObject != null && dynamicObject.length > 0) {
            list = Arrays.asList(dynamicObject);
        }
        list.forEach(d -> {
            PlanTaskModel temp = new PlanTaskModel();
            temp.setId(d.getLong("id"));
            temp.setPlanEndDate(d.getDate("planendtime"));
            temp.setPlanStartDate(d.getDate("planstarttime"));
            temp.setCompleteStatus(d.getString("completionstatus"));
            DynamicObject majortype = d.getDynamicObject("belongplantype");
            temp.setPlanType(majortype == null ? "" : majortype.getString("plantype"));
            tasks.add(temp);
        });
        return tasks;
    }

    private List<PlanTaskModel> queryTaskWithReport(Map<String, Object> filterMap) {
        Date planendtimeend;
        Object majortypes;
        Date end = DateUtil.getEndDayTime((Date)DateUtil.parseShortDate((String)this.getPageCache().get("WEEKLASTDAY")));
        StringBuilder sql = new StringBuilder("select a.FID,a.FPLANSTARTTIME,a.FPLANENDTIME,a.FCOMPLETIONSTATUS,m.FPLANTYPE from T_PMPM_TASK a LEFT JOIN T_PMPM_MAJORTYPE m ON a.FBELONGPLANTYPEID=m.FID WHERE a.FCREATORID=? and a.FSOURCETASKID=0 and a.FSTATUS='C' AND a.FPLANSTARTTIME > ? AND EXISTS(SELECT b.FID FROM T_PMPM_TASKREPORT b WHERE b.FTASKID=a.FID AND b.FCREATETIME <=?)");
        Object statuses = filterMap.get("completionstatus");
        if (statuses != null) {
            sql.append(" AND a.FCOMPLETIONSTATUS in (").append(StringUtils.join((Iterable)((List)statuses), (char)',')).append(')');
        }
        if ((majortypes = filterMap.get("majortype")) != null) {
            sql.append(" AND m.FPLANTYPE in (").append(StringUtils.join((Iterable)((List)majortypes), (char)',')).append(')');
        }
        ArrayList<Comparable<Long>> paramsList = new ArrayList<Comparable<Long>>(10);
        paramsList.add(Long.valueOf(RequestContext.get().getUserId()));
        paramsList.add(end);
        paramsList.add(end);
        Date planendtimebegin = (Date)filterMap.get(PLANENDTIMEBEGIN);
        if (planendtimebegin != null) {
            sql.append(" AND a.FPLANENDTIME >=?");
            paramsList.add(planendtimebegin);
        }
        if ((planendtimeend = (Date)filterMap.get(PLANENDTIMEEND)) != null) {
            sql.append(" AND a.FPLANENDTIME <=?");
            paramsList.add(planendtimeend);
        }
        Object[] params = paramsList.toArray(new Object[paramsList.size()]);
        sql.append(" group by a.FID,a.FPLANSTARTTIME,a.FPLANENDTIME,a.FCOMPLETIONSTATUS,m.FPLANTYPE ");
        String dbRouteKey = PmpmWorkhoursConstant.dt.getDBRouteKey();
        List taskList = (List)DB.query((DBRoute)new DBRoute(dbRouteKey), (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<PlanTaskModel>>(){

            public List<PlanTaskModel> handle(ResultSet rs) throws Exception {
                ArrayList<PlanTaskModel> result = new ArrayList<PlanTaskModel>(10);
                while (rs.next()) {
                    PlanTaskModel temp = new PlanTaskModel();
                    temp.setId(rs.getLong("fid"));
                    temp.setPlanEndDate(rs.getDate("fplanendtime"));
                    temp.setPlanStartDate(rs.getDate("fplanstarttime"));
                    temp.setCompleteStatus(rs.getString("fcompletionstatus"));
                    temp.setPlanType(rs.getString("fplantype"));
                    result.add(temp);
                }
                return result;
            }
        });
        return taskList;
    }

    private void fillCellValueAndStyle(int row, DynamicObject[] taskHours) {
        String weekDaysCache = this.getWeekDaysCache();
        String[] split = weekDaysCache.split(",");
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        BigDecimal sum = new BigDecimal(0);
        for (int i = 1; i <= 7; ++i) {
            String columKey = ENTRYCOLUMNKEYPREFIX + i;
            BigDecimal hour = new BigDecimal(0);
            String day = split[i - 1];
            for (DynamicObject taskHour : taskHours) {
                Date workDate = (Date)taskHour.get("workdate");
                if (!day.equals(DateUtil.formatShortDate((Date)workDate))) continue;
                hour = (BigDecimal)taskHour.get("hour");
                break;
            }
            this.getModel().setValue(columKey, (Object)hour, row);
            sum = sum.add(hour);
            String today = DateUtil.formatShortDate((Date)DateUtil.getCurrentDate());
            int compareTo = day.compareTo(today);
            if (compareTo != 0) continue;
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(row);
            cellStyle.setFieldKey(columKey);
            cellStyle.setBackColor("#ffffaa");
            cellStyles.add(cellStyle);
            grid.setCellStyle(cellStyles);
        }
        this.getModel().setValue("daysum", (Object)sum, row);
    }

    private String getWeekDaysCache() {
        String s = "";
        String week = this.getPageCache().get("week");
        if (week.equals(PmpmWorkhoursListConstant.WeekParam.THISWEEK.getValue())) {
            s = this.getPageCache().get("THIS_WEEK_DAYS");
        } else if (week.equals(PmpmWorkhoursListConstant.WeekParam.LASTWEEK.getValue())) {
            s = this.getPageCache().get("LAST_WEEK_DAYS");
        } else if (week.equals(PmpmWorkhoursListConstant.WeekParam.NEXTWEEK.getValue())) {
            s = this.getPageCache().get("NEXT_WEEK_DAYS");
        }
        return s;
    }

    private void updateBtnSelectedStyle(String key, boolean isSelected) {
        HashMap<String, Object> propertiesMapSelected = new HashMap<String, Object>(16);
        propertiesMapSelected.put("fc", "#5e80eb");
        propertiesMapSelected.put("bc", "#F3F8FF");
        HashMap<String, String> selectedborder = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> selectedstyle = new HashMap<String, HashMap<String, String>>(16);
        selectedborder.put("b", "1px_solid_#5e80eb");
        selectedborder.put("l", "1px_solid_#5e80eb");
        selectedborder.put("r", "1px_solid_#5e80eb");
        selectedborder.put("t", "1px_solid_#5e80eb");
        selectedstyle.put("b", selectedborder);
        propertiesMapSelected.put("s", selectedstyle);
        HashMap<String, Object> propertiesMapUnSelected = new HashMap<String, Object>(16);
        HashMap<String, String> unselectedborder = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> unselectedstyle = new HashMap<String, HashMap<String, String>>(16);
        unselectedborder.put("b", "1px_solid_#F3F8FF");
        unselectedborder.put("l", "1px_solid_#F3F8FF");
        unselectedborder.put("r", "1px_solid_#F3F8FF");
        unselectedborder.put("t", "1px_solid_#F3F8FF");
        unselectedstyle.put("b", unselectedborder);
        propertiesMapUnSelected.put("fc", "#8d929f");
        propertiesMapUnSelected.put("bc", "#F3F8FF");
        propertiesMapUnSelected.put("s", unselectedstyle);
        this.getView().updateControlMetadata(key, isSelected ? propertiesMapSelected : propertiesMapUnSelected);
    }

    private DynamicObject[] queryTaskHours(Long taskId) {
        ArrayList<QFilter> qlist = new ArrayList<QFilter>(10);
        qlist.add(new QFilter("creator", "=", (Object)RequestContext.get().getUserId()));
        qlist.add(new QFilter("task", "=", (Object)taskId));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String week = this.getPageCache().get("week");
        Date begin = null;
        Date end = null;
        try {
            if (week.equals(PmpmWorkhoursListConstant.WeekParam.THISWEEK.getValue())) {
                String this_week_days = this.getPageCache().get("THIS_WEEK_DAYS");
                begin = simpleDateFormat.parse(this_week_days.split(",")[0]);
                end = simpleDateFormat.parse(this_week_days.split(",")[6]);
            } else if (week.equals(PmpmWorkhoursListConstant.WeekParam.LASTWEEK.getValue())) {
                String last_week_days = this.getPageCache().get("LAST_WEEK_DAYS");
                begin = simpleDateFormat.parse(last_week_days.split(",")[0]);
                end = simpleDateFormat.parse(last_week_days.split(",")[6]);
            } else if (week.equals(PmpmWorkhoursListConstant.WeekParam.NEXTWEEK.getValue())) {
                String next_week_days = this.getPageCache().get("NEXT_WEEK_DAYS");
                begin = simpleDateFormat.parse(next_week_days.split(",")[0]);
                end = simpleDateFormat.parse(next_week_days.split(",")[6]);
            }
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        if (end != null) {
            qlist.add(new QFilter("workdate", ">=", begin));
        }
        if (end != null) {
            qlist.add(new QFilter("workdate", "<=", end));
        }
        return BusinessDataServiceHelper.load((String)"pmpm_workhours", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,task,workdate,hour", (QFilter[])qlist.toArray(new QFilter[qlist.size()]), (String)"workdate asc,modifytime desc");
    }

    private List<QFilter> getQueryFilter(Map<String, Object> filterMap) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        this.setStatusFilter(filterList, filterMap);
        this.setPlanFinishDateFilter(filterList, filterMap);
        this.setFromTypeFilter(filterList, filterMap);
        this.setTaskPlanBeginAndPlanEndFilter(filterList);
        this.setUserIdFilter(filterList);
        filterList.add(new QFilter("sourcetask", "=", (Object)0));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        return filterList;
    }

    private void setUserIdFilter(List<QFilter> filterList) {
        String userId = RequestContext.get().getUserId();
        filterList.add(new QFilter("responsibleperson", "=", (Object)userId).or(new QFilter("cooperationperson", "=", (Object)userId)));
    }

    private void setTaskPlanBeginAndPlanEndFilter(List<QFilter> filterList) {
        Date now = DateUtil.getCurrentDate();
        Date monday = null;
        Date sunday = null;
        String week = this.getPageCache().get("week");
        if (PmpmWorkhoursListConstant.WeekParam.THISWEEK.getValue().equals(week)) {
            monday = DateUtil.getThisWeekMonday((Date)now);
            sunday = DateUtil.getThisWeekSunDay((Date)now);
        } else if (PmpmWorkhoursListConstant.WeekParam.LASTWEEK.getValue().equals(week)) {
            monday = DateUtil.getLastWeekMonday((Date)now);
            sunday = DateUtil.getLastWeekSunday((Date)now);
        } else if (PmpmWorkhoursListConstant.WeekParam.NEXTWEEK.getValue().equals(week)) {
            monday = DateUtil.getNextWeekMonday((Date)now);
            sunday = DateUtil.getNextWeekSunday((Date)now);
        }
        this.getPageCache().put("WEEKFIRSTDAY", DateUtil.formatShortDate((Date)DateUtils.addDays((Date)monday, (int)-1)));
        this.getPageCache().put("WEEKLASTDAY", DateUtil.formatShortDate((Date)DateUtils.addDays((Date)sunday, (int)-1)));
        filterList.add(new QFilter("planstarttime", "<=", (Object)DateUtils.addDays((Date)sunday, (int)-1)));
        filterList.add(new QFilter("planendtime", ">=", (Object)DateUtils.addDays((Date)monday, (int)-1)));
    }

    private void setFromTypeFilter(List<QFilter> filterList, Map<String, Object> filterMap) {
        boolean value = this.isBtnSelectdValue("btn_fromtype_0");
        ArrayList<String> fromTypeList = new ArrayList<String>(10);
        if (!value) {
            boolean value5;
            boolean value4;
            boolean value3;
            boolean value2;
            boolean value1 = this.isBtnSelectdValue("btn_fromtype_1");
            if (value1) {
                fromTypeList.add(PlanTypeEnum.MAINPLAN.getValue());
            }
            if (value2 = this.isBtnSelectdValue("btn_fromtype_2")) {
                fromTypeList.add(PlanTypeEnum.MAJORPLAN.getValue());
            }
            if (value3 = this.isBtnSelectdValue("btn_fromtype_3")) {
                fromTypeList.add(PlanTypeEnum.DEPTPLAN.getValue());
            }
            if (value4 = this.isBtnSelectdValue("btn_fromtype_4")) {
                fromTypeList.add(PlanTypeEnum.PRIVATEPLAN.getValue());
            }
            if (value5 = this.isBtnSelectdValue("btn_fromtype_5")) {
                fromTypeList.add(PlanTypeEnum.DEPTFENJIEPLAN.getValue());
            }
        }
        if (fromTypeList.size() > 0) {
            filterList.add(new QFilter("belongplantype.plantype", "in", fromTypeList));
            filterMap.put("majortype", fromTypeList);
        }
    }

    private void setPlanFinishDateFilter(List<QFilter> filterList, Map<String, Object> filterMap) {
        Date now = DateUtil.getCurrentDate();
        boolean value = this.isBtnSelectdValue("btn_planfinishdate_0");
        Date beginDate = null;
        Date endDate = null;
        if (!value) {
            beginDate = (Date)this.getModel().getValue("daterangefield_startdate");
            endDate = (Date)this.getModel().getValue("daterangefield_enddate");
            if (beginDate == null && endDate == null) {
                boolean value4;
                boolean value3;
                boolean value2;
                boolean value1 = this.isBtnSelectdValue("btn_planfinishdate_1");
                if (value1) {
                    beginDate = DateUtils.addDays((Date)DateUtil.getThisWeekMonday((Date)now), (int)-1);
                    endDate = DateUtils.addDays((Date)DateUtil.getThisWeekSunDay((Date)now), (int)-1);
                }
                if (value2 = this.isBtnSelectdValue("btn_planfinishdate_2")) {
                    beginDate = DateUtils.addDays((Date)DateUtil.getNextWeekMonday((Date)now), (int)-1);
                    endDate = DateUtils.addDays((Date)DateUtil.getNextWeekSunday((Date)now), (int)-1);
                }
                if (value3 = this.isBtnSelectdValue("btn_planfinishdate_3")) {
                    beginDate = DateUtil.getFirstDayOfThisMonth((Date)now);
                    endDate = DateUtil.getLastDayOfThisMonth((Date)now);
                }
                if (value4 = this.isBtnSelectdValue("btn_planfinishdate_4")) {
                    beginDate = DateUtil.getFirstDayOfNextMonth((Date)now);
                    endDate = DateUtil.getLastDayOfNextMonth((Date)now);
                }
            }
            if (beginDate != null) {
                filterList.add(new QFilter("planendtime", ">=", (Object)beginDate));
                filterMap.put(PLANENDTIMEBEGIN, beginDate);
            }
            if (endDate != null) {
                filterList.add(new QFilter("planendtime", "<=", (Object)DateUtil.getEndDayTime((Date)endDate)));
                filterMap.put(PLANENDTIMEEND, endDate);
            }
        }
    }

    private void setStatusFilter(List<QFilter> filterList, Map<String, Object> filterMap) {
        boolean value = this.isBtnSelectdValue("btn_status_0");
        ArrayList<String> statuslist = new ArrayList<String>(10);
        if (!value) {
            boolean value6;
            boolean value5;
            boolean value4;
            boolean value3;
            boolean value2;
            boolean value1 = this.isBtnSelectdValue("btn_status_1");
            if (value1) {
                statuslist.add(CompletionStatusEnum.UNSTART.getValue());
            }
            if (value2 = this.isBtnSelectdValue("btn_status_2")) {
                statuslist.add(CompletionStatusEnum.PROGRESSING.getValue());
            }
            if (value3 = this.isBtnSelectdValue("btn_status_3")) {
                statuslist.add(CompletionStatusEnum.OVERDUE.getValue());
            }
            if (value4 = this.isBtnSelectdValue("btn_status_4")) {
                statuslist.add(CompletionStatusEnum.ONTIMECOMPLETE.getValue());
            }
            if (value5 = this.isBtnSelectdValue("btn_status_5")) {
                statuslist.add(CompletionStatusEnum.OVERDUECOMPLETE.getValue());
            }
            if (value6 = this.isBtnSelectdValue("btn_status_6")) {
                statuslist.add(CompletionStatusEnum.ESTIMATEDELAY.getValue());
            }
        }
        if (statuslist.size() > 0) {
            filterList.add(new QFilter("completionstatus", "in", statuslist));
            filterMap.put("completionstatus", statuslist);
        }
    }

    private boolean isBtnSelectdValue(String key) {
        String s = this.getPageCache().get(key);
        boolean f = "true".equals(s);
        return f;
    }

    private void handleNextWeekClickEvent() {
        this.setPageCache("week", PmpmWorkhoursListConstant.WeekParam.NEXTWEEK.getValue());
        this.updateWeekButtonStyle(PmpmWorkhoursListConstant.WeekParam.NEXTWEEK);
    }

    private void handleThisWeekClickEvent() {
        this.setPageCache("week", PmpmWorkhoursListConstant.WeekParam.THISWEEK.getValue());
        this.updateWeekButtonStyle(PmpmWorkhoursListConstant.WeekParam.THISWEEK);
    }

    private void handleLastWeekClickEvent() {
        this.setPageCache("week", PmpmWorkhoursListConstant.WeekParam.LASTWEEK.getValue());
        this.updateWeekButtonStyle(PmpmWorkhoursListConstant.WeekParam.LASTWEEK);
    }

    private void setWeekDaysCache() {
        Date now = DateUtil.getCurrentDate();
        Date thisWeekMonday = DateUtil.getThisWeekMonday((Date)now);
        Date thisWeekSunDay = DateUtil.getThisWeekSunDay((Date)now);
        Date lastWeekMonday = DateUtil.getLastWeekMonday((Date)now);
        Date lastWeekSunday = DateUtil.getLastWeekSunday((Date)now);
        Date nextWeekMonday = DateUtil.getNextWeekMonday((Date)now);
        Date nextWeekSunday = DateUtil.getNextWeekSunday((Date)now);
        Map<String, List<String>> days = PmpmWorkHoursListPlugin.getDays(DateUtils.addDays((Date)thisWeekMonday, (int)-1), DateUtils.addDays((Date)thisWeekSunDay, (int)-1));
        this.setPageCache("THIS_WEEK_DAYS", StringUtils.join((Iterable)days.get("days"), (String)","));
        this.setPageCache("THIS_WEEK_DAYS_SHORT", StringUtils.join((Iterable)days.get("shortdays"), (String)","));
        Map<String, List<String>> days1 = PmpmWorkHoursListPlugin.getDays(DateUtils.addDays((Date)lastWeekMonday, (int)-1), DateUtils.addDays((Date)lastWeekSunday, (int)-1));
        this.setPageCache("LAST_WEEK_DAYS", StringUtils.join((Iterable)days1.get("days"), (String)","));
        this.setPageCache("LAST_WEEK_DAYS_SHORT", StringUtils.join((Iterable)days1.get("shortdays"), (String)","));
        Map<String, List<String>> days2 = PmpmWorkHoursListPlugin.getDays(DateUtils.addDays((Date)nextWeekMonday, (int)-1), DateUtils.addDays((Date)nextWeekSunday, (int)-1));
        this.setPageCache("NEXT_WEEK_DAYS", StringUtils.join((Iterable)days2.get("days"), (String)","));
        this.setPageCache("NEXT_WEEK_DAYS_SHORT", StringUtils.join((Iterable)days2.get("shortdays"), (String)","));
    }

    public static Map<String, List<String>> getDays(Date start, Date end) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        ArrayList<String> days = new ArrayList<String>(10);
        ArrayList<String> shortdays = new ArrayList<String>(10);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        tempEnd.add(5, 1);
        while (tempStart.before(tempEnd)) {
            String format = dateFormat.format(tempStart.getTime());
            days.add(format);
            shortdays.add(DateUtil.monthDayClearZero((String)format));
            tempStart.add(6, 1);
        }
        result.put("days", days);
        result.put("shortdays", shortdays);
        return result;
    }

    private void updateWeekButtonStyle(PmpmWorkhoursListConstant.WeekParam selectedBtnValue) {
        HashMap<String, String> propertiesMapSelected = new HashMap<String, String>(16);
        propertiesMapSelected.put("bc", "#56aaff");
        propertiesMapSelected.put("fc", "#ffffff");
        HashMap<String, String> propertiesMapUnSelected = new HashMap<String, String>(16);
        propertiesMapUnSelected.put("bc", "#e5e5e5");
        propertiesMapUnSelected.put("fc", "#000000");
        switch (selectedBtnValue) {
            case LASTWEEK: {
                this.getView().updateControlMetadata(BUTTONLASTWEEK, propertiesMapSelected);
                this.getView().updateControlMetadata(BUTTONTHISWEEK, propertiesMapUnSelected);
                this.getView().updateControlMetadata(BUTTONNEXTWEEK, propertiesMapUnSelected);
                break;
            }
            case THISWEEK: {
                this.getView().updateControlMetadata(BUTTONTHISWEEK, propertiesMapSelected);
                this.getView().updateControlMetadata(BUTTONLASTWEEK, propertiesMapUnSelected);
                this.getView().updateControlMetadata(BUTTONNEXTWEEK, propertiesMapUnSelected);
                break;
            }
            case NEXTWEEK: {
                this.getView().updateControlMetadata(BUTTONNEXTWEEK, propertiesMapSelected);
                this.getView().updateControlMetadata(BUTTONTHISWEEK, propertiesMapUnSelected);
                this.getView().updateControlMetadata(BUTTONLASTWEEK, propertiesMapUnSelected);
            }
        }
    }

    private void setPageCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private void clearOtherPlanfinishdateFilter(String name) {
        PLAN_FINISHDATE_LIST.forEach(d -> {
            if (!d.equals(name)) {
                this.getPageCache().put(d, "false");
                this.updateBtnSelectedStyle((String)d, false);
            }
        });
    }

    private void handleFromTypeChangeEvent(String name, boolean propValue) {
        this.updateBtnSelectedStyle(name, propValue);
        if ("btn_fromtype_0".equals(name)) {
            if (propValue) {
                this.clearFromTypeFilter();
            }
        } else if (propValue) {
            this.resetFromTypeFilterSwitch(false);
        }
        if (!propValue && this.needResetFromTypeFilterSwitch()) {
            this.resetFromTypeFilterSwitch(true);
        }
    }

    private void handlePlanfinishdateChangeEvent(String name, boolean propValue) {
        this.updateBtnSelectedStyle(name, propValue);
        if (propValue) {
            this.clearOtherPlanfinishdateFilter(name);
            this.getModel().beginInit();
            this.getModel().setValue("daterangefield_startdate", null);
            this.getModel().setValue("daterangefield_enddate", null);
            this.getModel().endInit();
            this.getView().updateView();
        }
        if (!propValue && this.needResetPlanfinishdateFilterSwitch()) {
            this.getPageCache().put("btn_planfinishdate_0", "true");
            this.updateBtnSelectedStyle("btn_planfinishdate_0", true);
        }
    }

    private void updatePlanEndRangeFilter() {
        Optional<String> first;
        Object start = this.getModel().getValue("daterangefield_startdate");
        Object end = this.getModel().getValue("daterangefield_enddate");
        if (start != null || end != null) {
            PLAN_FINISHDATE_LIST.forEach(d -> {
                this.setPageCache((String)d, "false");
                this.updateBtnSelectedStyle((String)d, false);
            });
        }
        if (!(start != null && end != null || (first = PLAN_FINISHDATE_LIST.stream().filter(d -> "true".equals(this.getPageCache().get(d))).findFirst()).isPresent())) {
            this.setPageCache("btn_planfinishdate_0", "true");
            this.updateBtnSelectedStyle("btn_planfinishdate_0", true);
        }
    }

    private void handleStatusChangeEvent(String name, boolean propValue) {
        this.updateBtnSelectedStyle(name, propValue);
        if ("btn_status_0".equals(name)) {
            if (propValue) {
                this.clearStatusFilter();
            }
        } else if (propValue) {
            this.resetStatusFilterSwitch(false);
        }
        if (!propValue && this.needResetStatusFilterSwitch()) {
            this.resetStatusFilterSwitch(true);
        }
    }

    private boolean needResetFromTypeFilterSwitch() {
        boolean f = true;
        for (int i = 1; i <= 5; ++i) {
            String value = this.getPageCache().get(BUTTONFROMTYPEPREFIX + i);
            if (!"true".equals(value)) continue;
            f = false;
        }
        return f;
    }

    private boolean needResetPlanfinishdateFilterSwitch() {
        boolean f = true;
        for (int i = 1; i <= 4; ++i) {
            String value = this.getPageCache().get(BUTTONPLANFINISHDATEPREFIX + i);
            if (!"true".equals(value)) continue;
            f = false;
        }
        return f;
    }

    private boolean needResetStatusFilterSwitch() {
        boolean f = true;
        for (int i = 1; i <= 6; ++i) {
            String value = this.getPageCache().get(BUTTONSTATUSPREFIX + i);
            if (!"true".equals(value)) continue;
            f = false;
        }
        return f;
    }

    private void resetFromTypeFilterSwitch(boolean isOpen) {
        this.getPageCache().put("btn_fromtype_0", isOpen ? "true" : "false");
        this.updateBtnSelectedStyle("btn_fromtype_0", isOpen);
    }

    private void resetStatusFilterSwitch(boolean isOpen) {
        this.getPageCache().put("btn_status_0", isOpen ? "true" : "false");
        this.updateBtnSelectedStyle("btn_status_0", isOpen);
    }

    private void clearFromTypeFilter() {
        this.getPageCache().put("btn_fromtype_1", "false");
        this.getPageCache().put("btn_fromtype_2", "false");
        this.getPageCache().put("btn_fromtype_3", "false");
        this.getPageCache().put("btn_fromtype_4", "false");
        this.getPageCache().put("btn_fromtype_5", "false");
        this.updateBtnSelectedStyle("btn_fromtype_1", false);
        this.updateBtnSelectedStyle("btn_fromtype_2", false);
        this.updateBtnSelectedStyle("btn_fromtype_3", false);
        this.updateBtnSelectedStyle("btn_fromtype_4", false);
        this.updateBtnSelectedStyle("btn_fromtype_5", false);
    }

    private void clearStatusFilter() {
        this.getPageCache().put("btn_status_1", "false");
        this.getPageCache().put("btn_status_2", "false");
        this.getPageCache().put("btn_status_3", "false");
        this.getPageCache().put("btn_status_4", "false");
        this.getPageCache().put("btn_status_5", "false");
        this.getPageCache().put("btn_status_6", "false");
        this.updateBtnSelectedStyle("btn_status_1", false);
        this.updateBtnSelectedStyle("btn_status_2", false);
        this.updateBtnSelectedStyle("btn_status_3", false);
        this.updateBtnSelectedStyle("btn_status_4", false);
        this.updateBtnSelectedStyle("btn_status_5", false);
        this.updateBtnSelectedStyle("btn_status_6", false);
    }
}

