/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.business.model.pmas.ProjectConstant;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.hierarchy.DynamicObjectTreeNode;
import kd.pmgt.pmbs.common.hierarchy.Hierarchy;
import kd.pmgt.pmbs.common.hierarchy.Hierarchyable;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmBillPlugin;

public class ProImportTaskListPlugin
extends AbstractPmpmBillPlugin
implements TreeNodeClickListener,
RowClickEventListener,
ClickListener,
CellClickListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ProImportTaskListPlugin.class);
    private static final String TREEVIEW = "treeview";
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String OKBTN = "okbtn";
    private static final String CANCELBTN = "cancelbtn";
    private static final String PROJECT_SELECTPROS = "id,name,createorg";

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "majortype": {
                TreeView tree = (TreeView)this.getView().getControl(TREEVIEW);
                Map focusNodeMap = tree.getTreeState().getFocusNode();
                tree.treeNodeClick(focusNodeMap.get("parentid").toString(), focusNodeMap.get("id").toString());
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntryGrid.addRowClickListener((RowClickEventListener)this);
        treeEntryGrid.addCellClickListener((CellClickListener)this);
        Button cancelBtn = (Button)this.getView().getControl(CANCELBTN);
        cancelBtn.addClickListener((ClickListener)this);
        Button okBtn = (Button)this.getView().getControl(OKBTN);
        okBtn.addClickListener((ClickListener)this);
        BasedataEdit majortype = (BasedataEdit)this.getControl("majortype");
        majortype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String billType = (String)param.getCustomParam("billType");
        if ("majorplan".equals(billType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"majortype"});
            BasedataEdit majorTypeCtl = (BasedataEdit)this.getControl("majortype");
            majorTypeCtl.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"majortype"});
        }
        TreeView treeview = (TreeView)this.getView().getControl(TREEVIEW);
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)"pmpm");
        String userId = RequestContext.get().getUserId();
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(userId), (String)appId, (String)"pmpm_projectplan", (String)"47150e89000000ac");
        List haspPermOrgIds = hasPermOrgs.getHasPermOrgs();
        DynamicObject[] orgs = null;
        if (hasPermOrgs.hasAllOrgPerm() && haspPermOrgIds.size() == 0) {
            for (DynamicObject org : orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name,number", null)) {
                haspPermOrgIds.add(org.getLong("id"));
            }
        } else {
            orgs = BusinessDataServiceHelper.load((Object[])haspPermOrgIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
        }
        Map<Long, Long> orgRelationMap = this.setOrgRelationMap(haspPermOrgIds);
        Hierarchy tree = new Hierarchy();
        this.initTreeNodeOfOrg(orgs, orgRelationMap, tree);
        DynamicObject[] projects = this.getAllProjectOfOrgs(orgs);
        ArrayList<DynamicObject> projectList = new ArrayList<DynamicObject>(projects.length);
        this.excludeProject(projects, projectList);
        this.initTreeNodeByProject(tree, projectList);
        TreeNode root = new TreeNode(null, "-1", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ProImportTaskListPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), true);
        root.setIsOpened(true);
        treeview.addNode(root);
        treeview.focusNode(root);
        List treeNodes = tree.getAllChildren(tree.getRootNode());
        for (Hierarchyable hierarchyable : treeNodes) {
            DynamicObjectTreeNode treeNode = (DynamicObjectTreeNode)hierarchyable;
            TreeNode node = treeNode.getTreeNode();
            String color = (String)treeNode.getData().get("color");
            node.setColor(color);
            treeview.addNode(node);
            treeview.expand(node.getId());
        }
    }

    private void excludeProject(DynamicObject[] projects, List<DynamicObject> projectList) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customMap = param.getCustomParams();
        String billType = (String)param.getCustomParam("billType");
        String proId = customMap.get("proId").toString();
        for (DynamicObject project : projects) {
            if (proId.equals(project.getString("id"))) continue;
            if ("majorplan".equals(billType)) {
                DynamicObject projectKind = project.getDynamicObject("group");
                if (projectKind == null) continue;
                String projectKindId = projectKind.getString("id");
                QFilter kindFilter = new QFilter("group", "=", (Object)projectKindId);
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                DynamicObject majorType = BusinessDataServiceHelper.loadSingle((String)"pmpm_majortype", (String)"name", (QFilter[])new QFilter[]{kindFilter, enableFilter});
                if (majorType == null) continue;
            }
            projectList.add(project);
        }
    }

    private DynamicObject[] getAllProjectOfOrgs(DynamicObject[] orgs) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(orgs.length);
        for (DynamicObject org : orgs) {
            long orgId = org.getLong("id");
            orgIdList.add(orgId);
        }
        DynamicObject[] projs = ProjectPermissionHelper.getPermProjByOrgList(orgIdList, null);
        ArrayList<String> proIds = new ArrayList<String>(projs.length);
        for (DynamicObject proj : projs) {
            proIds.add(proj.getPkValue().toString());
        }
        return BusinessDataServiceHelper.load((Object[])proIds.toArray(), (DynamicObjectType)ProjectConstant.dt);
    }

    private void initTreeNodeByProject(Hierarchy tree, List<DynamicObject> projectList) {
        DynamicObjectTreeNode node = null;
        for (DynamicObject project : projectList) {
            node = new DynamicObjectTreeNode();
            node.setId(((Long)project.getPkValue()).longValue());
            node.setName(project.getString("name"));
            DynamicObject org = project.getDynamicObject("pmascreateorg");
            node.setParentId(Long.parseLong(org.getPkValue().toString()));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("color", "blue");
            node.setData(data);
            node.setValue(project);
            TreeNode projectNode = node.getTreeNode();
            projectNode.setColor("blue");
            TreeNode parentNode = ((DynamicObjectTreeNode)tree.getObject(node.getParentId())).getTreeNode();
            parentNode.addChild(0, node.getTreeNode());
        }
    }

    private void initTreeNodeOfOrg(DynamicObject[] orgs, Map<Long, Long> orgRelationMap, Hierarchy tree) {
        DynamicObjectTreeNode rootnode = new DynamicObjectTreeNode();
        rootnode.setId(-1L);
        rootnode.setName(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ProImportTaskListPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        rootnode.setValue(null);
        tree.setRootNode((Hierarchyable)rootnode);
        for (DynamicObject org : orgs) {
            DynamicObjectTreeNode node = new DynamicObjectTreeNode();
            node.setId(((Long)org.getPkValue()).longValue());
            node.setName(org.getString("name"));
            Long parentId = orgRelationMap.get(Long.valueOf(org.getPkValue().toString()));
            if (null != parentId) {
                node.setParentId(parentId.longValue());
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("color", "black");
            node.setData(data);
            node.setValue(org);
            tree.addObject((Hierarchyable)node);
        }
    }

    private Map<Long, Long> setOrgRelationMap(List<Long> haspPermOrgIds) {
        QFilter filterOrgId = new QFilter("org.id", "in", haspPermOrgIds);
        QFilter filterTreetype = new QFilter("view.treetype", "=", (Object)this.getOrgViewType());
        QFilter[] filters = new QFilter[]{filterOrgId, filterTreetype};
        Map orgrelations = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org_structure"), (QFilter[])filters);
        HashMap<Long, Long> orgRelationMap = new HashMap<Long, Long>();
        for (Map.Entry relation : orgrelations.entrySet()) {
            DynamicObject relationInfo = (DynamicObject)relation.getValue();
            if (relationInfo.get("parent.id") != null && haspPermOrgIds.contains(relationInfo.get("parent.id"))) {
                orgRelationMap.put(relationInfo.getLong("org.id"), Long.valueOf(relationInfo.get("parent.id").toString()));
                continue;
            }
            orgRelationMap.put(relationInfo.getLong("org.id"), -1L);
        }
        return orgRelationMap;
    }

    private void treeList(Object projectId, Long orgId) {
        int i;
        QFilter filter1;
        QFilter belongPlanTypeFilter;
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
        treeGrid.setCollapse(false);
        IDataModel model = treeGrid.getModel();
        model.deleteEntryData(TREEENTRYENTITY);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filterStatus = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter filterSource = new QFilter("sourcetask", "=", (Object)"0");
        QFilter filterProject = new QFilter("project", "<>", (Object)"0");
        filters.add(filterStatus);
        filters.add(filterSource);
        filters.add(filterProject);
        ArrayList<QFilter> newQfilters = new ArrayList<QFilter>();
        String billType = (String)this.getView().getFormShowParameter().getCustomParam("billType");
        if ("projectplan".equals(billType)) {
            belongPlanTypeFilter = new QFilter("belongplantype.plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
            filters.add(belongPlanTypeFilter);
            filter1 = new QFilter("level", "=", (Object)1);
            newQfilters.add(filter1);
        } else if ("majorplan".equals(billType)) {
            belongPlanTypeFilter = new QFilter("belongplantype.plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
            filters.add(belongPlanTypeFilter);
            filter1 = new QFilter("level", "=", (Object)1);
            QFilter filter2 = new QFilter("parent.belongplantype.plantype", "=", (Object)1);
            filter1.or(filter2);
            newQfilters.add(filter1);
        }
        ArrayList<Long> newOrgIdsList = new ArrayList<Long>();
        if (null != orgId) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            orgIds.add(orgId);
            List orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(this.getOrgViewType()), orgIds, (boolean)true);
            DynamicObject[] appId = BizAppServiceHelp.getAppIdByAppNumber((String)"pmpm");
            String userId = RequestContext.get().getUserId();
            HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(userId), (String)appId, (String)"pmpm_projectplan", (String)"47150e89000000ac");
            newOrgIdsList.add(orgId);
            List haspPermOrgIds = hasPermOrgs.getHasPermOrgs();
            if (hasPermOrgs.hasAllOrgPerm() && haspPermOrgIds.size() == 0) {
                DynamicObject[] orgs;
                for (DynamicObject org : orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name,number", null)) {
                    haspPermOrgIds.add(org.getLong("id"));
                }
            }
            for (Long id : orgList) {
                if (!haspPermOrgIds.contains(id)) continue;
                newOrgIdsList.add(id);
            }
        }
        if (projectId != null) {
            QFilter projectFilter = new QFilter("project", "=", projectId);
            filters.add(projectFilter);
        }
        newQfilters.addAll(filters);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,controllevel,majortype,tasktype,absoluteduration,pretask,logical,relativeduration,responsibleperson,responsibledept,taskresultdocentry.id,taskresultdocentry.seq,taskresultdocentry.resultname,taskresultdocentry.force,taskresultdocentry.frequency,taskresultdocentry.resultdescription,taskreferdocentry.id,taskreferdocentry.attachmentfield,taskreferdocentry.description,taskreferdocentry.referdocname,taskreferdocentry.seq,project,plans,sourcetask,prechangetask,sharer,comment,percent,completionstatus,taskseq,achievementnode,realendtime,comptimedeviation,resultdoc,version,planstarttime,planendtime,aimfinishtime,cooperationperson,cooperationdept,belongplantype,realtimedeviation", (QFilter[])newQfilters.toArray(new QFilter[newQfilters.size()]));
        ArrayList<DynamicObject> newTaskList = new ArrayList<DynamicObject>();
        for (DynamicObject task : tasks) {
            Long projectOrgId;
            String majortypeId;
            String filterMajortypeId;
            DynamicObject majortype;
            DynamicObject project = task.getDynamicObject("project");
            if (project == null || (project = BusinessDataServiceHelper.loadSingle((Object)project.getString("id"), (String)"bd_project")).getDynamicObject("pmascreateorg") == null || "majorplan".equals(billType) && (majortype = (DynamicObject)this.getModel().getValue("majortype")) != null && !(filterMajortypeId = majortype.getString("id")).equals(majortypeId = task.getDynamicObject("majortype").getString("id")) || !newOrgIdsList.contains(projectOrgId = Long.valueOf(project.getDynamicObject("pmascreateorg").getLong("id")))) continue;
            task.set("level", (Object)"1");
            newTaskList.add(task);
        }
        this.fillTreeList(model, newTaskList.toArray(new DynamicObject[newTaskList.size()]), 1, 0, filters);
        int rowCount = this.getModel().getEntryRowCount(TREEENTRYENTITY);
        DynamicObjectCollection datas = model.getEntryEntity(TREEENTRYENTITY);
        for (i = 0; i < rowCount; ++i) {
            model.setValue("row", (Object)i, i);
        }
        for (i = 0; i < rowCount; ++i) {
            List list;
            DynamicObject obj = model.getEntryRowEntity(TREEENTRYENTITY, i);
            DynamicObject parent = (DynamicObject)obj.get("parent");
            if (parent == null || (list = datas.stream().filter(o -> o.get("fid").equals(parent.get("id"))).collect(Collectors.toList())).isEmpty()) continue;
            model.setValue("prow", ((DynamicObject)list.get(0)).get("row"), i);
        }
    }

    private void fillTreeList(IDataModel model, DynamicObject[] objs, int level, int rowIndex, List<QFilter> filters) {
        if (objs == null || objs.length == 0) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            int rIndex = 0;
            rIndex = level == 1 ? model.createNewEntryRow(TREEENTRYENTITY) : model.insertEntryRow(TREEENTRYENTITY, rowIndex);
            TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
            grid.getModel().updateCache();
            this.getModel().setValue("taskname", (Object)objs[i].getString("id"), rIndex);
            this.getModel().setValue("parent", objs[i].get("parent"), rIndex);
            this.getModel().setValue("fid", objs[i].get("id"), rIndex);
            this.getModel().setValue("searchname", objs[i].get("name"), rIndex);
            this.getModel().setValue("level", (Object)level, rIndex);
            DynamicObject controllevel = objs[i].getDynamicObject("controllevel");
            if (null != controllevel) {
                this.getModel().setValue("searchgkjb", (Object)controllevel.getString("name"), rIndex);
            }
            QFilter parentId = new QFilter("parent", "=", objs[i].get("id"));
            ArrayList<QFilter> newQfilters = new ArrayList<QFilter>(10);
            newQfilters.addAll(filters);
            newQfilters.add(parentId);
            DynamicObject[] subTasks = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,controllevel,majortype,tasktype,absoluteduration,pretask,logical,relativeduration,responsibleperson,responsibledept,taskresultdocentry.id,taskresultdocentry.seq,taskresultdocentry.resultname,taskresultdocentry.force,taskresultdocentry.frequency,taskresultdocentry.resultdescription,taskreferdocentry.id,taskreferdocentry.attachmentfield,taskreferdocentry.description,taskreferdocentry.referdocname,taskreferdocentry.seq,project,plans,sourcetask,prechangetask,sharer,comment,percent,completionstatus,taskseq,achievementnode,realendtime,comptimedeviation,resultdoc,version,planstarttime,planendtime,aimfinishtime,cooperationperson,cooperationdept,belongplantype,realtimedeviation", (QFilter[])newQfilters.toArray(new QFilter[newQfilters.size()]));
            if (subTasks == null || subTasks.length <= 0) continue;
            this.fillTreeList(model, subTasks, level + 1, rIndex, filters);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (TREEVIEW.equals(key)) {
            Object nodeId = evt.getNodeId();
            if (this.isProjectNode(nodeId)) {
                DynamicObject project = null;
                try {
                    project = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)"bd_project", (String)PROJECT_SELECTPROS);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                if (project != null) {
                    DynamicObject org = project.getDynamicObject("createorg");
                    this.treeList(project.getString("id"), Long.valueOf(org.getString("id")));
                } else {
                    this.treeList(null, null);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u7ecf\u4e0d\u5b58\u5728\u4e86", (String)"ProImportTaskListPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getModel().deleteEntryData(TREEENTRYENTITY);
            }
        }
    }

    private boolean isProjectNode(Object nodeId) {
        DynamicObject project = null;
        try {
            project = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)"bd_project");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return project != null;
    }

    public void click(EventObject evt) {
        String btnKey;
        Button source = (Button)evt.getSource();
        switch (btnKey = source.getKey()) {
            case "okbtn": {
                this.doOkbtnClick();
                break;
            }
            case "cancelbtn": {
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    private void doOkbtnClick() {
        DynamicObject project;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
        int[] rows = treeEntryGrid.getSelectRows();
        Date planStartDate = (Date)this.getModel().getValue("planstartdate");
        DynamicObject majorType = (DynamicObject)this.getModel().getValue("majortype");
        String billType = (String)this.getView().getFormShowParameter().getCustomParam("billType");
        boolean isValid = true;
        String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e", (String)"ProImportTaskListPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
        if (planStartDate == null) {
            msg = msg + ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"ProImportTaskListPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
            isValid = false;
        }
        if (majorType == null && "majorplan".equals(billType)) {
            msg = msg + ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"ProImportTaskListPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
            isValid = false;
        }
        if (!isValid) {
            this.getView().showTipNotification(msg);
            return;
        }
        if (rows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f15\u5165\u7684\u4efb\u52a1", (String)"ProImportTaskListPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (planStartDate != null && (project = (DynamicObject)this.getView().getParentView().getModel().getValue("project")) != null) {
            Calendar proStartDate = PmpmTaskUtil.getFirstDayByProject((Object)project.getString("id"));
            Calendar proEndDate = PmpmTaskUtil.getEndDayByProject((Object)project.getString("id"));
            Calendar starteDate = Calendar.getInstance();
            starteDate.setTime(planStartDate);
            if (starteDate.compareTo(proStartDate) < 0 || starteDate.compareTo(proEndDate) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u8d85\u51fa\u65e5\u5386\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u6216\u91cd\u65b0\u8bbe\u7f6e\u65e5\u5386\u3002", (String)"ProImportTaskListPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        TreeMap<String, ArrayList<String>> map = new TreeMap<String, ArrayList<String>>();
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            DynamicObject rowObj = this.getModel().getEntryRowEntity(TREEENTRYENTITY, row);
            Integer level = (Integer)this.getModel().getValue("level", row);
            ArrayList<String> list = (ArrayList<String>)map.get(level.toString());
            if (null == list) {
                list = new ArrayList<String>();
            }
            list.add(rowObj.getDynamicObject("taskname").getString("id"));
            map.put(level.toString(), list);
        }
        this.getView().getParentView().getFormShowParameter().setCustomParam("planstartdate", (Object)planStartDate);
        this.getView().getParentView().cacheFormShowParameter();
        this.getView().returnDataToParent(map);
        this.getView().invokeOperation("close");
    }

    public void cellClick(CellClickEvent cellclickevent) {
        String fieldKey = cellclickevent.getFieldKey();
        if ("0".equals(fieldKey)) {
            this.resetSelectedRows(cellclickevent.getRow());
        }
    }

    public void resetSelectedRows(int focusRow) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
        HashMap<Object, Integer> rowMap = new HashMap<Object, Integer>();
        DynamicObjectCollection objs = treeEntryGrid.getModel().getEntryEntity(TREEENTRYENTITY);
        for (DynamicObject obj : objs) {
            rowMap.put(obj.get("fid"), obj.getInt("row"));
        }
        int[] rows = treeEntryGrid.getSelectRows();
        Set selectIds = this.getSelectedIds(rows, objs);
        int[] selectRows = new int[selectIds.size()];
        int index = 0;
        for (Object object : selectIds) {
            selectRows[index] = (Integer)rowMap.get(object.toString());
            ++index;
        }
        treeEntryGrid.selectRows(selectRows, focusRow);
        this.getModel().deleteEntryData("entryentity");
        for (Object sRow : (Object)selectRows) {
            DynamicObject rowObj = this.getModel().getEntryRowEntity(TREEENTRYENTITY, (int)sRow);
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("basedatafield", (Object)rowObj.getString("fid"), rowIndex);
        }
    }

    private Set getSelectedIds(int[] rows, DynamicObjectCollection objs) {
        LinkedHashSet<Object> selectIds = new LinkedHashSet<Object>(rows.length);
        block0: for (int row : rows) {
            DynamicObject parentTask = (DynamicObject)this.getModel().getValue("taskname", row);
            selectIds.add(parentTask.getPkValue());
            HashSet<String> fatherSet = new HashSet<String>(16);
            DynamicObject curParent = (DynamicObject)this.getModel().getValue("parent", row);
            if (null == curParent) continue;
            fatherSet.add(curParent.getPkValue().toString());
            for (int pp = row - 1; pp >= 0; --pp) {
                DynamicObject pParent;
                String ppTaskid;
                DynamicObject ppTask = (DynamicObject)this.getModel().getValue("taskname", pp);
                String string = ppTaskid = ppTask == null ? "" : ppTask.getString("id");
                if (!fatherSet.contains(ppTaskid)) continue;
                if (ppTask != null) {
                    selectIds.add(ppTask.getPkValue());
                }
                if (null == (pParent = (DynamicObject)this.getModel().getValue("parent", row))) continue block0;
                fatherSet.add(pParent.getPkValue().toString());
            }
        }
        return selectIds;
    }

    public void cellDoubleClick(CellClickEvent cellclickevent) {
    }

    public void entryRowClick(RowClickEvent rowclickevent) {
        super.entryRowClick(rowclickevent);
        this.resetSelectedRows(rowclickevent.getRow());
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String propName;
        switch (propName = arg.getProperty().getName()) {
            case "majortype": {
                TreeView tree = (TreeView)this.getView().getControl(TREEVIEW);
                String focusNodeId = tree.getTreeState().getFocusNodeId();
                ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().clear();
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                ArrayList<String> majorTypeIdList = new ArrayList<String>();
                if (this.isProjectNode(focusNodeId)) {
                    QFilter idFilter = new QFilter("id", "=", (Object)focusNodeId);
                    DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"group", (QFilter[])new QFilter[]{idFilter});
                    String kindId = project.getDynamicObject("group").getString("id");
                    QFilter kindFilter = new QFilter("group", "=", (Object)kindId);
                    DynamicObject[] majorTypes = BusinessDataServiceHelper.load((String)"pmpm_majortype", (String)"id", (QFilter[])new QFilter[]{kindFilter, enableFilter});
                    for (int i = 0; i < majorTypes.length; ++i) {
                        majorTypeIdList.add(majorTypes[i].getString("id"));
                    }
                }
                QFilter filter = new QFilter("id", "in", (Object)majorTypeIdList.toArray(new String[majorTypeIdList.size()]));
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
        }
    }
}

