/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.ProPermissionHelper;
import kd.pmgt.pmbs.formplugin.AbstractPmbsFormPlugin;

public class ProOperationalReportPlugin
extends AbstractPmbsFormPlugin
implements HyperLinkClickListener {
    private static final Long TASKTYPE_CRUXNODE_ID = 681750946157443072L;
    private static final String chartTitleName = "chartTitleName";
    private static final String planEnd = "planEnd";
    private static final String unStart = "unStart";
    private static final String progressing = "progressing";
    private static final String onTimeEnd = "onTimeEnd";
    private static final String overTimeEnd = "overTimeEnd";
    private static final String overTimeNotEnd = "overTimeNotEnd";
    private static final String estimateDelay = "estimateDelay";
    private static final String xAxisList = "xAxisList";
    private static final String realDataList = "realDataList";
    private static final String planEndQtyList = "planEndList";
    private static final String leftpiedata = "leftpiedata";
    private static final String rightpiedata = "rightpiedata";
    private static final String leftbardata = "leftbardata";
    private static final String rightbardata = "rightbardata";
    private static final String colorap = "colorap";
    private static final String tasknamelabel = "tasknamelabel";
    private static final String planendtimeap = "planendtimeap";
    private static final String cruxtasknodeap = "cruxtasknodeap";
    private static final String rightarrowap = "rightarrowap";
    private static final String leftarrowap = "leftarrowap";
    private static final List<String> ExluproStatus = Stream.of(ProjectStatusEnum.APPROVAL_IN.getValue(), ProjectStatusEnum.APPROVAL_FAIL.getValue()).collect(Collectors.toList());

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object project = this.getView().getFormShowParameter().getCustomParam("projectId");
        Object orgId = this.getView().getFormShowParameter().getCustomParam("orgId");
        if (orgId != null && StringUtils.isNotBlank((Object)orgId)) {
            Map projMap = ProPermissionHelper.getEntityPermProj((Object)orgId, (boolean)true, ExluproStatus, (boolean)true, (String)this.getView().getEntityId(), (String)"new");
            Set projectIdSet = projMap.keySet();
            for (Object object : projectIdSet) {
                if (project == null || !StringUtils.equals((CharSequence)object.toString(), (CharSequence)project.toString())) continue;
                this.getModel().setValue("project", project);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        for (int i = 0; i < 10; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{cruxtasknodeap + i});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalanalysisap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"cruxap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"processap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"thiscycleap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"nextcycleap"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tipap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipap"});
        }
        DynamicObject thisModel = this.getModel().getDataEntity();
        boolean isFormDb = thisModel.getDataEntityState().getFromDatabase();
        if (isFormDb) {
            DynamicObjectCollection progessEntry;
            this.updateChart();
            this.statisticsTaskCount();
            this.getView().setVisible(Boolean.TRUE, new String[]{"cruxap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"thiscycleap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nextcycleap"});
            DynamicObjectCollection dataDetailCol = this.getModel().getEntryEntity("datadetailentry");
            if (dataDetailCol == null || dataDetailCol.size() == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"datadetalap"});
            }
            if ((progessEntry = this.getModel().getEntryEntity("progressentry")) != null && progessEntry.size() > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"processap"});
            }
            DynamicObjectCollection cruxNodeCol = this.getModel().getEntryEntity("cruxnodeentry");
            ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(10);
            for (int i = 0; i < cruxNodeCol.size(); ++i) {
                DynamicObject task = ((DynamicObject)cruxNodeCol.get(i)).getDynamicObject("cruxtask");
                if (task == null) continue;
                taskList.add(task);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{rightarrowap});
            this.getView().setVisible(Boolean.FALSE, new String[]{leftarrowap});
            if (taskList.size() == 0) {
                return;
            }
            if (taskList.size() > 10) {
                this.getPageCache().put("beginIndex", "0");
                this.getView().setVisible(Boolean.TRUE, new String[]{rightarrowap});
            }
            this.updateCruxFlex(taskList.toArray(new DynamicObject[taskList.size()]));
            this.getModel().setDataChanged(false);
        } else {
            DynamicObject project = thisModel.getDynamicObject("project");
            if (project != null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tipap"});
                this.updateTotalData("project");
            } else {
                for (int i = 0; i < 10; ++i) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{cruxtasknodeap + i});
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{rightarrowap});
                this.getView().setVisible(Boolean.FALSE, new String[]{leftarrowap});
            }
        }
        this.updateDataDetailEntryName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("cruxnodeentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid2 = (EntryGrid)this.getControl("thiscyctaskentry");
        entryGrid2.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        if (StringUtils.equals((CharSequence)"cruxtaskname", (CharSequence)fieldName)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            DynamicObject task = (DynamicObject)this.getModel().getValue("cruxtask", rowIndex);
            if (task != null) {
                DynamicObject sourceTask = task.getDynamicObject("sourcetask");
                BigDecimal version = (BigDecimal)this.getModel().getValue("cruxversion", rowIndex);
                paramMap.put("formId", "pmpm_reporttaskview");
                paramMap.put("pkId", String.valueOf(task.getPkValue()));
                if (sourceTask != null) {
                    QFilter sourceTaskFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
                    QFilter versionFilter = new QFilter("version", "=", (Object)version);
                    DynamicObject versionTask = QueryServiceHelper.queryOne((String)"pmpm_task", (String)"id", (QFilter[])new QFilter[]{sourceTaskFilter, versionFilter});
                    if (versionTask != null) {
                        paramMap.put("pkId", versionTask.getPkValue());
                    }
                }
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        } else if (StringUtils.equals((CharSequence)"thiscycletaskname", (CharSequence)fieldName)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            DynamicObject task = (DynamicObject)this.getModel().getValue("thiscycletask", rowIndex);
            if (task != null) {
                DynamicObject sourceTask = task.getDynamicObject("sourcetask");
                BigDecimal version = (BigDecimal)this.getModel().getValue("thisversion", rowIndex);
                paramMap.put("formId", "pmpm_reporttaskview");
                paramMap.put("pkId", String.valueOf(task.getPkValue()));
                if (sourceTask != null) {
                    QFilter sourceTaskFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
                    QFilter versionFilter = new QFilter("version", "=", (Object)version);
                    DynamicObject versionTask = QueryServiceHelper.queryOne((String)"pmpm_task", (String)"id", (QFilter[])new QFilter[]{sourceTaskFilter, versionFilter});
                    if (versionTask != null) {
                        paramMap.put("pkId", versionTask.getPkValue());
                    }
                }
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    private boolean isExistOne() {
        Date lastDayInReportDate;
        Date firstDayInReportDate;
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (project == null) {
            return false;
        }
        Date reportDate = this.getModel().getDataEntity().getDate("reportcycle");
        String reportType = this.getModel().getDataEntity().getString("reporttype");
        QFilter largeFirstDayFilter = null;
        QFilter lessLastDayFilter = null;
        if (StringUtils.equals((CharSequence)"01", (CharSequence)reportType)) {
            firstDayInReportDate = DateUtil.getFirstDayOfThisMonth((Date)reportDate);
            lastDayInReportDate = DateUtil.getLastDayOfThisMonth((Date)reportDate);
            largeFirstDayFilter = new QFilter("reportcycle", ">=", (Object)firstDayInReportDate);
            lessLastDayFilter = new QFilter("reportcycle", "<", (Object)lastDayInReportDate);
        } else {
            firstDayInReportDate = DateUtil.getThisWeekMonday((Date)reportDate);
            lastDayInReportDate = DateUtil.getThisWeekSunDay((Date)reportDate);
            largeFirstDayFilter = new QFilter("reportcycle", ">=", (Object)firstDayInReportDate);
            lessLastDayFilter = new QFilter("reportcycle", "<", (Object)lastDayInReportDate);
        }
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter reportTypeFilter = new QFilter("reporttype", "=", (Object)reportType);
        boolean fromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        boolean isExist = false;
        if (fromDb) {
            QFilter notSelfFilter = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
            isExist = QueryServiceHelper.exists((String)"pmpm_prooperationalreport", (QFilter[])new QFilter[]{projectFilter, reportTypeFilter, largeFirstDayFilter, lessLastDayFilter, notSelfFilter});
        } else {
            isExist = QueryServiceHelper.exists((String)"pmpm_prooperationalreport", (QFilter[])new QFilter[]{projectFilter, reportTypeFilter, largeFirstDayFilter, lessLastDayFilter});
        }
        return isExist;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "submitandnew": {
                boolean isExist = this.isExistOne();
                if (!isExist) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5728\u8be5\u5468\u671f\u4e0b\uff0c\u5df2\u7ecf\u5b58\u5728\u4e86\u4e00\u4efd\u9879\u76ee\u8fd0\u8425\u62a5\u544a\uff0c\u4e0d\u80fd\u91cd\u590d\u4fdd\u5b58\u3002", (String)"ProOperationalReportPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                return;
            }
            case "precruxnode": {
                this.getView().setVisible(Boolean.TRUE, new String[]{rightarrowap});
                String beginIndex1 = this.getPageCache().get("beginIndex");
                Integer beginRow1 = Integer.valueOf(beginIndex1);
                DynamicObjectCollection cruxEntry1 = this.getModel().getEntryEntity("cruxnodeentry");
                Integer n = beginRow1;
                Integer n2 = beginRow1 = Integer.valueOf(beginRow1 - 1);
                if (beginRow1 > 0) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{leftarrowap});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{leftarrowap});
                }
                DynamicObject[] taskArr1 = new DynamicObject[10];
                for (int i = 0; i < 10; ++i) {
                    taskArr1[i] = ((DynamicObject)cruxEntry1.get(i + beginRow1)).getDynamicObject("cruxtask");
                }
                this.updateCruxFlex(taskArr1);
                this.getPageCache().put("beginIndex", beginRow1.toString());
                break;
            }
            case "nextcruxnode": {
                this.getView().setVisible(Boolean.TRUE, new String[]{leftarrowap});
                String beginIndex = this.getPageCache().get("beginIndex");
                Integer beginRow = Integer.valueOf(beginIndex);
                DynamicObjectCollection cruxEntry = this.getModel().getEntryEntity("cruxnodeentry");
                Integer n = beginRow;
                Integer n3 = beginRow = Integer.valueOf(beginRow + 1);
                if (cruxEntry.size() - beginRow > 10) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{rightarrowap});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{rightarrowap});
                }
                DynamicObject[] taskArr = new DynamicObject[10];
                for (int i = 0; i < 10; ++i) {
                    taskArr[i] = ((DynamicObject)cruxEntry.get(i + beginRow)).getDynamicObject("cruxtask");
                }
                this.updateCruxFlex(taskArr);
                this.getPageCache().put("beginIndex", beginRow.toString());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"reporttype", (CharSequence)propName)) {
            this.updateDataDetailEntryName();
            this.updateTotalData(propName);
        } else if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipap"});
            this.updateTotalData(propName);
        } else if (StringUtils.equals((CharSequence)"reportcycle", (CharSequence)propName)) {
            this.updateTotalData(propName);
        } else if (StringUtils.equals((CharSequence)"controllevels", (CharSequence)propName)) {
            this.updateTotalData(propName);
        }
    }

    private void updateTotalData(String propName) {
        boolean isExist = this.isExistOne();
        if (isExist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5728\u8be5\u5468\u671f\u4e0b\uff0c\u5df2\u7ecf\u5b58\u5728\u4e86\u4e00\u4efd\u9879\u76ee\u8fd0\u8425\u62a5\u544a\u3002", (String)"ProOperationalReportPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        String reportType = this.getModel().getDataEntity().getString("reporttype");
        Date reportDate = this.getModel().getDataEntity().getDate("reportcycle");
        if (project == null || reportType == null || reportDate == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)"reporttype", (CharSequence)propName)) {
            this.queryData();
            this.queryBarData();
            this.updateChart();
            this.updateThisCycleTaskEntry();
            this.updateNextCycleTaskEntry();
            this.updateDataDetailEntry();
        } else if (StringUtils.equals((CharSequence)"reportcycle", (CharSequence)propName)) {
            this.queryData();
            this.queryBarData();
            this.updateChart();
            this.updateThisCycleTaskEntry();
            this.updateNextCycleTaskEntry();
            this.updateDataDetailEntry();
        } else if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            this.queryData();
            this.queryBarData();
            this.updateChart();
            this.updateCruxNodeEntry();
            this.updateThisCycleTaskEntry();
            this.updateNextCycleTaskEntry();
            this.updateDataDetailEntry();
            this.updateProcessEntry();
        } else if (StringUtils.equals((CharSequence)"controllevels", (CharSequence)propName)) {
            this.queryBarData();
            this.updateChart();
        }
    }

    private void updateCruxNodeEntry() {
        DynamicObject[] taskArr;
        this.getModel().deleteEntryData("cruxnodeentry");
        this.getView().setVisible(Boolean.TRUE, new String[]{"cruxap"});
        DynamicObject thisModel = this.getModel().getDataEntity();
        DynamicObject project = thisModel.getDynamicObject("project");
        if (project == null) {
            return;
        }
        QFilter commonFilter = this.getCommonFilter();
        QFilter taskTypeNumberFilter = new QFilter("tasktype", "=", (Object)TASKTYPE_CRUXNODE_ID);
        for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,taskseq,name,planendtime,realendtime,majortype,percent,realtimedeviation,responsibleperson,responsibledept,cooperationperson,cooperationdept,version,completionstatus", (QFilter[])new QFilter[]{commonFilter, taskTypeNumberFilter}, (String)"planendtime,taskseq desc")) {
            int rowIndex = this.getModel().createNewEntryRow("cruxnodeentry");
            this.getModel().setValue("cruxtask", (Object)dynamicObject, rowIndex);
            this.setCruxTaskDetail(dynamicObject, rowIndex);
        }
        this.getView().updateView("cruxnodeentry");
        this.getView().setVisible(Boolean.FALSE, new String[]{rightarrowap});
        this.getView().setVisible(Boolean.FALSE, new String[]{leftarrowap});
        if (taskArr.length == 0) {
            return;
        }
        if (taskArr.length > 10) {
            this.getPageCache().put("beginIndex", "0");
            this.getView().setVisible(Boolean.TRUE, new String[]{rightarrowap});
        }
        this.updateCruxFlex(taskArr);
    }

    private void updateCruxFlex(DynamicObject[] taskArr) {
        int i;
        for (i = 0; i < 10; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{cruxtasknodeap + i});
        }
        for (i = 0; i < taskArr.length && i <= 9; ++i) {
            HashMap<String, String> propMap;
            String completionStatus = taskArr[i].getString("completionstatus");
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap<String, String>(16);
                propMap.put("bc", "#FF585A");
                this.getView().updateControlMetadata(colorap + i, propMap);
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap(16);
                propMap.put("bc", "#2DECE9");
                this.getView().updateControlMetadata(colorap + i, propMap);
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.PROGRESSING.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap(16);
                propMap.put("bc", "#00BBFF");
                this.getView().updateControlMetadata(colorap + i, propMap);
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.UNSTART.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap(16);
                propMap.put("bc", "#D2DBDE");
                this.getView().updateControlMetadata(colorap + i, propMap);
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap(16);
                propMap.put("bc", "#83F348");
                this.getView().updateControlMetadata(colorap + i, propMap);
            } else if (StringUtils.equals((CharSequence)CompletionStatusEnum.ESTIMATEDELAY.getValue(), (CharSequence)completionStatus)) {
                propMap = new HashMap(16);
                propMap.put("bc", "#FFC000");
                this.getView().updateControlMetadata(colorap + i, propMap);
            }
            Label taskNameLabel = (Label)this.getControl(tasknamelabel + i);
            taskNameLabel.setText(taskArr[i].getString("name"));
            Label planEndTimeLabel = (Label)this.getControl(planendtimeap + i);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
            String planEndTimeString = f.format(taskArr[i].getDate("planendtime"));
            planEndTimeLabel.setText(planEndTimeString);
            this.getView().setVisible(Boolean.TRUE, new String[]{cruxtasknodeap + i});
        }
    }

    private void updateNextCycleTaskEntry() {
        this.getModel().deleteEntryData("nextcyctaskentry");
        DynamicObject thisModel = this.getModel().getDataEntity();
        DynamicObject project = thisModel.getDynamicObject("project");
        if (project == null) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"nextcycleap"});
        String reportType = thisModel.getString("reporttype");
        Date reportDate = thisModel.getDate("reportcycle");
        QFilter commonFilter = this.getCommonFilter();
        if (StringUtils.equals((CharSequence)reportType, (CharSequence)"01")) {
            DynamicObject[] taskArr;
            Date firstDayOfNextMonth = DateUtil.getFirstDayOfNextMonth((Date)reportDate);
            Date lastDayOfNextMonth = DateUtil.getLastDayOfNextMonth((Date)reportDate);
            QFilter endTimeLargeLastDayOfNextMonthFilter = new QFilter("planendtime", ">", (Object)lastDayOfNextMonth);
            QFilter startTimeLessFirstDayOfNextMonthFilter = new QFilter("planstarttime", "<", (Object)firstDayOfNextMonth);
            QFilter startTimeInNextMonthFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfNextMonth).and(new QFilter("planstarttime", ">=", (Object)firstDayOfNextMonth));
            QFilter endTimeInNextMonthFilter = new QFilter("planendtime", "<=", (Object)lastDayOfNextMonth).and(new QFilter("planendtime", ">=", (Object)firstDayOfNextMonth));
            ArrayList<String> unCompleteStatusList = new ArrayList<String>(10);
            unCompleteStatusList.add(CompletionStatusEnum.UNSTART.getValue());
            unCompleteStatusList.add(CompletionStatusEnum.PROGRESSING.getValue());
            unCompleteStatusList.add(CompletionStatusEnum.ESTIMATEDELAY.getValue());
            unCompleteStatusList.add(CompletionStatusEnum.OVERDUE.getValue());
            QFilter unCompleteFilter = new QFilter("completionstatus", "in", unCompleteStatusList);
            QFilter filter = startTimeInNextMonthFilter.or(endTimeInNextMonthFilter).or(startTimeLessFirstDayOfNextMonthFilter.and(endTimeLargeLastDayOfNextMonthFilter)).and(unCompleteFilter);
            for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,taskseq,name,planstarttime,planendtime,realendtime,majortype,tasktype,percent,realtimedeviation,responsibleperson,responsibledept,cooperationperson,cooperationdept,version,completionstatus", (QFilter[])new QFilter[]{commonFilter, filter}, (String)"taskseq")) {
                int rowIndex = this.getModel().createNewEntryRow("nextcyctaskentry");
                this.getModel().setValue("nextcycletask", (Object)dynamicObject, rowIndex);
                this.setNextCycleTaskDetail(dynamicObject, rowIndex);
            }
            this.getView().updateView("nextcyctaskentry");
        } else {
            DynamicObject[] taskArr;
            Date firstDayOfNextWeek = DateUtil.getNextWeekMonday((Date)reportDate);
            Date lastDayOfNextWeek = DateUtil.getNextWeekSunday((Date)reportDate);
            QFilter endTimeLargeLastDayOfNextMonthFilter = new QFilter("planendtime", ">", (Object)lastDayOfNextWeek);
            QFilter startTimeLessFirstDayOfNextMonthFilter = new QFilter("planstarttime", "<", (Object)firstDayOfNextWeek);
            QFilter startTimeInNextMonthFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfNextWeek).and(new QFilter("planstarttime", ">=", (Object)firstDayOfNextWeek));
            QFilter endTimeInNextMonthFilter = new QFilter("planendtime", "<=", (Object)lastDayOfNextWeek).and(new QFilter("planendtime", ">=", (Object)firstDayOfNextWeek));
            ArrayList<String> unCompleteStatusList = new ArrayList<String>(10);
            unCompleteStatusList.add(CompletionStatusEnum.UNSTART.getValue());
            unCompleteStatusList.add(CompletionStatusEnum.PROGRESSING.getValue());
            QFilter unCompleteFilter = new QFilter("completionstatus", "in", unCompleteStatusList);
            QFilter filter = startTimeInNextMonthFilter.or(endTimeInNextMonthFilter).or(startTimeLessFirstDayOfNextMonthFilter.and(endTimeLargeLastDayOfNextMonthFilter)).and(unCompleteFilter);
            for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,taskseq,name,planstarttime,planendtime,realendtime,majortype,tasktype,percent,realtimedeviation,responsibleperson,responsibledept,cooperationperson,cooperationdept,version,completionstatus", (QFilter[])new QFilter[]{commonFilter, filter}, (String)"taskseq")) {
                int rowIndex = this.getModel().createNewEntryRow("nextcyctaskentry");
                this.getModel().setValue("nextcycletask", (Object)dynamicObject, rowIndex);
                this.setNextCycleTaskDetail(dynamicObject, rowIndex);
            }
            this.getView().updateView("nextcyctaskentry");
        }
    }

    private void updateThisCycleTaskEntry() {
        this.getModel().deleteEntryData("thiscyctaskentry");
        DynamicObject thisModel = this.getModel().getDataEntity();
        DynamicObject project = thisModel.getDynamicObject("project");
        if (project == null) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"thiscycleap"});
        String reportType = thisModel.getString("reporttype");
        Date reportDate = thisModel.getDate("reportcycle");
        QFilter commonFilter = this.getCommonFilter();
        ArrayList<String> unCompleteStatusList = new ArrayList<String>(10);
        unCompleteStatusList.add(CompletionStatusEnum.UNSTART.getValue());
        unCompleteStatusList.add(CompletionStatusEnum.PROGRESSING.getValue());
        unCompleteStatusList.add(CompletionStatusEnum.OVERDUE.getValue());
        unCompleteStatusList.add(CompletionStatusEnum.ESTIMATEDELAY.getValue());
        QFilter unCompleteFilter = new QFilter("completionstatus", "in", unCompleteStatusList);
        if (StringUtils.equals((CharSequence)reportType, (CharSequence)"01")) {
            DynamicObject[] taskArr;
            Date firstDayOfMonth = DateUtil.getFirstDayOfThisMonth((Date)reportDate);
            Date lastDayOfMonth = DateUtil.getLastDayOfThisMonth((Date)reportDate);
            QFilter startTimeInThisMonthFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfMonth).and(new QFilter("planstarttime", ">=", (Object)firstDayOfMonth));
            QFilter endTimeInThisMonthFilter = new QFilter("planendtime", ">=", (Object)firstDayOfMonth).and(new QFilter("planendtime", "<=", (Object)lastDayOfMonth));
            QFilter endTimeBeforeThisMonthAndUnCompleteFilter = new QFilter("planendtime", "<", (Object)firstDayOfMonth).and(unCompleteFilter);
            QFilter startOrEndInThisFilter = startTimeInThisMonthFilter.or(endTimeInThisMonthFilter);
            QFilter startBeforeThisAndEndAfterThisFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfMonth).and(new QFilter("planendtime", ">", (Object)lastDayOfMonth));
            QFilter realEndTimeInThisFilter = new QFilter("realendtime", "<=", (Object)lastDayOfMonth).and(new QFilter("realendtime", ">=", (Object)firstDayOfMonth));
            for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,taskseq,name,planendtime,realendtime,majortype,tasktype,percent,realtimedeviation,responsibleperson,responsibledept,cooperationperson,cooperationdept,version,completionstatus", (QFilter[])new QFilter[]{commonFilter, endTimeBeforeThisMonthAndUnCompleteFilter.or(startOrEndInThisFilter).or(startBeforeThisAndEndAfterThisFilter).or(realEndTimeInThisFilter)}, (String)"taskseq")) {
                int rowIndex = this.getModel().createNewEntryRow("thiscyctaskentry");
                this.getModel().setValue("thiscycletask", (Object)dynamicObject, rowIndex);
                this.setThisCycleTaskDetail(dynamicObject, rowIndex);
            }
            this.getView().updateView("thiscyctaskentry");
        } else {
            DynamicObject[] taskArr;
            Date firstDayOfWeek = DateUtil.getThisWeekMonday((Date)reportDate);
            Date lastDayOfWeek = DateUtil.getThisWeekSunDay((Date)reportDate);
            QFilter startTimeInThisWeekFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfWeek).and(new QFilter("planstarttime", ">=", (Object)firstDayOfWeek));
            QFilter endTimeInThisWeekFilter = new QFilter("planendtime", ">=", (Object)firstDayOfWeek).and(new QFilter("planendtime", "<=", (Object)lastDayOfWeek));
            QFilter endTimeBeforeThisWeekAndUnCompleteFilter = new QFilter("planendtime", "<", (Object)firstDayOfWeek).and(unCompleteFilter);
            QFilter startOrEndInThisFilter = startTimeInThisWeekFilter.and(endTimeInThisWeekFilter);
            QFilter startBeforeThisAndEndAfterThisFilter = new QFilter("planstarttime", "<=", (Object)lastDayOfWeek).and(new QFilter("planendtime", ">", (Object)lastDayOfWeek));
            QFilter realEndTimeInThisFilter = new QFilter("realendtime", "<=", (Object)lastDayOfWeek).and(new QFilter("realendtime", ">=", (Object)firstDayOfWeek));
            for (DynamicObject dynamicObject : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,taskseq,name,planendtime,realendtime,majortype,tasktype,percent,realtimedeviation,responsibleperson,responsibledept,version,completionstatus", (QFilter[])new QFilter[]{commonFilter, endTimeBeforeThisWeekAndUnCompleteFilter.or(startOrEndInThisFilter).or(startBeforeThisAndEndAfterThisFilter).or(realEndTimeInThisFilter)}, (String)"taskseq")) {
                int rowIndex = this.getModel().createNewEntryRow("thiscyctaskentry");
                this.getModel().setValue("thiscycletask", (Object)dynamicObject, rowIndex);
                this.setThisCycleTaskDetail(dynamicObject, rowIndex);
            }
            this.getView().updateView("thiscyctaskentry");
        }
        this.statisticsTaskCount();
    }

    private void updateChart() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"totalanalysisap"});
        String leftPieDataObj = this.getModel().getDataEntity().getString(leftpiedata);
        String rightPieDataObj = this.getModel().getDataEntity().getString(rightpiedata);
        this.updatePieChartByJsonData("thismonthpiechart", JSONObject.parseObject((String)leftPieDataObj));
        this.updatePieChartByJsonData("totalpiechart", JSONObject.parseObject((String)rightPieDataObj));
        String leftBarDataObj = this.getModel().getDataEntity().getString(leftbardata);
        String rightBarDataObj = this.getModel().getDataEntity().getString(rightbardata);
        this.updateBarChartByJsonData("thismonthbarchart", JSONObject.parseObject((String)leftBarDataObj));
        this.updateBarChartByJsonData("totalbarchart", JSONObject.parseObject((String)rightBarDataObj));
    }

    private void queryBarData() {
        Integer endQty;
        String comPletionStatus;
        Integer planEndQty;
        String controlLevelName;
        DynamicObject controlLevel;
        DynamicObject thisModel = this.getModel().getDataEntity();
        DynamicObject project = thisModel.getDynamicObject("project");
        if (project == null) {
            return;
        }
        String reportType = thisModel.getString("reporttype");
        Date reportDate = thisModel.getDate("reportcycle");
        DynamicObjectCollection controllevels = thisModel.getDynamicObjectCollection("controllevels");
        HashSet<Object> controlLevelIdSet = new HashSet<Object>();
        for (DynamicObject dynamicObject : controllevels) {
            DynamicObject controlLevel2 = dynamicObject.getDynamicObject("fbasedataid");
            controlLevelIdSet.add(controlLevel2.getPkValue());
        }
        DynamicObject[] taskArr = null;
        DynamicObject[] totalTaskArr = null;
        HashMap<String, Integer> controlLevelPlanEndMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> controlLevelEndMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> controlLevelTotalPlanEndMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> controlLevelTotalEndMap = new HashMap<String, Integer>(16);
        JSONObject leftBarDataObj = new JSONObject();
        JSONObject rightBarDataObj = new JSONObject();
        QFilter commonFilter = this.getCommonFilter();
        QFilter controlLevelFilter = new QFilter("controllevel", "in", controlLevelIdSet);
        if (StringUtils.equals((CharSequence)reportType, (CharSequence)"01")) {
            leftBarDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u672c\u6708\u5b9e\u9645\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            rightBarDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b9e\u9645\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            Date firstDayOfMonth = DateUtil.getFirstDayOfThisMonth((Date)reportDate);
            Date lastDayOfMonth = DateUtil.getLastDayOfThisMonth((Date)reportDate);
            QFilter lessLastDayOfMonthFilter = new QFilter("planendtime", "<=", (Object)lastDayOfMonth);
            QFilter largeFirstDayOfMonthFilter = new QFilter("planendtime", ">=", (Object)firstDayOfMonth);
            if (!controlLevelIdSet.isEmpty()) {
                taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter, largeFirstDayOfMonthFilter, controlLevelFilter});
                totalTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter, controlLevelFilter});
            } else {
                taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter, largeFirstDayOfMonthFilter});
                totalTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter});
            }
        } else {
            leftBarDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u672c\u5468\u5b9e\u9645\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            rightBarDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b9e\u9645\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            DynamicObject[] firstDayOfWeek = DateUtil.getThisWeekMonday((Date)reportDate);
            Date lastDayOfWeek = DateUtil.getThisWeekSunDay((Date)reportDate);
            QFilter lessLastDayOfWeekFilter = new QFilter("planendtime", "<=", (Object)lastDayOfWeek);
            QFilter largeFirstDayOfWeekFilter = new QFilter("planendtime", ">=", (Object)firstDayOfWeek);
            if (!controlLevelIdSet.isEmpty()) {
                taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter, largeFirstDayOfWeekFilter, controlLevelFilter});
                totalTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter, controlLevelFilter});
            } else {
                taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter, largeFirstDayOfWeekFilter});
                totalTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter});
            }
        }
        for (DynamicObject task : taskArr) {
            controlLevel = task.getDynamicObject("controllevel");
            if (controlLevel == null) continue;
            controlLevelName = controlLevel.getString("name");
            planEndQty = (Integer)controlLevelPlanEndMap.get(controlLevelName);
            planEndQty = planEndQty != null ? Integer.valueOf(planEndQty + 1) : Integer.valueOf(1);
            controlLevelPlanEndMap.put(controlLevelName, planEndQty);
            comPletionStatus = task.getString("completionstatus");
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                endQty = (Integer)controlLevelEndMap.get(controlLevelName);
                endQty = endQty != null ? Integer.valueOf(endQty + 1) : Integer.valueOf(1);
                controlLevelEndMap.put(controlLevelName, endQty);
                continue;
            }
            if (!StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) continue;
            endQty = (Integer)controlLevelEndMap.get(controlLevelName);
            endQty = endQty != null ? Integer.valueOf(endQty + 1) : Integer.valueOf(1);
            controlLevelEndMap.put(controlLevelName, endQty);
        }
        for (DynamicObject task : totalTaskArr) {
            controlLevel = task.getDynamicObject("controllevel");
            if (controlLevel == null) continue;
            controlLevelName = controlLevel.getString("name");
            planEndQty = (Integer)controlLevelTotalPlanEndMap.get(controlLevelName);
            planEndQty = planEndQty != null ? Integer.valueOf(planEndQty + 1) : Integer.valueOf(1);
            controlLevelTotalPlanEndMap.put(controlLevelName, planEndQty);
            comPletionStatus = task.getString("completionstatus");
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                endQty = (Integer)controlLevelTotalEndMap.get(controlLevelName);
                endQty = endQty != null ? Integer.valueOf(endQty + 1) : Integer.valueOf(1);
                controlLevelTotalEndMap.put(controlLevelName, endQty);
                continue;
            }
            if (!StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) continue;
            endQty = (Integer)controlLevelTotalEndMap.get(controlLevelName);
            endQty = endQty != null ? Integer.valueOf(endQty + 1) : Integer.valueOf(1);
            controlLevelTotalEndMap.put(controlLevelName, endQty);
        }
        ArrayList<BigDecimal> realDataDetailList = new ArrayList<BigDecimal>(10);
        ArrayList<Integer> planEndList = new ArrayList<Integer>(10);
        for (Map.Entry controlLevel3 : controlLevelPlanEndMap.entrySet()) {
            Integer endQty2 = (Integer)controlLevelEndMap.get(controlLevel3.getKey());
            if (endQty2 == null) {
                endQty2 = 0;
            }
            Integer planEndQty2 = (Integer)controlLevel3.getValue();
            realDataDetailList.add(BigDecimal.valueOf(endQty2.intValue()));
            planEndList.add(planEndQty2);
        }
        ArrayList<BigDecimal> totalRealDetailDataList = new ArrayList<BigDecimal>(10);
        ArrayList<Integer> totalPlanEndList = new ArrayList<Integer>(10);
        for (Map.Entry controlLevel1 : controlLevelTotalPlanEndMap.entrySet()) {
            Integer endQty3 = (Integer)controlLevelTotalEndMap.get(controlLevel1.getKey());
            if (endQty3 == null) {
                endQty3 = 0;
            }
            Integer planEndQty3 = (Integer)controlLevel1.getValue();
            totalRealDetailDataList.add(BigDecimal.valueOf(endQty3.intValue()));
            totalPlanEndList.add(planEndQty3);
        }
        leftBarDataObj.put(xAxisList, controlLevelPlanEndMap.keySet());
        rightBarDataObj.put(xAxisList, controlLevelTotalPlanEndMap.keySet());
        leftBarDataObj.put(realDataList, realDataDetailList);
        rightBarDataObj.put(realDataList, totalRealDetailDataList);
        leftBarDataObj.put(planEndQtyList, planEndList);
        rightBarDataObj.put(planEndQtyList, totalPlanEndList);
        this.getModel().setValue(leftbardata, (Object)leftBarDataObj.toString());
        this.getModel().setValue(rightbardata, (Object)rightBarDataObj.toString());
    }

    private void queryData() {
        DynamicObject thisModel = this.getModel().getDataEntity();
        DynamicObject project = thisModel.getDynamicObject("project");
        String reportType = thisModel.getString("reporttype");
        Date reportDate = thisModel.getDate("reportcycle");
        if (project == null) {
            return;
        }
        JSONObject leftPieDataObj = new JSONObject();
        JSONObject rightPieDataObj = new JSONObject();
        QFilter commonFilter = this.getCommonFilter();
        DynamicObject[] taskArr = null;
        DynamicObject[] totalTaskArr = null;
        if (StringUtils.equals((CharSequence)reportType, (CharSequence)"01")) {
            leftPieDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u672c\u6708\u6267\u884c\u5360\u6bd4", (String)"ProOperationalReportPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            rightPieDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u7d2f\u8ba1\u6267\u884c\u5360\u6bd4", (String)"ProOperationalReportPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            Date firstDayOfMonth = DateUtil.getFirstDayOfThisMonth((Date)reportDate);
            Date lastDayOfMonth = DateUtil.getLastDayOfThisMonth((Date)reportDate);
            QFilter lessLastDayOfMonthFilter = new QFilter("planendtime", "<=", (Object)lastDayOfMonth);
            QFilter largeFirstDayOfMonthFilter = new QFilter("planendtime", ">=", (Object)firstDayOfMonth);
            taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter, largeFirstDayOfMonthFilter});
            totalTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter});
        } else {
            leftPieDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u672c\u5468\u6267\u884c\u5360\u6bd4", (String)"ProOperationalReportPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            rightPieDataObj.put(chartTitleName, (Object)ResManager.loadKDString((String)"\u7d2f\u8ba1\u6267\u884c\u5360\u6bd4", (String)"ProOperationalReportPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            Date firstDayOfWeek = DateUtil.getThisWeekMonday((Date)reportDate);
            Date lastDayOfWeek = DateUtil.getThisWeekSunDay((Date)reportDate);
            QFilter lessLastDayOfWeekFilter = new QFilter("planendtime", "<=", (Object)lastDayOfWeek);
            QFilter largeFirstDayOfWeekFilter = new QFilter("planendtime", ">=", (Object)firstDayOfWeek);
            taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter, largeFirstDayOfWeekFilter});
            totalTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,controllevel,planendtime,completionstatus,project", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfWeekFilter});
        }
        int unStartQty = 0;
        int progressingQty = 0;
        int onTimeEndQty = 0;
        int overTimeEndQty = 0;
        int overTimeNotEndQty = 0;
        int estimateDelayQty = 0;
        for (DynamicObject task : taskArr) {
            String comPletionStatus = task.getString("completionstatus");
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.UNSTART.getValue())) {
                ++unStartQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.PROGRESSING.getValue())) {
                ++progressingQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                ++onTimeEndQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) {
                ++overTimeEndQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.OVERDUE.getValue())) {
                ++overTimeNotEndQty;
                continue;
            }
            if (!StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.ESTIMATEDELAY.getValue())) continue;
            ++estimateDelayQty;
        }
        leftPieDataObj.put(planEnd, (Object)taskArr.length);
        leftPieDataObj.put(unStart, (Object)unStartQty);
        leftPieDataObj.put(progressing, (Object)progressingQty);
        leftPieDataObj.put(onTimeEnd, (Object)onTimeEndQty);
        leftPieDataObj.put(overTimeEnd, (Object)overTimeEndQty);
        leftPieDataObj.put(overTimeNotEnd, (Object)overTimeNotEndQty);
        leftPieDataObj.put(estimateDelay, (Object)estimateDelayQty);
        int totalUnStartQty = 0;
        int totalProgressingQty = 0;
        int totalOnTimeEndQty = 0;
        int totalOverTimeEndQty = 0;
        int totalOverTimeNotEndQty = 0;
        int totalEstimateDelayQty = 0;
        for (DynamicObject task : totalTaskArr) {
            String comPletionStatus = task.getString("completionstatus");
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.UNSTART.getValue())) {
                ++totalUnStartQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.PROGRESSING.getValue())) {
                ++totalProgressingQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                ++totalOnTimeEndQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) {
                ++totalOverTimeEndQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.OVERDUE.getValue())) {
                ++totalOverTimeNotEndQty;
                continue;
            }
            if (!StringUtils.equals((CharSequence)comPletionStatus, (CharSequence)CompletionStatusEnum.ESTIMATEDELAY.getValue())) continue;
            ++totalEstimateDelayQty;
        }
        rightPieDataObj.put(planEnd, (Object)totalTaskArr.length);
        rightPieDataObj.put(unStart, (Object)totalUnStartQty);
        rightPieDataObj.put(progressing, (Object)totalProgressingQty);
        rightPieDataObj.put(onTimeEnd, (Object)totalOnTimeEndQty);
        rightPieDataObj.put(overTimeEnd, (Object)totalOverTimeEndQty);
        rightPieDataObj.put(overTimeNotEnd, (Object)totalOverTimeNotEndQty);
        rightPieDataObj.put(estimateDelay, (Object)totalEstimateDelayQty);
        this.getModel().setValue(leftpiedata, (Object)leftPieDataObj.toJSONString());
        this.getModel().setValue(rightpiedata, (Object)rightPieDataObj.toJSONString());
    }

    private void updatePieChartByJsonData(String chartKey, JSONObject pieDataObject) {
        String pieTiltleName = pieDataObject.getString(chartTitleName);
        BigDecimal planEndQty = pieDataObject.getBigDecimal(planEnd);
        BigDecimal unStartQty = pieDataObject.getBigDecimal(unStart);
        BigDecimal progessingQty = pieDataObject.getBigDecimal(progressing);
        BigDecimal onTimeEndQty = pieDataObject.getBigDecimal(onTimeEnd);
        BigDecimal overTimeEndQty = pieDataObject.getBigDecimal(overTimeEnd);
        BigDecimal overTimeNotEndQty = pieDataObject.getBigDecimal(overTimeNotEnd);
        BigDecimal estimateDelayQty = pieDataObject.getBigDecimal(estimateDelay);
        PieChart pieChart1 = (PieChart)this.getControl(chartKey);
        pieChart1.clearData();
        pieChart1.setTitleAlign(XAlign.left, YAlign.top);
        pieChart1.setShowTooltip(true);
        pieChart1.setName(new LocaleString(pieTiltleName));
        PieSeries pieSeries1 = pieChart1.createPieSeries(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210 (%s) \u6761", (String)"ProOperationalReportPlugin_8", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), planEndQty));
        pieSeries1.setCenter("50%", "55%");
        pieSeries1.setRadius("62%");
        boolean flag = false;
        if (unStartQty != null && unStartQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"ProOperationalReportPlugin_9", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), (Number)unStartQty, "#D2DBDE");
            flag = true;
        }
        if (progessingQty != null && progessingQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"ProOperationalReportPlugin_10", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), (Number)progessingQty, "#00BBFF");
            flag = true;
        }
        if (onTimeEndQty != null && onTimeEndQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u6309\u65f6\u5b8c\u6210", (String)"ProOperationalReportPlugin_11", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), (Number)onTimeEndQty, "#83F348");
            flag = true;
        }
        if (overTimeEndQty != null && overTimeEndQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u903e\u671f\u5b8c\u6210", (String)"ProOperationalReportPlugin_12", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), (Number)overTimeEndQty, "#2DECE9");
            flag = true;
        }
        if (overTimeNotEndQty != null && overTimeNotEndQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u903e\u671f\u672a\u5b8c\u6210", (String)"ProOperationalReportPlugin_13", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), (Number)overTimeNotEndQty, "#FF585A");
            flag = true;
        }
        if (estimateDelayQty != null && estimateDelayQty.compareTo(BigDecimal.ZERO) != 0) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u9884\u8ba1\u903e\u671f", (String)"ProOperationalReportPlugin_14", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), (Number)estimateDelayQty, "#FFC000");
            flag = true;
        }
        HashMap labelMap = new HashMap(16);
        HashMap<String, String> subTextMap = new HashMap<String, String>(16);
        subTextMap.put("color", "#FF3300");
        subTextMap.put("fontSize", "13");
        pieChart1.setTitlePropValue("subtext", (Object)("\uff08" + String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210 (%s) \u6761", (String)"ProOperationalReportPlugin_8", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), planEndQty) + "\uff09"));
        pieChart1.setTitlePropValue("subtextStyle", subTextMap);
        HashMap<String, String> normalMap = new HashMap<String, String>(16);
        normalMap.put("formatter", ResManager.loadKDString((String)"{b}\uff1a{c} \u6761\n\u5360\u6bd4\uff1a{d}%", (String)"ProOperationalReportPlugin_15", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        labelMap.put("normal", normalMap);
        pieSeries1.setPropValue("label", labelMap);
        if (!flag) {
            pieSeries1.addData(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"ProOperationalReportPlugin_16", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), (Number)BigDecimal.ZERO, "#BEBEBE");
            pieChart1.refresh();
            return;
        }
        pieChart1.refresh();
    }

    private void updateBarChartByJsonData(String chartKey, JSONObject barDataObject) {
        String chartTitleName = barDataObject.getString(chartTitleName);
        JSONArray xAxisListArr = barDataObject.getJSONArray(xAxisList);
        String[] xAxisList = new String[xAxisListArr.size()];
        for (int i = 0; i < xAxisListArr.size(); ++i) {
            xAxisList[i] = (String)xAxisListArr.get(i);
        }
        JSONArray realDataListArr = barDataObject.getJSONArray(realDataList);
        Number[] realDataList = new BigDecimal[realDataListArr.size()];
        for (int i = 0; i < realDataListArr.size(); ++i) {
            realDataList[i] = realDataListArr.getBigDecimal(i);
        }
        JSONArray planEndQtyListArr = barDataObject.getJSONArray(planEndQtyList);
        if (planEndQtyListArr == null) {
            return;
        }
        Number[] planEndList = new Integer[planEndQtyListArr.size()];
        for (int i = 0; i < planEndQtyListArr.size(); ++i) {
            planEndList[i] = planEndQtyListArr.getInteger(i);
        }
        HistogramChart histogramChart = (HistogramChart)this.getControl(chartKey);
        histogramChart.clearData();
        histogramChart.setTitleAlign(XAlign.left, YAlign.top);
        histogramChart.setLegendAlign(XAlign.right, YAlign.top);
        histogramChart.setShowTooltip(true);
        histogramChart.setMargin(Position.top, "60px");
        histogramChart.setName(new LocaleString(chartTitleName));
        Axis yAxis = histogramChart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u6570", (String)"ProOperationalReportPlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), AxisType.value);
        Integer max = 0;
        for (Integer n : planEndList) {
            if (n <= max) continue;
            max = n;
        }
        kd.bos.form.chart.Label plLabel = new kd.bos.form.chart.Label();
        plLabel.setShow(true);
        plLabel.setFontSize("14");
        plLabel.setPosition(Position.inside);
        BarSeries series1 = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_18", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        series1.setData(planEndList);
        series1.setColor("#00BBFF");
        series1.setLabel(plLabel);
        BigDecimal xBigDecimal = BigDecimal.valueOf(max.intValue()).multiply(new BigDecimal("1.2")).setScale(0, RoundingMode.HALF_UP);
        yAxis.setMax((Number)xBigDecimal);
        histogramChart.createXAxis("", xAxisList);
        BarSeries barSeries = histogramChart.createBarSeries(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u6570", (String)"ProOperationalReportPlugin_19", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        barSeries.setData(realDataList);
        barSeries.setColor("#83F348");
        barSeries.setLabel(plLabel);
        histogramChart.refresh();
    }

    private void updateDataDetailEntryName() {
        String reportType = this.getModel().getDataEntity().getString("reporttype");
        String thisMonthColName = ResManager.loadKDString((String)"\u672c\u6708", (String)"ProOperationalReportPlugin_20", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
        String thisCycleTaskEntryName = ResManager.loadKDString((String)"\u672c\u6708\u4efb\u52a1", (String)"ProOperationalReportPlugin_21", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
        String nextCycleTaskEntryName = ResManager.loadKDString((String)"\u4e0b\u6708\u4efb\u52a1", (String)"ProOperationalReportPlugin_22", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)"02", (CharSequence)reportType)) {
            thisMonthColName = ResManager.loadKDString((String)"\u672c\u5468", (String)"ProOperationalReportPlugin_23", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
            thisCycleTaskEntryName = ResManager.loadKDString((String)"\u672c\u5468\u4efb\u52a1", (String)"ProOperationalReportPlugin_24", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
            nextCycleTaskEntryName = ResManager.loadKDString((String)"\u4e0b\u5468\u4efb\u52a1", (String)"ProOperationalReportPlugin_25", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("datadetailentry");
        grid.setColumnProperty("thismonth", "header", (Object)new LocaleString(thisMonthColName));
        HashMap<String, LocaleString> thisCycleMap = new HashMap<String, LocaleString>(16);
        thisCycleMap.put("text", new LocaleString(thisCycleTaskEntryName));
        this.getView().updateControlMetadata("thiscycleap", thisCycleMap);
        HashMap<String, LocaleString> nextCycleMap = new HashMap<String, LocaleString>(16);
        nextCycleMap.put("text", new LocaleString(nextCycleTaskEntryName));
        this.getView().updateControlMetadata("nextcycleap", nextCycleMap);
    }

    private void statisticsTaskCount() {
        DynamicObjectCollection taskCol = this.getModel().getEntryEntity("thiscyctaskentry");
        int totalQty = taskCol.size();
        int onTimeEndQty = 0;
        int overTimeEndQty = 0;
        int processQty = 0;
        int overTimeNotEndQty = 0;
        for (DynamicObject dynamicObject : taskCol) {
            DynamicObject task = dynamicObject.getDynamicObject("thiscycletask");
            String status = task.getString("completionstatus");
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue(), (CharSequence)status)) {
                ++onTimeEndQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.PROGRESSING.getValue(), (CharSequence)status)) {
                ++processQty;
                continue;
            }
            if (StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue(), (CharSequence)status)) {
                ++overTimeEndQty;
                continue;
            }
            if (!StringUtils.equals((CharSequence)CompletionStatusEnum.OVERDUE.getValue(), (CharSequence)status)) continue;
            ++overTimeNotEndQty;
        }
        this.getModel().setValue("totalqty", (Object)totalQty);
        this.getModel().setValue("ontimeqty", (Object)onTimeEndQty);
        this.getModel().setValue("overtimeendqty", (Object)overTimeEndQty);
        this.getModel().setValue("processqty", (Object)processQty);
        this.getModel().setValue("overtimenotendqty", (Object)overTimeNotEndQty);
    }

    private void updateDataDetailEntry() {
        Date reportDate;
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (project == null) {
            return;
        }
        this.getModel().deleteEntryData("datadetailentry");
        QFilter commonFilter = this.getCommonFilter();
        QFilter belongPlanTypeFilter = new QFilter("belongplantype.plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
        String reportType = this.getModel().getDataEntity().getString("reporttype");
        Date lastDayOfMonth = reportDate = this.getModel().getDataEntity().getDate("reportcycle");
        lastDayOfMonth = StringUtils.equals((CharSequence)reportType, (CharSequence)"01") ? DateUtil.getLastDayOfThisMonth((Date)reportDate) : DateUtil.getThisWeekSunDay((Date)reportDate);
        QFilter lessLastDayOfMonthFilter = new QFilter("planendtime", "<=", (Object)lastDayOfMonth);
        DynamicObject[] majorTaskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,name,majortype,planendtime,completionstatus", (QFilter[])new QFilter[]{commonFilter, lessLastDayOfMonthFilter, belongPlanTypeFilter});
        HashMap majorTypeMap = new HashMap(16);
        for (DynamicObject task : majorTaskArr) {
            DynamicObject majorType = task.getDynamicObject("majortype");
            String status = task.getString("completionstatus");
            Date planEndTime = task.getDate("planendtime");
            Date firstDayOfThisMonth = DateUtil.getFirstDayOfThisMonth((Date)reportDate);
            if (majorType == null) continue;
            String majorTypeId = majorType.getString("id");
            HashMap<String, Integer> taskQtyMap = (HashMap<String, Integer>)majorTypeMap.get(majorTypeId);
            if (taskQtyMap != null && !taskQtyMap.isEmpty()) {
                Integer overTimeNotEndQty;
                Integer planEndQty;
                Integer n;
                Integer totalPlanEndQty;
                Integer n2 = totalPlanEndQty = (Integer)taskQtyMap.get("totalPlanEndQty");
                Integer n3 = totalPlanEndQty = Integer.valueOf(totalPlanEndQty + 1);
                taskQtyMap.put("totalPlanEndQty", totalPlanEndQty);
                if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                    Integer totalOnTimeEndQty;
                    n3 = totalOnTimeEndQty = (Integer)taskQtyMap.get("totalOnTimeEndQty");
                    n = totalOnTimeEndQty = Integer.valueOf(totalOnTimeEndQty + 1);
                    taskQtyMap.put("totalOnTimeEndQty", totalOnTimeEndQty);
                } else if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) {
                    Integer totalOverTimeEndQty;
                    n3 = totalOverTimeEndQty = (Integer)taskQtyMap.get("totalOverTimeEndQty");
                    Integer n4 = totalOverTimeEndQty = Integer.valueOf(totalOverTimeEndQty + 1);
                    taskQtyMap.put("totalOverTimeEndQty", totalOverTimeEndQty);
                } else if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUE.getValue())) {
                    Integer totalOverTimeNotEndQty;
                    n3 = totalOverTimeNotEndQty = (Integer)taskQtyMap.get("totalOverTimeNotEndQty");
                    Integer n5 = totalOverTimeNotEndQty = Integer.valueOf(totalOverTimeNotEndQty + 1);
                    taskQtyMap.put("totalOverTimeNotEndQty", totalOverTimeNotEndQty);
                }
                if (planEndTime.before(firstDayOfThisMonth)) continue;
                n3 = planEndQty = (Integer)taskQtyMap.get("planEndQty");
                n = planEndQty = Integer.valueOf(planEndQty + 1);
                taskQtyMap.put("planEndQty", planEndQty);
                if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                    Integer onTimeEndQty;
                    n = onTimeEndQty = (Integer)taskQtyMap.get("onTimeEndQty");
                    Integer n6 = onTimeEndQty = Integer.valueOf(onTimeEndQty + 1);
                    taskQtyMap.put("onTimeEndQty", onTimeEndQty);
                    continue;
                }
                if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) {
                    Integer overTimeEndQty;
                    n = overTimeEndQty = (Integer)taskQtyMap.get("overTimeEndQty");
                    Integer n7 = overTimeEndQty = Integer.valueOf(overTimeEndQty + 1);
                    taskQtyMap.put("overTimeEndQty", overTimeEndQty);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUE.getValue())) continue;
                n = overTimeNotEndQty = (Integer)taskQtyMap.get("overTimeNotEndQty");
                Integer n8 = overTimeNotEndQty = Integer.valueOf(overTimeNotEndQty + 1);
                taskQtyMap.put("overTimeNotEndQty", overTimeNotEndQty);
                continue;
            }
            taskQtyMap = new HashMap<String, Integer>(16);
            int planEndQty = 0;
            int onTimeEndQty = 0;
            int overTimeEndQty = 0;
            int overTimeNotEndQty = 0;
            int totalPlanEndQty = 0;
            int totalOnTimeEndQty = 0;
            int totalOverTimeEndQty = 0;
            int totalOverTimeNotEndQty = 0;
            ++totalPlanEndQty;
            if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                ++totalOnTimeEndQty;
            } else if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) {
                ++totalOverTimeEndQty;
            } else if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUE.getValue())) {
                ++totalOverTimeNotEndQty;
            }
            if (!planEndTime.before(firstDayOfThisMonth)) {
                ++planEndQty;
                if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.ONTIMECOMPLETE.getValue())) {
                    ++onTimeEndQty;
                } else if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUECOMPLETE.getValue())) {
                    ++overTimeEndQty;
                } else if (StringUtils.equals((CharSequence)status, (CharSequence)CompletionStatusEnum.OVERDUE.getValue())) {
                    ++overTimeNotEndQty;
                }
            }
            taskQtyMap.put("planEndQty", planEndQty);
            taskQtyMap.put("onTimeEndQty", onTimeEndQty);
            taskQtyMap.put("overTimeEndQty", overTimeEndQty);
            taskQtyMap.put("overTimeNotEndQty", overTimeNotEndQty);
            taskQtyMap.put("totalPlanEndQty", totalPlanEndQty);
            taskQtyMap.put("totalOnTimeEndQty", totalOnTimeEndQty);
            taskQtyMap.put("totalOverTimeEndQty", totalOverTimeEndQty);
            taskQtyMap.put("totalOverTimeNotEndQty", totalOverTimeNotEndQty);
            majorTypeMap.put(majorTypeId, taskQtyMap);
        }
        if (majorTypeMap.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"datadetalap"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"datadetalap"});
        for (Map.Entry entry : majorTypeMap.entrySet()) {
            int rowIndex = this.getModel().createNewEntryRow("datadetailentry");
            this.getModel().setValue("majortype", entry.getKey(), rowIndex);
            Map taskQtyMap = (Map)entry.getValue();
            this.getModel().setValue("entryplanend", taskQtyMap.get("planEndQty"), rowIndex);
            this.getModel().setValue("entryontimeend", taskQtyMap.get("onTimeEndQty"), rowIndex);
            this.getModel().setValue("entryovertimeend", taskQtyMap.get("overTimeEndQty"), rowIndex);
            this.getModel().setValue("entryovertimenotend", taskQtyMap.get("overTimeNotEndQty"), rowIndex);
            this.getModel().setValue("entrytotalplanend", taskQtyMap.get("totalPlanEndQty"), rowIndex);
            this.getModel().setValue("entrytotalontimeend", taskQtyMap.get("totalOnTimeEndQty"), rowIndex);
            this.getModel().setValue("entrytotalovertimeend", taskQtyMap.get("totalOverTimeEndQty"), rowIndex);
            this.getModel().setValue("entrytotalovertimenotend", taskQtyMap.get("totalOverTimeNotEndQty"), rowIndex);
        }
    }

    private void updateProcessEntry() {
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (project == null) {
            return;
        }
        this.getModel().deleteEntryData("progressentry");
        QFilter majorTypeFilter = new QFilter("majortype.plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject[] majorPlanArr = BusinessDataServiceHelper.load((String)"pmpm_majorplan", (String)"id,name,majortype", (QFilter[])new QFilter[]{projectFilter, majorTypeFilter, billStatusFilter});
        if (majorPlanArr == null || majorPlanArr.length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"processap"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"processap"});
        HashSet<String> majorNameSet = new HashSet<String>();
        for (DynamicObject majorPlan : majorPlanArr) {
            DynamicObject majorType = majorPlan.getDynamicObject("majortype");
            if (majorType == null) continue;
            majorNameSet.add(majorType.getString("name"));
        }
        int rowIndex = this.getModel().createNewEntryRow("progressentry");
        this.getModel().setValue("majortypename", (Object)ResManager.loadKDString((String)"\u6574\u4f53\u8bf4\u660e", (String)"ProOperationalReportPlugin_26", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), rowIndex);
        for (String majorName : majorNameSet) {
            rowIndex = this.getModel().createNewEntryRow("progressentry");
            this.getModel().setValue("majortypename", (Object)majorName, rowIndex);
        }
    }

    private void setCruxTaskDetail(DynamicObject task, int rowIndex) {
        DynamicObject cooperationDept;
        DynamicObject cooperationPerson;
        DynamicObject responsibleDept;
        this.getModel().setValue("cruxtaskstatus", task.get("completionstatus"), rowIndex);
        this.getModel().setValue("cruxtaskname", (Object)task.getString("name"), rowIndex);
        DynamicObject majorType = task.getDynamicObject("majortype");
        if (majorType != null) {
            this.getModel().setValue("cruxmajorname", (Object)majorType.getString("name"), rowIndex);
        }
        this.getModel().setValue("cruxpercent", (Object)task.getBigDecimal("percent").divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP), rowIndex);
        this.getModel().setValue("cruxplanendtime", task.get("planendtime"), rowIndex);
        this.getModel().setValue("cruxrealendtime", task.get("realendtime"), rowIndex);
        this.getModel().setValue("cruxrealtimedeviation", task.get("realtimedeviation"), rowIndex);
        DynamicObject responsiblePerson = task.getDynamicObject("responsibleperson");
        if (responsiblePerson != null) {
            this.getModel().setValue("cruxresponsibleperson", (Object)responsiblePerson.getString("name"), rowIndex);
        }
        if ((responsibleDept = task.getDynamicObject("responsibledept")) != null) {
            this.getModel().setValue("cruxresponsibledept", (Object)responsibleDept.getString("name"), rowIndex);
        }
        if ((cooperationPerson = task.getDynamicObject("cooperationperson")) != null) {
            this.getModel().setValue("cruxcooperationperson", (Object)cooperationPerson.getString("name"), rowIndex);
        }
        if ((cooperationDept = task.getDynamicObject("cooperationdept")) != null) {
            this.getModel().setValue("cruxcooperationdept", (Object)cooperationDept.getString("name"), rowIndex);
        }
        this.getModel().setValue("cruxversion", task.get("version"), rowIndex);
    }

    private void setThisCycleTaskDetail(DynamicObject task, int rowIndex) {
        DynamicObject responsiblePerson;
        DynamicObject majorType;
        this.getModel().setValue("thistaskstatus", task.get("completionstatus"), rowIndex);
        this.getModel().setValue("thiscycletaskname", (Object)task.getString("name"), rowIndex);
        DynamicObject taskType = task.getDynamicObject("tasktype");
        if (taskType != null) {
            this.getModel().setValue("thistasktype", (Object)taskType.getString("name"), rowIndex);
        }
        if ((majorType = task.getDynamicObject("majortype")) != null) {
            this.getModel().setValue("thismajorname", (Object)majorType.getString("name"), rowIndex);
        }
        if ((responsiblePerson = task.getDynamicObject("responsibleperson")) != null) {
            this.getModel().setValue("thisresponsibleperson", (Object)responsiblePerson.getString("name"), rowIndex);
        }
        this.getModel().setValue("thisplanendtime", task.get("planendtime"), rowIndex);
        this.getModel().setValue("thisrealendtime", task.get("realendtime"), rowIndex);
        this.getModel().setValue("thisrealtimedeviation", task.get("realtimedeviation"), rowIndex);
        this.getModel().setValue("thisversion", task.get("version"), rowIndex);
    }

    private void setNextCycleTaskDetail(DynamicObject task, int rowIndex) {
        DynamicObject cooperationPerson;
        DynamicObject majorType;
        this.getModel().setValue("nextcycletaskname", (Object)task.getString("name"), rowIndex);
        DynamicObject taskType = task.getDynamicObject("tasktype");
        if (taskType != null) {
            this.getModel().setValue("nexttasktype", (Object)taskType.getString("name"), rowIndex);
        }
        if ((majorType = task.getDynamicObject("majortype")) != null) {
            this.getModel().setValue("nextmajorname", (Object)majorType.getString("name"), rowIndex);
        }
        this.getModel().setValue("nextplanstarttime", task.get("planstarttime"), rowIndex);
        this.getModel().setValue("nextplanendtime", task.get("planendtime"), rowIndex);
        DynamicObject responsiblePerson = task.getDynamicObject("responsibleperson");
        if (responsiblePerson != null) {
            this.getModel().setValue("nextresponsibleperson", (Object)responsiblePerson.getString("name"), rowIndex);
        }
        if ((cooperationPerson = task.getDynamicObject("cooperationperson")) != null) {
            this.getModel().setValue("nextcooperationperson", (Object)cooperationPerson.getString("name"), rowIndex);
        }
        this.getModel().setValue("nextversion", task.get("version"), rowIndex);
    }

    private QFilter getCommonFilter() {
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        QFilter sourceTaskFilter = new QFilter("sourcetask", "=", (Object)"0");
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter notFenJieFilter = new QFilter("belongplantype.plantype", "!=", (Object)PlanTypeEnum.DEPTFENJIEPLAN.getValue());
        return sourceTaskFilter.and(projectFilter).and(statusFilter).and(notFenJieFilter);
    }
}

