/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.PlanEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmListPlugin;

public class ProPlanMonitorListPlugin
extends AbstractPmpmListPlugin
implements HyperLinkClickListener {
    private static final String KEY_TREEENTRYENTITY = "taskentity";
    private static final String CODE_EXPORT = "export";
    private static String[] COLUMNKEY = new String[]{"taskname", "completionstatus", "project", "controllevelname", "majortypename", "tasktype", "absoluteduration", "percent", "pretaskname", "planstarttime", "planendtime", "aimfinishtime", "comptimedeviation", "responsiblepersonname", "responsibledeptname", "cooperationpersonsname", "resultdoc"};
    private String[] header = new String[]{ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"ProPlanMonitorListPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"ProPlanMonitorListPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9879\u76ee", (String)"ProPlanMonitorListPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"ProPlanMonitorListPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"ProPlanMonitorListPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"ProPlanMonitorListPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"ProPlanMonitorListPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fdb\u5ea6\uff08%\uff09", (String)"ProPlanMonitorListPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"ProPlanMonitorListPlugin_8", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"ProPlanMonitorListPlugin_9", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"ProPlanMonitorListPlugin_10", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u76ee\u6807\u5b8c\u6210\u65f6\u95f4", (String)"ProPlanMonitorListPlugin_11", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u504f\u5dee", (String)"ProPlanMonitorListPlugin_12", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba", (String)"ProPlanMonitorListPlugin_13", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u90e8\u95e8", (String)"ProPlanMonitorListPlugin_14", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba", (String)"ProPlanMonitorListPlugin_15", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u679c", (String)"ProPlanMonitorListPlugin_16", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0])};

    private String getFileName() {
        return ResManager.loadKDString((String)"\u9879\u76ee\u8ba1\u5212\u76d1\u63a7", (String)"ProPlanMonitorListPlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
    }

    private String getSheetName() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"ProPlanMonitorListPlugin_18", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
    }

    private String[] getHeader() {
        return this.header;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (CODE_EXPORT.equals(operateKey)) {
            this.doExportExcel();
        }
    }

    private void doExportExcel() {
        DynamicObjectCollection rowData = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        if (!rowData.isEmpty()) {
            JSONArray data = new JSONArray();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject row : rowData) {
                JSONObject obj = new JSONObject();
                DynamicObject task = row.getDynamicObject("task");
                obj.put("taskname", (Object)task.getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("completionstatus", (Object)CompletionStatusEnum.getEnumByValue((Object)task.get("completionstatus")).getName());
                obj.put("project", task.getDynamicObject("project") == null ? null : task.getDynamicObject("project").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("controllevelname", task.getDynamicObject("controllevel") == null ? null : task.getDynamicObject("controllevel").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("majortypename", task.getDynamicObject("majortype") == null ? null : task.getDynamicObject("majortype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("tasktype", task.getDynamicObject("tasktype") == null ? null : task.getDynamicObject("tasktype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("absoluteduration", (Object)task.getInt("absoluteduration"));
                obj.put("percent", (Object)task.getBigDecimal("percent").setScale(2));
                obj.put("pretaskname", task.getDynamicObject("pretask") == null ? null : task.getDynamicObject("pretask").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("planstarttime", (Object)sdf.format(task.getDate("planstarttime")));
                obj.put("planendtime", (Object)sdf.format(task.get("planendtime")));
                obj.put("aimfinishtime", task.get("aimfinishtime") == null ? null : sdf.format(task.get("aimfinishtime")));
                obj.put("comptimedeviation", (Object)task.getInt("comptimedeviation"));
                obj.put("responsiblepersonname", task.getDynamicObject("responsibleperson") == null ? null : task.getDynamicObject("responsibleperson").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("responsibledeptname", task.getDynamicObject("responsibledept") == null ? null : task.getDynamicObject("responsibledept").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("cooperationpersonsname", task.getDynamicObject("cooperationperson") == null ? null : task.getDynamicObject("cooperationperson").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("resultdoc", task.get("resultdoc"));
                data.add((Object)obj);
            }
            String url = POIHelper.exportExcel((String)this.getFileName(), (String)this.getSheetName(), (String[])this.getHeader(), (String[])COLUMNKEY, null, (JSONArray)data);
            this.getView().download(url);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"ProPlanMonitorListPlugin_19", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        if (StringUtils.equals((CharSequence)"taskname", (CharSequence)fieldName)) {
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            DynamicObject task = (DynamicObject)this.getModel().getValue("task", rowIndex);
            if (task != null) {
                paramMap.put("formId", "pmpm_reporttaskview");
                paramMap.put("pkId", String.valueOf(task.getPkValue()));
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        HashSet<String> allTaskids;
        super.setFilter(e);
        this.getModel().deleteEntryData(KEY_TREEENTRYENTITY);
        List filters = e.getQFilters();
        HashMap<String, QFilter> taskFilterMap = new HashMap<String, QFilter>(16);
        ArrayList<QFilter> planFilters = new ArrayList<QFilter>(10);
        boolean hasCheckProjectFilter = false;
        QFilter majorTypeFilter = null;
        for (QFilter qFilter : filters) {
            String property = qFilter.getProperty();
            if ("project.createorg.id".equals(property)) continue;
            if ("belongplantype.id".equals(property)) {
                QFilter majorTypeIdFilter = new QFilter("majortype", "in", qFilter.getValue());
                majorTypeFilter = new QFilter("id", "=", qFilter.getValue());
                planFilters.add(majorTypeIdFilter);
                continue;
            }
            if ("project.id".equals(property)) {
                QFilter projectFilter = new QFilter("project", "in", qFilter.getValue());
                planFilters.add(projectFilter);
                hasCheckProjectFilter = true;
                continue;
            }
            taskFilterMap.put(property, qFilter);
        }
        if (!hasCheckProjectFilter || majorTypeFilter == null) {
            return;
        }
        DynamicObject majorObj = BusinessDataServiceHelper.loadSingle((String)"pmpm_majortype", (String)"plantype,plantypename", (QFilter[])new QFilter[]{majorTypeFilter});
        QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        planFilters.add(planVersion);
        if (StringUtils.equals((CharSequence)majorObj.getString("plantype"), (CharSequence)PlanTypeEnum.MAINPLAN.getValue())) {
            DynamicObject[] projectPlans = BusinessDataServiceHelper.load((String)"pmpm_projectplan", (String)"id,majortype,taskentity.id,taskentity.taskid,taskentity.level,taskentity.pid", (QFilter[])planFilters.toArray(new QFilter[planFilters.size()]));
            if (projectPlans == null || projectPlans.length == 0) {
                return;
            }
            allTaskids = new HashSet<String>(16);
            this.getAllTaskIdByProjectPlans(projectPlans, allTaskids);
            if (!allTaskids.isEmpty()) {
                this.fillTreeList(taskFilterMap, allTaskids, true);
            }
        } else if (StringUtils.equals((CharSequence)majorObj.getString("plantype"), (CharSequence)PlanTypeEnum.MAJORPLAN.getValue())) {
            DynamicObject[] majorPlans = BusinessDataServiceHelper.load((String)"pmpm_majorplan", (String)"id,majortype,taskentity.id,taskentity.taskid,taskentity.level,taskentity.pid", (QFilter[])planFilters.toArray(new QFilter[planFilters.size()]));
            if (majorPlans == null || majorPlans.length == 0) {
                return;
            }
            allTaskids = new HashSet(16);
            this.getAllTaskIdByMajorPlans(majorPlans, allTaskids);
            if (allTaskids.isEmpty()) {
                return;
            }
            this.fillTreeList(taskFilterMap, allTaskids, false);
        }
    }

    private boolean isMainTask(Object taskId) {
        if (taskId == null) {
            throw new KDBizException("\u4efb\u52a1ID\u4e3a\u7a7a");
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"belongplantype");
        DynamicObject belongplantype = task.getDynamicObject("belongplantype");
        return "1".equals((belongplantype = BusinessDataServiceHelper.loadSingle((Object)belongplantype.getString("id"), (String)"pmpm_majortype", (String)"plantype")).getString("plantype"));
    }

    private void fillTreeList(Map<String, QFilter> taskFilterMap, Set<String> allTaskids, boolean isFromMainPlan) {
        DynamicObject[] allTasks;
        DynamicObjectCollection showTaskCols = new DynamicObjectCollection();
        QFilter idFilter = new QFilter("id", "in", (Object)allTaskids.toArray());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(idFilter);
        for (DynamicObject task : allTasks = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"id,parent,tasktype,taskseq,controllevel,planstarttime,planendtime,sourcetask,status,completionstatus,comptimedeviation,level", (QFilter[])filterList.toArray(new QFilter[filterList.size()]), (String)"taskseq")) {
            boolean isShow = this.judgeTaskIsShow(task, taskFilterMap);
            if (!isShow) continue;
            showTaskCols.add((Object)task);
        }
        if (showTaskCols != null && !showTaskCols.isEmpty()) {
            this.fillTreeListByShowTask(showTaskCols, isFromMainPlan);
        }
    }

    private void getAllTaskIdByProjectPlans(DynamicObject[] projectPlans, Set<String> allTaskids) {
        for (DynamicObject plan : projectPlans) {
            DynamicObjectCollection taskEntry;
            if (!PlanTypeEnum.MAINPLAN.getValue().equals(plan.getDynamicObject("majortype").getString("plantype")) || (taskEntry = plan.getDynamicObjectCollection(KEY_TREEENTRYENTITY)) == null || taskEntry.isEmpty()) continue;
            List mainTaskIds = taskEntry.stream().map(entry -> entry.get("taskid").toString()).collect(Collectors.toList());
            allTaskids.addAll(mainTaskIds);
            break;
        }
    }

    private void getAllTaskIdByMajorPlans(DynamicObject[] projectPlans, Set<String> allTaskids) {
        for (DynamicObject plan : projectPlans) {
            DynamicObjectCollection taskEntry;
            if (plan.getDynamicObject("majortype") == null || (taskEntry = plan.getDynamicObjectCollection(KEY_TREEENTRYENTITY)) == null || taskEntry.isEmpty()) continue;
            List mainTaskIds = taskEntry.stream().map(entry -> entry.get("taskid").toString()).collect(Collectors.toList());
            allTaskids.addAll(mainTaskIds);
            break;
        }
    }

    private boolean judgeTaskIsShow(DynamicObject task, Map<String, QFilter> taskFilterMap) {
        ArrayList<Long> levelList = null;
        ArrayList<String> statusList = null;
        DynamicObject taskType = task.getDynamicObject("tasktype");
        if (taskFilterMap.get("tasktype.id") != null && taskType != null) {
            Object typeIds = taskFilterMap.get("tasktype.id").getValue();
            ArrayList<Long> taskTypeList = new ArrayList<Long>(10);
            if (typeIds instanceof List) {
                for (Object obj : (List)typeIds) {
                    taskTypeList.add((Long)obj);
                }
            } else {
                taskTypeList.add((Long)typeIds);
            }
            if (!taskTypeList.contains(taskType.getPkValue())) {
                return false;
            }
        }
        Object controllevel = task.get("controllevel.id");
        if (taskFilterMap.get("controllevel.id") != null) {
            Object levelIds = taskFilterMap.get("controllevel.id").getValue();
            levelList = new ArrayList<Long>(10);
            if (levelIds instanceof List) {
                for (Object obj : (List)levelIds) {
                    levelList.add((Long)obj);
                }
            } else {
                levelList.add((Long)levelIds);
            }
            if (controllevel == null || !levelList.contains(controllevel)) {
                return false;
            }
        }
        Object completionStatus = task.get("completionstatus");
        if (taskFilterMap.get("completionstatus") != null) {
            Object statusIds = taskFilterMap.get("completionstatus").getValue();
            statusList = new ArrayList<String>(10);
            if (statusIds instanceof List) {
                for (Object obj : (List)statusIds) {
                    statusList.add((String)obj);
                }
            } else {
                statusList.add(statusIds.toString());
            }
            if (completionStatus == null || !statusList.contains(completionStatus)) {
                return false;
            }
        }
        Date planstarttime = task.getDate("planstarttime");
        Long startMillisecond = planstarttime.getTime();
        Date planendtime = task.getDate("planendtime");
        Long endMillisecond = planendtime.getTime();
        if (taskFilterMap.get("planstarttime") != null) {
            QFilter time = taskFilterMap.get("planstarttime");
            Date smallTime = (Date)((QFilter.QFilterNest)time.getNests(true).get(0)).getParent().getValue();
            Long smallMillisecond = smallTime.getTime();
            Date bigTime = (Date)((QFilter.QFilterNest)time.getNests(true).get(0)).getFilter().getValue();
            Long bigMillisecond = bigTime.getTime();
            if (!(startMillisecond >= smallMillisecond && startMillisecond <= bigMillisecond || endMillisecond >= smallMillisecond && endMillisecond <= bigMillisecond)) {
                return false;
            }
        }
        return true;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        DynamicObject[] taskTypes;
        DynamicObject[] levels;
        List list = args.getCommonFilterColumns();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        CommonFilterColumn planTypeCommonFilterColumn = (CommonFilterColumn)filterGridView.getItems().get(2);
        List<ComboItem> planTypeComboItems = this.buildPlanTypeComboItems(null);
        if (planTypeComboItems.get(0) != null) {
            planTypeCommonFilterColumn.setDefaultValues(new Object[]{planTypeComboItems.get(0).getId()});
        }
        CommonFilterColumn orgColumn = (CommonFilterColumn)list.get(0);
        CommonFilterColumn controllevelColum = (CommonFilterColumn)list.get(3);
        List controllevelItems = controllevelColum.getComboItems();
        ArrayList<Object> new_controllevelItems = new ArrayList<Object>(10);
        ArrayList<String> levelIds = new ArrayList<String>(10);
        for (ComboItem comboItem : controllevelItems) {
            levelIds.add(comboItem.getValue());
        }
        ArrayList<QFilter> levelFilters = new ArrayList<QFilter>(10);
        QFilter levelIdFilter = new QFilter("id", "in", (Object)levelIds.toArray());
        levelFilters.add(levelIdFilter);
        QFilter levelEnableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        levelFilters.add(levelEnableFilter);
        for (DynamicObject level : levels = BusinessDataServiceHelper.load((String)"pmpm_controllevel", (String)"id,name", (QFilter[])levelFilters.toArray(new QFilter[levelFilters.size()]))) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(level.getPkValue()));
            item.setCaption(new LocaleString(level.getString("name")));
            item.setValue(String.valueOf(level.getPkValue()));
            new_controllevelItems.add(item);
        }
        controllevelColum.setComboItems(new_controllevelItems);
        CommonFilterColumn taskTypeColum = (CommonFilterColumn)list.get(4);
        List taskTypeItems = taskTypeColum.getComboItems();
        ArrayList<ComboItem> new_taskTypeItems = new ArrayList<ComboItem>(10);
        ArrayList<String> typeIds = new ArrayList<String>(10);
        for (ComboItem comboItem : taskTypeItems) {
            typeIds.add(comboItem.getValue());
        }
        ArrayList<QFilter> typeFilters = new ArrayList<QFilter>(10);
        QFilter typeIdFilter = new QFilter("id", "in", (Object)typeIds.toArray());
        typeFilters.add(typeIdFilter);
        QFilter typeEnableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        typeFilters.add(typeEnableFilter);
        QFilter isProjectFilter = new QFilter("checkboxisprojecttask", "=", (Object)DefaultEnum.YES.getValue());
        typeFilters.add(isProjectFilter);
        for (DynamicObject type : taskTypes = BusinessDataServiceHelper.load((String)"pmpm_tasktype", (String)"id,name", (QFilter[])typeFilters.toArray(new QFilter[typeFilters.size()]))) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(type.getPkValue()));
            item.setCaption(new LocaleString(type.getString("name")));
            item.setValue(String.valueOf(type.getPkValue()));
            new_taskTypeItems.add(item);
        }
        taskTypeColum.setComboItems(new_taskTypeItems);
        this.setFilterParamFromOtherPage(filterGridView, planTypeCommonFilterColumn, orgColumn);
        super.filterContainerInit(args);
    }

    private void setFilterParamFromOtherPage(FilterGridView filterGridView, CommonFilterColumn planTypeCommonFilterColumn, CommonFilterColumn orgColumn) {
        Object orgIdparma = this.getView().getFormShowParameter().getCustomParam("orgId");
        Object planTypeId = this.getView().getFormShowParameter().getCustomParam("planTypeId");
        Object proId = this.getView().getFormShowParameter().getCustomParam("proId");
        if (null != orgIdparma && null != planTypeId && null != proId) {
            orgColumn.setDefaultValue(String.valueOf(orgIdparma));
            planTypeCommonFilterColumn.setDefaultValue(String.valueOf(planTypeId));
            CommonFilterColumn projectColumn = (CommonFilterColumn)filterGridView.getItems().get(1);
            if (null != projectColumn) {
                List comboItems = projectColumn.getComboItems();
                String proIdStr = String.valueOf(proId);
                boolean isExistPro = false;
                for (ComboItem comboItem : comboItems) {
                    if (!StringUtils.equals((CharSequence)comboItem.getValue(), (CharSequence)proIdStr)) continue;
                    isExistPro = true;
                    break;
                }
                if (isExistPro) {
                    projectColumn.setDefaultValue(proIdStr);
                } else {
                    QFilter qFilter = new QFilter("id", "=", proId);
                    DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{qFilter});
                    if (project != null) {
                        ComboItem item = new ComboItem();
                        item.setId(project.getPkValue().toString());
                        item.setCaption(new LocaleString(project.getString("name")));
                        item.setValue(project.getPkValue().toString());
                        comboItems.add(0, item);
                        projectColumn.setDefaultValue(proIdStr);
                    } else {
                        projectColumn.setDefaultValue(proIdStr);
                    }
                }
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        Object projectId = args.getFilterValue("project.id");
        if (projectId == null) {
            return;
        }
        CommonFilterColumn planTypeCommonFilterColumn = (CommonFilterColumn)filterGridView.getItems().get(2);
        List<ComboItem> planTypeComboItems = this.buildPlanTypeComboItems(projectId);
        planTypeCommonFilterColumn.setComboItems(planTypeComboItems);
        super.filterContainerSearchClick(args);
    }

    private List<ComboItem> buildPlanTypeComboItems(Object projectId) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (projectId != null) {
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project");
            DynamicObject kind = project.getDynamicObject("group");
            if (kind != null) {
                QFilter filter = new QFilter("group", "=", kind.getPkValue());
                QFilter planTypeFilter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
                filter.or(planTypeFilter);
                filters.add(filter);
            } else {
                QFilter planTypeFilter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
                filters.add(planTypeFilter);
            }
        } else {
            QFilter filter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue()).or("plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
            filters.add(filter);
        }
        QFilter typeEnableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        filters.add(typeEnableFilter);
        DynamicObject[] majors = BusinessDataServiceHelper.load((String)"pmpm_majortype", (String)"plantype,plantypename", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (majors.length > 0) {
            for (DynamicObject planType : majors) {
                ComboItem item = new ComboItem();
                item.setId(planType.getPkValue().toString());
                OrmLocaleValue type = (OrmLocaleValue)planType.get("plantypename");
                item.setCaption(new LocaleString(type.getLocaleValue()));
                item.setValue(planType.getPkValue().toString());
                if (PlanTypeEnum.getEnumByValue((Object)planType.get("plantype")).equals((Object)PlanTypeEnum.MAINPLAN)) {
                    combos.add(0, item);
                    continue;
                }
                combos.add(item);
            }
        }
        return combos;
    }

    private void fillTreeList(IDataModel model, DynamicObjectCollection allTasks, DynamicObjectCollection parents, boolean isRoot, int rowIndex) {
        if (allTasks == null || allTasks.isEmpty()) {
            return;
        }
        parents.sort(Comparator.comparing(task -> task.getInt("taskseq")));
        for (int i = 0; i < parents.size(); ++i) {
            DynamicObject parent = (DynamicObject)parents.get(i);
            allTasks.remove((Object)parent);
            int rIndex = 0;
            rIndex = isRoot ? model.createNewEntryRow(KEY_TREEENTRYENTITY) : model.insertEntryRow(KEY_TREEENTRYENTITY, rowIndex);
            TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
            Object parentId = parent.getPkValue();
            grid.setCollapse(false);
            grid.getModel().updateCache();
            model.setValue("task", parent.getPkValue(), rIndex);
            String completionstatus = parent.getString("completionstatus");
            model.setValue("completionstatus", (Object)completionstatus, rIndex);
            CellStyle style = new CellStyle();
            style.setRow(rIndex);
            style.setFieldKey("comptimedeviation");
            BigDecimal comptimedeviation = parent.getBigDecimal("comptimedeviation");
            if (BigDecimal.ZERO.compareTo(comptimedeviation) > 0) {
                style.setForeColor("red");
            } else if (BigDecimal.ZERO.compareTo(comptimedeviation) < 0) {
                style.setForeColor("green");
            }
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
            styles.add(style);
            grid.setCellStyle(styles);
            DynamicObjectCollection sons = new DynamicObjectCollection();
            for (DynamicObject task2 : allTasks) {
                Object taskParentId = task2.get("parent.id");
                if (parentId == null || taskParentId == null || !parentId.toString().equals(taskParentId.toString())) continue;
                sons.add((Object)task2);
            }
            if (sons.isEmpty()) continue;
            this.fillTreeList(model, allTasks, sons, false, rIndex);
        }
    }

    private void fillTreeListByShowTask(DynamicObjectCollection allTaskCol, boolean isFromMainPlan) {
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
        DynamicObjectCollection taskEntityCols = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        DynamicObjectType dt = taskEntityCols.getDynamicObjectType();
        ArrayList<Integer> taskIndexFromMainPlans = new ArrayList<Integer>(allTaskCol.size());
        DynamicObject taskObj = null;
        DynamicObject newTaskObj = null;
        for (int i = 0; i < allTaskCol.size(); ++i) {
            boolean isFromMainTask;
            taskObj = (DynamicObject)allTaskCol.get(i);
            newTaskObj = new DynamicObject(dt);
            if (!isFromMainPlan && (isFromMainTask = this.isMainTask(taskObj.getPkValue()))) {
                taskIndexFromMainPlans.add(i);
            }
            newTaskObj.set("id", (Object)taskObj.getPkValue().toString());
            newTaskObj.set("task", (Object)taskObj);
            String completionstatus = taskObj.getString("completionstatus");
            newTaskObj.set("completionstatus", (Object)completionstatus);
            newTaskObj.set("pid", (Object)(taskObj.getDynamicObject("parent") == null ? "0" : taskObj.getDynamicObject("parent").getPkValue().toString()));
            taskEntityCols.add((Object)newTaskObj);
            CellStyle style = new CellStyle();
            style.setRow(i);
            style.setFieldKey("comptimedeviation");
            BigDecimal comptimedeviation = taskObj.getBigDecimal("comptimedeviation");
            if (BigDecimal.ZERO.compareTo(comptimedeviation) > 0) {
                style.setForeColor("red");
            } else if (BigDecimal.ZERO.compareTo(comptimedeviation) < 0) {
                style.setForeColor("green");
            }
            styles.add(style);
        }
        int[] taskIndexFromMainPlan = taskIndexFromMainPlans.stream().mapToInt(Integer::intValue).toArray();
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        grid.setCollapse(false);
        grid.setCellStyle(styles);
        grid.setRowLock(true, taskIndexFromMainPlan);
        grid.setRowBackcolor("lightgrey", taskIndexFromMainPlan);
        grid.getModel().updateCache();
        grid.getModel().updateEntryCache(taskEntityCols);
        this.getModel().updateEntryCache(taskEntityCols);
        this.getView().updateView(KEY_TREEENTRYENTITY);
    }

    private void fillList(IDataModel model, DynamicObjectCollection tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_TREEENTRYENTITY);
        for (DynamicObject task : tasks) {
            int rIndex = model.createNewEntryRow(KEY_TREEENTRYENTITY);
            grid.getModel().updateCache();
            model.setValue("task", task.getPkValue(), rIndex);
            String completionstatus = task.getString("completionstatus");
            model.setValue("completionstatus", (Object)completionstatus, rIndex);
            CellStyle style = new CellStyle();
            style.setRow(rIndex);
            style.setFieldKey("comptimedeviation");
            BigDecimal comptimedeviation = task.getBigDecimal("comptimedeviation");
            if (BigDecimal.ZERO.compareTo(comptimedeviation) > 0) {
                style.setForeColor("red");
            } else if (BigDecimal.ZERO.compareTo(comptimedeviation) < 0) {
                style.setForeColor("green");
            }
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
            styles.add(style);
            grid.setCellStyle(styles);
        }
    }
}

