/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PlanEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmFormPlugin;

public class ProResultDocTrackListPlugin
extends AbstractPmpmFormPlugin
implements HyperLinkClickListener {
    private static final String COL_RESULTNAME = "resultname";
    private static final String COL_TASKNAME = "name";
    private static final String BILLLISTID = "billlistap";
    private static final String CODE_QUERYCLICK = "queryclick";
    private static final String KEY_SEARCH = "search";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billlist = (BillList)this.getControl(BILLLISTID);
        billlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (CODE_QUERYCLICK.equals(operateKey)) {
            String textField = (String)this.getModel().getValue("textfield");
            Label label = (Label)this.getControl("labelap");
            if (StringUtils.equals((CharSequence)textField, (CharSequence)ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]))) {
                label.setText(ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            } else {
                label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"ProResultDocTrackListPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            }
        } else if (KEY_SEARCH.equals(operateKey)) {
            this.doSearch();
        }
    }

    private void doSearch() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee", (String)"ProResultDocTrackListPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        BillList billList = (BillList)this.getControl(BILLLISTID);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter projectFilter = new QFilter("project.id", "=", project.getPkValue());
        qFilters.add(projectFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilters.add(statusFilter);
        QFilter taskFilter = new QFilter("sourcetask.id", "=", (Object)0);
        qFilters.add(taskFilter);
        QFilter achievementNodeFilter = new QFilter("achievementnode", "=", (Object)DefaultEnum.YES.getValue());
        qFilters.add(achievementNodeFilter);
        QFilter isForceFilter = new QFilter("taskresultdocentry.force", "=", (Object)DefaultEnum.YES.getValue());
        qFilters.add(isForceFilter);
        billList.getFilterParameter().setQFilters(qFilters);
        billList.getFilterParameter().setOrderBy("majorname asc,name asc");
        billList.refreshData();
        this.configCellStyle();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl(BILLLISTID);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter filter = new QFilter("1", "=", (Object)0);
        qFilters.add(filter);
        billList.getFilterParameter().setQFilters(qFilters);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object orgIdparma = this.getView().getFormShowParameter().getCustomParam("orgId");
        Object planTypeId = this.getView().getFormShowParameter().getCustomParam("planTypeId");
        Object proId = this.getView().getFormShowParameter().getCustomParam("proId");
        if (null != orgIdparma && null != planTypeId && null != proId) {
            this.getModel().setValue("org", orgIdparma);
            this.getModel().setValue("project", proId);
            BillList billList = (BillList)this.getControl(BILLLISTID);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter majortype = new QFilter("majortype", "=", planTypeId);
            QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
            QFilter proPlan = new QFilter("project", "=", proId);
            DynamicObject[] plans = BusinessDataServiceHelper.load((String)"pmpm_projectplan", (String)"id,taskentity,taskentity.taskid", (QFilter[])new QFilter[]{majortype, planVersion, proPlan});
            HashSet<Object> allTaskids = new HashSet<Object>();
            for (DynamicObject plan : plans) {
                DynamicObjectCollection taskentries = plan.getDynamicObjectCollection("taskentity");
                if (taskentries == null || taskentries.size() <= 0) continue;
                for (DynamicObject entry : taskentries) {
                    Object id = entry.get("taskid");
                    allTaskids.add(id);
                }
            }
            QFilter projectFilter = new QFilter("id", "in", allTaskids);
            qFilters.add(projectFilter);
            billList.getFilterParameter().setQFilters(qFilters);
            billList.getFilterParameter().setOrderBy("majorname asc,name asc");
            billList.refreshData();
            this.getView().updateView("project");
            this.getView().updateView("org");
            this.getView().invokeOperation(KEY_SEARCH);
        }
        this.configCellStyle();
    }

    private void configCellStyle() {
        BillList taskbilllist = (BillList)this.getControl(BILLLISTID);
        ListSelectedRowCollection rows = taskbilllist.getCurrentListAllRowCollection();
        if (rows.isEmpty()) {
            return;
        }
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            ListSelectedRow taskRow = rows.get(rowIndex);
            Object taskid = taskRow.getPrimaryKeyValue();
            Object entryid = taskRow.getEntryPrimaryKeyValue();
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(rowIndex);
            cellStyle.setFieldKey(COL_RESULTNAME);
            ArrayList<Object> docEntryIdList = new ArrayList<Object>(10);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            QFilter taskFilter = new QFilter("task", "=", taskid);
            filters.add(taskFilter);
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            filters.add(statusFilter);
            DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)"pmpm_taskreport", (String)"id,billno,billstatus,persontype,creator,modifier,auditor,auditdate,modifytime,createtime,chengguoentity.id,chengguoentity.attachmentfield,chengguoentity.resultname,chengguoentity.desc,chengguoentity.force,chengguoentity.resultid,chengguoentity.frequency,iscomplete,completetime,tips,reportdesc,huibaojlentity.id,huibaojlentity.completeprocess,huibaojlentity.resultdate,huibaojlentity.reportperson,huibaojlentity.completedesc,huibaojlentity.taskreport,huibaojlentity.historytask,huibaojlentity.resultstatus,task,percent,huibaoperson", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"modifytime desc");
            if (taskReports != null && taskReports.length != 0) {
                if (taskReports[0].getBigDecimal("percent").compareTo(new BigDecimal("100")) == 0) {
                    cellStyle.setBackColor("lightgreen");
                } else {
                    block1: for (DynamicObject report : taskReports) {
                        DynamicObjectCollection entries = report.getDynamicObjectCollection("chengguoentity");
                        if (entries.isEmpty()) continue;
                        for (DynamicObject resultdoc : entries) {
                            if (!entryid.toString().equals(resultdoc.getString("resultid"))) continue;
                            docEntryIdList.add(resultdoc.getPkValue());
                            continue block1;
                        }
                    }
                    List results = new ArrayList();
                    if (!docEntryIdList.isEmpty()) {
                        String sql = "SELECT FBASEDATAID FROM T_PMPM_TASKREPORTDOC WHERE FENTRYID in(" + StringUtils.strip((String)((Object)docEntryIdList).toString(), (String)"[]") + ")";
                        results = (List)DB.query((DBRoute)new DBRoute("cr"), (String)sql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                            public List<String> handle(ResultSet rs) throws Exception {
                                ArrayList<String> result = new ArrayList<String>(10);
                                while (rs.next()) {
                                    result.add(rs.getString(1));
                                }
                                return result;
                            }
                        });
                    }
                    if (results.size() == 0) {
                        cellStyle.setBackColor("lightgrey");
                    }
                }
            } else {
                cellStyle.setBackColor("lightgrey");
            }
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
            cellStyles.add(cellStyle);
            taskbilllist.setCellStyle(cellStyles);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if (COL_RESULTNAME.equals(fieldName)) {
            this.resultNameHyperLink(args);
        } else if (COL_TASKNAME.equals(fieldName)) {
            BillList taskbilllist = (BillList)this.getControl(BILLLISTID);
            ListSelectedRow row = taskbilllist.getCurrentSelectedRowInfo();
            Long taskPk = (Long)row.getPrimaryKeyValue();
            if (taskPk != null) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("formId", "pmpm_reporttaskview");
                paramMap.put("pkId", String.valueOf(taskPk));
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u53ef\u80fd\u4e0d\u5b58\u5728", (String)"ProResultDocTrackListPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resultNameHyperLink(HyperLinkClickEvent args) {
        String sql;
        void var14_16;
        BillList taskbilllist = (BillList)this.getControl(BILLLISTID);
        ListSelectedRowCollection rows = taskbilllist.getCurrentListAllRowCollection();
        Optional<ListSelectedRow> currentRow = rows.stream().filter(row -> row.getRowKey() == args.getRowIndex()).findFirst();
        if (!currentRow.isPresent()) {
            return;
        }
        Object taskid = currentRow.get().getPrimaryKeyValue();
        Object entryid = currentRow.get().getEntryPrimaryKeyValue();
        ArrayList<Object> docEntryIdList = new ArrayList<Object>();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter taskFilter = new QFilter("task", "=", taskid);
        filters.add(taskFilter);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        filters.add(statusFilter);
        DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)"pmpm_taskreport", (String)"id,billno,billstatus,persontype,creator,modifier,auditor,auditdate,modifytime,createtime,chengguoentity.id,chengguoentity.attachmentfield,chengguoentity.resultname,chengguoentity.desc,chengguoentity.force,chengguoentity.resultid,chengguoentity.frequency,iscomplete,completetime,tips,reportdesc,huibaojlentity.id,huibaojlentity.completeprocess,huibaojlentity.resultdate,huibaojlentity.reportperson,huibaojlentity.completedesc,huibaojlentity.taskreport,huibaojlentity.historytask,huibaojlentity.resultstatus,task,percent,huibaoperson", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"modifytime desc");
        if (taskReports == null || taskReports.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6682\u672a\u5f00\u59cb\u6c47\u62a5", (String)"ProResultDocTrackListPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        DynamicObject[] dynamicObjectArray = taskReports;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var14_16 < n) {
            DynamicObject report = dynamicObjectArray[var14_16];
            DynamicObjectCollection entries = report.getDynamicObjectCollection("chengguoentity");
            if (!entries.isEmpty()) {
                for (DynamicObject resultdoc : entries) {
                    if (!entryid.toString().equals(resultdoc.getString("resultid"))) continue;
                    docEntryIdList.add(resultdoc.getPkValue());
                }
            }
            ++var14_16;
        }
        if (docEntryIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6682\u672a\u4e0a\u4f20\u6587\u6863\uff0c\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"ProResultDocTrackListPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        List results = new ArrayList();
        for (Object e : docEntryIdList) {
            if (!results.isEmpty()) break;
            sql = "SELECT FBASEDATAID FROM T_PMPM_TASKREPORTDOC WHERE FENTRYID = " + e;
            results = (List)DB.query((DBRoute)new DBRoute("cr"), (String)sql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> result = new ArrayList<String>(10);
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                    return result;
                }
            });
        }
        if (results == null || results.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6682\u672a\u4e0a\u4f20\u6587\u6863,\u4e0b\u8f7d\u5931\u8d25", (String)"ProResultDocTrackListPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        for (String string : results) {
            sql = "SELECT FURL FROM T_BD_ATTACHMENT WHERE FID = " + string;
            List files = (List)DB.query((DBRoute)new DBRoute("basedata"), (String)sql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> result = new ArrayList<String>(10);
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                    return result;
                }
            });
            String attUrl = EncreptSessionUtils.encryptSession((String)UrlService.getAttachmentFullUrl((String)((String)files.get(0))));
            this.getView().download(attUrl);
        }
    }
}

