/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmbs.common.utils.TimeUtils;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;
import kd.pmgt.pmpm.formplugin.ProjWorkCalendarLoadService;
import org.apache.commons.lang.ArrayUtils;

public class ProjWorkCalendarEntityPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ProjWorkCalendarEntityPlugin.class);
    private static final int DEFAULT_YEAR_COUNT = 100;
    public final SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");

    public void initialize() {
        this.addClickListeners(new String[]{"btnsave"});
        this.initProperty();
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IPageCache pageCache = this.getPageCache();
        DynamicObject dynamicObject = this.getDynamicObject();
        String oldexpiringyearfrom = dynamicObject.getString("expiringyearfrom");
        String oldexpiringmonthfrom = dynamicObject.getString("expiringmonthfrom");
        String oldexpiringyearto = dynamicObject.getString("expiringyearto");
        String oldexpiringmonthto = dynamicObject.getString("expiringmonthto");
        if (StringUtils.isNotEmpty((CharSequence)oldexpiringyearfrom) && StringUtils.isNotEmpty((CharSequence)oldexpiringmonthfrom) && StringUtils.isNotEmpty((CharSequence)oldexpiringyearto) && StringUtils.isNotEmpty((CharSequence)oldexpiringmonthto)) {
            hashMap.put("oldexpiringyearfrom", oldexpiringyearfrom);
            hashMap.put("oldexpiringmonthfrom", oldexpiringmonthfrom);
            hashMap.put("oldexpiringyearto", oldexpiringyearto);
            hashMap.put("oldexpiringmonthto", oldexpiringmonthto);
            pageCache.put(hashMap);
        }
        IDataModel model = this.getModel();
        boolean[] arrArestDays = this.getRestDays(model);
        String restDays = ArrayUtils.toString((Object)arrArestDays);
        pageCache.put("oldRestDays", restDays);
        if (StringUtils.isNotEmpty((CharSequence)oldexpiringmonthfrom)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"expiringmonthfrom"});
        }
        if (StringUtils.isNotEmpty((CharSequence)oldexpiringyearfrom)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"expiringyearfrom"});
        }
    }

    private void initProperty() {
        Calendar cal = Calendar.getInstance();
        int currentYear = cal.get(1);
        this.genYearComboItems("expiringyearfrom", currentYear - 5);
        this.genYearComboItems("expiringyearto", currentYear - 5);
    }

    private void genYearComboItems(String propertyName, int currentYear) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(10);
        for (int i = 0; i < 100; ++i) {
            String year = String.valueOf(currentYear + i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(year));
            comboItem.setValue(year);
            propertyItems.add(comboItem);
        }
        propertyField.selectedStore((ComboItem)propertyItems.get(5));
        propertyField.setComboItems(propertyItems);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (!(source instanceof AbstractOperate)) {
            return;
        }
        AbstractOperate op = (AbstractOperate)source;
        if ("save".equalsIgnoreCase(op.getOperateKey())) {
            if (!this.getModel().getDataChanged()) {
                args.cancel = true;
                this.getView().close();
                return;
            }
            if (this.validate()) {
                boolean taskflag;
                IDataModel model = this.getModel();
                String oldRestDays = this.getPageCache().get("oldRestDays");
                Map all = this.getPageCache().getAll();
                String oldexpiringyearfrom = (String)all.get("oldexpiringyearfrom");
                String expiringyearfrom = this.getModel().getValue("expiringyearfrom").toString();
                boolean[] arrRestDays = this.getRestDays(model);
                String restDays = ArrayUtils.toString((Object)arrRestDays);
                String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
                if (StringUtils.isNotEmpty((CharSequence)orgId) && StringUtils.isNotEmpty((CharSequence)expiringyearfrom) && StringUtils.isEmpty((CharSequence)oldexpiringyearfrom)) {
                    taskflag = this.findTask();
                    if (taskflag && StringUtils.isEmpty((CharSequence)this.getPageCache().get("saveflag"))) {
                        this.openTips();
                    }
                    if (taskflag && StringUtils.isEmpty((CharSequence)this.getPageCache().get("saveflag"))) {
                        args.setCancel(true);
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)oldexpiringyearfrom) && !oldRestDays.equals(restDays)) {
                    taskflag = this.findTask();
                    if (taskflag && StringUtils.isEmpty((CharSequence)this.getPageCache().get("saveflag"))) {
                        this.openTips();
                    }
                    if (taskflag && !StringUtils.isEmpty((CharSequence)oldexpiringyearfrom) && StringUtils.isEmpty((CharSequence)this.getPageCache().get("saveflag"))) {
                        args.setCancel(true);
                    }
                }
                log.debug("\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
                this.editOrgId();
                this.generateDate();
            } else {
                args.cancel = true;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("closesetcalendartip".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            String priority = closedCallBackEvent.getReturnData().toString();
            this.getPageCache().put("saveflag", "0");
            this.getModel().setValue("priority", (Object)priority);
            this.getView().invokeOperation("save");
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    private void editOrgId() {
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
        String defaultproj = (String)this.getView().getFormShowParameter().getCustomParam("version");
        String parentid = (String)this.getView().getFormShowParameter().getCustomParam("parentid");
        if (orgId.contains("proj")) {
            String proj = orgId.split("proj")[0];
            this.getModel().setValue("project", (Object)proj);
            this.getModel().setValue("projectorg", (Object)parentid);
            this.getModel().setValue("createorg", (Object)parentid);
        } else if (StringUtils.isBlank((CharSequence)orgId)) {
            this.getModel().setValue("org", (Object)orgId);
            this.getModel().setValue("createorg", (Object)orgId);
            this.getModel().setValue("version", (Object)defaultproj);
        } else {
            this.getModel().setValue("org", (Object)orgId);
            this.getModel().setValue("createorg", (Object)orgId);
        }
    }

    private boolean validate() {
        if (!this.dateExclusionValidate()) {
            return false;
        }
        if (!this.amTimeValidate()) {
            return false;
        }
        if (!this.pmTimeValidate()) {
            return false;
        }
        return this.expiringDateValidate();
    }

    private boolean dateExclusionValidate() {
        boolean[] isHalfWorkDay;
        boolean result = true;
        boolean[] isRestDay = this.getRestDays(this.getModel());
        if (isRestDay.length != (isHalfWorkDay = this.getHalfWorkDays(this.getModel())).length) {
            return result;
        }
        for (int i = 0; i < isRestDay.length; ++i) {
            if (!isRestDay[i] || !isHalfWorkDay[i]) continue;
            result = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u4f11\u606f\u65e5\u548c\u534a\u5929\u5de5\u4f5c\u65e5\u4e0d\u80fd\u52fe\u9009\u540c\u4e00\u5929", (String)"ProjWorkCalendarEntityPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            break;
        }
        return result;
    }

    private boolean amTimeValidate() {
        boolean result = false;
        DynamicObject obj = this.getDynamicObject();
        if (this.nullToZero(obj, "hourofbegintimeam") || this.nullToZero(obj, "minofbegintimeam") || this.nullToZero(obj, "hourofendtimeam") || this.nullToZero(obj, "minofendtimeam")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0a\u5348\u65f6\u95f4\u5fc5\u987b\u5f55\u5165", (String)"ProjWorkCalendarEntityPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return result;
        }
        result = TimeUtils.compareHourAndMinute((int)obj.getInt("hourofbegintimeam"), (int)obj.getInt("minofbegintimeam"), (int)obj.getInt("hourofendtimeam"), (int)obj.getInt("minofendtimeam"));
        if (!result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0a\u5348\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4", (String)"ProjWorkCalendarEntityPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private boolean pmTimeValidate() {
        boolean result = false;
        DynamicObject obj = this.getDynamicObject();
        if (this.nullToZero(obj, "hourofbegintimepm") || this.nullToZero(obj, "minofbegintimepm") || this.nullToZero(obj, "hourofendtimepm") || this.nullToZero(obj, "minofendtimepm")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0b\u5348\u65f6\u95f4\u5fc5\u987b\u5f55\u5165", (String)"ProjWorkCalendarEntityPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return result;
        }
        result = TimeUtils.compareHourAndMinute((int)obj.getInt("hourofbegintimepm"), (int)obj.getInt("minofbegintimepm"), (int)obj.getInt("hourofendtimepm"), (int)obj.getInt("minofendtimepm"));
        if (!result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0b\u5348\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4", (String)"ProjWorkCalendarEntityPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private boolean nullToZero(DynamicObject obj, String propertyName) {
        Object property = obj.get(propertyName);
        if (property == null || property.toString().length() == 0) {
            obj.set(propertyName, (Object)0);
            return true;
        }
        return false;
    }

    private boolean expiringDateValidate() {
        DynamicObject obj = this.getDynamicObject();
        if (obj.get("expiringyearfrom") == null || obj.get("expiringmonthfrom") == null || obj.get("expiringyearto") == null || obj.get("expiringmonthto") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"ProjWorkCalendarEntityPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        int yearFrom = obj.getInt("expiringyearfrom");
        int monthFrom = obj.getInt("expiringmonthfrom");
        int yearTo = obj.getInt("expiringyearto");
        int monthTo = obj.getInt("expiringmonthto");
        if (yearTo < yearFrom || yearTo == yearFrom && monthTo < monthFrom) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f", (String)"ProjWorkCalendarEntityPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        IPageCache pageCache = this.getPageCache();
        Map all = pageCache.getAll();
        if (all != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)all.get("oldexpiringyearto"))) && StringUtils.isNotEmpty((CharSequence)((CharSequence)all.get("oldexpiringmonthto")))) {
            int oldexpiringyearto = Integer.parseInt((String)all.get("oldexpiringyearto"));
            int oldexpiringmonthto = Integer.parseInt((String)all.get("oldexpiringmonthto"));
            if (yearTo < oldexpiringyearto || yearTo == oldexpiringyearto && monthTo < oldexpiringmonthto) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fee\u6539\u7684\u7ed3\u675f\u65f6\u95f4\u53ea\u80fd\u5927\u4e8e\u4fee\u6539\u524d\u7684\u7ed3\u675f\u65f6\u95f4", (String)"ProjWorkCalendarEntityPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private DynamicObject getDynamicObject() {
        IDataModel model = this.getModel();
        return model.getDataEntity();
    }

    private void generateDate() {
        IDataModel model = this.getModel();
        model.getDataEntity();
        DynamicObject obj = model.getDataEntity();
        int yearFrom = obj.getInt("expiringyearfrom");
        int monthFrom = obj.getInt("expiringmonthfrom");
        int yearTo = obj.getInt("expiringyearto");
        int monthTo = obj.getInt("expiringmonthto");
        Calendar curDate = Calendar.getInstance();
        curDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        Calendar fromDate = Calendar.getInstance();
        fromDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        IPageCache pageCache = this.getPageCache();
        String oldexpiringyearfrom = pageCache.get("oldexpiringyearfrom");
        if (StringUtils.isEmpty((CharSequence)oldexpiringyearfrom)) {
            fromDate.setTime(curDate.getTime());
        } else {
            Calendar curDatefor = Calendar.getInstance();
            curDatefor.set(curDatefor.get(1), curDatefor.get(2), curDatefor.get(5), 0, 0, 0);
            fromDate.setTime(curDatefor.getTime());
        }
        Calendar toDate = Calendar.getInstance();
        toDate.set(yearTo, monthTo - 1, 1, 0, 0, 0);
        toDate.set(yearTo, monthTo - 1, toDate.getActualMaximum(5), 0, 0, 0);
        boolean[] isRestDay = this.getRestDays(model);
        boolean[] isHalfWorkDay = this.getHalfWorkDays(model);
        int oldCalendarCount = this.removeDuplicateRecord(fromDate);
        int days = TimeUtils.daysBetween((Calendar)fromDate, (Calendar)toDate);
        for (int i = 0; i < days; ++i) {
            int index = oldCalendarCount + i;
            model.createNewEntryRow("dateEntry");
            model.setValue("workdate", (Object)this.SDF.format(fromDate.getTime()), index);
            if (isRestDay[fromDate.get(7) - 1]) {
                model.setValue("datetype", (Object)"4", index);
            } else if (isHalfWorkDay[fromDate.get(7) - 1]) {
                model.setValue("datetype", (Object)"2", index);
            } else {
                model.setValue("datetype", (Object)"1", index);
            }
            fromDate.add(5, 1);
        }
    }

    private int removeDuplicateRecord(Calendar fromDate) {
        int i;
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("dateEntry");
        Calendar oldCal = Calendar.getInstance();
        ArrayList<DynamicObject> oldCalendarList = new ArrayList<DynamicObject>();
        for (i = rowCount - 1; i >= 0; --i) {
            DynamicObject oldObj = model.getEntryRowEntity("dateEntry", i);
            if (oldObj.getDate("workdate") == null) continue;
            oldCal.setTime(oldObj.getDate("workdate"));
            if (fromDate.before(oldCal) || TimeUtils.isSameDate((Calendar)fromDate, (Calendar)oldCal)) {
                model.deleteEntryRow("dateEntry", i);
                continue;
            }
            oldCalendarList.add(oldObj);
        }
        rowCount = model.getEntryRowCount("dateEntry");
        for (i = rowCount - 1; i >= 0; --i) {
            model.deleteEntryRow("dateEntry", i);
        }
        int oldRecordCount = oldCalendarList.size();
        int entryIndex = 0;
        for (int i2 = oldRecordCount - 1; i2 >= 0; --i2) {
            DynamicObject oldObj = (DynamicObject)oldCalendarList.get(i2);
            model.createNewEntryRow("dateEntry");
            model.setValue("workdate", (Object)oldObj.getDate("workdate"), entryIndex);
            model.setValue("datetype", oldObj.get("datetype"), entryIndex);
            ++entryIndex;
        }
        return oldRecordCount;
    }

    private boolean[] getRestDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isRestDay = new boolean[]{obj.getBoolean("issunrest"), obj.getBoolean("ismonrest"), obj.getBoolean("istuerest"), obj.getBoolean("iswedrest"), obj.getBoolean("isthurest"), obj.getBoolean("isfrirest"), obj.getBoolean("issatrest")};
        return isRestDay;
    }

    private boolean[] getHalfWorkDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isHalfWorkDay = new boolean[]{obj.getBoolean("ishalfsunrest"), obj.getBoolean("ishalfmonrest"), obj.getBoolean("ishalftuerest"), obj.getBoolean("ishalfwedrest"), obj.getBoolean("ishalfthurest"), obj.getBoolean("ishalffrirest"), obj.getBoolean("ishalfsatrest")};
        return isHalfWorkDay;
    }

    public boolean findTask() {
        Set taskIdSetByOrg;
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
        boolean taskflag = false;
        if (StringUtils.isNotEmpty((CharSequence)orgId) && orgId.contains("proj")) {
            taskflag = ProjWorkCalendarLoadService.queryProjectTask(orgId);
            return taskflag;
        }
        if (StringUtils.isNotEmpty((CharSequence)orgId) && (taskIdSetByOrg = PmpmTaskUtil.getTaskIdSetByOrgId((Object)orgId)) != null && taskIdSetByOrg.size() > 0) {
            taskflag = true;
            return taskflag;
        }
        return taskflag;
    }

    public void openTips() {
        HashMap params = new HashMap();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closesetcalendartip");
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("pmpm_changecalendartips");
        param.setCloseCallBack(closeCallBack);
        param.setCustomParams(params);
        this.getView().showForm(param);
    }
}

