/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProjWorkCalendarLoadService {
    public static final String ID = "id";
    public static final String SELECTED_ORG_ID = "org";
    public static final String DATA_ORG_ID = "dataorg";
    public static final String WORK_DATE = "workDate";
    public static final String DATE_TYPE = "dateType";
    public static final String PROJECT_ID = "projectid";
    private static Log logger = LogFactory.getLog(ProjWorkCalendarLoadService.class);

    public static List<Map<String, String>> loadWorkCalendar(Map<String, String> orgMap, int year) {
        if (orgMap == null || !orgMap.containsKey(SELECTED_ORG_ID)) {
            return new ArrayList<Map<String, String>>();
        }
        String dateFrom = year + "-01-01";
        String dateTo = year + "-12-31";
        return ProjWorkCalendarLoadService.loadWorkCalendar(orgMap, dateFrom, dateTo);
    }

    public static List<Map<String, String>> loadWorkCalendar(Map<String, String> orgMap, String dateFrom, String dateTo) {
        if (orgMap == null || !orgMap.containsKey(SELECTED_ORG_ID) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> workDataList = new ArrayList<Map<String, String>>();
        String orgId = orgMap.get(SELECTED_ORG_ID);
        orgMap.put(DATA_ORG_ID, orgId);
        if (orgId.contains("proj")) {
            ProjWorkCalendarLoadService.loadForProjctDefault(workDataList, orgMap, dateFrom, dateTo);
        } else {
            ProjWorkCalendarLoadService.load(workDataList, orgMap, dateFrom, dateTo);
        }
        if (workDataList.size() == 0) {
            return workDataList;
        }
        ProjWorkCalendarLoadService.fillFullYear(workDataList, orgMap, dateFrom, dateTo);
        return workDataList;
    }

    public static List<Map<String, String>> loadWorkCalendarForDefualt(Map<String, String> orgMap, String dateFrom, String dateTo) {
        ArrayList<Map<String, String>> workDataList = new ArrayList<Map<String, String>>();
        ProjWorkCalendarLoadService.loadForProjctDefaultNoProjId(orgMap, workDataList, dateFrom, dateTo);
        return workDataList;
    }

    public static Map<String, Object> getMarkDateMap(String orgId, String dateFrom, String dateTo, String flag) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return markDateMap;
        }
        ProjWorkCalendarLoadService.findAllMarkDate(markDateMap, orgId, dateFrom, dateTo, flag);
        return markDateMap;
    }

    private static void load(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr) {
        String orgId = orgMap.get(DATA_ORG_ID);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        ORM orm = ORM.create();
        QFilter[] qf = new QFilter[]{new QFilter(SELECTED_ORG_ID, "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)0), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection obj = null;
        DynamicObjectCollection parendCalendar = orm.query("pmpm_projworkcalendarset", qf);
        String flag = "";
        if (parendCalendar != null && parendCalendar.size() > 0) {
            obj = parendCalendar;
            flag = "1";
            ProjWorkCalendarLoadService.loadCommon(workDataList, orgMap, dateFromStr, dateToStr, obj, flag);
            return;
        }
        String parentId = ProjWorkCalendarLoadService.getOrgPrentId(orgId);
        if (StringUtils.isNotBlank((CharSequence)parentId) && !"0".equals(parentId)) {
            orgMap.put(DATA_ORG_ID, parentId);
            ProjWorkCalendarLoadService.load(workDataList, orgMap, dateFromStr, dateToStr);
        } else {
            QFilter[] filter = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)0), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
            DynamicObjectCollection defaultProjCalendar = orm.query("pmpm_projworkcalendarset", filter);
            if (defaultProjCalendar != null && defaultProjCalendar.size() > 0) {
                obj = defaultProjCalendar;
                ProjWorkCalendarLoadService.loadCommonForDefaultNoProjId(workDataList, orgMap, dateFromStr, dateToStr, obj);
            }
        }
    }

    private static void loadForProjctDefault(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr) {
        String orgId = orgMap.get(DATA_ORG_ID);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        ORM orm = ORM.create();
        QFilter[] qf = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)orgId.split("proj")[0]) : new QFilter(SELECTED_ORG_ID, "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)0), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection obj = null;
        DynamicObjectCollection projCalendar = orm.query("pmpm_projworkcalendarset", qf);
        String flag = "";
        if (projCalendar != null && projCalendar.size() > 0) {
            flag = "0";
            obj = projCalendar;
            ProjWorkCalendarLoadService.loadCommon(workDataList, orgMap, dateFromStr, dateToStr, obj, flag);
        } else {
            QFilter[] filter = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)0), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
            DynamicObjectCollection defaultProjCalendar = orm.query("pmpm_projworkcalendarset", filter);
            if (defaultProjCalendar != null && defaultProjCalendar.size() > 0) {
                obj = defaultProjCalendar;
                ProjWorkCalendarLoadService.loadCommonForDefault(workDataList, orgMap, dateFromStr, dateToStr, obj);
            }
        }
    }

    private static void loadForProjctDefaultNoProjId(Map<String, String> orgMap, List<Map<String, String>> workDataList, String dateFromStr, String dateToStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        ORM orm = ORM.create();
        DynamicObjectCollection obj = null;
        QFilter[] filter = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)0), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection defaultProjCalendar = orm.query("pmpm_projworkcalendarset", filter);
        if (defaultProjCalendar != null && defaultProjCalendar.size() > 0) {
            obj = defaultProjCalendar;
            ProjWorkCalendarLoadService.loadCommonForDefaultNoProjId(workDataList, orgMap, dateFromStr, dateToStr, obj);
        }
    }

    private static void fillFullYear(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFrom, String dateTo) {
        String minDateFrom = workDataList.get(0).get(WORK_DATE);
        String maxDateFrom = workDataList.get(workDataList.size() - 1).get(WORK_DATE);
        Date fDate = null;
        Date tDate = null;
        Date minDate = null;
        Date maxDate = null;
        try {
            Calendar cal;
            SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
            fDate = SDF.parse(dateFrom);
            tDate = SDF.parse(dateTo);
            minDate = SDF.parse(minDateFrom);
            maxDate = SDF.parse(maxDateFrom);
            if (fDate.compareTo(minDate) < 0) {
                cal = Calendar.getInstance();
                cal.setTime(minDate);
                cal.add(5, -1);
                workDataList.addAll(ProjWorkCalendarLoadService.fillDate(orgMap.get(SELECTED_ORG_ID), orgMap.get(DATA_ORG_ID), dateFrom, SDF.format(cal.getTime())));
            }
            if (maxDate.compareTo(tDate) < 0) {
                cal = Calendar.getInstance();
                cal.setTime(maxDate);
                cal.add(5, 1);
                workDataList.addAll(ProjWorkCalendarLoadService.fillDate(orgMap.get(SELECTED_ORG_ID), orgMap.get(DATA_ORG_ID), SDF.format(cal.getTime()), dateTo));
            }
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
    }

    private static List<Map<String, String>> fillDate(String org, String dataOrg, String dateFrom, String dateTo) {
        ArrayList<Map<String, String>> tempWorkDataList = new ArrayList<Map<String, String>>();
        if (StringUtils.isBlank((CharSequence)org) || "0".equals(org)) {
            return tempWorkDataList;
        }
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put(SELECTED_ORG_ID, org);
        ProjWorkCalendarLoadService.loadForProjctDefault(tempWorkDataList, orgMap, dateFrom, dateTo);
        return tempWorkDataList;
    }

    private static void findAllMarkDate(Map<String, Object> markDateMap, String orgId, String dateFromStr, String dateToStr, String flag) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] filters = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)orgId.split("proj")[0]) : new QFilter(SELECTED_ORG_ID, "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)1), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)"pmpm_projworkcalendarset", (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        if (entityList == null) {
            QFilter[] qfilters = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)1), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
            DynamicObjectCollection defualtEntityList = QueryServiceHelper.query((String)"pmpm_projworkcalendarset", (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
            SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
            for (DynamicObject date : defualtEntityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
    }

    private static String getOrgPrentId(String id) {
        String parentId = "";
        QFilter[] qf = new QFilter[]{new QFilter("view.isdefault", "=", (Object)1), new QFilter("view.treetype", "=", (Object)"15"), new QFilter(SELECTED_ORG_ID, "=", (Object)id)};
        DynamicObject parentObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,parent", (QFilter[])qf);
        if (parentObj == null) {
            return parentId;
        }
        return parentObj.getString("parent");
    }

    private static void loadCommon(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, DynamicObjectCollection obj, String flag) {
        String orgId = orgMap.get(DATA_ORG_ID);
        Map<String, Object> markDateMap = ProjWorkCalendarLoadService.getMarkDateMap(orgMap.get(SELECTED_ORG_ID), dateFromStr, dateToStr, flag);
        String selectOrgId = orgMap.get(SELECTED_ORG_ID);
        if (StringUtils.isNotBlank((CharSequence)selectOrgId) && !orgId.equals(selectOrgId)) {
            markDateMap = ProjWorkCalendarLoadService.getMarkDateMap(orgId, dateFromStr, dateToStr, flag);
        }
        DynamicObjectCollection entry = ((DynamicObject)obj.get(0)).getDynamicObjectCollection("dateentry");
        entry.sort((date1, date2) -> {
            int result = 0;
            if (date1 != null && date2 != null) {
                Date D2;
                Date D1 = (Date)date1.get("workdate");
                result = D1.after(D2 = (Date)date2.get("workdate")) ? 1 : -1;
            }
            return result;
        });
        orgMap.put(ID, String.valueOf(((DynamicObject)obj.get(0)).getPkValue()));
        SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
        for (DynamicObject workday : entry) {
            HashMap<String, String> data = new HashMap<String, String>();
            String dateKey = SDF.format(workday.getDate(WORK_DATE));
            data.put(WORK_DATE, dateKey);
            Object dateType = markDateMap.get(dateKey);
            if (dateType == null) {
                data.put(DATE_TYPE, workday.getString(DATE_TYPE));
            } else {
                data.put(DATE_TYPE, dateType.toString());
            }
            workDataList.add(data);
        }
    }

    private static void loadCommonForDefault(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, DynamicObjectCollection obj) {
        String orgId = orgMap.get(DATA_ORG_ID);
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        Map<String, Object> markDateMapForDefault = ProjWorkCalendarLoadService.getMarkDateMapForDefault(dateFromStr, dateToStr, orgId);
        Map<String, Object> markDateMapForDefaultNoProjId = ProjWorkCalendarLoadService.getMarkDateMapForDefaultNoProjId(dateFromStr, dateToStr);
        markDateMap.putAll(markDateMapForDefault);
        markDateMap.putAll(markDateMapForDefaultNoProjId);
        DynamicObjectCollection entry = ((DynamicObject)obj.get(0)).getDynamicObjectCollection("dateentry");
        entry.sort((date1, date2) -> {
            int result = 0;
            if (date1 != null && date2 != null) {
                Date D2;
                Date D1 = (Date)date1.get("workdate");
                result = D1.after(D2 = (Date)date2.get("workdate")) ? 1 : -1;
            }
            return result;
        });
        orgMap.put(ID, String.valueOf(((DynamicObject)obj.get(0)).getPkValue()));
        SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
        for (DynamicObject workday : entry) {
            HashMap<String, String> data = new HashMap<String, String>();
            String dateKey = SDF.format(workday.getDate(WORK_DATE));
            data.put(WORK_DATE, dateKey);
            Object dateType = markDateMap.get(dateKey);
            if (dateType == null) {
                data.put(DATE_TYPE, workday.getString(DATE_TYPE));
            } else {
                data.put(DATE_TYPE, dateType.toString());
            }
            workDataList.add(data);
        }
    }

    private static void loadCommonForDefaultNoProjId(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, DynamicObjectCollection obj) {
        Map<String, Object> markDateMap = ProjWorkCalendarLoadService.getMarkDateMapForDefaultNoProjId(dateFromStr, dateToStr);
        DynamicObjectCollection entry = ((DynamicObject)obj.get(0)).getDynamicObjectCollection("dateentry");
        entry.sort((date1, date2) -> {
            int result = 0;
            if (date1 != null && date2 != null) {
                Date D2;
                Date D1 = (Date)date1.get("workdate");
                result = D1.after(D2 = (Date)date2.get("workdate")) ? 1 : -1;
            }
            return result;
        });
        orgMap.put(ID, String.valueOf(((DynamicObject)obj.get(0)).getPkValue()));
        SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
        for (DynamicObject workday : entry) {
            HashMap<String, String> data = new HashMap<String, String>();
            String dateKey = SDF.format(workday.getDate(WORK_DATE));
            data.put(WORK_DATE, dateKey);
            Object dateType = markDateMap.get(dateKey);
            if (dateType == null) {
                data.put(DATE_TYPE, workday.getString(DATE_TYPE));
            } else {
                data.put(DATE_TYPE, dateType.toString());
            }
            workDataList.add(data);
        }
    }

    public static boolean queryCalendarFlag(String orgId, String startDate, String endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(startDate);
            dateTo = dateFormat.parse(endDate);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] qf = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)orgId.split("proj")[0]) : new QFilter(SELECTED_ORG_ID, "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)0), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObject[] projCalendar = BusinessDataServiceHelper.load((String)"pmpm_projworkcalendarset", (String)ID, (QFilter[])qf);
        return projCalendar == null || projCalendar.length <= 0;
    }

    public static List<Map<String, String>> loadForCurrCalender(Map<String, String> orgMap, int year) {
        String dateFromStr = year + "-01-01";
        String dateToStr = year + "-12-31";
        ArrayList<Map<String, String>> workDataList = new ArrayList<Map<String, String>>();
        String orgId = orgMap.get(SELECTED_ORG_ID);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        ORM orm = ORM.create();
        QFilter[] qf = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)orgId.split("proj")[0]) : new QFilter(SELECTED_ORG_ID, "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)0), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection obj = null;
        DynamicObjectCollection projCalendar = orm.query("pmpm_projworkcalendarset", qf);
        String flag = "";
        if (projCalendar != null && projCalendar.size() > 0) {
            flag = "0";
            obj = projCalendar;
            ProjWorkCalendarLoadService.loadCommonForCurrOrg(workDataList, orgMap, dateFromStr, dateToStr, obj, flag);
        }
        return workDataList;
    }

    public static void loadCommonForCurrOrg(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr, DynamicObjectCollection obj, String flag) {
        Map<String, Object> markDateMap = ProjWorkCalendarLoadService.getMarkDateMapForCurrOrg(orgMap.get(SELECTED_ORG_ID), dateFromStr, dateToStr, flag);
        DynamicObjectCollection entry = ((DynamicObject)obj.get(0)).getDynamicObjectCollection("dateentry");
        orgMap.put(ID, String.valueOf(((DynamicObject)obj.get(0)).getPkValue()));
        SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
        for (DynamicObject workday : entry) {
            HashMap<String, String> data = new HashMap<String, String>();
            String dateKey = SDF.format(workday.getDate(WORK_DATE));
            data.put(WORK_DATE, dateKey);
            Object dateType = markDateMap.get(dateKey);
            if (dateType == null) {
                data.put(DATE_TYPE, workday.getString(DATE_TYPE));
            } else {
                data.put(DATE_TYPE, dateType.toString());
            }
            workDataList.add(data);
        }
    }

    public static Map<String, Object> getMarkDateMapForCurrOrg(String orgId, String dateFrom, String dateTo, String flag) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return markDateMap;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFromDate = null;
        Date dateToDate = null;
        try {
            dateFromDate = dateFormat.parse(dateFrom);
            dateToDate = dateFormat.parse(dateTo);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] filters = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)orgId.split("proj")[0]) : new QFilter(SELECTED_ORG_ID, "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)1), new QFilter("dateentry.workdate", ">=", (Object)dateFromDate), new QFilter("dateentry.workdate", "<=", (Object)dateToDate)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)"pmpm_projworkcalendarset", (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        return markDateMap;
    }

    public static Map<String, Object> getMarkDateMapForDefault(String dateFrom, String dateTo, String org) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFromDate = null;
        Date dateToDate = null;
        try {
            dateFromDate = dateFormat.parse(dateFrom);
            dateToDate = dateFormat.parse(dateTo);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] filters = new QFilter[]{new QFilter("project", "=", (Object)org.split("proj")[0]), new QFilter("isindividuation", "=", (Object)1), new QFilter("dateentry.workdate", ">=", (Object)dateFromDate), new QFilter("dateentry.workdate", "<=", (Object)dateToDate)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)"pmpm_projworkcalendarset", (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        return markDateMap;
    }

    public static Map<String, Object> getMarkDateMapForDefaultNoProjId(String dateFrom, String dateTo) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFromDate = null;
        Date dateToDate = null;
        try {
            dateFromDate = dateFormat.parse(dateFrom);
            dateToDate = dateFormat.parse(dateTo);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] filters = new QFilter[]{new QFilter("version", "=", (Object)"default"), new QFilter("isindividuation", "=", (Object)1), new QFilter("dateentry.workdate", ">=", (Object)dateFromDate), new QFilter("dateentry.workdate", "<=", (Object)dateToDate)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)"pmpm_projworkcalendarset", (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        return markDateMap;
    }

    public static boolean queryCalendarFlagNoRecurtion(String orgId, String startDate, String endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(startDate);
            dateTo = dateFormat.parse(endDate);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] qf = new QFilter[]{orgId.contains("proj") ? new QFilter("project", "=", (Object)orgId.split("proj")[0]) : new QFilter(SELECTED_ORG_ID, "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)0), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObject[] projCalendar = BusinessDataServiceHelper.load((String)"pmpm_projworkcalendarset", (String)ID, (QFilter[])qf);
        return projCalendar == null || projCalendar.length <= 0;
    }

    public static boolean queryProjectTask(String orgId) {
        QFilter[] qf = new QFilter[]{new QFilter("project", "=", (Object)orgId.split("proj")[0])};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"pmpm_task", (String)ID, (QFilter[])qf);
        return dynamicObject != null;
    }
}

