/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.common.utils.TimeUtils;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;
import kd.pmgt.pmpm.formplugin.ProjWorkCalendarLoadService;

public class ProjWorkCalenderEditPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
IConfirmCallBack {
    private static final Log logger = LogFactory.getLog(ProjWorkCalenderEditPlugin.class);
    private static final String IS_INIT_CALLBACK = "isInitCallBack";
    private static final String IS_COPY_LASTYEAR_CALLBACK = "isCopyLastyearCallBack";
    private static final String ENTITY_ORG_StRUCTURE = "bos_org_structure";
    private static final String PERMISSIONSET = "0=O4D47MAXJ=";
    private static final String PERMISSIONSETDEFAULT = "0=O4NDUXIQPR";
    private final SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
    private static Map<Object, TreeNode> treeNodeMap = new HashMap<Object, TreeNode>();

    public void initialize() {
        TreeView orgtree = (TreeView)this.getControl("orgtree");
        orgtree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        orgtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"setdefoultworkcalendar", "setworkcalendar", "preyear", "nextyear"});
        WorkCalendar workCalendar = (WorkCalendar)this.getView().getControl("workcalendarap");
        workCalendar.addClickListener((ClickListener)this);
        workCalendar.setPassDayLocked(false);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!QueryServiceHelper.exists((String)"bos_org", null)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u670d\u52a1\u521b\u5efa\u884c\u653f\u7ec4\u7ec7\u3002", (String)"ProjWorkCalenderEditPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        if (this.getModel().getValue("year") == null || String.valueOf(this.getModel().getDataEntity().get("year")).trim().length() == 0) {
            this.setCurYear(Calendar.getInstance().get(1));
        }
        this.initOrgTree();
        if (this.isExistCalendar()) {
            int year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
            this.loadWorkCalendar(year);
        } else {
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            String pmpmApp = BizAppServiceHelp.getAppIdByAppNumber((String)"pmpm");
            long orgId = RequestContext.get().getOrgId();
            List permissionOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)pmpmApp, (String)"pmpm_projworkcalender", (String)PERMISSIONSETDEFAULT);
            if (!permissionOrgs.contains(orgId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9ed8\u8ba4\u65e5\u5386\u6570\u636e\u4e14\u65e0\u201c\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u201d\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjWorkCalenderEditPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
                this.getView().close();
                return;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)pmpmApp, (String)"pmpm_projworkcalender", (String)PERMISSIONSETDEFAULT);
            if (!hasPerm) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9ed8\u8ba4\u65e5\u5386\u6570\u636e\u4e14\u65e0\u201c\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u201d\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjWorkCalenderEditPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
                this.getView().close();
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6ca1\u6709\u9ed8\u8ba4\u65e5\u5386\u6570\u636e\uff0c\u662f\u5426\u73b0\u5728\u5f00\u59cb\u521d\u59cb\u5316\uff1f", (String)"ProjWorkCalenderEditPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_INIT_CALLBACK, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        int year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
        if (callBackId.equals(IS_INIT_CALLBACK)) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", "");
                params.put("orgId", "");
                params.put("year", this.getModel().getValue("year"));
                params.put("version", "default");
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "reload");
                this.showForm("pmpm_projworkcalendarset", params, closeCallBack, ShowType.Modal);
            } else if (mbce.getResult().equals((Object)MessageBoxResult.Cancel)) {
                this.getView().close();
            }
        } else if (IS_COPY_LASTYEAR_CALLBACK.equalsIgnoreCase(callBackId)) {
            int nextyear = year + 1;
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.generateNextYearEntry(nextyear);
                this.setCurYear(nextyear);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        int year = Calendar.getInstance().get(1);
        this.setCurYear(year);
        if (!this.loadWorkCalendar(year)) {
            this.loadEmptyWorkCalendar(year);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent nodeEvent) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        Object parentNodeId = nodeEvent.getParentNodeId();
        if ("noOrg".equals(parentNodeId) || "outOrg".equals(parentNodeId)) {
            return;
        }
        long nodeId = Long.parseLong(nodeEvent.getNodeId().toString());
        List<Map<String, String>> prosOfOrg = this.querySubProjectOfOrg(nodeId + "");
        ArrayList<Long> orgList = new ArrayList<Long>(10);
        orgList.add(nodeId);
        DynamicObject[] permProjectByStatus = ProjectPermissionHelper.getPermProjectByStatus(orgList, (boolean)true, (String)this.getView().getEntityId(), (String)"view");
        ArrayList<Long> permProjectIds = new ArrayList<Long>(permProjectByStatus.length);
        for (DynamicObject permProject : permProjectByStatus) {
            permProjectIds.add(Long.valueOf(permProject.getPkValue().toString()));
        }
        Iterator<Map<String, String>> prosOfOrgIter = prosOfOrg.iterator();
        while (prosOfOrgIter.hasNext()) {
            Map<String, String> next = prosOfOrgIter.next();
            String id = next.get("id").split("proj")[0];
            if (permProjectIds.contains(Long.valueOf(id))) continue;
            prosOfOrgIter.remove();
        }
        for (Map<String, String> map : prosOfOrg) {
            nodes.add(this.changeMapToTreeNode(map));
        }
        List orgTreeData = OrgViewServiceHelper.getOrgChildrenTreeData((String)"15", (long)nodeId);
        for (Map map : orgTreeData) {
            String isleaf;
            orgList.clear();
            String orgId = (String)map.get("id");
            orgList.add(Long.valueOf(orgId));
            List<Map<String, String>> proj = this.querySubProjectOfOrg(orgId);
            if (CollectionUtils.isEmpty(proj)) {
                nodes.add(this.changeMapToTreeNode(map));
                continue;
            }
            DynamicObject[] permProjectSubs = ProjectPermissionHelper.getPermProjectByStatus(orgList, (boolean)false, (String)this.getView().getEntityId(), (String)"view");
            permProjectIds.clear();
            for (DynamicObject permProjectSub : permProjectSubs) {
                permProjectIds.add(Long.valueOf(permProjectSub.getPkValue().toString()));
            }
            Iterator<Map<String, String>> proIterSub = proj.iterator();
            while (proIterSub.hasNext()) {
                Map<String, String> next = proIterSub.next();
                String id = next.get("id").split("proj")[0];
                if (permProjectIds.contains(Long.valueOf(id))) continue;
                proIterSub.remove();
            }
            if (!CollectionUtils.isEmpty(proj) && (isleaf = (String)map.get("isleaf")).equals("1")) {
                map.put("isleaf", "0");
            }
            nodes.add(this.changeMapToTreeNode(map));
        }
        TreeView tv = (TreeView)nodeEvent.getSource();
        tv.addNodes(nodes);
        if (parentNodeId != null && !"".equals(parentNodeId)) {
            tv.focusNode(this.getCurTreeNode(nodeEvent.getNodeId().toString()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void click(EventObject evt) {
        WorkCalendar workCalendar;
        Control ctl = (Control)evt.getSource();
        TreeView orgtree = (TreeView)this.getControl("orgtree");
        Map node = orgtree.getTreeState().getFocusNode();
        String fourceOrgId = node.get("id").toString();
        Object parentid = node.get("parentid");
        String fourceNode = fourceOrgId.split("proj")[0];
        long fourceNodeId = Long.parseLong(fourceNode);
        String orgId = String.valueOf(this.getModel().getValue("dataorg"));
        int year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
        if (ctl.getKey().toLowerCase().startsWith("preyear")) {
            int lastyear = year - 1;
            Object curId = this.getModel().getValue("id");
            if (this.loadWorkCalendar(lastyear)) {
                this.setCurYear(lastyear);
            } else {
                if (year <= Calendar.getInstance().get(1)) {
                    this.getModel().setValue("id", curId);
                    String msg = String.format(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e%s\u5e74\u7684\u5de5\u4f5c\u65e5\u5386", (String)"ProjWorkCalenderEditPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), year - 1);
                    this.getView().showTipNotification(msg);
                    return;
                }
                this.loadEmptyWorkCalendar(lastyear);
            }
        } else if (ctl.getKey().toLowerCase().startsWith("nextyear")) {
            int nextyear = year + 1;
            String dateFromCurr = year + "-01-01";
            String dateToCurr = year + "-12-31";
            Object curId = this.getModel().getValue("id");
            boolean flag = ProjWorkCalendarLoadService.queryCalendarFlag(fourceOrgId, dateFromCurr, dateToCurr);
            if (!flag) {
                if (this.loadWorkCalendarForCurrOrg(nextyear) || StringUtils.isBlank((Object)curId)) {
                    this.setCurYear(nextyear);
                } else {
                    if (!this.isHasPermOfCalendarOper(fourceOrgId, parentid, fourceNodeId)) {
                        return;
                    }
                    this.getModel().setValue("id", curId);
                    this.getModel().setValue("dataorg", (Object)orgId);
                    String msg = String.format(ResManager.loadKDString((String)"%s\u5e74\u5de5\u4f5c\u65e5\u5386\u4e0d\u5b58\u5728\uff0c\u662f\u5426\u590d\u5236\u4e0a\u4e00\u5e74\u5de5\u4f5c\u65e5\u5386\uff1f", (String)"ProjWorkCalenderEditPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), nextyear);
                    this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(IS_COPY_LASTYEAR_CALLBACK, (IFormPlugin)this));
                }
            } else if (this.loadWorkCalendar(nextyear) || StringUtils.isBlank((Object)curId)) {
                this.setCurYear(nextyear);
            } else {
                if (!this.isHasPermOfCalendarOper(fourceOrgId, parentid, fourceNodeId)) {
                    return;
                }
                this.getModel().setValue("id", curId);
                this.getModel().setValue("dataorg", (Object)orgId);
                this.getView().showConfirm(String.format("%s" + ResManager.loadKDString((String)"\u5e74\u5de5\u4f5c\u65e5\u5386\u4e0d\u5b58\u5728\uff0c\u662f\u5426\u590d\u5236\u4e0a\u4e00\u5e74\u5de5\u4f5c\u65e5\u5386\uff1f", (String)"ProjWorkCalenderEditPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), nextyear), MessageBoxOptions.YesNo, new ConfirmCallBackListener(IS_COPY_LASTYEAR_CALLBACK, (IFormPlugin)this));
            }
        }
        if (!(workCalendar = (WorkCalendar)this.getControl("workcalendarap")).equals(ctl)) return;
        Calendar curDatefor = Calendar.getInstance();
        curDatefor.set(curDatefor.get(1), curDatefor.get(2), curDatefor.get(5), 0, 0, 0);
        Date time = curDatefor.getTime();
        ArrayList dateList = workCalendar.getDateList();
        for (String date : dateList) {
            try {
                Date parse = this.SDF.parse(date);
                if (!parse.before(time)) continue;
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bbe\u7f6e\u5f53\u524d\u65e5\u671f\u4ee5\u524d\u7684\u65e5\u671f", (String)"ProjWorkCalenderEditPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
                return;
            }
            catch (ParseException e) {
                logger.error((Throwable)e);
            }
        }
        String dateFromCurr = year + "-01-01";
        String dateToCurr = year + "-12-31";
        boolean flag = ProjWorkCalendarLoadService.queryCalendarFlag(fourceOrgId, dateFromCurr, dateToCurr);
        if (!this.isHasPermOfCalendarOper(fourceOrgId, parentid, fourceNodeId)) {
            return;
        }
        if (flag) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed9\u7ec4\u7ec7\u6216\u8005\u9879\u76ee\u8bbe\u7f6e\u65e5\u5386", (String)"ProjWorkCalenderEditPlugin_10", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
            return;
        }
        boolean taskflag = false;
        if (fourceOrgId.contains("proj")) {
            taskflag = ProjWorkCalendarLoadService.queryProjectTask(fourceOrgId);
        } else {
            Set taskIdSetByOrgId = PmpmTaskUtil.getTaskIdSetByOrgId((Object)fourceOrgId);
            if (taskIdSetByOrgId != null && taskIdSetByOrgId.size() > 0) {
                taskflag = true;
            }
        }
        if (taskflag) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closesetcalendartip");
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("pmpm_changecalendartips");
            param.setCloseCallBack(closeCallBack);
            params.put("dateList", workCalendar.getDateList());
            params.put("dateType", workCalendar.getDateType());
            param.setCustomParams(params);
            this.getView().showForm(param);
            return;
        }
        this.markWorkCalendar(workCalendar, this.getFocusOrgId());
    }

    private boolean isHasPermOfCalendarOper(String fourceOrgId, Object parentid, long fourceNodeId) {
        String proj;
        List<Long> permProjectIds;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String pmpmApp = BizAppServiceHelp.getAppIdByAppNumber((String)"pmpm");
        if (!fourceOrgId.contains("proj")) {
            List permOrgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)RequestContext.get().getUserId(), (String)pmpmApp, (String)"pmpm_projworkcalender", (String)PERMISSIONSET);
            if (!permOrgList.contains(fourceNodeId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u201c\u8bbe\u7f6e\u65e5\u5386\u201d\u4fee\u6539\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjWorkCalenderEditPlugin_8", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)pmpmApp, (String)"pmpm_projworkcalender", (String)PERMISSIONSET);
            if (!hasPerm) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u201c\u8bbe\u7f6e\u65e5\u5386\u201d\u4fee\u6539\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjWorkCalenderEditPlugin_8", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
                return false;
            }
        } else if (fourceOrgId.contains("proj") && !(permProjectIds = this.projectPermission(parentid)).contains(Long.valueOf(proj = fourceOrgId.split("proj")[0]))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u201c\u8bbe\u7f6e\u65e5\u5386\u201d\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjWorkCalenderEditPlugin_9", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        TreeView orgtree = (TreeView)this.getControl("orgtree");
        Map node = orgtree.getTreeState().getFocusNode();
        String fourceOrgId = node.get("id").toString();
        Object parentid = node.get("parentid");
        String fourceNode = fourceOrgId.split("proj")[0];
        long fourceNodeId = Long.parseLong(fourceNode);
        String orgId = String.valueOf(this.getModel().getValue("dataorg"));
        String pmpmApp = BizAppServiceHelp.getAppIdByAppNumber((String)"pmpm");
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (key.toLowerCase().startsWith("setworkcalendar")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (!this.isHasPermOfCalendarOper(fourceOrgId, parentid, fourceNodeId)) {
                return;
            }
            String id = String.valueOf(this.getModel().getValue("id"));
            if (StringUtils.isBlank((CharSequence)id)) {
                ORM orm = ORM.create();
                QFilter[] qf = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("isindividuation", "=", (Object)0)};
                DynamicObject col = orm.queryOne("pmpm_projworkcalendarset", qf);
                if (col != null) {
                    id = col.getString("id");
                    this.getModel().setValue("id", (Object)id);
                    this.getModel().setValue("dataorg", (Object)orgId);
                }
            }
            params.put("id", id);
            params.put("orgId", fourceOrgId);
            params.put("year", this.getModel().getValue("year"));
            params.put("parentid", node.get("parentid").toString());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "reload");
            this.showForm("pmpm_projworkcalendarset", params, closeCallBack, ShowType.Modal);
        } else if (key.toLowerCase().startsWith("setdefoultworkcalendar")) {
            List permOrgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)RequestContext.get().getUserId(), (String)pmpmApp, (String)"pmpm_projworkcalender", (String)PERMISSIONSET);
            if (!permOrgList.contains(fourceNodeId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u201c\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u201d\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjWorkCalenderEditPlugin_11", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
                return;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)pmpmApp, (String)"pmpm_projworkcalender", (String)PERMISSIONSETDEFAULT);
            if (!hasPerm) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u201c\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u201d\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjWorkCalenderEditPlugin_11", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), "", MessageTypes.Default);
                return;
            }
            QFilter versionFilter = new QFilter("version", "=", (Object)"default");
            QFilter[] qFilters = new QFilter[]{versionFilter};
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"pmpm_projworkcalendarset", (String)"id", (QFilter[])qFilters);
            HashMap<String, String> params = new HashMap<String, String>();
            if (dynamicObject == null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6ca1\u6709\u9ed8\u8ba4\u65e5\u5386\u6570\u636e\uff0c\u662f\u5426\u73b0\u5728\u5f00\u59cb\u521d\u59cb\u5316\uff1f", (String)"ProjWorkCalenderEditPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_INIT_CALLBACK, (IFormPlugin)this));
                return;
            }
            String id = dynamicObject.get("id").toString();
            params.put("id", id);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closesetcalendar");
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("pmpm_defaultcalendar");
            param.setCloseCallBack(closeCallBack);
            param.setCustomParams(params);
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("closesetcalendartip".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            String orgId = "";
            orgId = this.getFocusOrgId().contains("proj") ? this.getFocusOrgId().split("proj")[0] : this.getFocusOrgId();
            WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
            ArrayList<String> arrayList = new ArrayList<String>();
            String priority = closedCallBackEvent.getReturnData().toString().split("\\[\"")[0];
            String aftersplit = closedCallBackEvent.getReturnData().toString().split("\\[\"")[1];
            String date = aftersplit.split("\"\\]")[0];
            String all = date.replaceAll("\",\"", ",");
            String[] splitdate = all.split(",");
            int length = splitdate.length;
            for (int i = 0; i < length; ++i) {
                arrayList.add(splitdate[i]);
            }
            String dateType = aftersplit.split("\"\\]")[1];
            workCalendar.setDateList(arrayList);
            workCalendar.setDateType(dateType);
            this.markWorkCalendar(workCalendar, this.getFocusOrgId());
            if (this.getFocusOrgId().contains("proj")) {
                PmpmTaskUtil.updateTimeWhenCalChange((Object)orgId, (int)Integer.parseInt(priority));
            } else {
                PmpmTaskUtil.updateTimeWhenOrgCalChange((Object)orgId, (int)Integer.parseInt(priority));
            }
        }
        if (this.isExistCalendar()) {
            int year = Calendar.getInstance().get(1);
            this.setCurYear(year);
            if (!this.loadWorkCalendar(year)) {
                this.loadEmptyWorkCalendar(year);
            }
        } else {
            this.getView().close();
        }
    }

    private void setCurYear(int year) {
        this.getModel().setValue("year", (Object)year);
        Label label = (Label)this.getControl("yearshow");
        label.setText(String.valueOf(year));
    }

    private void initOrgTree() {
        TreeView orgtree = (TreeView)this.getControl("orgtree");
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        long orgId = RequestContext.get().getOrgId();
        ArrayList<Map<String, String>> orgTreeData = new ArrayList<Map<String, String>>();
        this.currUserOrg(orgTreeData, orgId);
        treeNodeMap.clear();
        if (orgTreeData.size() == 0) {
            return;
        }
        TreeNode root = this.changeMapToTreeNode((Map)orgTreeData.get(0));
        if (root == null) {
            root = new TreeNode();
            root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ProjWorkCalenderEditPlugin_12", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            root.setParentid("");
            root.setIsOpened(false);
            nodes.add(root);
        } else {
            root.setParentid("");
            root.setChildren(new ArrayList());
            root.setIsOpened(true);
            nodes.add(root);
        }
        orgtree.addNodes(nodes);
        orgtree.focusNode(root);
    }

    private TreeNode changeMapToTreeNode(Map<String, String> map) {
        String nodeid;
        if (map.isEmpty()) {
            return null;
        }
        TreeNode node = new TreeNode();
        node.setId(map.get("id"));
        node.setText(map.get("name"));
        node.setParentid(map.get("parentid"));
        String isleaf = map.get("isleaf");
        if (isleaf == null) {
            isleaf = "0";
        }
        if ("0".equals(isleaf)) {
            node.setChildren(new ArrayList());
        }
        if ((nodeid = map.get("id")).contains("proj")) {
            node.setColor("blue");
        }
        if (!treeNodeMap.containsKey(map.get("id"))) {
            treeNodeMap.put(map.get("id"), node);
        }
        return node;
    }

    private TreeNode getCurTreeNode(String nodeId) {
        return treeNodeMap.get(nodeId);
    }

    private boolean isExistCalendar() {
        QFilter[] qf = new QFilter[]{new QFilter("isindividuation", "=", (Object)0), new QFilter("version", "=", (Object)"default")};
        return QueryServiceHelper.exists((String)"pmpm_projworkcalendarset", (QFilter[])qf);
    }

    private boolean loadWorkCalendar(int year) {
        boolean isLoaded = false;
        String orgId = this.getFocusOrgId();
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put("org", orgId);
        List<Map<String, String>> workDataList = ProjWorkCalendarLoadService.loadWorkCalendar(orgMap, year);
        this.getModel().setValue("dataorg", (Object)((String)orgMap.get("dataorg")).split("proj")[0]);
        if (workDataList != null && workDataList.size() > 0) {
            isLoaded = true;
            this.getModel().setValue("id", orgMap.get("id"));
            this.getModel().setValue("startvaliddate", (Object)workDataList.get(0).get("workDate"));
            this.getModel().setValue("endvaliddate", (Object)workDataList.get(workDataList.size() - 1).get("workDate"));
            WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
            workCalendar.setYear(year);
            workCalendar.setWorkDataList(workDataList);
            workCalendar.setData();
        } else {
            this.getModel().setValue("id", (Object)"");
        }
        return isLoaded;
    }

    private boolean loadWorkCalendarForCurrOrg(int year) {
        boolean isLoaded = false;
        String orgId = this.getFocusOrgId();
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put("org", orgId);
        List<Map<String, String>> workDataList = ProjWorkCalendarLoadService.loadForCurrCalender(orgMap, year);
        this.getModel().setValue("org", (Object)((String)orgMap.get("org")).split("proj")[0]);
        if (workDataList != null && workDataList.size() > 0) {
            isLoaded = true;
            this.getModel().setValue("id", orgMap.get("id"));
            this.getModel().setValue("startvaliddate", (Object)workDataList.get(0).get("workDate"));
            this.getModel().setValue("endvaliddate", (Object)workDataList.get(workDataList.size() - 1).get("workDate"));
            WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
            workCalendar.setYear(year);
            workCalendar.setWorkDataList(workDataList);
            workCalendar.setData();
        } else {
            this.getModel().setValue("id", null);
        }
        return isLoaded;
    }

    private String getFocusOrgId() {
        TreeView orgtree = (TreeView)this.getControl("orgtree");
        Map map = orgtree.getTreeState().getFocusNode();
        String orgId = (String)map.get("id");
        if (orgId.contains("proj")) {
            this.getModel().setValue("project", (Object)orgId.split("proj")[0]);
        } else {
            this.getModel().setValue("org", (Object)orgId);
        }
        return orgId;
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        String orgId = params.get("orgId").toString();
        String year = params.get("year").toString();
        String dateFrom = year + "-01-01";
        String dateTo = year + "-12-31";
        if (StringUtils.isNotEmpty((CharSequence)orgId)) {
            boolean flag = ProjWorkCalendarLoadService.queryCalendarFlag(orgId, dateFrom, dateTo);
            if (!flag) {
                param.setBillStatus(BillOperationStatus.EDIT);
                if (this.getModel().getValue("id") != null && String.valueOf(this.getModel().getValue("id")).trim().length() != 0) {
                    param.setPkId(this.getModel().getValue("id"));
                }
            }
            param.setCustomParams(params);
            if (closeCallBack != null) {
                param.setCloseCallBack(closeCallBack);
            }
            this.getView().showForm((FormShowParameter)param);
        } else {
            param.setCustomParams(params);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void generateNextYearEntry(int nextyear) {
        String dateTo;
        String dateFrom;
        int nextyear1 = nextyear - 1;
        String id = this.getModel().getValue("id").toString();
        TreeView treeView = (TreeView)this.getControl("orgtree");
        Map node = treeView.getTreeState().getFocusNode();
        String orgId = node.get("id").toString();
        boolean flag = ProjWorkCalendarLoadService.queryCalendarFlag(orgId, dateFrom = nextyear1 + "-01-01", dateTo = nextyear1 + "-12-31");
        if (flag) {
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u7ed9\u5f53\u524d\u7ec4\u7ec7\u6216\u8005\u9879\u76ee\u8bbe\u7f6e%s\u5e74\u65e5\u5386,\u624d\u80fd\u590d\u5236\u4e0b\u4e00\u5e74\u65e5\u5386\u3002", (String)"ProjWorkCalenderEditPlugin_13", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), nextyear1);
            this.getView().showErrorNotification(msg);
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"pmpm_projworkcalendarset");
        DynamicObject[] curWorkCalendarArr = BusinessDataServiceHelper.load((Object[])new Object[]{id}, (DynamicObjectType)type);
        if (curWorkCalendarArr == null || curWorkCalendarArr.length == 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u7ed9\u5f53\u524d\u7ec4\u7ec7\u6216\u8005\u9879\u76ee\u8bbe\u7f6e%s\u5e74\u65e5\u5386,\u624d\u80fd\u590d\u5236\u4e0b\u4e00\u5e74\u65e5\u5386\u3002", (String)"ProjWorkCalenderEditPlugin_13", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), nextyear1);
            this.getView().showErrorNotification(msg);
            return;
        }
        DynamicObject curWorkCalendar = curWorkCalendarArr[0];
        curWorkCalendar.set("expiringyearto", (Object)nextyear);
        int month = 12;
        curWorkCalendar.set("expiringmonthto", (Object)month);
        DynamicObjectCollection dateentry = curWorkCalendar.getDynamicObjectCollection("dateentry");
        if (dateentry != null && dateentry.size() > 0) {
            int seq = dateentry.size();
            DynamicObject lastObj = (DynamicObject)dateentry.get(seq - 1);
            Date lastWorkDate = lastObj.getDate("workdate");
            Calendar smallDate = Calendar.getInstance();
            smallDate.setTime(lastWorkDate);
            smallDate.add(5, 1);
            Calendar bigDate = Calendar.getInstance();
            bigDate.set(nextyear, month - 1, 1, 0, 0, 0);
            bigDate.set(nextyear, month - 1, bigDate.getActualMaximum(5), 0, 0, 0);
            int days = TimeUtils.daysBetween((Calendar)smallDate, (Calendar)bigDate);
            this.genCurWorkCalendarEntity(curWorkCalendar, dateentry, days, seq + 1, smallDate);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curWorkCalendar});
    }

    private void genCurWorkCalendarEntity(DynamicObject curWorkCalendar, DynamicObjectCollection dateentry, int days, int seq, Calendar smallDate) {
        Object[] isRestDay = this.getRestDays(curWorkCalendar);
        Object[] isHalfWorkDay = this.getHalfWorkDays(curWorkCalendar);
        String orgId = String.valueOf(this.getModel().getValue("dataorg"));
        int year = smallDate.get(1);
        int nextYear = year + 1;
        Calendar nextYearCal = Calendar.getInstance();
        nextYearCal.set(1, nextYear);
        int nextYearDays = nextYearCal.getActualMaximum(6);
        int newxYearStart = days - nextYearDays;
        Map<String, Object> markDateMap = this.getMarkDateMap(orgId, year, days);
        Calendar curCal = Calendar.getInstance();
        ArrayList<String> dateList = new ArrayList<String>(markDateMap.size());
        ArrayList workDataList = new ArrayList();
        for (int i = 0; i < days; ++i) {
            DynamicObject row = new DynamicObject(dateentry.getDynamicObjectType());
            row.set("seq", (Object)(i + seq));
            Date workDate = smallDate.getTime();
            String workDateStr = this.SDF.format(workDate);
            row.set("workdate", (Object)workDate);
            curCal.setTime(workDate);
            curCal.set(1, year);
            String workDateKey = this.SDF.format(curCal.getTime());
            Object dateTypeObj = markDateMap.get(workDateKey);
            if (dateTypeObj != null) {
                String dateType = String.valueOf(dateTypeObj);
                row.set("datetype", (Object)dateType);
                dateList.add(workDateStr);
                this.recordMarkWorkCalendar(orgId, dateList, dateType);
                dateList.clear();
            } else {
                int curDate = smallDate.get(7) - 1;
                dateTypeObj = (Boolean)isRestDay[curDate] != false ? "4" : ((Boolean)isHalfWorkDay[curDate] != false ? "2" : "1");
                row.set("datetype", dateTypeObj);
            }
            dateentry.add((Object)row);
            smallDate.add(5, 1);
            if (i < newxYearStart) continue;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("workDate", workDateStr);
            data.put("dateType", dateTypeObj == null ? "1" : dateTypeObj.toString());
            workDataList.add(data);
        }
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        workCalendar.setYear(nextYear);
        workCalendar.setWorkDataList(workDataList);
        workCalendar.setData();
    }

    private Object[] getRestDays(DynamicObject obj) {
        Object[] isRestDay = new Object[]{obj.get("issunrest"), obj.get("ismonrest"), obj.get("istuerest"), obj.get("iswedrest"), obj.get("isthurest"), obj.get("isfrirest"), obj.get("issatrest")};
        return isRestDay;
    }

    private Object[] getHalfWorkDays(DynamicObject obj) {
        Object[] isHalfWorkDay = new Object[]{obj.get("ishalfsunrest"), obj.get("ishalfmonrest"), obj.get("ishalftuerest"), obj.get("ishalfwedrest"), obj.get("ishalfthurest"), obj.get("ishalffrirest"), obj.get("ishalfsatrest")};
        return isHalfWorkDay;
    }

    private Map<String, Object> getMarkDateMap(String orgId, int year, int days) {
        Calendar startDate = Calendar.getInstance();
        startDate.set(year, 0, 1);
        Calendar endDate = Calendar.getInstance();
        endDate.add(5, days);
        endDate.set(year, 11, 31);
        String sDate = this.SDF.format(startDate.getTime());
        String eDate = this.SDF.format(endDate.getTime());
        boolean calendarFlag = ProjWorkCalendarLoadService.queryCalendarFlag(orgId, sDate, eDate);
        String flag = calendarFlag ? "1" : "0";
        Map<String, Object> markDateMap = ProjWorkCalendarLoadService.getMarkDateMap(orgId, sDate, eDate, flag);
        return markDateMap;
    }

    private void recordMarkWorkCalendar(String orgId, List<String> dateList, String dateType) {
        TreeView orgtree = (TreeView)this.getControl("orgtree");
        Map node = orgtree.getTreeState().getFocusNode();
        QFilter[] filters = new QFilter[2];
        if (StringUtils.isBlank((CharSequence)orgId)) {
            filters[0] = new QFilter("version", "=", (Object)"default");
        } else if (orgId.contains("proj")) {
            filters[0] = new QFilter("project", "=", (Object)orgId.split("proj")[0]);
        } else if (!orgId.contains("proj")) {
            filters[0] = new QFilter("org", "=", (Object)orgId);
        }
        filters[1] = new QFilter("isindividuation", "=", (Object)1);
        ORM orm = ORM.create();
        ArrayList<DynamicObject> workCalendarObjs = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection workCalendarDb = orm.query("pmpm_projworkcalendarset", "id, dateentry.*", filters);
        if (workCalendarDb == null || workCalendarDb.size() == 0) {
            DynamicObject[] insertedObjs;
            DynamicObject obj = orm.newDynamicObject("pmpm_projworkcalendarset");
            String smallDateStr = dateList.get(0);
            Date smallDate = new Date();
            try {
                smallDate = this.SDF.parse(smallDateStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(smallDate);
            if (!StringUtils.isBlank((CharSequence)orgId) && orgId.contains("proj")) {
                obj.set("org", (Object)node.get("parentid").toString());
                obj.set("project", (Object)orgId.split("proj")[0]);
            } else if (!StringUtils.isBlank((CharSequence)orgId) && !orgId.contains("proj")) {
                obj.set("org", (Object)orgId);
            }
            obj.set("isindividuation", (Object)1);
            this.genEntityCommon(obj, orgId);
            for (DynamicObject newObj : insertedObjs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj})) {
                DynamicObjectCollection dateentry = newObj.getDynamicObjectCollection("dateentry");
                this.genMarkWorkCalendarEntity(newObj, dateentry, dateList.size(), dateType, cal);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
            }
        } else {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)"pmpm_projworkcalendarset");
            EntryProp entryProp = (EntryProp)met.getProperty("dateentry");
            EntryType entryType = (EntryType)entryProp.getItemType();
            for (DynamicObject obj : workCalendarDb) {
                DynamicObjectCollection dateentry = obj.getDynamicObjectCollection("dateentry");
                if (dateentry == null) continue;
                List<Map<String, Object>> recordDateList = this.removeDuplicateMarkRecord(dateentry, dateList, dateType);
                int index = 1;
                for (Map<String, Object> dateMap : recordDateList) {
                    DynamicObject newObj = new DynamicObject((DynamicObjectType)entryType, null);
                    newObj.set("seq", (Object)index++);
                    newObj.set("workdate", dateMap.get("workdate"));
                    newObj.set("datetype", dateMap.get("datetype"));
                    dateentry.add((Object)newObj);
                }
                workCalendarObjs.add(obj);
            }
            orm.update(workCalendarObjs);
        }
    }

    private void genEntityCommon(DynamicObject obj, String orgId) {
        obj.set("org", (Object)orgId);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            obj.set("createorg", (Object)RequestContext.get().getOrgId());
        } else {
            obj.set("createorg", (Object)orgId);
        }
        obj.set("enable", (Object)"1");
        obj.set("status", (Object)"A");
        obj.set("creator", (Object)RequestContext.get().getUserId());
        Date date = new Date();
        obj.set("createtime", (Object)date);
        obj.set("modifier", (Object)RequestContext.get().getUserId());
        obj.set("modifytime", (Object)date);
        obj.set("minofendtimepm", (Object)0);
        obj.set("hourofendtimepm", (Object)0);
        obj.set("minofbegintimepm", (Object)0);
        obj.set("hourofbegintimepm", (Object)0);
        obj.set("minofendtimeam", (Object)0);
        obj.set("hourofendtimeam", (Object)0);
        obj.set("minofbegintimeam", (Object)0);
        obj.set("hourofbegintimeam", (Object)0);
    }

    private void genMarkWorkCalendarEntity(DynamicObject curWorkCalendar, DynamicObjectCollection dateentry, int days, String dateType, Calendar smallDate) {
        for (int i = 0; i < days; ++i) {
            DynamicObject row = new DynamicObject(dateentry.getDynamicObjectType());
            row.set("seq", (Object)0);
            row.set("workdate", (Object)smallDate.getTime());
            row.set("datetype", (Object)dateType);
            dateentry.add((Object)row);
            smallDate.add(5, 1);
        }
    }

    private List<Map<String, Object>> removeDuplicateMarkRecord(DynamicObjectCollection dateentry, List<String> dateList, String dateType) {
        HashMap<String, Object> oldDateMap;
        int oldCount = 0;
        if (dateentry != null) {
            oldCount = dateentry.size();
        }
        int newDateCount = dateList.size();
        ArrayList<Map<String, Object>> recordDateList = new ArrayList<Map<String, Object>>(oldCount + newDateCount);
        HashMap<String, String> newDateMap = new HashMap<String, String>(newDateCount);
        try {
            for (String date : dateList) {
                oldDateMap = new HashMap<String, Object>(2);
                oldDateMap.put("datetype", dateType);
                oldDateMap.put("workdate", this.SDF.parse(date));
                recordDateList.add(oldDateMap);
                newDateMap.put(date, dateType);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (dateentry != null) {
            for (int i = oldCount - 1; i >= 0; --i) {
                DynamicObject newObj = (DynamicObject)dateentry.get(i);
                if (newDateMap.get(this.SDF.format(newObj.getDate("workdate"))) == null) {
                    oldDateMap = new HashMap(2);
                    oldDateMap.put("workdate", newObj.getDate("workdate"));
                    oldDateMap.put("datetype", newObj.get("datetype"));
                    recordDateList.add(oldDateMap);
                }
                dateentry.remove(i);
            }
        }
        return recordDateList;
    }

    private void loadEmptyWorkCalendar(int year) {
        this.setCurYear(year);
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        workCalendar.setYear(year);
        workCalendar.setData();
    }

    private void markWorkCalendar(WorkCalendar workCalendar, String orgId) {
        ArrayList dateList = workCalendar.getDateList();
        if (!this.markDateValidate(dateList)) {
            return;
        }
        String dateType = workCalendar.getDateType();
        this.recordMarkWorkCalendar(orgId, dateList, dateType);
        workCalendar.setDateTypeCallBack((List)dateList, dateType);
    }

    private boolean markDateValidate(List<String> dateList) {
        if (dateList == null || dateList.size() == 0) {
            return false;
        }
        boolean isSucess = true;
        String startDateStr = dateList.get(0);
        Calendar today = Calendar.getInstance();
        try {
            Date startDate = this.SDF.parse(startDateStr);
            if (today.getTime().getTime() > startDate.getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6807\u6ce8\u5f53\u524d\u65e5\u671f\u4e4b\u524d\u7684\u65e5\u5386", (String)"ProjWorkCalenderEditPlugin_14", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                isSucess = false;
            } else {
                String endDateStr = dateList.get(dateList.size() - 1);
                Date endDate = this.SDF.parse(endDateStr);
                Date startvaliddate = (Date)this.getModel().getValue("startvaliddate");
                Date endvaliddate = (Date)this.getModel().getValue("endvaliddate");
                if (startvaliddate == null || endvaliddate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u5de5\u4f5c\u65e5\u5386\u7684\u6709\u6548\u671f\u95f4\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u3002", (String)"ProjWorkCalenderEditPlugin_15", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (startvaliddate.getTime() > startDate.getTime() || endvaliddate.getTime() < endDate.getTime()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6807\u6ce8\u5f53\u524d\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u6709\u6548\u671f\u95f4\u4e4b\u5916\u7684\u65e5\u5386", (String)"ProjWorkCalenderEditPlugin_16", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    isSucess = false;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u6821\u9a8c\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            isSucess = false;
        }
        return isSucess;
    }

    private void currUserOrg(List<Map<String, String>> orgTreeData, long orgId) {
        ORM orm = ORM.create();
        QFilter fftreetypefilter = new QFilter("view", "=", (Object)"15");
        QFilter fIsEnable = new QFilter("org.enable", "=", (Object)"1");
        QFilter fpidfilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters2 = new QFilter[]{fftreetypefilter, fpidfilter, fIsEnable};
        try (DataSet ds = orm.queryDataSet(OrgViewServiceHelper.class.getName(), ENTITY_ORG_StRUCTURE, "org.id,org.name,org.number,org.fcomment,parent.id,isleaf", filters2, "org.number asc");){
            Row row2 = null;
            HashMap<String, String> map = null;
            for (Row row2 : ds) {
                if (row2.get("org.id") == null || row2.get("org.id") != null && StringUtils.isEmpty((CharSequence)row2.getString("org.id"))) continue;
                map = new HashMap<String, String>();
                map.put("id", row2.get("org.id") == null ? "0" : row2.getString("org.id"));
                map.put("name", row2.get("org.name") == null ? "" : row2.getString("org.name"));
                map.put("number", row2.get("org.number") == null ? "" : row2.getString("org.number"));
                map.put("comment", row2.get("org.fcomment") == null ? "" : row2.getString("org.fcomment"));
                map.put("parentid", row2.get("parent.id") == null ? "0" : row2.getString("parent.id"));
                if (row2.get("isleaf") == null) {
                    map.put("isleaf", "1");
                } else {
                    map.put("isleaf", row2.getBoolean("isleaf") != false ? "1" : "0");
                }
                orgTreeData.add(map);
            }
        }
    }

    private List<Map<String, String>> querySubProjectOfOrg(String orgId) {
        QFilter fIsEnable = new QFilter("enable", "=", (Object)"1");
        QFilter fpidfilter = new QFilter("pmascreateorg", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{fpidfilter, fIsEnable};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_project", (String)"id,name", (QFilter[])filters);
        ArrayList<Map<String, String>> projList = new ArrayList<Map<String, String>>(dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            String id = dynamicObjects[i].getPkValue().toString();
            String projName = dynamicObjects[i].get("name").toString();
            map.put("id", id + "proj");
            map.put("name", projName);
            map.put("parentid", orgId);
            map.put("isleaf", "1");
            projList.add(map);
        }
        return projList;
    }

    private List<Long> projectPermission(Object parentid) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        orgIdList.add(Long.valueOf(parentid.toString()));
        DynamicObject[] permProjectByStatus = ProjectPermissionHelper.getPermProjectByStatus(orgIdList, (boolean)false, (String)"pmpm_projworkcalender", (String)"setworkcalendar");
        ArrayList<Long> permProjectIds = new ArrayList<Long>(permProjectByStatus.length);
        for (DynamicObject permProject : permProjectByStatus) {
            permProjectIds.add(Long.valueOf(permProject.getPkValue().toString()));
        }
        return permProjectIds;
    }
}

