/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.business.model.pmpm.PmpmMajortypeConstant;
import kd.pmgt.pmbs.business.model.pmpm.ProjectPlanConstant;
import kd.pmgt.pmbs.business.model.pmpm.TaskConstant;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.PlanEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DynamicObjectTypeUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.common.utils.TaskCloneUtil;
import kd.pmgt.pmbs.common.utils.task.PmpmTaskUtil;
import kd.pmgt.pmpm.common.utils.PlanEntryUtil;
import kd.pmgt.pmpm.common.utils.PlanTaskImpAndExpUtil;
import kd.pmgt.pmpm.common.utils.TreeEntryUtils;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmBillPlugin;

public class ProjectPlanEditPlugin
extends AbstractPmpmBillPlugin
implements BeforeF7SelectListener,
UploadListener,
TabSelectListener {
    private static final String parentId = "parentBillId";
    private static final String invokeOper = "invokeOper";
    private String[] rowNames = new String[]{"taskname", "tasknumber", "controllevel", "spectype", "tasktype", "absoluteshedule", "pretask", "logical", "relativeschedule", "planbegindate", "planenddate", "aimfinishtime", "comptimedeviation", "directperson", "directorg", "indirectperson", "indirectorg", "achievementnode"};

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int curIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
        switch (key) {
            case "spectype": {
                DynamicObject oldSpecType = (DynamicObject)valueSet[0].getOldValue();
                String taskId = (String)this.getModel().getValue("taskid", curIndex);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                if (task.getDynamicObject("prechangetask") == null) break;
                String preChaneTaskId = task.getDynamicObject("prechangetask").getString("id");
                QFilter filter = new QFilter("parent.id", "=", (Object)preChaneTaskId);
                filter.and(new QFilter("belongplantype.plantype", "=", (Object)"2"));
                DynamicObject subTask = BusinessDataServiceHelper.loadSingle((String)"pmpm_task", (String)"name", (QFilter[])new QFilter[]{filter});
                if (subTask == null) break;
                if (this.getPageCache().get("specChange") == null) {
                    this.getPageCache().put("specChange", "true");
                    this.getModel().setValue("spectype", (Object)oldSpecType, curIndex);
                    break;
                }
                this.getPageCache().remove("specChange");
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u5b58\u5728\u4e0b\u7ea7\u4e13\u9879\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4e13\u4e1a\u7c7b\u578b\u3002", (String)"ProjectPlanEditPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int curIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
        switch (key) {
            case "project": {
                DynamicObject oldProject = (DynamicObject)valueSet[0].getOldValue();
                String oldProjectId = "";
                if (oldProject != null) {
                    oldProjectId = oldProject.getString("id");
                }
                this.getPageCache().put("oldProjectId", oldProjectId);
                int rowCount = this.getModel().getEntryRowCount("taskentity");
                if (rowCount > 0) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u4f1a\u6e05\u7a7a\u5206\u5f55\u6240\u6709\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectPlanEditPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("switchProject"));
                } else {
                    this.switchProject();
                }
                this.setDateEditRange();
                break;
            }
            case "pretask": {
                PlanEntryUtil.calPlanTimeByPreTaskAndLogical((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex);
                this.setAllParentRowLocked();
                break;
            }
            case "logical": {
                PlanEntryUtil.calPlanTimeByPreTaskAndLogical((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex);
                this.setAllParentRowLocked();
                break;
            }
            case "aimfinishtime": {
                if (curIndex < 0) {
                    return;
                }
                PlanEntryUtil.calCompTimeDeviation((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex);
                this.setAllParentRowLocked();
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                break;
            }
            case "planbegindate": {
                if (curIndex < 0) {
                    return;
                }
                String taskId = (String)this.getModel().getValue("taskid", curIndex);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                Date planStartTime = (Date)this.getModel().getValue("planbegindate", curIndex);
                Date planEndTime = (Date)this.getModel().getValue("planenddate", curIndex);
                if (planStartTime == null) {
                    return;
                }
                if (planEndTime != null && planStartTime.after(planEndTime)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5b8c\u6210\u65f6\u95f4", (String)"ProjectPlanEditPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("planbegindate", changeSet.getOldValue(), curIndex);
                    return;
                }
                PlanEntryUtil.calPlanTime((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex, (String)"planbegindate");
                PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)curIndex);
                PlanEntryUtil.updateReferTaskTime((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAllParentRowLocked();
                break;
            }
            case "planenddate": {
                if (curIndex < 0) {
                    return;
                }
                String taskId = (String)this.getModel().getValue("taskid", curIndex);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                Date planStartTime = (Date)this.getModel().getValue("planbegindate", curIndex);
                Date planEndTime = (Date)this.getModel().getValue("planenddate", curIndex);
                if (planEndTime == null) {
                    return;
                }
                if (planStartTime != null && planStartTime.after(planEndTime)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4", (String)"ProjectPlanEditPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("planenddate", null, curIndex);
                    return;
                }
                PlanEntryUtil.calPlanTime((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex, (String)"planenddate");
                PlanEntryUtil.calCompTimeDeviation((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex);
                PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)curIndex);
                PlanEntryUtil.updateReferTaskTime((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAllParentRowLocked();
                break;
            }
            case "absoluteshedule": {
                BigDecimal oldValue = (BigDecimal)changeSet.getOldValue();
                BigDecimal newValue = (BigDecimal)changeSet.getNewValue();
                if (newValue.compareTo(BigDecimal.ZERO) < 0) {
                    this.getModel().setValue("absoluteshedule", (Object)oldValue, curIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f\u9700\u8981\u5927\u4e8e0", (String)"ProjectPlanEditPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                }
                PlanEntryUtil.calPlanTime((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex, (String)"absoluteshedule");
                String taskId = (String)this.getModel().getValue("taskid", curIndex);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)curIndex);
                PlanEntryUtil.updateReferTaskTime((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAllParentRowLocked();
                break;
            }
            case "relativeschedule": {
                PlanEntryUtil.calPlanTimeByPreTaskAndLogical((IFormView)this.getView(), (IDataModel)this.getModel(), (int)curIndex);
                String taskId = (String)this.getModel().getValue("taskid", curIndex);
                DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)curIndex);
                PlanEntryUtil.updateReferTaskTime((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                this.setAllParentRowLocked();
                break;
            }
            case "indirectperson": {
                DynamicObject entryInfo;
                DynamicObject cooperationPreson;
                if (curIndex < 0) {
                    return;
                }
                int rowCount = this.getModel().getEntryRowCount("taskentity");
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("taskentity");
                if (curIndex >= rowCount || (cooperationPreson = (entryInfo = (DynamicObject)entrys.get(curIndex)).getDynamicObject("indirectperson")) == null) break;
                DynamicObject responsiblePerson = entryInfo.getDynamicObject("directperson");
                if (responsiblePerson != null && cooperationPreson.getString("id").equals(responsiblePerson.getString("id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba", (String)"ProjectPlanEditPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("indirectperson", null, curIndex);
                    return;
                }
                long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(cooperationPreson.getPkValue().toString()));
                this.getModel().setValue("indirectorg", (Object)orgId, curIndex);
                break;
            }
            case "directperson": {
                DynamicObject entryInfo;
                DynamicObject responsiblePreson;
                if (curIndex < 0) {
                    return;
                }
                int rowCount = this.getModel().getEntryRowCount("taskentity");
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("taskentity");
                if (curIndex >= rowCount || (responsiblePreson = (entryInfo = (DynamicObject)entrys.get(curIndex)).getDynamicObject("directperson")) == null) break;
                DynamicObject cooperationPerson = entryInfo.getDynamicObject("indirectperson");
                if (cooperationPerson != null && cooperationPerson.getString("id").equals(responsiblePreson.getString("id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba", (String)"ProjectPlanEditPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("directperson", null, curIndex);
                    return;
                }
                long orgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(responsiblePreson.getPkValue().toString()));
                this.getModel().setValue("directorg", (Object)orgId, curIndex);
                break;
            }
            case "spectypecombo": {
                String projectPlanId = this.getModel().getDataEntity().getPkValue().toString();
                String specId = (String)this.getModel().getValue("spectypecombo");
                this.loadSpecEntryData(projectPlanId, specId);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("switchProject".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.switchProject();
        } else if ("switchProject".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
            String oldProjectId = this.getPageCache().get("oldProjectId");
            this.getModel().beginInit();
            this.getModel().setValue("project", (Object)oldProjectId);
            this.getModel().endInit();
            this.getView().updateView("project");
        }
        if ("close".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getPageCache().put("shouldClose", "true");
            this.getView().invokeOperation("close");
        }
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String key;
            switch (key = messageBoxClosedEvent.getCallBackId()) {
                case "calmodify": {
                    PlanEntryUtil.updateEntryTaskTimeWhenCalModify((IFormView)this.getView(), (IDataModel)this.getModel());
                    PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                    this.setAllParentRowLocked();
                    break;
                }
                case "proimptask": {
                    HashMap<String, Object> map = new HashMap<String, Object>(16);
                    HashMap<String, String> customMap = new HashMap<String, String>(16);
                    map.put("formId", "pmpm_impprotaskf7");
                    map.put("customParams", customMap);
                    FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                    parameter.setStatus(OperationStatus.EDIT);
                    parameter.getOpenStyle().setShowType(ShowType.Modal);
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_impprotaskf7"));
                    StyleCss css = new StyleCss();
                    css.setHeight("600px");
                    css.setWidth("1200px");
                    parameter.getOpenStyle().setInlineStyleCss(css);
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    String orgId = org.getString("id");
                    customMap.put("orgId", orgId);
                    customMap.put("billType", "projectplan");
                    DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                    String projectId = project.getString("id");
                    customMap.put("proId", projectId);
                    this.getView().showForm(parameter);
                    break;
                }
                case "importtask": {
                    if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ProjectPlanEditPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    FormShowParameter importExcelFormParameter = new FormShowParameter();
                    importExcelFormParameter.setFormId("taskimpdialog");
                    importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
                    importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_taskimpdialog"));
                    this.getView().showForm(importExcelFormParameter);
                    break;
                }
                case "close": {
                    int rowCount;
                    for (int i = rowCount = this.getModel().getEntryRowCount("taskentity"); i >= 0; --i) {
                        if (!"".equals(this.getModel().getValue("taskname", i))) continue;
                        String taskId = (String)this.getModel().getValue("taskid", i);
                        this.getModel().deleteEntryRow("taskentity", i);
                        DeleteServiceHelper.delete((IDataEntityType)TaskConstant.dt, (Object[])new Object[]{taskId});
                    }
                    this.getView().invokeOperation("save");
                    this.getView().invokeOperation("close");
                    break;
                }
            }
        }
    }

    private void switchProject() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            return;
        }
        this.deleteAllTask();
        this.getModel().deleteEntryData("taskentity");
        project = BusinessDataServiceHelper.loadSingle((Object)project.getString("id"), (String)"bd_project", (String)"group");
        if (project == null) {
            return;
        }
        this.isNoExistMajorType(project.getString("id"));
        String name = project.getString("name");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formatDate = sdf.format(new Date());
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        name = name + "(" + formatDate + ")" + ResManager.loadKDString((String)"\u4e3b\u9879\u8ba1\u5212", (String)"ProjectPlanEditPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]) + version.floatValue();
        this.getModel().setValue("name", (Object)name);
        String projectId = project.getString("id");
        QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
        DynamicObject[] calendarArr = BusinessDataServiceHelper.load((String)"pmpm_projworkcalendarset", (String)"version", (QFilter[])new QFilter[]{projectFilter});
        if (calendarArr.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u6ca1\u6709\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u65e5\u5386\u3002", (String)"ProjectPlanEditPlugin_8", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject majorType = BusinessDataServiceHelper.loadSingle((Object)"683786139815183360", (DynamicObjectType)PmpmMajortypeConstant.dt);
        if (majorType != null) {
            this.getModel().setValue("majortype", (Object)majorType);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit preTask = (BasedataEdit)this.getControl("pretask");
        preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsiblePerson = (BasedataEdit)this.getControl("directperson");
        responsiblePerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsibleDept = (BasedataEdit)this.getControl("directorg");
        responsibleDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cooperationPerson = (BasedataEdit)this.getControl("indirectperson");
        cooperationPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cooperationDept = (BasedataEdit)this.getControl("indirectorg");
        cooperationDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit spec = (BasedataEdit)this.getControl("spectype");
        spec.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button uploadBtn = (Button)this.getControl("btnimp");
        uploadBtn.addUploadListener((UploadListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabkey = tabSelectEvent.getTabKey();
        if ("spectab".equals(tabkey)) {
            this.setShowTab();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String key = (String)this.getView().getFormShowParameter().getCustomParam(invokeOper);
        Object parentbill = this.getView().getFormShowParameter().getCustomParam(parentId);
        if (null != key && key.equalsIgnoreCase("copy") && null != parentbill) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"project"});
            BigDecimal version = (BigDecimal)this.getModel().getValue("version");
            BigDecimal newVersion = version.add(BigDecimal.ONE);
            this.getModel().setValue("version", (Object)newVersion);
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project != null) {
                String name = project.getString("name");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                String formatDate = sdf.format(new Date());
                name = name + "[" + formatDate + "]" + ResManager.loadKDString((String)"\u4e3b\u9879\u8ba1\u5212", (String)"ProjectPlanEditPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]) + String.valueOf(newVersion);
                this.getModel().setValue("name", (Object)name);
            }
            this.getModel().setValue("prechangeplan", (Object)String.valueOf(parentbill));
            if (newVersion.compareTo(new BigDecimal("2")) == 0) {
                this.getModel().setValue("sourceplan", (Object)String.valueOf(parentbill));
            } else {
                DynamicObject preChangeDynamicObject = BusinessDataServiceHelper.loadSingle((Object)parentbill, (String)"pmpm_projectplan", (String)"id, sourceplan");
                if (null != preChangeDynamicObject) {
                    this.getModel().setValue("sourceplan", (Object)preChangeDynamicObject.getDynamicObject("sourceplan"));
                }
            }
            this.getModel().setValue("planstatus", (Object)PlanEnum.CREATEING.getValue());
        }
        TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
        entryTree.setCollapse(false);
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        if (BigDecimal.ONE.compareTo(version) != 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"importtask"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        OperationStatus formStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)formStatus) && version.compareTo(BigDecimal.ONE) == 0) {
            this.getModel().beginInit();
            this.getModel().setValue("project", null);
            this.getModel().endInit();
            this.getView().updateView("project");
        }
        String key = (String)this.getView().getFormShowParameter().getCustomParam(invokeOper);
        Object parentbill = this.getView().getFormShowParameter().getCustomParam(parentId);
        if (null != parentbill && null != key && key.equalsIgnoreCase("copy") && version.compareTo(BigDecimal.ONE) > 0) {
            this.getView().invokeOperation("save");
            DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
            ArrayList<DynamicObject> newTasks = new ArrayList<DynamicObject>(10);
            HashMap<String, String> taskIdRelation = new HashMap<String, String>(16);
            JSONObject jsonObject = new JSONObject();
            ORM orm = ORM.create();
            if (entries != null && !entries.isEmpty()) {
                long[] ids = orm.genLongIds("pmpm_task", entries.size());
                int idIndex = 0;
                for (DynamicObject entry : entries) {
                    if (null == entry.get("taskname")) continue;
                    DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)entry.get("taskid"), (String)"pmpm_task");
                    DynamicObject newTask = (DynamicObject)OrmUtils.clone((Object)task, (IDataEntityType)TaskConstant.dt, (boolean)true, (boolean)true);
                    TaskCloneUtil.cloneTask((DynamicObject)newTask, (DynamicObject)task);
                    newTask.set("version", (Object)(task.getInt("version") + 1));
                    newTask.set("sourcetask", (Object)task);
                    DynamicObject plantype = (DynamicObject)task.get("belongplantype");
                    DynamicObject plantypeObj = BusinessDataServiceHelper.loadSingle((Object)plantype.getPkValue(), (String)"pmpm_majortype");
                    if (null != plantypeObj && StringUtils.equalsIgnoreCase((CharSequence)plantypeObj.getString("plantype"), (CharSequence)PlanTypeEnum.MAINPLAN.getValue())) {
                        jsonObject.clear();
                        jsonObject.put("mainproplanid", this.getModel().getDataEntity().getPkValue());
                        newTask.set("plans", (Object)jsonObject.toString());
                    }
                    newTask.set("status", (Object)StatusEnum.TEMPSAVE.getValue());
                    newTask.set("prechangetask", (Object)task);
                    Long id = ids[idIndex++];
                    taskIdRelation.put(task.getString("id"), String.valueOf(id));
                    newTask.set("id", (Object)id);
                    entry.set("taskid", (Object)String.valueOf(id));
                    entry.set("taskname", (Object)newTask.getString("name"));
                    newTasks.add(newTask);
                }
            }
            for (int i = 0; i < newTasks.size(); ++i) {
                String oldPreTaskId;
                DynamicObject newTask = (DynamicObject)newTasks.get(i);
                if (null != newTask.getDynamicObject("parent")) {
                    String oldParentId = newTask.getDynamicObject("parent").getString("id");
                    String newParentId = (String)taskIdRelation.get(oldParentId);
                    List parentList = newTasks.stream().filter(obj -> newParentId.equals(obj.getString("id"))).collect(Collectors.toList());
                    newTask.set("parent", parentList.get(0));
                }
                if (null == newTask.getDynamicObject("pretask") || taskIdRelation.get(oldPreTaskId = newTask.getDynamicObject("pretask").getString("id")) == null) continue;
                String newPreTaskId = (String)taskIdRelation.get(oldPreTaskId);
                List preTaskList = newTasks.stream().filter(obj -> newPreTaskId.equals(obj.getString("id"))).collect(Collectors.toList());
                newTask.set("pretask", preTaskList.get(0));
            }
            DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
            boolean isBefore = this.isBeforePlanAudit(project.getPkValue(), parentbill);
            if (isBefore) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9879\u76ee\u65e5\u5386\u53d1\u751f\u4e86\u4fee\u6539\uff0c\u662f\u5426\u9700\u8981\u91cd\u7b97\u65f6\u95f4\uff1f", (String)"ProjectPlanEditPlugin_9", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("calmodify"));
            }
            SaveServiceHelper.save((DynamicObject[])newTasks.toArray(new DynamicObject[newTasks.size()]));
            this.getView().invokeOperation("save");
            this.getView().getFormShowParameter().getCustomParams().clear();
            String userId = RequestContext.get().getUserId();
            this.getModel().setValue("creator", (Object)userId);
        }
        this.setDateEditRange();
        this.setAllParentRowLocked();
        this.setShowTab();
    }

    private void setShowTab() {
        Object preChangePlan = this.getModel().getValue("prechangeplan");
        String status = this.getModel().getDataEntity().getString("billstatus");
        if (preChangePlan != null && !"C".equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"adjusttab"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"adjusttab"});
        }
        String proPlanId = this.getModel().getDataEntity().getPkValue().toString();
        QFilter proPlanFilter = new QFilter("projectplan", "=", (Object)proPlanId);
        DynamicObject[] majorPlan = BusinessDataServiceHelper.load((String)"pmpm_majorplan", (String)"id", (QFilter[])new QFilter[]{proPlanFilter});
        if (majorPlan.length > 0 && "C".equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"spectab"});
            this.setSpecTypeCombo();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"spectab"});
        }
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            this.isNoExistMajorType(project.getString("id"));
        }
    }

    private void setSpecTypeCombo() {
        ArrayList<ComboItem> comboList = new ArrayList<ComboItem>(16);
        ArrayList<String> specNameList = new ArrayList<String>(16);
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject specObj = (DynamicObject)this.getModel().getValue("spectype", i);
            if (specObj == null) continue;
            String specId = specObj.getString("id");
            String specName = specObj.getString("name");
            if (specNameList.contains(specName)) continue;
            specNameList.add(specName);
            comboList.add(new ComboItem(new LocaleString(specName), specId));
        }
        ComboEdit specCombo = (ComboEdit)this.getControl("spectypecombo");
        specCombo.setComboItems(comboList);
        if (comboList.size() > 0) {
            ComboItem comboItem = (ComboItem)comboList.get(0);
            this.getModel().setValue("spectypecombo", (Object)comboItem.getValue());
        }
    }

    private void loadSpecEntryData(String projectPlanId, String specId) {
        this.getModel().deleteEntryData("spectaskentity");
        if (!"".equals(specId)) {
            QFilter proPlanFilter = new QFilter("projectplan", "=", (Object)projectPlanId);
            QFilter specTypeFilter = new QFilter("majortype", "=", (Object)specId);
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            DynamicObject[] majorPlans = BusinessDataServiceHelper.load((String)"pmpm_majorplan", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,name,version,org,marjortype,taskentity.id,taskentity.pid,taskentity.isGroupNode,taskentity.taskname,taskentity.tasknumber,taskentity.controllevel,taskentity.spectype,taskentity.tasktype,taskentity.absoluteshedule,taskentity.pretask,taskentity.parent,taskentity.level,taskentity.isleaf,taskentity.relativeschedule,taskentity.planbegindate,taskentity.planenddate,taskentity.aimfinishtime,taskentity.comptimedeviation,taskentity.directperson,taskentity.directorg,taskentity.indirectperson,taskentity.indirectorg,taskentity.taskid,projectplan,project,logical,planstatus", (QFilter[])new QFilter[]{proPlanFilter, specTypeFilter, statusFilter}, (String)"version desc");
            if (majorPlans.length > 0) {
                TreeEntryGrid specEntryCtrl = (TreeEntryGrid)this.getControl("spectaskentity");
                specEntryCtrl.setCollapse(false);
                DynamicObject majorPlan = majorPlans[0];
                DynamicObjectCollection taskEntry = majorPlan.getDynamicObjectCollection("taskentity");
                HashMap<String, Integer> taskIdIndexMap = new HashMap<String, Integer>(16);
                for (DynamicObject taskEntryObj : taskEntry) {
                    String taskId = taskEntryObj.getString("taskid");
                    DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                    DynamicObject parentTask = task.getDynamicObject("parent");
                    if (parentTask == null) {
                        int index = this.getModel().createNewEntryRow("spectaskentity");
                        this.getModel().setValue("taskobj", (Object)task.getString("id"), index);
                        taskIdIndexMap.put(task.getString("id"), index);
                        continue;
                    }
                    int parentIndex = (Integer)taskIdIndexMap.get(parentTask.getString("id"));
                    int index = this.getModel().insertEntryRow("spectaskentity", parentIndex);
                    this.getModel().setValue("taskobj", (Object)task.getString("id"), index);
                    taskIdIndexMap.put(task.getString("id"), index);
                }
            }
        }
    }

    private void setDateEditRange() {
        DateEdit planStartTime = (DateEdit)this.getControl("planbegindate");
        DateEdit planEndTime = (DateEdit)this.getControl("planenddate");
        DateEdit aimFinishTime = (DateEdit)this.getControl("aimfinishtime");
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (project != null) {
            Object projecId = project.getPkValue();
            Date firstDay = PmpmTaskUtil.getFirstDayByProject((Object)projecId).getTime();
            Date endDay = PmpmTaskUtil.getEndDayByProject((Object)projecId).getTime();
            planStartTime.setMinDate(firstDay);
            planStartTime.setMaxDate(endDay);
            planEndTime.setMinDate(firstDay);
            planEndTime.setMaxDate(endDay);
            aimFinishTime.setMinDate(firstDay);
            aimFinishTime.setMaxDate(endDay);
        }
    }

    private void setProjectFilter(BeforeF7SelectEvent arg) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            String operateNum = "new";
            ArrayList<Long> orgList = new ArrayList<Long>(10);
            orgList.add((Long)org.getPkValue());
            DynamicObject[] proMap = ProjectPermissionHelper.getPermProjectByStatus(orgList, (boolean)true, (String)"pmpm_projectplan", (String)operateNum);
            Set proIdSet = Arrays.stream(proMap).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            QFilter orgFilter = new QFilter("project", "in", proIdSet);
            DynamicObject[] cols = BusinessDataServiceHelper.load((String)"pmpm_projectplan", (String)"project,org", (QFilter[])new QFilter[]{orgFilter});
            if (cols.length > 0) {
                for (DynamicObject plan : cols) {
                    Object id = plan.getDynamicObject("project").getPkValue();
                    if (!proIdSet.contains(plan.getDynamicObject("project").getPkValue())) continue;
                    proIdSet.remove(id);
                }
            }
            QFilter projectFilter = new QFilter("id", "in", proIdSet);
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().clear();
            showParameter.getListFilterParameter().getQFilters().add(projectFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskEntity");
        int[] selRows = grid.getSelectRows();
        this.getModel().getEntryEntity("taskEntity");
        switch (key) {
            case "save": {
                this.beforeDoSave(args);
                break;
            }
            case "submit": {
                PlanEntryUtil.saveTask((IFormView)this.getView(), (IDataModel)this.getModel());
                break;
            }
            case "addtask": {
                this.addTaskOperation(grid, selRows);
                break;
            }
            case "modifytask": {
                this.modifyTaskOperation(selRows);
                break;
            }
            case "deletetask": {
                this.deleteTaskOperation(selRows);
                break;
            }
            case "upgrade": {
                this.upgradeOperation(selRows);
                break;
            }
            case "downgrade": {
                this.downgradeOperation(selRows);
                break;
            }
            case "moveentryup": {
                this.beforeDoMoveEntryUp(selRows);
                break;
            }
            case "moveentrydown": {
                this.beforeDoMoveEntryDown(selRows);
                break;
            }
        }
    }

    private void beforeDoMoveEntryDown(int[] selRows) {
        if (selRows == null || selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u79fb\u52a8\u7684\u6570\u636e", (String)"ProjectPlanEditPlugin_24", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u79fb\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"ProjectPlanEditPlugin_27", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!TreeEntryUtils.isAllowMoveDown((IDataModel)this.getModel(), (int[])selRows, (String)"taskentity")) {
            return;
        }
        int pIndex = this.getParentRowIndex(selRows[0]);
        int bIndex = this.getYoungerBrotherIndex(selRows[0]);
        this.getPageCache().put("parentIndex", String.valueOf(pIndex));
        this.getPageCache().put("brotherIndex", String.valueOf(bIndex));
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private void beforeDoMoveEntryUp(int[] selRows) {
        if (selRows == null || selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u79fb\u52a8\u7684\u6570\u636e", (String)"ProjectPlanEditPlugin_24", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u79fb\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"ProjectPlanEditPlugin_25", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!TreeEntryUtils.isAllowMoveUp((IDataModel)this.getModel(), (int[])selRows, (String)"taskentity")) {
            return;
        }
        int parentIndex = this.getParentRowIndex(selRows[0]);
        int brotherIndex = this.getOlderBrotherIndex(selRows[0]);
        this.getPageCache().put("parentIndex", String.valueOf(parentIndex));
        this.getPageCache().put("brotherIndex", String.valueOf(brotherIndex));
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private void downgradeOperation(int[] selRows) {
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u964d\u7ea7\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"ProjectPlanEditPlugin_22", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u964d\u7ea7\u884c", (String)"ProjectPlanEditPlugin_23", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeEntryUtils.downgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, null);
        String taskId = (String)this.getModel().getValue("taskid", selRows[0]);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
        if (this.getModel().getValue("parent", selRows[0]) != null) {
            DynamicObject parentTask = (DynamicObject)this.getModel().getValue("parent", selRows[0]);
            task.set("parent", (Object)parentTask);
        }
        PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)selRows[0]);
        PlanEntryUtil.updateReferTaskTimeForTreeGrade((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
        PlanEntryUtil.updateTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel(), (int)selRows[0]);
        this.setAllParentRowLocked();
        this.loadPreTask();
        this.getView().updateView("taskentity");
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private void upgradeOperation(int[] selRows) {
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"ProjectPlanEditPlugin_20", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5347\u7ea7\u884c", (String)"ProjectPlanEditPlugin_21", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeEntryUtils.upgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, null);
        String taskId = (String)this.getModel().getValue("taskid", selRows[0]);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
        PlanEntryUtil.setRowValToTask((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)selRows[0]);
        PlanEntryUtil.updateReferTaskTimeForTreeGrade((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task);
        PlanEntryUtil.updateTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel(), (int)selRows[0]);
        this.setAllParentRowLocked();
        this.loadPreTask();
        this.getView().updateView("taskentity");
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private void deleteTaskOperation(int[] selRows) {
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5220\u9664\u7684\u4efb\u52a1", (String)"ProjectPlanEditPlugin_18", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        int index = 0;
        ArrayList<String> delIdsArr = new ArrayList<String>(10);
        ArrayList<String> delEntryIdsArr = new ArrayList<String>(10);
        for (int j = selRows.length - 1; j >= 0; --j) {
            index = selRows[j];
            boolean isLeaf = (Boolean)this.getModel().getValue("isleaf", index);
            if (!isLeaf) {
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u7b2c%s\u884c\u7684\u5b50\u4efb\u52a1", (String)"ProjectPlanEditPlugin_19", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), selRows[j] + 1);
                this.getView().showTipNotification(msg);
                return;
            }
            String delTaskId = (String)this.getModel().getValue("taskid", index);
            if (this.hasSubMajorTask(delTaskId, index)) continue;
            return;
        }
        for (int i = selRows.length - 1; i >= 0; --i) {
            index = selRows[i];
            String delTaskId = (String)this.getModel().getValue("taskid", index);
            if (delTaskId != null && !"0".equals(delTaskId) && !"".equals(delTaskId)) {
                delIdsArr.add(delTaskId);
            }
            delEntryIdsArr.add(this.getModel().getEntryRowEntity("taskentity", index).getString("id"));
            DynamicObject parentTaskObj = (DynamicObject)this.getModel().getValue("parent", index);
            if (parentTaskObj != null) {
                String parentTaskId = parentTaskObj.getString("id");
                for (int j = index - 1; j >= 0; --j) {
                    int lastChildIndex;
                    String curTaskId = (String)this.getModel().getValue("taskid", j);
                    if (!parentTaskId.equals(curTaskId) || (lastChildIndex = PlanEntryUtil.getSameLevelChildIndex((IFormView)this.getView(), (IDataModel)this.getModel(), (int)j)) != index) continue;
                    this.getModel().setValue("isleaf", (Object)Boolean.TRUE, j);
                    this.getModel().getEntryRowEntity("taskentity", j).set("isGroupNode", (Object)Boolean.FALSE);
                }
            }
            this.getModel().deleteEntryRow("taskentity", index);
        }
        DynamicObjectType subEntryDt = DynamicObjectTypeUtils.getEntryDynamicObjectType((String)"pmpm_projectplan", (String)"taskentity");
        DeleteServiceHelper.delete((IDataEntityType)subEntryDt, (Object[])delEntryIdsArr.toArray());
        DeleteServiceHelper.delete((IDataEntityType)TaskConstant.dt, (Object[])delIdsArr.toArray());
        for (String string : delIdsArr) {
            PmpmTaskUtil.cleanPreTaskAndLogicalWhereDelTask((Object)string);
        }
        PlanEntryUtil.saveTask((IFormView)this.getView(), (IDataModel)this.getModel());
        this.setAllParentRowLocked();
        this.getView().updateView("taskentity");
    }

    private void modifyTaskOperation(int[] selRows) {
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4fee\u6539\u7684\u4efb\u52a1\u884c", (String)"ProjectPlanEditPlugin_15", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fee\u6539\u4efb\u52a1\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"ProjectPlanEditPlugin_16", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        PlanEntryUtil.saveTask((IFormView)this.getView(), (IDataModel)this.getModel());
        int index = selRows[0];
        String taskId = (String)this.getModel().getValue("taskid", index);
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"completionstatus");
        String completeStatus = taskObj.getString("completionstatus");
        if (CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completeStatus) || CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completeStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"ProjectPlanEditPlugin_17", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<Object, Object> customMap1 = new HashMap<Object, Object>(16);
        this.openTaskPage(customMap1, taskId);
    }

    private void addTaskOperation(TreeEntryGrid grid, int[] selRows) {
        this.getPageCache().put("isAddTask", "true");
        if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ProjectPlanEditPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u4e0b\u4efb\u52a1\u884c\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"ProjectPlanEditPlugin_13", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        ORM orm = ORM.create();
        String taskId = String.valueOf(orm.genLongId((IDataEntityType)TaskConstant.dt));
        this.getModel().beginInit();
        if (selRows.length == 0) {
            int index = this.getModel().createNewEntryRow("taskentity");
            this.getModel().setValue("taskid", (Object)taskId, index);
            this.getModel().setValue("level", (Object)1, index);
            this.getModel().setValue("isleaf", (Object)Boolean.TRUE, index);
            this.createTaskAndSave(index);
        } else {
            if ("".equals(this.getModel().getValue("taskname", selRows[0]))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u7ea7\u4efb\u52a1\u7684\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"ProjectPlanEditPlugin_14", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            String parentTaskId = (String)this.getModel().getValue("taskid", selRows[0]);
            int parentLevel = (Integer)this.getModel().getValue("level", selRows[0]);
            int curRowLevel = parentLevel + 1;
            int index = this.getModel().insertEntryRow("taskentity", selRows[0]);
            this.getModel().setValue("taskid", (Object)taskId, index);
            this.getModel().setValue("parent", (Object)parentTaskId, index);
            this.getModel().setValue("level", (Object)curRowLevel, index);
            this.getModel().setValue("isleaf", (Object)Boolean.TRUE, index);
            this.getModel().setValue("isleaf", (Object)Boolean.FALSE, selRows[0]);
            this.getModel().setValue("pretask", null, selRows[0]);
            this.getModel().setValue("logical", null, selRows[0]);
            this.createTaskAndSave(index);
            grid.expand(selRows[0]);
        }
        this.getModel().endInit();
        this.getView().updateView("taskentity");
        this.setAllParentRowLocked();
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
        this.getPageCache().remove("isAddTask");
    }

    private void beforeDoSave(BeforeDoOperationEventArgs args) {
        Object planName = this.getModel().getValue("name");
        Object version = this.getModel().getValue("version");
        Object project = this.getModel().getValue("project");
        if (project == null) {
            this.getView().showTipNotification("\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            args.setCancel(true);
        } else if (planName == null || "".equals(planName.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"ProjectPlanEditPlugin_10", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (version == null || "".equals(version)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ProjectPlanEditPlugin_11", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (!"true".equals(this.getPageCache().get("isAddTask"))) {
            int rowCount = this.getModel().getEntryRowCount("taskentity");
            for (int i = 0; i < rowCount; ++i) {
                if (!"".equals(this.getModel().getValue("taskname", i))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355\u5206\u5f55\u7684\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProjectPlanEditPlugin_12", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(true);
            }
        }
    }

    private int getParentRowIndex(int row) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent", row);
        if (parent != null) {
            Object parentId = parent.getPkValue();
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                Object taskId = rowEntity.get("taskid");
                if (taskId == null || !parentId.toString().equals(taskId.toString())) continue;
                return i;
            }
        }
        return 0;
    }

    private int getOlderBrotherIndex(int row) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent", row);
        if (parent != null) {
            Object parentId = parent.getPkValue();
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                DynamicObject rowParent = (DynamicObject)rowEntity.get("parent");
                if (rowParent == null || !parentId.equals(rowParent.getPkValue())) continue;
                return i;
            }
        } else {
            for (int i = row - 1; i >= 0; --i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                DynamicObject rowParent = (DynamicObject)rowEntity.get("parent");
                if (rowParent != null) continue;
                return i;
            }
        }
        return 0;
    }

    private int getYoungerBrotherIndex(int row) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent", row);
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        if (parent != null) {
            Object parentId = parent.getPkValue();
            int nextIndex = 0;
            int nextCount = 0;
            for (int i = row + 1; i < rowCount; ++i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
                DynamicObject rowParent = (DynamicObject)rowEntity.get("parent");
                if (rowParent == null || !parentId.equals(rowParent.getPkValue())) continue;
                if (nextIndex != 0) {
                    nextCount = i - nextIndex;
                    break;
                }
                nextIndex = i;
            }
            if (nextCount == 0) {
                nextCount = rowCount - nextIndex;
            }
            return row + nextCount;
        }
        int nextIndex = 0;
        int nextCount = 0;
        for (int i = row + 1; i < rowCount; ++i) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("taskentity", i);
            DynamicObject rowParent = (DynamicObject)rowEntity.get("parent");
            if (rowParent != null) continue;
            if (nextIndex != 0) {
                nextCount = i - nextIndex;
                break;
            }
            nextIndex = i;
        }
        if (nextCount == 0) {
            nextCount = rowCount - nextIndex;
        }
        return row + nextCount;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = operate.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskEntity");
        switch (key) {
            case "save": {
                PlanEntryUtil.saveTask((IFormView)this.getView(), (IDataModel)this.getModel());
                break;
            }
            case "batchmodify": {
                this.batchModifyOperation(grid);
                break;
            }
            case "viewtaskdetail": {
                this.viewTaskDetailOperation(grid);
                break;
            }
            case "moveentryup": {
                this.getModel().updateCache();
                String parentIndex = this.getPageCache().get("parentIndex");
                String brotherIndex = this.getPageCache().get("brotherIndex");
                if (parentIndex == null || brotherIndex == null) break;
                grid.selectRows(Integer.parseInt(brotherIndex));
                grid.focus(Integer.parseInt(parentIndex), Integer.parseInt(brotherIndex));
                this.getPageCache().remove("parentIndex");
                this.getPageCache().remove("brotherIndex");
                break;
            }
            case "moveentrydown": {
                this.getModel().updateCache();
                String pIndex = this.getPageCache().get("parentIndex");
                String bIndex = this.getPageCache().get("brotherIndex");
                if (pIndex == null || bIndex == null) break;
                grid.selectRows(Integer.parseInt(bIndex));
                grid.focus(Integer.parseInt(pIndex), Integer.parseInt(bIndex));
                this.getPageCache().remove("parentIndex");
                this.getPageCache().remove("brotherIndex");
                break;
            }
            case "exportmodel": {
                this.exportModelOperation();
                break;
            }
            case "proimptask": {
                if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ProjectPlanEditPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u5220\u9664\u73b0\u6709\u4efb\u52a1\u53ca\u4efb\u52a1\u6267\u884c\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectPlanEditPlugin_32", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("proimptask"));
                break;
            }
            case "importtask": {
                this.importTaskOperation();
                break;
            }
        }
    }

    private void viewTaskDetailOperation(TreeEntryGrid grid) {
        int[] selRows = grid.getSelectRows();
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u884c", (String)"ProjectPlanEditPlugin_30", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u4efb\u52a1\u8be6\u60c5\u4e0d\u5141\u8bb8\u591a\u9009\u884c", (String)"ProjectPlanEditPlugin_31", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = selRows[0];
        String taskId = (String)this.getModel().getValue("taskid", rowIndex);
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        if (taskId != null) {
            paramMap.put("formId", "pmpm_reporttaskview");
            paramMap.put("pkId", taskId);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    private void batchModifyOperation(TreeEntryGrid grid) {
        int[] selRows = grid.getSelectRows();
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6279\u91cf\u4fee\u6539\u884c", (String)"ProjectPlanEditPlugin_29", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("formId", "pmpm_batchmodify");
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_batchmodify"));
        this.getView().showForm(parameter);
    }

    private void importTaskOperation() {
        int size = this.getModel().getEntryRowCount("taskentity");
        if (size == 0) {
            if ((Long)this.getModel().getDataEntity().get("id") == 0L) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u5c1a\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ProjectPlanEditPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter importExcelFormParameter = new FormShowParameter();
            importExcelFormParameter.setFormId("taskimpdialog");
            importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
            importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_taskimpdialog"));
            this.getView().showForm(importExcelFormParameter);
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355\u5bfc\u5165\u5c06\u4f1a\u6e05\u7a7a\u73b0\u6709\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectPlanEditPlugin_33", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("importtask"));
        }
    }

    private void exportModelOperation() {
        JSONArray data = new JSONArray();
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            JSONObject jsonObject = new JSONObject();
            PlanTaskImpAndExpUtil.createTaskJsonObject((DynamicObject)task, (JSONObject)jsonObject);
            data.add((Object)jsonObject);
        }
        PlanTaskImpAndExpUtil.exportModel((IFormView)this.getView(), (JSONArray)data);
    }

    private void createTaskAndSave(int index) {
        DynamicObject rowObj = this.getModel().getEntryRowEntity("taskentity", index);
        DynamicObject task = new DynamicObject(TaskConstant.dt);
        task.set("id", (Object)rowObj.getString("taskid"));
        task.set("parent", (Object)rowObj.getString("parent"));
        task.set("level", (Object)rowObj.getString("level"));
        task.set("isleaf", (Object)rowObj.getString("isleaf"));
        task.set("taskseq", (Object)index);
        task.set("completionstatus", (Object)CompletionStatusEnum.UNSTART.getValue());
        task.set("enable", (Object)1);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        task.set("project", (Object)project);
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        task.set("version", (Object)version);
        JSONObject plansJsonObject = new JSONObject();
        String mainProPlanId = this.getModel().getDataEntity().getPkValue().toString();
        plansJsonObject.put("mainproplanid", (Object)mainProPlanId);
        String plans = plansJsonObject.toString();
        task.set("plans", (Object)plans);
        DynamicObject majorType = BusinessDataServiceHelper.loadSingle((String)"pmpm_majortype", (String)"id,plantype", (QFilter[])new QFilter[]{new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue())});
        task.set("belongplantype", (Object)majorType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        this.getView().invokeOperation("save");
    }

    private void loadTask() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            PlanEntryUtil.setRowTaskObj((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)i);
        }
        PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    private boolean hasSubMajorTask(String taskId, int seq) {
        DynamicObject curTaskObj;
        if (taskId != null && !"0".equals(taskId) && !"".equals(taskId) && (curTaskObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"prechangetask")).getDynamicObject("prechangetask") != null) {
            DynamicObject[] taskArr;
            String preChangeTaskId = curTaskObj.getDynamicObject("prechangetask").getString("id");
            QFilter filter = new QFilter("parent.id", "=", (Object)preChangeTaskId);
            filter.and(new QFilter("belongplantype.plantype", "=", (Object)"2"));
            for (DynamicObject task : taskArr = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"numer,name,belongplantype.plantype,plans", (QFilter[])new QFilter[]{filter})) {
                QFilter statusFilter;
                String majorPlanId;
                QFilter idFilter;
                DynamicObject majorPlan;
                String planStr = task.getString("plans");
                JSONObject plansObj = JSONObject.parseObject((String)planStr);
                if (plansObj.get((Object)"majorproplanid") == null || (majorPlan = BusinessDataServiceHelper.loadSingle((String)"pmpm_majorplan", (String)"name", (QFilter[])new QFilter[]{idFilter = new QFilter("id", "=", (Object)(majorPlanId = plansObj.getString("majorproplanid"))), statusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue())})) == null) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u4e3b\u9879\u4efb\u52a1%s\u5728\u4e0b\u7ea7\u4e13\u9879\u8ba1\u5212\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u5148\u5220\u9664\u4e13\u9879\u8ba1\u5212\u3002", (String)"ProjectPlanEditPlugin_34", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), this.getModel().getValue("taskname", seq));
                this.getView().showTipNotification(msg);
                return false;
            }
        }
        return true;
    }

    private void deleteAllTask() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        if (rowCount == 0) {
            return;
        }
        Object[] delTaskPks = new String[rowCount];
        Object[] delEntryPks = new String[rowCount];
        for (int i = rowCount - 1; i >= 0; --i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            DynamicObject entryInfo = this.getModel().getEntryRowEntity("taskentity", i);
            delTaskPks[i] = taskId;
            delEntryPks[i] = entryInfo.getString("id");
        }
        DeleteServiceHelper.delete((IDataEntityType)TaskConstant.dt, (Object[])delTaskPks);
        DynamicObjectType subEntryDt = DynamicObjectTypeUtils.getEntryDynamicObjectType((String)"pmpm_projectplan", (String)"taskentity");
        DeleteServiceHelper.delete((IDataEntityType)subEntryDt, (Object[])delEntryPks);
    }

    private void openTaskPage(Map<Object, Object> customMap, String pkId) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("formId", "pmpm_task");
        map.put("customParams", customMap);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        if (pkId != null) {
            ((BillShowParameter)parameter).setPkId((Object)pkId);
        } else {
            customMap.put("mainproplanid", this.getModel().getDataEntity().getPkValue());
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project != null) {
                customMap.put("projectid", project.getString("id"));
            }
        }
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_task"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        switch (key = closedCallBackEvent.getActionId()) {
            case "pmpm_batchmodify": {
                int[] selRows;
                Map dataMap = (Map)closedCallBackEvent.getReturnData();
                if (dataMap == null) break;
                String directperson = (String)dataMap.get("directperson");
                String directorg = (String)dataMap.get("directorg");
                String indirectperson = (String)dataMap.get("indirectperson");
                String indirectorg = (String)dataMap.get("indirectorg");
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
                for (int index : selRows = grid.getSelectRows()) {
                    if (directperson != null) {
                        DynamicObject inDirectPerson = (DynamicObject)this.getModel().getValue("indirectperson", index);
                        if (inDirectPerson != null && directperson.equals(inDirectPerson.getString("id"))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba", (String)"ProjectPlanEditPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                            this.getModel().setValue("directperson", null, index);
                        } else {
                            this.getModel().setValue("directperson", (Object)directperson, index);
                        }
                    }
                    if (directorg != null) {
                        this.getModel().setValue("directorg", (Object)directorg, index);
                    }
                    if (indirectperson != null) {
                        DynamicObject responsiblePerson = (DynamicObject)this.getModel().getValue("directperson", index);
                        if (indirectperson.equals(responsiblePerson.getString("id"))) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u529e\u4eba\u548c\u534f\u529e\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba", (String)"ProjectPlanEditPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                            this.getModel().setValue("indirectperson", null, index);
                        } else {
                            this.getModel().setValue("indirectperson", (Object)indirectperson, index);
                        }
                    }
                    if (indirectorg != null) {
                        this.getModel().setValue("indirectorg", (Object)indirectorg, index);
                    }
                    grid.selectRows(-1);
                }
                break;
            }
            case "pmpm_task": {
                this.loadTask();
                this.setAdjustLocked();
                break;
            }
            case "pmpm_impprotaskf7": {
                Map taskMap = (Map)closedCallBackEvent.getReturnData();
                if (taskMap == null) {
                    return;
                }
                this.deleteAllTask();
                this.getModel().deleteEntryData("taskentity");
                ArrayList saveTaskList = new ArrayList(10);
                HashMap taskIdRelation = new HashMap(16);
                for (Map.Entry entry : taskMap.entrySet()) {
                    String level = (String)entry.getKey();
                    ArrayList taskIdList = (ArrayList)entry.getValue();
                    PlanTaskImpAndExpUtil.cloneTaskToEntry((IFormView)this.getView(), (String)level, (ArrayList)taskIdList, saveTaskList, taskIdRelation);
                }
                try {
                    PlanTaskImpAndExpUtil.calculateByAbsoluteduration((IFormView)this.getView(), saveTaskList);
                    PlanTaskImpAndExpUtil.setPretask((IFormView)this.getView(), saveTaskList, taskIdRelation);
                }
                catch (Exception e) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8ba1\u7b97\u540e\u7684\u4efb\u52a1\u65e5\u671f\u8d85\u51fa\u65e5\u5386\u8303\u56f4\uff0c\u8bf7\u8bbe\u7f6e\u65e5\u5386\u540e\u518d\u91cd\u65b0\u5f15\u5165\u3002", (String)"ProjectPlanEditPlugin_35", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                }
                for (DynamicObject task : saveTaskList) {
                    PmpmTaskUtil.updateParentTaskTime((DynamicObject[])saveTaskList.toArray(new DynamicObject[saveTaskList.size()]), (DynamicObject)task);
                }
                if (saveTaskList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])saveTaskList.toArray(new DynamicObject[saveTaskList.size()]));
                }
                int rowCount = this.getModel().getEntryRowCount("taskentity");
                for (int i = 0; i < rowCount; ++i) {
                    String taskId = (String)this.getModel().getValue("taskid", i);
                    DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
                    PlanEntryUtil.setRowTaskObjForImp((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)task, (int)i);
                }
                this.getView().invokeOperation("save");
                PlanTaskImpAndExpUtil.setEnableByLogical((IFormView)this.getView());
                PlanEntryUtil.updateTaskEntryComTimeDeviationColor((IFormView)this.getView(), (IDataModel)this.getModel());
                break;
            }
            case "pmpm_taskimpdialog": {
                List taskList = (List)closedCallBackEvent.getReturnData();
                if (taskList == null || taskList.size() <= 0) {
                    return;
                }
                this.deleteAllTask();
                this.getModel().deleteEntryData("taskentity");
                DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
                DynamicObjectType entryDt = new DynamicObject(ProjectPlanConstant.dt).getDynamicObjectCollection("taskentity").getDynamicObjectType();
                for (DynamicObject task : taskList) {
                    entries.add((Object)PlanEntryUtil.cloneTaskToEntry((DynamicObject)task, (DynamicObjectType)entryDt));
                }
                this.getModel().updateEntryCache(entries);
                this.getView().updateView("taskentity");
                this.getModel().updateCache();
                this.getPageCache().put("isAddTask", "true");
                this.getView().invokeOperation("save");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        ArrayList<String> keyList = new ArrayList<String>(10);
        keyList.add("spectype");
        keyList.add("directorg");
        keyList.add("directperson");
        keyList.add("indirectorg");
        keyList.add("indirectperson");
        keyList.add("pretask");
        String propName = arg.getProperty().getName();
        if (keyList.contains(propName)) {
            PlanEntryUtil.beforeEntryF7Select((IFormView)this.getView(), (IDataModel)this.getModel(), (BeforeF7SelectEvent)arg);
            return;
        }
        switch (propName) {
            case "project": {
                this.setProjectFilter(arg);
                break;
            }
            case "pretask": {
                break;
            }
        }
    }

    private void setAllParentRowLocked() {
        Object preChangePlan = this.getModel().getValue("prechangeplan");
        if (preChangePlan != null) {
            this.setAdjustLocked();
        }
    }

    private void setAdjustLocked() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task", (String)"completionstatus,prechangetask");
            if (!CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(task.get("completionstatus")) && !CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(task.get("completionstatus"))) continue;
            this.getView().setEnable(Boolean.FALSE, i, this.rowNames);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!"true".equals(this.getPageCache().get("shouldClose"))) {
            int rowCount = this.getModel().getEntryRowCount("taskentity");
            for (int i = 0; i < rowCount; ++i) {
                if (!"".equals(this.getModel().getValue("taskname", i))) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4efb\u52a1\u6e05\u5355\u5206\u5f55\u5b58\u5728\u4efb\u52a1\u540d\u79f0\u4e3a\u7a7a\u7684\u884c\uff0c\u662f\u5426\u5220\u9664", (String)"ProjectPlanEditPlugin_36", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("close"));
                e.setCancel(true);
                break;
            }
        }
        this.getPageCache().remove("shouldClose");
        String status = this.getModel().getDataEntity().getString("billstatus");
        if ("B".equals(status) || "C".equals(status)) {
            e.setCheckDataChange(false);
        }
    }

    private void isNoExistMajorType(String projectId) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project", (String)"group");
        DynamicObject projectKind = project.getDynamicObject("group");
        BasedataEdit specType = (BasedataEdit)this.getControl("spectype");
        if (projectKind == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"spectype"});
        } else {
            String kindId = projectKind.getString("id");
            QFilter groupFilter = new QFilter("group", "=", (Object)kindId);
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            DynamicObject[] majorTypes = BusinessDataServiceHelper.load((String)"pmpm_majortype", (String)"id", (QFilter[])new QFilter[]{groupFilter, enableFilter});
            if (majorTypes.length == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"spectype"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"spectype"});
            }
        }
    }

    private DynamicObject[] getProCal(Object projectId) {
        QFilter projectFilter = new QFilter("project", "=", projectId);
        DynamicObject[] projectCalendarArr = BusinessDataServiceHelper.load((String)"pmpm_projworkcalendarset", (String)"id,project,modifytime,version", (QFilter[])new QFilter[]{projectFilter}, (String)"modifytime desc");
        if (projectCalendarArr.length == 0) {
            QFilter defaultVersionFilter = new QFilter("version", "=", (Object)"default");
            DynamicObject[] defCalendarArr = BusinessDataServiceHelper.load((String)"pmpm_projworkcalendarset", (String)"id,project,modifytime,version", (QFilter[])new QFilter[]{defaultVersionFilter}, (String)"modifytime desc");
            return defCalendarArr;
        }
        return projectCalendarArr;
    }

    private boolean isBeforePlanAudit(Object projectId, Object prePlanId) {
        boolean flag = false;
        DynamicObject[] proCalArr = this.getProCal(projectId);
        if (proCalArr != null && proCalArr.length > 0) {
            DynamicObject lastProCal = proCalArr[0];
            Date modifyTime = lastProCal.getDate("modifytime");
            DynamicObject prePlanObj = BusinessDataServiceHelper.loadSingle((Object)prePlanId, (String)"pmpm_projectplan");
            Date auditTime = prePlanObj.getDate("auditdate");
            if (modifyTime != null && auditTime != null && modifyTime.after(auditTime)) {
                flag = true;
            }
        }
        return flag;
    }

    private void loadPreTask() {
        int rowCount = this.getModel().getEntryRowCount("taskentity");
        for (int i = 0; i < rowCount; ++i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmpm_task");
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (preTask != null) continue;
            this.getModel().setValue("pretask", null, i);
            this.getModel().setValue("logical", null, i);
        }
    }
}

