/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpm.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmpm.formplugin.base.AbstractPmpmListPlugin;

public class ProjectPlanListPlugin
extends AbstractPmpmListPlugin {
    private static final String parentId = "parentBillId";
    private static final String invokeOper = "invokeOper";

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("project.number desc,majortype.plantype asc,version asc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                String project;
                QFilter versionFilter = new QFilter("version", "=", (Object)"default");
                DynamicObject[] calendarArr = BusinessDataServiceHelper.load((String)"pmpm_projworkcalendarset", (String)"version", (QFilter[])new QFilter[]{versionFilter});
                if (calendarArr.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386", (String)"ProjectPlanListPlugin_0", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if ((project = this.getPageCache().get("ProjectPermListPlugin_projectId")) == null || "".equals(project)) break;
                QFilter projectFilter = new QFilter("project", "=", (Object)project);
                DynamicObject[] fundBill = BusinessDataServiceHelper.load((String)"pmpm_projectplan", (String)"", (QFilter[])new QFilter[]{projectFilter});
                if (fundBill.length == 0) {
                    return;
                }
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u4e0b\u5df2\u7ecf\u5b58\u5728\u4e3b\u9879\u8ba1\u5212\uff0c\u8bf7\u5728\u5217\u8868\u4e2d\u67e5\u770b\u3002", (String)"ProjectPlanListPlugin_1", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
            }
            case "doadjust": {
                String selKey;
                DynamicObject planObj;
                DynamicObject majorType;
                ListSelectedRow row = ((IListView)this.getView()).getCurrentSelectedRowInfo();
                String planTypeStr = PlanTypeEnum.MAJORPLAN.getValue();
                if (row != null && (majorType = (planObj = BusinessDataServiceHelper.loadSingle((Object)(selKey = String.valueOf(row.getPrimaryKeyValue())), (String)"pmpm_projectplan", (String)"majortype")).getDynamicObject("majortype")) != null) {
                    planTypeStr = majorType.getString("plantype");
                }
                String permNum = null;
                String type = "";
                if (PlanTypeEnum.MAINPLAN.getValue().equals(planTypeStr)) {
                    permNum = "QXX0307";
                    type = ResManager.loadKDString((String)"\u4e3b\u9879\u8ba1\u5212", (String)"ProjectPlanListPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
                } else if (PlanTypeEnum.MAJORPLAN.getValue().equals(planTypeStr)) {
                    permNum = "QXX0308";
                    type = ResManager.loadKDString((String)"\u4e13\u9879\u8ba1\u5212", (String)"ProjectPlanListPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]);
                }
                QFilter[] filter = new QFilter[]{new QFilter("number", "=", (Object)permNum)};
                DynamicObject permObj = BusinessDataServiceHelper.loadSingle((String)"perm_permitem", (String)"id,number,name", (QFilter[])filter);
                boolean hasPermission = false;
                if (permObj != null) {
                    long orgId = RequestContext.get().getOrgId();
                    String appId = this.getView().getFormShowParameter().getAppId();
                    long userId = Long.parseLong(RequestContext.get().getUserId());
                    int result = 0;
                    if (type.equals(ResManager.loadKDString((String)"\u4e3b\u9879\u8ba1\u5212", (String)"ProjectPlanListPlugin_2", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]))) {
                        result = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)appId, (String)"pmpm_projectplan", (String)permObj.getString("id"));
                    } else if (type.equals(ResManager.loadKDString((String)"\u4e13\u9879\u8ba1\u5212", (String)"ProjectPlanListPlugin_3", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]))) {
                        result = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)appId, (String)"pmpm_majorplan", (String)permObj.getString("id"));
                    }
                    if (result == 1) {
                        hasPermission = true;
                    }
                }
                if (!hasPermission) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709%s\u7684[\u8c03\u6574]\u7684\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u6388\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684[\u8c03\u6574\u8ba1\u5212]\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectPlanListPlugin_4", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]), type);
                    this.getView().showErrorNotification(msg);
                    args.setCancel(true);
                    return;
                }
                if (((ListView)this.getView()).getSelectedRows().size() > 1) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u53d6\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8c03\u6574", (String)"ProjectPlanListPlugin_5", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Object id = ((ListView)this.getView()).getSelectedRows().get(0).getPrimaryKeyValue();
                if (null == id) break;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmpm_projectplan", (String)"billstatus");
                if (null != dynamicObject && !"C".equals(dynamicObject.getString("billstatus"))) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u53d1\u5e03\u7684\u8ba1\u5212\u8fdb\u884c\u8c03\u6574", (String)"ProjectPlanListPlugin_6", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                QFilter[] filters = new QFilter[]{new QFilter("prechangeplan", "=", (Object)String.valueOf(id))};
                DynamicObject[] parentVsersion = BusinessDataServiceHelper.load((String)"pmpm_projectplan", (String)"name", (QFilter[])filters);
                if (null == parentVsersion || parentVsersion.length <= 0) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6700\u65b0\u7684\u8ba1\u5212\u7248\u672c\u8fdb\u884c\u8c03\u6574", (String)"ProjectPlanListPlugin_7", (String)"pmgt-pmpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "newmajorplan": {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("formId", "pmpm_majorplan");
                FormShowParameter param = FormShowParameter.createFormShowParameter(map);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setStatus(OperationStatus.EDIT);
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_majorplan"));
                this.getView().showForm(param);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "doadjust": {
                this.getView().invokeOperation("copy");
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        DynamicObject planObj;
        DynamicObject majorType;
        Boolean isCopy = (Boolean)e.getParameter().getCustomParam("iscopy");
        ListSelectedRow row = ((IListView)this.getView()).getCurrentSelectedRowInfo();
        String planTypeStr = PlanTypeEnum.MAJORPLAN.getValue();
        String selKey = null;
        if (row != null && (majorType = (planObj = BusinessDataServiceHelper.loadSingle((Object)(selKey = String.valueOf(row.getPrimaryKeyValue())), (String)"pmpm_projectplan", (String)"majortype")).getDynamicObject("majortype")) != null) {
            planTypeStr = majorType.getString("plantype");
        }
        if (isCopy != null && isCopy.booleanValue() && PlanTypeEnum.MAINPLAN.getValue().equals(planTypeStr)) {
            e.getParameter().setCustomParam(invokeOper, (Object)"copy");
            e.getParameter().setCustomParam(parentId, (Object)selKey);
        } else if (e.getParameter().getPkId() != null && PlanTypeEnum.MAJORPLAN.getValue().equals(planTypeStr)) {
            String billId = e.getParameter().getPkId().toString();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "pmpm_majorplan");
            FormShowParameter param = FormShowParameter.createFormShowParameter(map);
            if (billId != null) {
                ((BillShowParameter)param).setPkId((Object)billId);
            }
            param.setStatus(OperationStatus.EDIT);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (isCopy != null && isCopy.booleanValue()) {
                param.setCustomParam(invokeOper, (Object)"copy");
                param.setCustomParam(parentId, (Object)selKey);
                param.setCustomParam("hasCopied", (Object)"false");
            }
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pmpm_majorplan"));
            this.getView().showForm(param);
            e.setCancel(true);
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            if ("creator.name".equals(filterColumn.getFieldName())) {
                CommonFilterColumn creatorFilterColumn = (CommonFilterColumn)filterColumn;
                DynamicObject[] planList = BusinessDataServiceHelper.load((String)"pmpm_projectplan", (String)"creator", (QFilter[])new QFilter[0]);
                HashMap<String, DynamicObject> creatorIdMap = new HashMap<String, DynamicObject>();
                for (DynamicObject[] plan : planList) {
                    DynamicObject creator = plan.getDynamicObject("creator");
                    String creatorId = creator.getString("id");
                    if (creatorIdMap.containsKey(creatorId)) continue;
                    creatorIdMap.put(creatorId, creator);
                }
                for (Map.Entry entry : creatorIdMap.entrySet()) {
                    ComboItem item = new ComboItem();
                    item.setId((String)entry.getKey());
                    item.setCaption(new LocaleString(((DynamicObject)entry.getValue()).getString("name")));
                    item.setValue((String)entry.getKey());
                    creatorFilterColumn.getComboItems().add(item);
                }
                continue;
            }
            if ("majortype.plantypename".equals(filterColumn.getFieldName())) {
                DynamicObject[] majorTypeArr;
                DynamicObject[] plan;
                CommonFilterColumn majorTypeFilterColumn = (CommonFilterColumn)filterColumn;
                majorTypeFilterColumn.getComboItems().clear();
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                String[] planTypeArr = new String[]{PlanTypeEnum.MAINPLAN.getValue(), PlanTypeEnum.MAJORPLAN.getValue()};
                QFilter plantypeFilter = new QFilter("plantype", "in", (Object)planTypeArr);
                QFilter filter = enableFilter.and(plantypeFilter);
                plan = majorTypeArr = BusinessDataServiceHelper.load((String)"pmpm_majortype", (String)"id,name,plantypename", (QFilter[])new QFilter[]{filter}, (String)"plantype");
                int creator = plan.length;
                for (int creatorId = 0; creatorId < creator; ++creatorId) {
                    DynamicObject majorType = plan[creatorId];
                    ComboItem item = new ComboItem();
                    item.setId(majorType.getString("id"));
                    item.setCaption(new LocaleString(majorType.getString("plantypename")));
                    item.setValue(majorType.getString("id"));
                    majorTypeFilterColumn.getComboItems().add(item);
                }
                continue;
            }
            if (!"project.name".equals(filterColumn.getFieldName())) continue;
            CommonFilterColumn proejctFilterColumn = (CommonFilterColumn)filterColumn;
            proejctFilterColumn.getComboItems().clear();
            ArrayList<Long> orgIds = new ArrayList<Long>();
            orgIds.add(RequestContext.get().getOrgId());
            DynamicObject[] projects = ProjectPermissionHelper.getPermProjectByStatus(orgIds, (boolean)true, (String)"pmpm_projectplan", (String)"view");
            for (DynamicObject project : projects) {
                String proId = project.getPkValue().toString();
                String proName = project.getString("name");
                ComboItem item = new ComboItem();
                item.setId(proId);
                item.setCaption(new LocaleString(proName));
                item.setValue(proId);
                proejctFilterColumn.getComboItems().add(item);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        Object projectId = args.getFilterValue("project.id");
        if (projectId == null) {
            return;
        }
        CommonFilterColumn planTypeCommonFilterColumn = (CommonFilterColumn)filterGridView.getItems().get(4);
        List<ComboItem> planTypeComboItems = this.buildPlanTypeComboItems(projectId);
        planTypeCommonFilterColumn.setComboItems(planTypeComboItems);
    }

    private List<ComboItem> buildPlanTypeComboItems(Object projectId) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (projectId != null) {
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project");
            DynamicObject kind = project.getDynamicObject("group");
            QFilter filter = new QFilter("group", "=", kind.getPkValue());
            QFilter planTypeFilter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
            filter.or(planTypeFilter);
            filters.add(filter);
        } else {
            QFilter filter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue()).or("plantype", "=", (Object)PlanTypeEnum.MAJORPLAN.getValue());
            filters.add(filter);
        }
        QFilter typeEnableFilter = new QFilter("enable", "=", (Object)DefaultEnum.YES.getValue());
        filters.add(typeEnableFilter);
        DynamicObject[] majors = BusinessDataServiceHelper.load((String)"pmpm_majortype", (String)"plantype,plantypename", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (majors.length > 0) {
            for (DynamicObject planType : majors) {
                ComboItem item = new ComboItem();
                item.setId(planType.getPkValue().toString());
                OrmLocaleValue type = (OrmLocaleValue)planType.get("plantypename");
                item.setCaption(new LocaleString(type.getLocaleValue()));
                item.setValue(planType.getPkValue().toString());
                if (PlanTypeEnum.getEnumByValue((Object)planType.get("plantype")).equals((Object)PlanTypeEnum.MAINPLAN)) {
                    combos.add(0, item);
                    continue;
                }
                combos.add(item);
            }
        }
        return combos;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("pmpm_majorplan".equals(e.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

