/*
 * Decompiled with CFR 0.152.
 */
package pmgt.pmpt.business.gantt;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.enums.LogicalEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import org.apache.commons.lang.StringEscapeUtils;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttDept;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttLink;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttOwner;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttTask;
import pmgt.pmpt.business.gantt.entity.DhtmlxTaskData;
import pmgt.pmpt.business.gantt.entity.GanttCalendar;
import pmgt.pmpt.business.gantt.entity.GanttDate;

public class GanttUtilsTools {
    public static String[] week = new String[]{"issunrest", "ismonrest", "istuerest", "iswedrest", "isthurest", "isfrirest", "issatrest"};

    public static GanttCalendar converToCalendars(DynamicObject project, DynamicObject org) {
        if (project == null || org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7518\u7279\u56fe\u5f02\u5e38\uff1a\u9879\u76ee\u6216\u7ec4\u7ec7\u4e3a\u7a7a", (String)"GanttUtilsTools_2", (String)"pmgt-pmpt-business", (Object[])new Object[0]));
        }
        List<DynamicObject> calLists = GanttUtilsTools.getCalendarList(Long.valueOf(project.getPkValue().toString()), org.getPkValue(), "pmpt");
        GanttCalendar calendar = new GanttCalendar();
        if (calLists.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u5386\u4e3a\u7a7a\u3002", (String)"GanttUtilsTools_1", (String)"pmgt-pmpt-business", (Object[])new Object[0]));
        }
        DynamicObject defaultCalendar = calLists.get(0);
        DynamicObject individualCalendar = null;
        if (calLists.size() == 2) {
            if (defaultCalendar.getBoolean("isindividuation")) {
                individualCalendar = calLists.get(0);
                defaultCalendar = calLists.get(1);
            } else {
                individualCalendar = calLists.get(1);
            }
        }
        ArrayList<Integer> workingDays = new ArrayList<Integer>();
        for (int i = 0; i < week.length; ++i) {
            if (defaultCalendar.getBoolean(week[i])) continue;
            workingDays.add(i);
        }
        calendar.setWorkingDays(workingDays);
        if (individualCalendar != null) {
            DynamicObjectCollection calendarEntry = individualCalendar.getDynamicObjectCollection("dateentry");
            ArrayList<GanttDate> excludeDates = new ArrayList<GanttDate>(calendarEntry.size());
            for (DynamicObject entry : calendarEntry) {
                GanttDate date = new GanttDate();
                String datetype = entry.getString("datetype");
                if ("1".equalsIgnoreCase(datetype)) {
                    date.setType("1");
                } else {
                    date.setType("0");
                }
                date.setRealDate(entry.getDate("workdate"));
                excludeDates.add(date);
            }
            calendar.setExcludeDates(excludeDates);
        }
        return calendar;
    }

    public static List<DynamicObject> getCalendarList(Object projectId, Object orgId, String appId) {
        List calList = TaskUtil.getCalendarListByProject((Object)projectId, (String)appId);
        if (calList.size() == 0) {
            calList = TaskUtil.getCalListByOrg((Object)orgId, (String)appId);
        }
        Object[] pkValues = calList.stream().map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] calArray = BusinessDataServiceHelper.load((Object[])pkValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)(appId + "_projworkcalendarset")));
        return Arrays.asList(calArray);
    }

    public static List<DynamicObject> getProjectCalendarList(Object projectId, String appId) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"));
        DynamicObject org = project.getDynamicObject("createorg");
        return GanttUtilsTools.getCalendarList(projectId, org.getPkValue(), appId);
    }

    public static Set<DhtmlxGanttOwner> converToPerson(DynamicObjectCollection tasks) {
        HashSet<DhtmlxGanttOwner> Persons = new HashSet<DhtmlxGanttOwner>();
        for (DynamicObject task : tasks) {
            DynamicObject resPerson = task.getDynamicObject("responsibleperson");
            if (resPerson != null) {
                DhtmlxGanttOwner dhtmlxGanttOwner = new DhtmlxGanttOwner();
                dhtmlxGanttOwner.setId(resPerson.getPkValue().toString());
                dhtmlxGanttOwner.setText(resPerson.get("name").toString());
                dhtmlxGanttOwner.setParent(task.getDynamicObject("responsibledept").getPkValue().toString());
                Persons.add(dhtmlxGanttOwner);
            }
            DynamicObjectCollection cooppersons = task.getDynamicObjectCollection("multicooperationperson");
            for (DynamicObject coopperson : cooppersons) {
                DhtmlxGanttOwner dhtmlxGanttOwner = new DhtmlxGanttOwner();
                dhtmlxGanttOwner.setId(coopperson.get("fbasedataid_id").toString());
                dhtmlxGanttOwner.setText(coopperson.getDynamicObject("fbasedataid").get("name").toString());
                dhtmlxGanttOwner.setParent(task.getDynamicObject("responsibledept").getPkValue().toString());
                Persons.add(dhtmlxGanttOwner);
            }
        }
        return Persons;
    }

    public static Set<DhtmlxGanttDept> converToDepartment(DynamicObjectCollection tasks) {
        HashSet<DhtmlxGanttDept> Departments = new HashSet<DhtmlxGanttDept>();
        for (DynamicObject task : tasks) {
            DynamicObject resdept = task.getDynamicObject("responsibledept");
            if (resdept == null) continue;
            DhtmlxGanttDept dhtmlxGanttDept = new DhtmlxGanttDept();
            dhtmlxGanttDept.setId(resdept.getPkValue().toString());
            dhtmlxGanttDept.setText(resdept.get("name").toString());
            dhtmlxGanttDept.setParent(null);
            Departments.add(dhtmlxGanttDept);
        }
        return Departments;
    }

    public static DhtmlxTaskData converToTaskAndLink(DynamicObject project, DynamicObject org, DynamicObjectCollection tasks) {
        ArrayList<DhtmlxGanttTask> dhtmlxGanttTasks = new ArrayList<DhtmlxGanttTask>();
        ArrayList<DhtmlxGanttLink> dhtmlxGanttLinks = new ArrayList<DhtmlxGanttLink>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "#D0DBFF");
        map.put("2", "#00BBFF");
        map.put("3", "#F57582");
        map.put("4", "#83F348");
        map.put("5", "#2EECE9");
        map.put("6", "#FFDB4A");
        int linkIndex = 0;
        SimpleDateFormat beginSdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat endSdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        DhtmlxGanttTask projectTask = new DhtmlxGanttTask();
        projectTask.setId(project.getPkValue().toString());
        String proName = project.getString("name");
        proName = StringEscapeUtils.escapeHtml((String)proName);
        projectTask.setText(proName);
        projectTask.setOpen(true);
        projectTask.setType("project");
        dhtmlxGanttTasks.add(projectTask);
        String projectId = project.getPkValue().toString();
        HashSet<Object> projectStatusIdSet = new HashSet<Object>(tasks.size());
        for (DynamicObject task : tasks) {
            DynamicObject projectStatus = task.getDynamicObject("projectstatus");
            if (projectStatus == null) continue;
            projectStatusIdSet.add(projectStatus.getPkValue());
        }
        DynamicObject[] projectStatusArray = BusinessDataServiceHelper.load((Object[])projectStatusIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_prostatus"));
        Map<Object, DynamicObject> projectStatusMap = Arrays.stream(projectStatusArray).collect(Collectors.toMap(o -> o.getPkValue(), o -> o));
        for (DynamicObject task : tasks) {
            DhtmlxGanttTask dhtmlxGanttTask = new DhtmlxGanttTask();
            dhtmlxGanttTask.setId(task.getPkValue().toString());
            String taskName = task.getString("name");
            taskName = StringEscapeUtils.escapeHtml((String)taskName);
            dhtmlxGanttTask.setText(taskName);
            BigDecimal percent = task.getBigDecimal("percent");
            Date planStartTime = task.getDate("planstarttime");
            Date actualStartTime = task.getDate("planstarttime");
            Date actualEndTime = task.getDate("realendtime");
            if (percent.compareTo(new BigDecimal("100")) == 0) {
                BigDecimal duration;
                String stageNumber;
                DynamicObject projectStatus = task.getDynamicObject("projectstatus");
                if (projectStatus != null && StringUtils.equals((CharSequence)(stageNumber = (projectStatus = projectStatusMap.get(projectStatus.getPkValue())).getString("projectstage.number")), (CharSequence)ProjectStageEnum.PROPOSALSTAGE_S.getValue())) {
                    actualStartTime = planStartTime;
                    planStartTime = actualEndTime;
                }
                Date planEndTime = actualEndTime;
                actualEndTime = task.getDate("planendtime");
                if (planStartTime != null) {
                    dhtmlxGanttTask.setStart_date(beginSdf.format(planStartTime));
                }
                if (actualStartTime != null) {
                    dhtmlxGanttTask.setRealstarttime(beginSdf.format(actualStartTime));
                }
                if (actualEndTime != null) {
                    dhtmlxGanttTask.setRealendtime(endSdf.format(actualEndTime));
                }
                if ((duration = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Object)org.getPkValue(), (Date)DateUtil.parseDate((String)beginSdf.format(planStartTime)), (Date)DateUtil.parseDate((String)endSdf.format(planEndTime)), (String)"pmpt")).intValue() == 0) {
                    dhtmlxGanttTask.setDuration(1);
                } else {
                    dhtmlxGanttTask.setDuration(duration.intValue());
                }
                BigDecimal actualDuration = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Object)org.getPkValue(), (Date)DateUtil.parseDate((String)beginSdf.format(actualStartTime)), (Date)DateUtil.parseDate((String)endSdf.format(actualEndTime)), (String)"pmpt");
                dhtmlxGanttTask.setActualduration(actualDuration.intValue());
            } else {
                if (planStartTime != null) {
                    dhtmlxGanttTask.setStart_date(beginSdf.format(planStartTime));
                    dhtmlxGanttTask.setRealstarttime(beginSdf.format(planStartTime));
                }
                if (actualEndTime != null) {
                    dhtmlxGanttTask.setRealendtime(endSdf.format(actualEndTime));
                }
                dhtmlxGanttTask.setDuration(task.getInt("absoluteduration"));
            }
            Double progress = percent.divide(new BigDecimal(100)).doubleValue();
            dhtmlxGanttTask.setProgress(progress);
            if (progress.intValue() == 1) {
                dhtmlxGanttTask.setDeleteable(false);
                dhtmlxGanttTask.setEditable(false);
            }
            if (task.getString("pid") == null || "0".equals(task.getString("pid"))) {
                dhtmlxGanttTask.setParent(projectId);
            } else {
                dhtmlxGanttTask.setParent(task.getString("pid"));
            }
            String completionStatus = task.getString("completionstatus");
            dhtmlxGanttTask.setCompletionStatus(completionStatus);
            if (completionStatus != null) {
                dhtmlxGanttTask.setColor((String)map.get(completionStatus));
            }
            dhtmlxGanttTask.setType("task");
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (preTask != null) {
                DhtmlxGanttLink preLink = new DhtmlxGanttLink();
                preLink.setId(linkIndex + "");
                preLink.setSource(preTask.getPkValue().toString());
                preLink.setTarget(task.getPkValue().toString());
                String logical = task.getString("logical");
                if (StringUtils.equals((CharSequence)logical, (CharSequence)LogicalEnum.FINISH_FINISH.getValue())) {
                    preLink.setType("2");
                } else if (StringUtils.equals((CharSequence)logical, (CharSequence)LogicalEnum.FINISH_START.getValue())) {
                    preLink.setType("0");
                } else if (StringUtils.equals((CharSequence)logical, (CharSequence)LogicalEnum.START_FINISH.getValue())) {
                    preLink.setType("3");
                } else if (StringUtils.equals((CharSequence)logical, (CharSequence)LogicalEnum.START_START.getValue())) {
                    preLink.setType("1");
                } else {
                    preLink.setType("1");
                }
                dhtmlxGanttLinks.add(preLink);
                ++linkIndex;
            }
            HashSet<String> persons = new HashSet<String>();
            ArrayList<String> personsName = new ArrayList<String>();
            if (task.getDynamicObject("responsibleperson") != null) {
                DynamicObject person = task.getDynamicObject("responsibleperson");
                persons.add(person.getPkValue().toString());
                personsName.add(person.getString("name"));
            }
            if (task.getDynamicObjectCollection("multicooperationperson").size() > 0) {
                DynamicObjectCollection cooperationpersons = task.getDynamicObjectCollection("multicooperationperson");
                for (DynamicObject cooperationperson : cooperationpersons) {
                    persons.add(cooperationperson.get("fbasedataid_id").toString());
                    personsName.add(cooperationperson.getDynamicObject("fbasedataid").get("name").toString());
                }
            }
            dhtmlxGanttTask.setOwner_id(persons);
            dhtmlxGanttTask.setOwner_name(personsName);
            dhtmlxGanttTask.setCompletionStatus(task.getString("completionstatus"));
            dhtmlxGanttTasks.add(dhtmlxGanttTask);
        }
        DhtmlxTaskData taskData = new DhtmlxTaskData();
        taskData.setLinks(dhtmlxGanttLinks);
        taskData.setTasks(dhtmlxGanttTasks);
        return taskData;
    }
}

