/*
 * Decompiled with CFR 0.152.
 */
package pmgt.pmpt.business.gantt;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import pmgt.pmpt.business.gantt.DhtmlxGanttBuilder;
import pmgt.pmpt.business.gantt.GanttUtilsTools;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttDept;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttInfo;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttOwner;
import pmgt.pmpt.business.gantt.entity.DhtmlxTaskData;
import pmgt.pmpt.business.gantt.entity.GanttCalendar;

public class PlanGanttBuilder
extends DhtmlxGanttBuilder {
    DynamicObject project;
    DhtmlxGanttInfo dhtmlxGanttInfo;
    DynamicObject org;

    public PlanGanttBuilder(DynamicObject project, DynamicObject org, String operation) {
        this.project = project;
        this.org = org;
        this.dhtmlxGanttInfo = new DhtmlxGanttInfo(operation);
    }

    @Override
    public void buildProject() {
    }

    @Override
    public void buildTaskAndLink(DynamicObjectCollection entries) {
        DhtmlxTaskData taskData = GanttUtilsTools.converToTaskAndLink(this.project, this.org, entries);
        this.dhtmlxGanttInfo.setTaskData(taskData);
    }

    @Override
    public void buildCalendars() {
        GanttCalendar calendar = GanttUtilsTools.converToCalendars(this.project, this.org);
        this.dhtmlxGanttInfo.getOtherProperties().setCalendar(calendar);
    }

    @Override
    public void buildDepartments() {
        QFilter qFilter = new QFilter("project", "=", (Object)Long.valueOf(this.project.getPkValue().toString()));
        qFilter.and("relationtask", "=", (Object)0L);
        qFilter.and("islatest", "=", (Object)"1");
        Map tasks = BusinessDataServiceHelper.loadFromCache((String)"pmpt_task", (String)"responsibledept", (QFilter[])qFilter.toArray());
        HashSet<DhtmlxGanttDept> departments = new HashSet<DhtmlxGanttDept>();
        for (DynamicObject task : tasks.values()) {
            DynamicObject resdept = task.getDynamicObject("responsibledept");
            if (resdept == null) continue;
            DhtmlxGanttDept dhtmlxGanttDept = new DhtmlxGanttDept();
            dhtmlxGanttDept.setId(resdept.getPkValue().toString());
            dhtmlxGanttDept.setText(resdept.get("name").toString());
            dhtmlxGanttDept.setParent(null);
            departments.add(dhtmlxGanttDept);
        }
        this.dhtmlxGanttInfo.getOtherProperties().setDepts(departments);
    }

    @Override
    public void buildPerson() {
        QFilter qFilter = new QFilter("project", "=", (Object)Long.valueOf(this.project.getPkValue().toString()));
        qFilter.and("relationtask", "=", (Object)0L);
        qFilter.and("islatest", "=", (Object)"1");
        Map tasks = BusinessDataServiceHelper.loadFromCache((String)"pmpt_task", (String)"responsibleperson,responsibledept,multicooperationperson", (QFilter[])qFilter.toArray());
        HashSet<DhtmlxGanttOwner> persons = new HashSet<DhtmlxGanttOwner>();
        for (DynamicObject task : tasks.values()) {
            DynamicObject resPerson = task.getDynamicObject("responsibleperson");
            if (resPerson != null) {
                DhtmlxGanttOwner dhtmlxGanttOwner = new DhtmlxGanttOwner();
                dhtmlxGanttOwner.setId(resPerson.getPkValue().toString());
                dhtmlxGanttOwner.setText(resPerson.get("name").toString());
                dhtmlxGanttOwner.setParent(task.getDynamicObject("responsibledept").getPkValue().toString());
                persons.add(dhtmlxGanttOwner);
            }
            DynamicObjectCollection cooppersons = task.getDynamicObjectCollection("multicooperationperson");
            for (DynamicObject coopperson : cooppersons) {
                DhtmlxGanttOwner dhtmlxGanttOwner = new DhtmlxGanttOwner();
                dhtmlxGanttOwner.setId(coopperson.get("fbasedataid_id").toString());
                dhtmlxGanttOwner.setText(coopperson.getDynamicObject("fbasedataid").get("name").toString());
                dhtmlxGanttOwner.setParent(task.getDynamicObject("responsibledept").getPkValue().toString());
                persons.add(dhtmlxGanttOwner);
            }
        }
        this.dhtmlxGanttInfo.getOtherProperties().setPersons(persons);
    }

    @Override
    public DhtmlxGanttInfo build() {
        return this.dhtmlxGanttInfo;
    }
}

