/*
 * Decompiled with CFR 0.152.
 */
package pmgt.pmpt.business.gantt;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pmgt.pmbs.common.enums.LogicalEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import org.apache.commons.lang.StringEscapeUtils;
import pmgt.pmpt.business.gantt.DhtmlxGanttBuilder;
import pmgt.pmpt.business.gantt.GanttUtilsTools;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttDept;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttInfo;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttLink;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttOwner;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttTask;
import pmgt.pmpt.business.gantt.entity.GanttCalendar;
import pmgt.pmpt.business.gantt.entity.GanttDate;
import pmgt.pmpt.business.gantt.entity.TaskColorEnum;

public class ProMonitorGanttBuilder
extends DhtmlxGanttBuilder {
    DynamicObject project;
    DhtmlxGanttInfo dhtmlxGanttInfo;
    String[] week = new String[]{"issunrest", "ismonrest", "istuerest", "iswedrest", "isthurest", "isfrirest", "issatrest"};

    public ProMonitorGanttBuilder(DynamicObject project, String operation) {
        this.project = project;
        this.dhtmlxGanttInfo = new DhtmlxGanttInfo(operation);
    }

    @Override
    public DhtmlxGanttInfo build() {
        this.dhtmlxGanttInfo.getOtherProperties().setSource("monitor");
        return this.dhtmlxGanttInfo;
    }

    @Override
    public void buildProject() {
        DhtmlxGanttTask projectTask = new DhtmlxGanttTask();
        projectTask.setId(this.project.getPkValue().toString());
        String proName = this.project.getString("name");
        proName = StringEscapeUtils.escapeHtml((String)proName);
        projectTask.setText(proName);
        projectTask.setOpen(true);
        projectTask.setType("project");
        for (DhtmlxGanttTask task : this.dhtmlxGanttInfo.getTaskData().getTasks()) {
            if (task.getParent() != null) continue;
            task.setParent(projectTask.getId());
        }
        this.dhtmlxGanttInfo.getTaskData().getTasks().add(0, projectTask);
    }

    @Override
    public void buildTaskAndLink(DynamicObjectCollection entries) {
        LinkedList<DhtmlxGanttTask> dhtmlxGanttTasks = new LinkedList<DhtmlxGanttTask>();
        ArrayList<DhtmlxGanttLink> dhtmlxGanttLinks = new ArrayList<DhtmlxGanttLink>(10);
        int linkIndex = 0;
        SimpleDateFormat beginSdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat endSdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        HashMap<String, String> source2newest = new HashMap<String, String>();
        HashSet<Object> projectStatusIdSet = new HashSet<Object>(entries.size());
        for (DynamicObject entry : entries) {
            DynamicObject projectStatus;
            DynamicObject task = entry.getDynamicObject("task");
            if (task.getDynamicObject("sourcetask") != null) {
                source2newest.put(task.getDynamicObject("sourcetask").getPkValue().toString(), task.getPkValue().toString());
            } else {
                source2newest.put(task.getPkValue().toString(), task.getPkValue().toString());
            }
            if ((projectStatus = task.getDynamicObject("projectstatus")) == null) continue;
            projectStatusIdSet.add(projectStatus.getPkValue());
        }
        DynamicObject[] projectStatusArray = BusinessDataServiceHelper.load((Object[])projectStatusIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_prostatus"));
        Map<Object, DynamicObject> projectStatusMap = Arrays.stream(projectStatusArray).collect(Collectors.toMap(o -> o.getPkValue(), o -> o));
        for (DynamicObject entry : entries) {
            String sourceTaskId;
            DynamicObject task = entry.getDynamicObject("task");
            DhtmlxGanttTask dhtmlxGanttTask = new DhtmlxGanttTask();
            dhtmlxGanttTask.setId(task.getPkValue().toString());
            String taskName = task.getString("name");
            taskName = StringEscapeUtils.escapeHtml((String)taskName);
            dhtmlxGanttTask.setText(taskName);
            BigDecimal percent = task.getBigDecimal("percent");
            Date planStartTime = task.getDate("planstarttime");
            Date actualStartTime = task.getDate("planstarttime");
            Date actualEndTime = task.getDate("realendtime");
            if (percent.compareTo(new BigDecimal("100")) == 0) {
                String stageNumber;
                DynamicObject projectStatus = task.getDynamicObject("projectstatus");
                if (projectStatus != null && StringUtils.equals((CharSequence)(stageNumber = (projectStatus = projectStatusMap.get(projectStatus.getPkValue())).getString("projectstage.number")), (CharSequence)ProjectStageEnum.PROPOSALSTAGE_S.getValue())) {
                    actualStartTime = planStartTime;
                    planStartTime = actualEndTime;
                }
                Date planEndTime = actualEndTime;
                actualEndTime = task.getDate("planendtime");
                if (planStartTime != null) {
                    dhtmlxGanttTask.setStart_date(beginSdf.format(planStartTime));
                }
                if (actualStartTime != null) {
                    dhtmlxGanttTask.setRealstarttime(beginSdf.format(actualStartTime));
                }
                if (actualEndTime != null) {
                    dhtmlxGanttTask.setRealendtime(endSdf.format(actualEndTime));
                }
                if (planStartTime != null && planEndTime != null) {
                    BigDecimal duration = TaskUtil.getDaysBetweenTwoDate((Object)this.project.getPkValue(), (Date)DateUtil.parseDate((String)beginSdf.format(planStartTime)), (Date)DateUtil.parseDate((String)endSdf.format(planEndTime)), (String)"pmpt");
                    if (duration.intValue() == 0) {
                        dhtmlxGanttTask.setDuration(1);
                    } else {
                        dhtmlxGanttTask.setDuration(duration.intValue());
                    }
                }
                if (actualStartTime != null && actualEndTime != null) {
                    BigDecimal actualDuration = TaskUtil.getDaysBetweenTwoDate((Object)this.project.getPkValue(), (Date)DateUtil.parseDate((String)beginSdf.format(actualStartTime)), (Date)DateUtil.parseDate((String)endSdf.format(actualEndTime)), (String)"pmpt");
                    dhtmlxGanttTask.setActualduration(actualDuration.intValue());
                }
            } else {
                if (planStartTime != null) {
                    dhtmlxGanttTask.setStart_date(beginSdf.format(planStartTime));
                    dhtmlxGanttTask.setRealstarttime(beginSdf.format(planStartTime));
                }
                if (actualEndTime != null) {
                    dhtmlxGanttTask.setRealendtime(endSdf.format(actualEndTime));
                }
                dhtmlxGanttTask.setDuration(task.getInt("absoluteduration"));
            }
            dhtmlxGanttTask.setProgress(percent.divide(new BigDecimal(100)).doubleValue());
            dhtmlxGanttTask.setParent(entry.get("pid") == null || entry.getLong("pid") == 0L ? null : entry.get("pid").toString());
            dhtmlxGanttTask.setCompletionStatus(task.getString("completionstatus"));
            dhtmlxGanttTask.setColor(TaskColorEnum.getValueByCompleteStatus(task.getString("completionstatus")).getValue());
            DynamicObject preTask = task.getDynamicObject("pretask");
            if (preTask != null && source2newest.containsKey(sourceTaskId = (preTask = BusinessDataServiceHelper.loadSingle((Object)preTask.getPkValue(), (String)"pmpt_task")).getDynamicObject("sourcetask") != null ? preTask.getDynamicObject("sourcetask").getPkValue().toString() : preTask.getPkValue().toString())) {
                String newestTask = (String)source2newest.get(sourceTaskId);
                DhtmlxGanttLink preLink = new DhtmlxGanttLink();
                preLink.setId(linkIndex + "");
                preLink.setSource(newestTask);
                preLink.setTarget(task.getPkValue().toString());
                String logical = task.getString("logical");
                if (StringUtils.equals((CharSequence)logical, (CharSequence)LogicalEnum.FINISH_FINISH.getValue())) {
                    preLink.setType("2");
                } else if (StringUtils.equals((CharSequence)logical, (CharSequence)LogicalEnum.FINISH_START.getValue())) {
                    preLink.setType("0");
                } else if (StringUtils.equals((CharSequence)logical, (CharSequence)LogicalEnum.START_FINISH.getValue())) {
                    preLink.setType("3");
                } else if (StringUtils.equals((CharSequence)logical, (CharSequence)LogicalEnum.START_START.getValue())) {
                    preLink.setType("1");
                } else {
                    preLink.setType("1");
                }
                dhtmlxGanttLinks.add(preLink);
                ++linkIndex;
            }
            HashSet<String> persons = new HashSet<String>();
            ArrayList<String> personsName = new ArrayList<String>(10);
            if (task.getDynamicObject("responsibleperson") != null) {
                persons.add(task.getDynamicObject("responsibleperson").getPkValue().toString());
                personsName.add(task.getDynamicObject("responsibleperson").getLocaleString("name").getLocaleValue_zh_CN());
            }
            if (task.getDynamicObjectCollection("multicooperationperson").size() > 0) {
                DynamicObjectCollection cooperationpersons = task.getDynamicObjectCollection("multicooperationperson");
                for (DynamicObject cooperationperson : cooperationpersons) {
                    persons.add(cooperationperson.get("fbasedataid_id").toString());
                    personsName.add(cooperationperson.getDynamicObject("fbasedataid").get("name").toString());
                }
            }
            dhtmlxGanttTask.setOwner_id(persons);
            dhtmlxGanttTask.setOwner_name(personsName);
            dhtmlxGanttTask.setCompletionStatus(task.getString("completionstatus"));
            dhtmlxGanttTask.setEditable(false);
            dhtmlxGanttTask.setOpen(true);
            dhtmlxGanttTask.setType("task");
            dhtmlxGanttTasks.add(dhtmlxGanttTask);
        }
        this.dhtmlxGanttInfo.getTaskData().setTasks(dhtmlxGanttTasks);
        this.dhtmlxGanttInfo.getTaskData().setLinks(dhtmlxGanttLinks);
    }

    @Override
    public void buildCalendars() {
        List<DynamicObject> calLists = GanttUtilsTools.getProjectCalendarList(Long.valueOf(this.project.getPkValue().toString()), "pmpt");
        GanttCalendar calendar = new GanttCalendar();
        if (calLists.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u5386\u4e3a\u7a7a\u3002", (String)"ProMonitorGanttBuilder_1", (String)"pmgt-pmpt-business", (Object[])new Object[0]));
        }
        DynamicObject defaultCalendar = calLists.get(0);
        DynamicObject individualCalendar = null;
        if (calLists.size() == 2) {
            if (defaultCalendar.getBoolean("isindividuation")) {
                individualCalendar = calLists.get(0);
                defaultCalendar = calLists.get(1);
            } else {
                individualCalendar = calLists.get(1);
            }
        }
        ArrayList<Integer> workingDays = new ArrayList<Integer>();
        for (int i = 0; i < this.week.length; ++i) {
            if (defaultCalendar.getBoolean(this.week[i])) continue;
            workingDays.add(i);
        }
        calendar.setWorkingDays(workingDays);
        if (individualCalendar != null) {
            DynamicObjectCollection calendarEntry = individualCalendar.getDynamicObjectCollection("dateentry");
            ArrayList<GanttDate> excludeDates = new ArrayList<GanttDate>(calendarEntry.size());
            for (DynamicObject entry : calendarEntry) {
                GanttDate date = new GanttDate();
                String datetype = entry.getString("datetype");
                if ("1".equalsIgnoreCase(datetype)) {
                    date.setType("1");
                } else {
                    date.setType("0");
                }
                date.setRealDate(entry.getDate("workdate"));
                excludeDates.add(date);
            }
            calendar.setExcludeDates(excludeDates);
        }
        this.dhtmlxGanttInfo.getOtherProperties().setCalendar(calendar);
    }

    @Override
    public void buildDepartments() {
        QFilter qFilter = new QFilter("project", "=", (Object)Long.valueOf(this.project.getPkValue().toString()));
        qFilter.and("relationtask", "=", (Object)0L);
        qFilter.and("islatest", "=", (Object)"1");
        Map tasks = BusinessDataServiceHelper.loadFromCache((String)"pmpt_task", (String)"responsibledept", (QFilter[])qFilter.toArray());
        HashSet<DhtmlxGanttDept> departments = new HashSet<DhtmlxGanttDept>();
        for (DynamicObject task : tasks.values()) {
            DynamicObject resdept = task.getDynamicObject("responsibledept");
            if (resdept == null) continue;
            DhtmlxGanttDept dhtmlxGanttDept = new DhtmlxGanttDept();
            dhtmlxGanttDept.setId(resdept.getPkValue().toString());
            dhtmlxGanttDept.setText(resdept.get("name").toString());
            dhtmlxGanttDept.setParent(null);
            departments.add(dhtmlxGanttDept);
        }
        this.dhtmlxGanttInfo.getOtherProperties().setDepts(departments);
    }

    @Override
    public void buildPerson() {
        QFilter qFilter = new QFilter("project", "=", (Object)Long.valueOf(this.project.getPkValue().toString()));
        qFilter.and("relationtask", "=", (Object)0L);
        qFilter.and("islatest", "=", (Object)"1");
        Map tasks = BusinessDataServiceHelper.loadFromCache((String)"pmpt_task", (String)"responsibleperson,responsibledept,multicooperationperson", (QFilter[])qFilter.toArray());
        HashSet<DhtmlxGanttOwner> persons = new HashSet<DhtmlxGanttOwner>();
        for (DynamicObject task : tasks.values()) {
            DynamicObject resPerson = task.getDynamicObject("responsibleperson");
            if (resPerson != null) {
                DhtmlxGanttOwner dhtmlxGanttOwner = new DhtmlxGanttOwner();
                dhtmlxGanttOwner.setId(resPerson.getPkValue().toString());
                dhtmlxGanttOwner.setText(resPerson.get("name").toString());
                dhtmlxGanttOwner.setParent(task.getDynamicObject("responsibledept").getPkValue().toString());
                persons.add(dhtmlxGanttOwner);
            }
            DynamicObjectCollection cooppersons = task.getDynamicObjectCollection("multicooperationperson");
            for (DynamicObject coopperson : cooppersons) {
                DhtmlxGanttOwner dhtmlxGanttOwner = new DhtmlxGanttOwner();
                dhtmlxGanttOwner.setId(coopperson.get("fbasedataid_id").toString());
                dhtmlxGanttOwner.setText(coopperson.getDynamicObject("fbasedataid").get("name").toString());
                dhtmlxGanttOwner.setParent(task.getDynamicObject("responsibledept").getPkValue().toString());
                persons.add(dhtmlxGanttOwner);
            }
        }
        this.dhtmlxGanttInfo.getOtherProperties().setPersons(persons);
    }
}

