/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.common.enums.RiskColorEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.AssignTaskListPlugin;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmpt.formplugin.utils.PmTaskBizHelper;

public class PmAssignTaskListPlugin
extends AssignTaskListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        this.completionstatusFilter((CommonFilterColumn)commonFilterColumns.get(3));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    BigDecimal overDays = PmTaskBizHelper.getOverDays(PmAssignTaskListPlugin.this.getAppId(), row);
                    row.set("realtimedeviation", (Object)overDays);
                }
                return rows;
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        List filterList = e.getQFilters();
        Optional<QFilter> colorFilter = filterList.stream().filter(qFilter -> StringUtils.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"riskcolor")).findFirst();
        colorFilter.ifPresent(filter -> {
            Object riskColor = filter.getValue();
            if (riskColor instanceof List) {
                Optional<Object> nonColor = ((List)riskColor).stream().filter(o -> Objects.equals(o, RiskColorEnum.NOCOLOR.getValue())).findAny();
                if (nonColor.isPresent()) {
                    filterList.remove(colorFilter.get());
                    List colors = Stream.of(RiskColorEnum.values()).filter(riskColorEnum -> !StringUtils.equalsIgnoreCase((CharSequence)RiskColorEnum.NOCOLOR.getValue(), (CharSequence)riskColorEnum.getValue())).map(colorEnum -> colorEnum.getValue()).collect(Collectors.toList());
                    QFilter cQfilter = new QFilter("riskcolor", "not in", colors);
                    List selectedColors = ((List)riskColor).stream().filter(o -> !Objects.equals(o, RiskColorEnum.NOCOLOR.getValue())).collect(Collectors.toList());
                    cQfilter.or(new QFilter("riskcolor", "in", selectedColors));
                    filterList.add(cQfilter);
                }
            } else if (Objects.equals(riskColor, RiskColorEnum.NOCOLOR.getValue())) {
                filterList.remove(colorFilter.get());
                List colors = Stream.of(RiskColorEnum.values()).filter(riskColorEnum -> !StringUtils.equalsIgnoreCase((CharSequence)RiskColorEnum.NOCOLOR.getValue(), (CharSequence)riskColorEnum.getValue())).map(colorEnum -> colorEnum.getValue()).collect(Collectors.toList());
                QFilter cQfilter = new QFilter("riskcolor", "not in", colors);
                filterList.add(cQfilter);
            }
        });
        String creatorFlag = "0";
        Iterator iterator = filterList.iterator();
        while (iterator.hasNext()) {
            QFilter next = (QFilter)iterator.next();
            if (!next.getProperty().equals("creatorfilter")) continue;
            creatorFlag = (String)next.getValue();
            iterator.remove();
        }
        QFilter creatorFilter = creatorFlag.equals("2") ? new QFilter("creator", "!=", (Object)Long.valueOf(RequestContext.get().getUserId())) : new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        String userId = RequestContext.get().getUserId();
        List chargeOrgs = UserServiceHelper.getUserDepartment((long)Long.parseLong(userId), (boolean)Boolean.TRUE);
        ArrayList chargeOrgIds = new ArrayList();
        for (Long orgId : chargeOrgs) {
            List allSubordinateOrgs = OrgServiceHelper.getAllSubordinateOrgs((long)orgId, (boolean)true);
            chargeOrgIds.addAll(allSubordinateOrgs);
        }
        QFilter chaOrgsFilter = new QFilter("mainorgofuser", "in", chargeOrgIds);
        List orgList = ProjectPermissionHelper.getAllPermOrgs((String)RequestContext.get().getUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)((ListView)this.getView()).getBillFormId(), (String)"view");
        DynamicObject[] projects = ProjectPermissionHelper.getPermProjectByStatus((List)orgList, (boolean)true, (String)((ListView)this.getView()).getBillFormId(), (String)"view", null);
        List projectPks = Arrays.stream(projects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter proFilter = new QFilter("project", "in", projectPks);
        if (creatorFlag.equals("0")) {
            creatorFilter.or(chaOrgsFilter).or(proFilter);
        } else if (creatorFlag.equals("2")) {
            creatorFilter.and(chaOrgsFilter.or(proFilter));
        }
        filterList.add(creatorFilter);
        filterList.add(new QFilter("relationtask", "=", (Object)0));
        QFilter taskSourceFilter = new QFilter("number", "=", (Object)TaskTypeEnum.ASSIGNTASK.getValue());
        DynamicObject taskSource = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasksource"), (String)"id", (QFilter[])new QFilter[]{taskSourceFilter});
        if (null != taskSource) {
            filterList.add(new QFilter("tasksource", "=", taskSource.getPkValue()));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        ListView view = (ListView)this.getView();
        Object focusRowPkId = view.getFocusRowPkId();
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"name")) {
            DynamicObject task;
            String selectProperties = String.join((CharSequence)",", "id", "status");
            if (Objects.nonNull(focusRowPkId) && null != (task = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"))) && StringUtils.equalsIgnoreCase((CharSequence)task.getString("status"), (CharSequence)StatusEnum.CHECKED.getValue())) {
                map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
                map.put("pkId", String.valueOf(focusRowPkId));
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.setAppId(this.getAppId());
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
                args.setCancel(true);
            }
        }
    }

    protected void completionstatusFilter(CommonFilterColumn filterColumn) {
        Object completionstatus = this.getView().getFormShowParameter().getCustomParam("completionstatus");
        if (completionstatus != null) {
            filterColumn.setDefaultValues(new Object[]{completionstatus});
        }
    }

    public String getAppId() {
        return "pmpt";
    }
}

