/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.PlanningCycleEnum;
import kd.pccs.placs.common.enums.RiskColorEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.poi.POIHelper;
import kd.pccs.placs.formplugin.FuncPlanMonitorListPlugin;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmpt.formplugin.utils.PmTaskBizHelper;

public class PmFuncPlanMonitorListPlugin
extends FuncPlanMonitorListPlugin {
    private static final String KEY_TREEENTRYENTITY = "taskentity";
    private Map<String, DynamicObject> mapAllTasks = null;
    private static String[] COLUMNKEY = new String[]{"taskname", "task", "completionstatus", "meetassigncount", "tasksource", "project", "controllevelname", "majortypename", "tasktype", "pretaskname", "planstarttime", "planendtime", "absoluteduration", "percent", "completedescription", "expecttime", "realendtime", "overduedays", "resultdoc", "responsiblepersonname", "responsibledeptname", "cooperationpersonsname", "multicooperationdept", "comment"};
    private String[] header = new String[]{ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PmFuncPlanMonitorListPlugin_0", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u7801", (String)"PmFuncPlanMonitorListPlugin_32", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"PmFuncPlanMonitorListPlugin_1", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f1a\u8bae\u51b3\u8bae", (String)"PmFuncPlanMonitorListPlugin_22", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u6765\u6e90", (String)"PmFuncPlanMonitorListPlugin_23", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9879\u76ee", (String)"PmFuncPlanMonitorListPlugin_2", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"PmFuncPlanMonitorListPlugin_3", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"PmFuncPlanMonitorListPlugin_4", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"PmFuncPlanMonitorListPlugin_5", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"PmFuncPlanMonitorListPlugin_8", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"PmFuncPlanMonitorListPlugin_9", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"PmFuncPlanMonitorListPlugin_10", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"PmFuncPlanMonitorListPlugin_6", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fdb\u5ea6\uff08%\uff09", (String)"PmFuncPlanMonitorListPlugin_7", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u60c5\u51b5\u8bf4\u660e", (String)"PmFuncPlanMonitorListPlugin_24", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4", (String)"PmFuncPlanMonitorListPlugin_25", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (String)"PmFuncPlanMonitorListPlugin_26", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u903e\u671f\u5929\u6570", (String)"PmFuncPlanMonitorListPlugin_27", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u679c", (String)"PmFuncPlanMonitorListPlugin_28", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba", (String)"PmFuncPlanMonitorListPlugin_11", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u90e8\u95e8", (String)"PmFuncPlanMonitorListPlugin_12", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba", (String)"PmFuncPlanMonitorListPlugin_13", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u90e8\u95e8", (String)"PmFuncPlanMonitorListPlugin_29", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"PmFuncPlanMonitorListPlugin_30", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0])};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit businessOrg = (BasedataEdit)this.getControl("businessorg");
        businessOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
        String propName = arg0.getProperty().getName();
        ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
        switch (propName) {
            case "businessorg": {
                long userId = RequestContext.get().getCurrUserId();
                List allPermOrgs = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"01", (String)String.valueOf(userId), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac");
                if (allPermOrgs.size() > 0) {
                    param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)allPermOrgs));
                    param.setF7ClickByFilter(true);
                    break;
                }
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)0L));
                param.setF7ClickByFilter(true);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("export".equals(operateKey)) {
            this.doExportExcel();
        } else if ("search".equals(operateKey)) {
            this.doSearch();
        } else if ("queryclick".equals(operateKey)) {
            String textField = (String)this.getModel().getValue("textfield");
            Label label = (Label)this.getView().getControl("labelap");
            if (StringUtils.equals((CharSequence)textField, (CharSequence)"false")) {
                label.setText(ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"PmFuncPlanMonitorListPlugin_15", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)"true");
            } else {
                label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"PmFuncPlanMonitorListPlugin_14", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)"false");
            }
        }
    }

    private void doExportExcel() {
        JSONArray data;
        DynamicObjectCollection rowDatas = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        if (!rowDatas.isEmpty()) {
            data = new JSONArray();
            String dateFormat = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            for (DynamicObject row : rowDatas) {
                JSONObject obj = new JSONObject();
                DynamicObject task = row.getDynamicObject("task");
                obj.put("taskname", (Object)task.getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("task", (Object)task.getString("number"));
                obj.put("completionstatus", (Object)CompletionStatusEnum.getEnumByValue((Object)task.get("completionstatus")).getName());
                obj.put("meetassigncount", task.get("meetassigncount"));
                DynamicObject taskSource = task.getDynamicObject("tasksource");
                obj.put("tasksource", taskSource != null ? taskSource.getLocaleString("name") : "");
                this.projectNameToJson(obj, task, "project", "project");
                obj.put("controllevelname", task.getDynamicObject("controllevel") == null ? null : task.getDynamicObject("controllevel").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("majortypename", task.getDynamicObject("majortype") == null ? null : task.getDynamicObject("majortype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("tasktype", task.getDynamicObject("tasktype") == null ? null : task.getDynamicObject("tasktype").getLocaleString("name").getLocaleValue());
                obj.put("pretaskname", task.getDynamicObject("pretask") == null ? null : task.getDynamicObject("pretask").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("planstarttime", (Object)sdf.format(task.getDate("planstarttime")));
                obj.put("planendtime", (Object)sdf.format(task.get("planendtime")));
                obj.put("absoluteduration", (Object)task.getInt("absoluteduration"));
                obj.put("percent", (Object)task.getBigDecimal("percent").setScale(2, RoundingMode.HALF_UP));
                obj.put("completedescription", task.get("completedescription"));
                if (task.getDate("expecttime") != null) {
                    obj.put("expecttime", (Object)sdf.format(task.getDate("expecttime")));
                }
                if (task.getDate("realendtime") != null) {
                    obj.put("realendtime", (Object)sdf.format(task.getDate("realendtime")));
                }
                obj.put("overduedays", (Object)PmTaskBizHelper.getOverDays(this.getAppId(), task));
                obj.put("resultdoc", task.get("resultdoc"));
                obj.put("responsiblepersonname", task.getDynamicObject("responsibleperson") == null ? null : task.getDynamicObject("responsibleperson").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put("responsibledeptname", task.getDynamicObject("responsibledept") == null ? null : task.getDynamicObject("responsibledept").getLocaleString("name").getLocaleValue_zh_CN());
                DynamicObjectCollection cooPersons = task.getDynamicObjectCollection("multicooperationperson");
                StringBuilder cooPersonsStr = new StringBuilder();
                cooPersons.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> cooPersonsStr.append(o.getDynamicObject("fbasedataid").getString("name")).append(";")).count();
                if (cooPersonsStr.length() > 0) {
                    cooPersonsStr.deleteCharAt(cooPersonsStr.length() - 1);
                }
                obj.put("cooperationpersonsname", (Object)cooPersonsStr);
                DynamicObjectCollection coodepts = task.getDynamicObjectCollection("multicooperationdept");
                StringBuilder coodeptsStr = new StringBuilder();
                coodepts.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> coodeptsStr.append(o.getDynamicObject("fbasedataid").getString("name")).append(";")).count();
                if (coodeptsStr.length() > 0) {
                    coodeptsStr.deleteCharAt(coodeptsStr.length() - 1);
                }
                obj.put("multicooperationdept", (Object)coodeptsStr);
                obj.put("comment", task.get("comment"));
                data.add((Object)obj);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"PmFuncPlanMonitorListPlugin_33", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        String url = POIHelper.exportExcel((String)this.getFileName(), (String)this.getSheetName(), (String[])this.getHeader(), (String[])COLUMNKEY, null, (JSONArray)data);
        this.getView().download(url);
    }

    private String getFileName() {
        return ResManager.loadKDString((String)"\u90e8\u95e8\u8ba1\u5212\u76d1\u63a7", (String)"PmFuncPlanMonitorListPlugin_31", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]);
    }

    private void getTaskEntryFromDept(DynamicObject[] deptPlans, List<Object> allTaskids, Map<String, DynamicObject> taskEntryMap, DynamicObjectCollection entries) {
        for (DynamicObject plan : deptPlans) {
            DynamicObjectCollection taskEntry = plan.getDynamicObjectCollection(KEY_TREEENTRYENTITY);
            if (taskEntry == null || taskEntry.isEmpty()) continue;
            entries.addAll((Collection)taskEntry);
        }
        for (DynamicObject entry : entries) {
            Object id = entry.getPkValue();
            allTaskids.add(id);
            taskEntryMap.put(id.toString(), entry);
        }
    }

    private String getSheetName() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"PmFuncPlanMonitorListPlugin_18", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]);
    }

    private String[] getHeader() {
        return this.header;
    }

    private void doSearch() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("businessorg");
        Object planningCycle = this.getModel().getValue("planningCycle");
        Object plantime = this.getModel().getValue("plantime");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c\u653f\u90e8\u95e8\u3002", (String)"PmFuncPlanMonitorListPlugin_34", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (planningCycle == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u5468\u671f\u3002", (String)"PmFuncPlanMonitorListPlugin_37", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (plantime == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65f6\u95f4\u3002", (String)"PmFuncPlanMonitorListPlugin_36", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(KEY_TREEENTRYENTITY);
        FormDataModel dataModel = (FormDataModel)grid.getModel();
        dataModel.deleteEntryData(KEY_TREEENTRYENTITY);
        DynamicObject[] deptPlans = this.getDeptPlans(org, planningCycle, plantime);
        this.hideLevelNum();
        if (deptPlans == null || deptPlans.length == 0) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"PmFuncPlanMonitorListPlugin_33", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> allTaskids = new ArrayList<Object>(10);
        HashMap<String, DynamicObject> taskEntryMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection entries = new DynamicObjectCollection();
        this.getTaskEntryFromDept(deptPlans, allTaskids, taskEntryMap, entries);
        if (allTaskids.isEmpty()) {
            return;
        }
        QFilter ids = new QFilter("id", "in", (Object)allTaskids.toArray());
        ArrayList<QFilter> idFilter = new ArrayList<QFilter>(10);
        idFilter.add(ids);
        DynamicObject[] allTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,parent,tasktype,controllevel,planstarttime,planendtime,sourcetask,status,completionstatus,realtimedeviation,comptimedeviation,belongplantype,percent,relationtask,completedescription,level", (QFilter[])idFilter.toArray(new QFilter[idFilter.size()]), (String)"taskseq");
        this.mapAllTasks = new HashMap<String, DynamicObject>(16);
        HashMap<String, QFilter> mapFilters = new HashMap<String, QFilter>(16);
        this.constructTaskFilter(mapFilters);
        this.filterTask(taskEntryMap, allTasks, mapFilters);
        if (taskEntryMap.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"PmFuncPlanMonitorListPlugin_33", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        this.batchCreateTaskEntryRows(grid, taskEntryMap);
        this.getView().updateView(KEY_TREEENTRYENTITY);
        this.hideLevelNum();
    }

    private void batchCreateTaskEntryRows(TreeEntryGrid grid, Map<String, DynamicObject> mapEntries) {
        DynamicObjectCollection afterFilterEntries = new DynamicObjectCollection();
        Iterator<Map.Entry<String, DynamicObject>> iter = mapEntries.entrySet().iterator();
        while (iter.hasNext()) {
            afterFilterEntries.add((Object)iter.next().getValue());
        }
        afterFilterEntries.sort(Comparator.comparing(obj -> obj.getInt("seq")));
        DynamicObjectCollection taskEntityCols = this.getModel().getEntryEntity(KEY_TREEENTRYENTITY);
        DynamicObjectType dt = taskEntityCols.getDynamicObjectType();
        DynamicObject newTaskObj = null;
        DynamicObject taskObj = null;
        ArrayList<Integer> taskIndexFromMainPlans = new ArrayList<Integer>(afterFilterEntries.size());
        for (int i = 0; i < afterFilterEntries.size(); ++i) {
            taskObj = (DynamicObject)afterFilterEntries.get(i);
            newTaskObj = new DynamicObject(dt);
            DynamicObject task = this.mapAllTasks.get(taskObj.getString("id"));
            if (task != null) {
                newTaskObj.set("id", task.getPkValue());
                newTaskObj.set("task", (Object)task);
                newTaskObj.set("overduedays", (Object)PmTaskBizHelper.getOverDays(this.getAppId(), task));
                newTaskObj.set("pid", (Object)(task.getDynamicObject("parent") == null ? "0" : task.getDynamicObject("parent").getPkValue().toString()));
                newTaskObj.set("completionstatusvalue", task.get("completionstatus"));
                DynamicObject relateTask = task.getDynamicObject("relationtask");
                if (relateTask != null) {
                    taskIndexFromMainPlans.add(i);
                }
            }
            taskEntityCols.add((Object)newTaskObj);
        }
        int[] taskIndexFromMainPlan = taskIndexFromMainPlans.stream().mapToInt(Integer::intValue).toArray();
        grid.setRowLock(true, taskIndexFromMainPlan);
        grid.setRowBackcolor("lightgrey", taskIndexFromMainPlan);
        this.getModel().updateEntryCache(taskEntityCols);
        this.setTextColor(grid);
        grid.setCollapse(false);
        grid.getModel().updateCache();
        grid.getModel().updateEntryCache(taskEntityCols);
        this.getModel().updateEntryCache(taskEntityCols);
    }

    private void filterTask(Map<String, DynamicObject> mapEntries, DynamicObject[] allTasks, Map<String, QFilter> mapFilters) {
        for (DynamicObject task : allTasks) {
            this.mapAllTasks.put(task.getPkValue().toString(), task);
            Object controllevel = task.get("controllevel.id");
            if (mapFilters.get("controllevel.id") != null) {
                Object levelIds = mapFilters.get("controllevel.id").getValue();
                ArrayList<Long> levelList = new ArrayList<Long>(10);
                if (levelIds instanceof List) {
                    for (Object obj : (List)levelIds) {
                        levelList.add((Long)obj);
                    }
                }
                if (!levelList.isEmpty() && !levelList.contains(controllevel)) {
                    mapEntries.remove(task.getPkValue().toString());
                    continue;
                }
            }
            DynamicObject taskType = task.getDynamicObject("tasktype");
            if (mapFilters.get("tasktype.id") != null && taskType != null) {
                Object typeIds = mapFilters.get("tasktype.id").getValue();
                ArrayList<Long> taskTypeList = new ArrayList<Long>(10);
                if (typeIds instanceof List) {
                    Object obj;
                    obj = ((List)typeIds).iterator();
                    while (obj.hasNext()) {
                        Object obj2 = obj.next();
                        taskTypeList.add((Long)obj2);
                    }
                }
                if (!taskTypeList.isEmpty() && !taskTypeList.contains(taskType.getPkValue())) {
                    mapEntries.remove(task.getPkValue().toString());
                    continue;
                }
            }
            Object completionStatus = task.get("completionstatus");
            if (mapFilters.get("completionstatus") != null) {
                Object statusIds = mapFilters.get("completionstatus").getValue();
                ArrayList<String> statusList = new ArrayList<String>(10);
                if (statusIds instanceof List) {
                    for (Object obj : (List)statusIds) {
                        statusList.add((String)obj);
                    }
                }
                if (!statusList.isEmpty() && !statusList.contains(completionStatus)) {
                    mapEntries.remove(task.getPkValue().toString());
                    continue;
                }
            }
            Object belongPlanType = task.get("belongplantype.id");
            if (mapFilters.get("belongplantype.id") == null) continue;
            Object planTypeIds = mapFilters.get("belongplantype.id").getValue();
            ArrayList<Long> belongPlantypeList = new ArrayList<Long>(10);
            if (planTypeIds instanceof List) {
                for (Object obj : (List)planTypeIds) {
                    belongPlantypeList.add((Long)obj);
                }
            }
            if (belongPlantypeList.isEmpty() || belongPlantypeList.contains(belongPlanType)) continue;
            mapEntries.remove(task.getPkValue().toString());
        }
    }

    private void constructTaskFilter(Map<String, QFilter> mapFilters) {
        DynamicObjectCollection belongPlanTypes;
        Object completionStatusObj;
        DynamicObjectCollection tasktypes;
        DynamicObjectCollection controllevels = (DynamicObjectCollection)this.getModel().getValue("controllevel");
        if (!controllevels.isEmpty()) {
            QFilter filter1 = new QFilter("controllevel.id", "in", controllevels.stream().map(controllevel -> controllevel.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
            mapFilters.put("controllevel.id", filter1);
        }
        if (!(tasktypes = (DynamicObjectCollection)this.getModel().getValue("tasktype")).isEmpty()) {
            QFilter filter2 = new QFilter("tasktype.id", "in", tasktypes.stream().map(tasktype -> tasktype.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
            mapFilters.put("tasktype.id", filter2);
        }
        if ((completionStatusObj = this.getModel().getValue("completionstatus")) != null) {
            String completionStatusText = this.getModel().getValue("completionstatus").toString();
            String[] completionStatusArray = completionStatusText.split(",");
            ArrayList<String> compleStatusList = new ArrayList<String>(10);
            for (String status : completionStatusArray) {
                if (status == null) continue;
                compleStatusList.add(status);
            }
            QFilter filter3 = new QFilter("completionstatus", "in", compleStatusList);
            mapFilters.put("completionstatus", filter3);
        }
        if (!(belongPlanTypes = (DynamicObjectCollection)this.getModel().getValue("belongplantype")).isEmpty()) {
            QFilter filter4 = new QFilter("belongplantype.id", "in", belongPlanTypes.stream().map(belongplantype -> belongplantype.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
            mapFilters.put("belongplantype.id", filter4);
        }
    }

    private DynamicObject[] getDeptPlans(DynamicObject org, Object planningCycle, Object plantime) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        qFilters.add(orgFilter);
        QFilter cycleFilter = new QFilter("planningcycle", "=", (Object)PlanningCycleEnum.getEnumByValue((Object)planningCycle));
        qFilters.add(cycleFilter);
        QFilter timeFilter = new QFilter("STARTTIME", "<=", plantime).and("ENDTIME", ">=", plantime);
        qFilters.add(timeFilter);
        QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
        qFilters.add(planVersion);
        DynamicObject[] plans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"deptplan"), (String)"id,taskentity,taskentity.taskid,taskentity.pid,taskentity.seq,taskentity.level,taskentity.isleaf", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        return plans;
    }

    private void setTextColor(TreeEntryGrid grid) {
        int rows = this.getModel().getEntryRowCount(KEY_TREEENTRYENTITY);
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
        for (int i = 0; i < rows; ++i) {
            CellStyle style = new CellStyle();
            style.setRow(i);
            style.setFieldKey("overduedays");
            DynamicObject task = (DynamicObject)this.getModel().getValue("task", i);
            if (PmTaskBizHelper.getOverDays(this.getAppId(), task).compareTo(BigDecimal.ZERO) > 0) {
                style.setForeColor("red");
            }
            styles.add(style);
            CellStyle style1 = new CellStyle();
            style1.setRow(i);
            style1.setFieldKey("taskname");
            String riskColor = task.getString("riskcolor");
            if (RiskColorEnum.YELLOW.getValue().equals(riskColor)) {
                style1.setBackColor("yellow");
            } else if (RiskColorEnum.RED.getValue().equals(riskColor)) {
                style1.setBackColor("#FD6C6A");
            }
            styles.add(style1);
        }
        grid.setCellStyle(styles);
    }
}

