/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.EnableEnum;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pccs.placs.business.base.AbstractPlacsBillAdapter;
import kd.pccs.placs.business.callback.CallBackStrategy;
import kd.pccs.placs.business.operation.OperationStrategy;
import kd.pccs.placs.business.utils.task.DealWithEntryDataUtils;
import kd.pccs.placs.business.utils.task.MultiCooperationPersonUtils;
import kd.pccs.placs.business.utils.task.PlanTaskImpAndExpUtil;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.business.utils.task.TreeEntryUtils;
import kd.pccs.placs.common.enums.TaskTypeEnum;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.MasterPlanEditPlugin;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.PlanTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import kd.pmgt.pmbs.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import pmgt.pmpt.business.PmPlanAchieveHelper;
import pmgt.pmpt.business.PmPlanTaskImpAndExpUtil;

public class PmMasterPlanEditPlugin
extends MasterPlanEditPlugin {
    private static final String DELETE_TASK_CONFIRM = "deleteTaskConfirm";
    private static final String NEW_TASK_CONFIRM = "newTaskConfirm";

    public void beforeBindData(EventObject e) {
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)orgId)) {
            this.getModel().setValue("org", (Object)Long.parseLong(orgId));
        }
        super.beforeBindData(e);
    }

    public String getAppId() {
        return "pmpt";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit assigner = (BasedataEdit)this.getControl("assigner");
        assigner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsiblePerson = (BasedataEdit)this.getControl("responsibleperson");
        responsiblePerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit multiCooperationPerson = (BasedataEdit)this.getControl("multicooperationperson");
        multiCooperationPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit responsibleDept = (BasedataEdit)this.getControl("responsibledept");
        responsibleDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("taskresultdocentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected void settingPreTaskFilter(ListShowParameter param) {
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity("taskentity");
        int selectIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
        DynamicObject selectEntry = this.getModel().getEntryRowEntity("taskentity", selectIndex);
        Set taskIds = taskEntries.stream().filter(entry -> !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)entry.getString("name")) && !entry.getPkValue().equals(selectEntry.getPkValue()) && entry.getBoolean("isleaf") && (entry.getDynamicObject("pretask") == null || entry.getDynamicObject("pretask") != null && !entry.getDynamicObject("pretask").getPkValue().equals(selectEntry.getPkValue()))).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        HashSet excludeTaskIds = new HashSet();
        this.getPreTaskLinkSet(taskEntries, selectEntry, excludeTaskIds);
        taskIds.removeAll(excludeTaskIds);
        ListFilterParameter parameter = param.getListFilterParameter();
        QFilter filter = new QFilter("id", "in", taskIds);
        parameter.setFilter(filter);
        parameter.setOrderBy("taskseq");
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String propName = arg.getProperty().getName();
        Object project = this.getModel().getValue("project");
        ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
        if (propName.equals("project")) {
            List qFilters = param.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("enable", "=", (Object)EnableEnum.Enable));
            qFilters.add(new QFilter("status", "=", (Object)StatusEnum.Checked));
            ArrayList<String> excludeStatusIds = new ArrayList<String>();
            excludeStatusIds.add(ProjectStatusEnum.BUSSINESS_CLOSE.getId());
            excludeStatusIds.add(ProjectStatusEnum.FINANCIAL_CLOSE.getId());
            excludeStatusIds.add(ProjectStatusEnum.SUSPEND.getId());
            excludeStatusIds.add(ProjectStatusEnum.QUIT.getId());
            QFilter proStatusFilter = new QFilter("prostatus", "not in", (Object)StringUtils.stringArrToLongArr((String[])excludeStatusIds.toArray(new String[0])));
            qFilters.add(proStatusFilter);
            QFilter filter = new QFilter("plantype", "=", (Object)PlanTypeEnum.MAINPLAN.getValue());
            DynamicObject planType = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"majortype"), (String)"", (QFilter[])new QFilter[]{filter});
            QFilter majorTypeFilter = new QFilter("majortype", "=", planType.getPkValue());
            DynamicObjectCollection masterPlans = QueryServiceHelper.query((String)"pmpt_masterplan", (String)"id,project", (QFilter[])new QFilter[]{majorTypeFilter});
            List planProIds = masterPlans.stream().map(o -> o.getLong("project")).collect(Collectors.toList());
            if (planProIds.size() > 0) {
                qFilters.add(new QFilter("id", "not in", planProIds));
            }
        } else if ("pretask".equals(propName)) {
            boolean isFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            if (!isFromDb) {
                this.getView().invokeOperation("save");
                this.getModel().updateCache();
            } else {
                DynamicObjectCollection tasks = this.getModel().getEntryEntity("taskentity");
                SaveServiceHelper.update((DynamicObject[])((DynamicObject[])tasks.toArray((Object[])new DynamicObject[0])));
            }
            if (!arg.getSourceMethod().equals("click")) {
                this.settingPreTaskFilter(arg);
                return;
            }
            this.showTaskF7(arg);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"specialtype", (CharSequence)propName)) {
            this.beforeSpecialTypeSelected(arg, project);
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"responsibledept", (CharSequence)propName)) {
            int entryCurrentRowIndex;
            DynamicObjectCollection orgEntryEntity = this.getModel().getEntryEntity("taskentity");
            DynamicObject taskRow = (DynamicObject)orgEntryEntity.get(entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("taskentity"));
            DynamicObject responsibleperson = taskRow.getDynamicObject("responsibleperson");
            if (responsibleperson != null) {
                List deptList = UserServiceHelper.getUserDepartment((long)Long.parseLong(responsibleperson.getPkValue().toString()), (boolean)false);
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)deptList));
            } else {
                long userId = RequestContext.get().getCurrUserId();
                List userOrgRanges = UserOrgRangeHelper.getUserOrgRanges((Long)userId);
                String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"orgseparate");
                List allSubOrgUnits = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, (List)userOrgRanges, (String)"01");
                if (allSubOrgUnits.size() > 0) {
                    List parentByOrgIds = OrgTreeUtils.getParentByOrgIds((List)allSubOrgUnits, (String)"01");
                    param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)parentByOrgIds));
                    param.setF7ClickByFilter(true);
                }
            }
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"multicooperationdept", (CharSequence)propName)) {
            int entryCurrentRowIndex;
            DynamicObjectCollection orgEntryEntity = this.getModel().getEntryEntity("taskentity");
            DynamicObject taskRow = (DynamicObject)orgEntryEntity.get(entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("taskentity"));
            DynamicObjectCollection cooperationpersons = taskRow.getDynamicObjectCollection("multicooperationperson");
            if (cooperationpersons != null && cooperationpersons.size() > 0) {
                ArrayList deptList = new ArrayList();
                cooperationpersons.stream().map(o -> deptList.addAll(UserServiceHelper.getUserDepartment((long)o.getLong("fbasedataid_id"), (boolean)false))).count();
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", deptList));
                if (cooperationpersons.size() == 1) {
                    param.setMultiSelect(false);
                }
            } else {
                long userId = RequestContext.get().getCurrUserId();
                List userOrgRanges = UserOrgRangeHelper.getUserOrgRanges((Long)userId);
                String pattern = ProjectPermissionHelper.getPatternIdByParam((Long)RequestContext.get().getOrgId(), (String)"orgseparate");
                List allSubOrgUnits = ProjectPermissionHelper.getAllSubOrgUnitsByPattern((String)pattern, (List)userOrgRanges, (String)"01");
                if (allSubOrgUnits.size() > 0) {
                    List parentByOrgIds = OrgTreeUtils.getParentByOrgIds((List)allSubOrgUnits, (String)"01");
                    param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)parentByOrgIds));
                    param.setF7ClickByFilter(true);
                }
            }
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"assigner", (CharSequence)propName) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"responsibleperson", (CharSequence)propName) || kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"multicooperationperson", (CharSequence)propName)) {
            QFilter qFilter;
            param.setF7Style(3);
            List qFilterList = param.getListFilterParameter().getQFilters();
            long currUserId = RequestContext.get().getCurrUserId();
            long projectId = 0L;
            if (project != null) {
                DynamicObject projectObj = (DynamicObject)project;
                projectId = Long.parseLong(projectObj.getPkValue().toString());
            }
            if ((qFilter = UserOrgRangeHelper.loadUserOrgRanges((Long)currUserId, (Long)projectId)) != null) {
                qFilterList.add(qFilter);
            }
        }
    }

    private void showTaskF7(BeforeF7SelectEvent arg) {
        arg.setCancel(true);
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (boolean)false, (int)2);
        this.settingPreTaskFilter(parameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showTaskF7"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected void showProjectList() {
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"bd_project", (boolean)false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "switchProjectCallBack");
        showListForm.setCloseCallBack(closeCallBack);
        List qFilters = showListForm.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("enable", "=", (Object)EnableEnum.Enable));
        qFilters.add(new QFilter("status", "=", (Object)StatusEnum.Checked));
        ArrayList<Long> excludeStatusIds = new ArrayList<Long>();
        excludeStatusIds.add(Long.parseLong(ProjectStatusEnum.BUSSINESS_CLOSE.getId()));
        excludeStatusIds.add(Long.parseLong(ProjectStatusEnum.FINANCIAL_CLOSE.getId()));
        excludeStatusIds.add(Long.parseLong(ProjectStatusEnum.SUSPEND.getId()));
        excludeStatusIds.add(Long.parseLong(ProjectStatusEnum.QUIT.getId()));
        QFilter proStatusFilter = new QFilter("prostatus", "not in", excludeStatusIds);
        proStatusFilter.and(new QFilter("pro", "not in", (Object)0));
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro", (QFilter[])new QFilter[]{proStatusFilter});
        List projectList = Arrays.stream(projects).filter(o -> o.getDynamicObject("pro") != null).collect(Collectors.toList());
        List projectIdList = projectList.stream().map(o -> o.getDynamicObject("pro").getPkValue()).collect(Collectors.toList());
        qFilters.add(new QFilter("id", "in", projectIdList));
        this.getView().showForm((FormShowParameter)showListForm);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        if ("switchProjectCallBack".equalsIgnoreCase(key)) {
            ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (listSelectedRowCollection == null || listSelectedRowCollection.isEmpty()) {
                return;
            }
            ListSelectedRow listSelectedRow = listSelectedRowCollection.get(0);
            this.switchProject(listSelectedRow.getPrimaryKeyValue());
        } else if ("batchmodify".equalsIgnoreCase(key)) {
            Map dataMap = (Map)closedCallBackEvent.getReturnData();
            MultiCooperationPersonUtils.dealBatchModifyPersons((IFormView)this.getView(), (Map)dataMap);
        } else if ("showTaskF7".equalsIgnoreCase(key)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows != null) {
                int curRow = this.getModel().getEntryCurrentRowIndex("taskentity");
                this.getModel().setValue("pretask", rows.get(0).getPrimaryKeyValue(), curRow);
            }
        } else if (MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskimpdialog").equalsIgnoreCase(key)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((Object)returnData)) {
                int i;
                DynamicObjectCollection tasks = (DynamicObjectCollection)returnData;
                boolean showResultDoc = false;
                for (Object task : tasks) {
                    DynamicObjectCollection transactionType = task.getDynamicObjectCollection("transactiontype");
                    if (null != transactionType) {
                        for (DynamicObject tx : transactionType) {
                            Long baseDataId = tx.getLong("fbasedataid_id");
                            DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
                            if (transactionType.size() >= 2 || Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number")) || task.getDynamicObjectCollection("taskresultdocentry") == null || task.getDynamicObjectCollection("taskresultdocentry").size() <= 0) continue;
                            showResultDoc = true;
                        }
                        continue;
                    }
                    if (transactionType != null || task.getDynamicObjectCollection("taskresultdocentry") == null) continue;
                    showResultDoc = true;
                }
                if (showResultDoc) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u4e3a\u201c\u6210\u679c\u201d\u7684\u4efb\u52a1\uff0c\u624d\u80fd\u4e0a\u4f20\u201c\u6210\u679c\u6587\u6863\u201d\u7684\u76f8\u5173\u4fe1\u606f\u3002", (String)"PmMasterPlanEditPlugin_27", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                }
                DealWithEntryDataUtils.updateEntryLevelData((DynamicObjectCollection)tasks);
                this.dealErrorBuilding(returnData);
                this.getModel().updateCache();
                this.getModel().updateEntryCache(tasks);
                this.getView().updateView();
                this.getView().invokeOperation("save");
                for (i = 0; i < tasks.size(); ++i) {
                    for (DynamicObject task1 : tasks) {
                        if (((DynamicObject)tasks.get(i)).get("pretask") == null || !((DynamicObject)tasks.get(i)).get("pretask").equals(task1.getString("name")) || !((DynamicObject)tasks.get(i)).getBoolean("isleaf")) continue;
                        this.getModel().setValue("pretask", (Object)task1, i);
                    }
                    if (((DynamicObject)tasks.get(i)).get("pretask") != null && ((DynamicObject)tasks.get(i)).getBoolean("isleaf")) continue;
                    this.getModel().setValue("logical", null, i);
                    this.getModel().setValue("relativeduration", null, i);
                }
                for (i = 0; i < tasks.size(); ++i) {
                    if (((DynamicObject)tasks.get(i)).get("pretask") == null) continue;
                    this.calculatePlanStartTimeByPreTaskAndLogical(i);
                }
                TreeEntryGrid entryTree = (TreeEntryGrid)this.getView().getControl("taskentity");
                entryTree.setCollapse(false);
            }
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)key, (CharSequence)"importprojecttask")) {
            List taskIds = (List)closedCallBackEvent.getReturnData();
            if (CollectionUtils.isNotEmpty((Collection)taskIds)) {
                DynamicObject[] importTasks = BusinessDataServiceHelper.load((Object[])taskIds.toArray(), (DynamicObjectType)MetaDataUtil.getDT((String)this.getAppId(), (String)"task"));
                DynamicObject planPro = (DynamicObject)this.getModel().getValue("project");
                DynamicObject group1 = planPro.getDynamicObject("group");
                boolean beSet = false;
                for (int i = 0; i < importTasks.length; ++i) {
                    DynamicObject task = importTasks[i];
                    DynamicObject taskPro = task.getDynamicObject("project");
                    DynamicObject group2 = taskPro.getDynamicObject("group");
                    if (group1 == null || group2 == null || !group1.getPkValue().toString().equals(group2.getPkValue().toString())) continue;
                    beSet = true;
                    this.getModel().setValue("specialtype", task.get("majortype"), i);
                }
                if (beSet) {
                    this.getView().invokeOperation("save");
                }
            }
        } else if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)key, (CharSequence)"relatedwbs")) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
            if (CollectionUtils.isEmpty((Collection)returnData)) {
                this.getModel().setValue("relatedwbs", (Object)Boolean.FALSE, currentRowIndex);
                return;
            }
            DynamicObject[] wbsArray = BusinessDataServiceHelper.load((Object[])returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_wbs"));
            Map<Long, DynamicObject> wbsId2Wbs = Arrays.stream(wbsArray).collect(Collectors.toMap(it -> it.getLong("id"), it -> it));
            DynamicObjectCollection taskEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("taskentity");
            DynamicObject currentEntity = (DynamicObject)taskEntities.get(currentRowIndex);
            DynamicObjectCollection newTaskEntities = new DynamicObjectCollection();
            long[] entryIds = DB.genLongIds((String)"t_pmpt_task", (int)(returnData.size() - 1));
            for (int i = 0; i < returnData.size(); ++i) {
                ListSelectedRow row = returnData.get(i);
                Long selectedWbsId = (Long)row.getPrimaryKeyValue();
                DynamicObject wbs = wbsId2Wbs.get(selectedWbsId);
                boolean alreadyRelated = taskEntities.stream().map(it -> it.getDynamicObject("wbs")).filter(Objects::nonNull).map(it -> it.getLong("id")).anyMatch(it -> it.equals(selectedWbsId));
                if (alreadyRelated) {
                    this.getModel().setValue("relatedwbs", (Object)Boolean.FALSE);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u8054\u5176\u4ed6\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9WBS\u3002", (String)"PmMasterPlanEditPlugin_28", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectType taskEntryDT = currentEntity.getDynamicObjectType();
                DynamicObject newTask = new DynamicObject(taskEntryDT);
                if (currentEntity.getDynamicObject("wbs") == null) {
                    newTask = currentEntity;
                    newTask.set("relatedwbs", (Object)Boolean.TRUE);
                    newTask.set("wbs", (Object)wbs);
                    newTask.set("name", (Object)wbs.getLocaleString("name"));
                    newTask.set("number", (Object)wbs.getString("number"));
                    continue;
                }
                newTask.set("id", (Object)entryIds[i - 1]);
                newTask.set("level", currentEntity.get("level"));
                newTask.set("pid", currentEntity.get("pid"));
                newTask.set("relatedwbs", (Object)Boolean.TRUE);
                newTask.set("wbs", (Object)wbs);
                newTask.set("name", (Object)wbs.getLocaleString("name"));
                newTask.set("number", (Object)wbs.getString("number"));
                newTaskEntities.add((Object)newTask);
            }
            taskEntities.addAll((Collection)newTaskEntities);
            this.getModel().updateEntryCache(taskEntities);
            this.getView().updateView("taskentity");
        } else {
            new CallBackStrategy().closedCallBack((AbstractPlacsBillAdapter)this, closedCallBackEvent);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = operate.getOperateKey();
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        switch (key) {
            case "viewtaskdetail": {
                this.viewTaskDetailOperation(grid);
            }
        }
    }

    protected PlanTaskImpAndExpUtil getUtil() {
        return new PmPlanTaskImpAndExpUtil(this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String key = e.getProperty().getName();
        Object newValue = changeSet.getNewValue();
        block7 : switch (key) {
            case "relatedwbs": {
                if (((Boolean)newValue).booleanValue()) {
                    ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pmbs_wbs", (boolean)true, (int)ShowType.Modal.getValue(), (boolean)true);
                    DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                    QFilter proFilter = new QFilter("project", "=", project.getPkValue());
                    QFilter statusFilter = new QFilter("status", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue());
                    QFilter enableFilter = new QFilter("enable", "=", (Object)kd.pmgt.pmbs.common.enums.EnableEnum.ENABLE.getValue());
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "relatedwbs");
                    showParameter.setCloseCallBack(closeCallBack);
                    showParameter.getListFilterParameter().setQFilters(Arrays.asList(proFilter, statusFilter, enableFilter));
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex("taskentity");
                DynamicObject wbs = (DynamicObject)this.getModel().getValue("wbs", currentRowIndex);
                if (wbs != null) {
                    this.getModel().setValue("name", null, currentRowIndex);
                    this.getModel().setValue("number", null, currentRowIndex);
                    this.getModel().setValue("wbs", null, currentRowIndex);
                }
                this.getModel().setValue("relatedwbs", (Object)Boolean.FALSE, currentRowIndex);
                break;
            }
            case "project": {
                Object oldValue = changeSet.getOldValue();
                if (newValue != null && oldValue != null && !newValue.equals(oldValue)) {
                    this.getView().getPageCache().put("projectPk", ((DynamicObject)changeSet.getNewValue()).getPkValue().toString());
                    String oldProject = this.getView().getPageCache().get("oldProject");
                    if (oldProject == null) {
                        this.getView().getPageCache().put("oldProject", ((DynamicObject)changeSet.getOldValue()).getPkValue().toString());
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u4f1a\u6e05\u7a7a\u5206\u5f55\u6240\u6709\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmMasterPlanEditPlugin_22", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showProjectListCallBack"));
                        break;
                    }
                    this.getView().getPageCache().remove("oldProject");
                    break;
                }
                if (newValue != null && oldValue == null) {
                    this.switchProject(((DynamicObject)changeSet.getNewValue()).getPkValue());
                    break;
                }
                if (newValue != null) break;
                this.getModel().setValue("billname", null);
                DynamicObjectCollection taskEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("taskentity");
                taskEntries.clear();
                this.getModel().updateEntryCache(taskEntries);
                this.getView().updateView("billname");
                this.getView().updateView("taskentity");
                break;
            }
            case "name": {
                if (newValue == null) {
                    return;
                }
                IDataEntityProperty localeIdProperty = ((LocaleDynamicObjectCollection)newValue).getLocaleIdProperty();
                String localeValue = (String)((LocaleDynamicObjectCollection)newValue).getCurrentLocaleValue(localeIdProperty);
                Optional<String> newOptional = ((LocaleDynamicObjectCollection)newValue).stream().filter(dyn -> dyn.getString("localeid").equals(localeValue)).map(dyn -> dyn.getString("name")).findFirst();
                if (!newOptional.isPresent()) {
                    return;
                }
                String newName = newOptional.get();
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)newName)) {
                    return;
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentity");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject dyn2 = (DynamicObject)entryEntity.get(i);
                    ILocaleString localeString = dyn2.getLocaleString("name");
                    String localeValue1 = localeString.getLocaleValue();
                    if (localeValue1 == null || !localeValue1.equals(newName) || i == rowIndex) continue;
                    String detail = String.format(ResManager.loadKDString((String)"\u201c\u4efb\u52a1\u540d\u79f0\u201d\u503c\u201c%1$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002\n\u7b2c%2$s\u884c\u4e0e\u7b2c%3$s\u884c\u7684\u4efb\u52a1\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmMasterPlanEditPlugin_42", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), newName, rowIndex + 1, i + 1);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"PmMasterPlanEditPlugin_29", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), detail, MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("name", (IFormPlugin)this));
                    this.getModel().setValue("name", null, rowIndex);
                    break block7;
                }
                break;
            }
            case "number": {
                if (newValue == null) break;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentity");
                int i = 0;
                for (DynamicObject obj : entryEntity) {
                    if (obj.get("number") != null && obj.getString("number").equalsIgnoreCase((String)newValue) && rowIndex != i) {
                        String detail = String.format(ResManager.loadKDString((String)"\u7b2c%2$s\u884c\u4e0e\u7b2c%3$s\u884c\u7684\u4efb\u52a1\u7f16\u7801\u91cd\u590d\uff0c\u4efb\u52a1\u7f16\u7801\u5747\u4e3a\u201c%1$s\u201d\u3002", (String)"PmMasterPlanEditPlugin_30", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), newValue, rowIndex + 1, i + 1);
                        this.getView().showTipNotification(detail);
                        this.getModel().setValue("number", null, rowIndex);
                        break block7;
                    }
                    ++i;
                }
                break;
            }
            case "attachtype": {
                DynamicObject attachType = (DynamicObject)newValue;
                PmPlanAchieveHelper.setTemplateFile((IFormView)this.getView(), (Integer)rowIndex, (String)"templatefile", (DynamicObject)attachType, (String)"resultname", (String)"taskresultdocentry");
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    protected void viewTaskDetailOperation(TreeEntryGrid grid) {
        int[] selRows = grid.getSelectRows();
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u4efb\u52a1\u884c\u3002", (String)"PmMasterPlanEditPlugin_31", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u9009\u62e9\uff0c\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"PmMasterPlanEditPlugin_32", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = selRows[0];
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentity");
        DynamicObject task = (DynamicObject)entryEntity.get(rowIndex);
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        if (task != null) {
            boolean exists = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"), (Object)task.getPkValue());
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5c1a\u672a\u4fdd\u5b58\u3002", (String)"PmMasterPlanEditPlugin_33", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                return;
            }
            paramMap.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"reporttaskview"));
            paramMap.put("pkId", task.getPkValue().toString());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setAppId(this.getAppId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    protected void switchProject(Object projectPk) {
        super.switchProject(projectPk);
        this.setDateEditRange();
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObjectCollection taskEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("taskentity");
        taskEntries.clear();
        String sourceBill = "pmbs_wbs";
        DynamicObject[] sourceArray = this.getWbsByProject(project);
        if (sourceArray == null || sourceArray.length == 0) {
            sourceBill = "pmas_prostatus";
            sourceArray = this.getProStatus(project);
        }
        this.getModel().beginInit();
        long[] ids = DB.genLongIds((String)"t_pmpt_task", (int)sourceArray.length);
        for (int i = 0; i < sourceArray.length; ++i) {
            DynamicObject source = sourceArray[i];
            DynamicObject taskEntry = taskEntries.addNew();
            taskEntry.set("id", (Object)ids[i]);
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)sourceBill, (CharSequence)"pmbs_wbs")) {
                this.fillTaskEntryByWbs(source, taskEntry);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"relatedwbs"});
                continue;
            }
            this.fillTaskEntryByProStage(source, taskEntry);
        }
        this.getModel().updateEntryCache(taskEntries);
        this.getView().updateView("taskentity");
        this.getModel().endInit();
    }

    private DynamicObject[] getWbsByProject(DynamicObject project) {
        QFilter statusFilter = new QFilter("status", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue());
        QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)kd.pmgt.pmbs.common.enums.EnableEnum.ENABLE.getValue());
        QFilter levelFilter = new QFilter("level", "=", (Object)1);
        List pkArray = QueryServiceHelper.queryPrimaryKeys((String)"pmbs_wbs", (QFilter[])new QFilter[]{projectFilter, statusFilter, enableFilter, levelFilter}, null, (int)-1);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_wbs");
        return BusinessDataServiceHelper.load((Object[])pkArray.toArray(), (DynamicObjectType)dt);
    }

    protected void setEntryTaskBelongTypeAndTaskSource() {
        DynamicObjectCollection taskEntries = this.getModel().getEntryEntity("taskentity");
        for (int i = 0; i < taskEntries.size(); ++i) {
            boolean fromWbsOrProjectStatus;
            DynamicObject task = (DynamicObject)taskEntries.get(i);
            this.getModel().setValue("belongplantype", this.getMasterPlanType().getPkValue(), i);
            this.getModel().setValue("tasksource", this.getMasterPlanType().getPkValue(), i);
            BigDecimal percent = task.getBigDecimal("percent");
            boolean bl = fromWbsOrProjectStatus = task.getDynamicObject("wbs") != null || task.getDynamicObject("projectstatus") != null;
            if (!fromWbsOrProjectStatus || percent.compareTo(BigDecimal.valueOf(100L)) != 0) continue;
            Date planendtime = task.getDate("planendtime");
            Date completeTime = task.getDate("realendtime");
            if (planendtime == null || completeTime == null) continue;
            if (DateUtil.compareByDay((Date)completeTime, (Date)planendtime) <= 0) {
                task.set("completionstatus", (Object)CompletionStatusEnum.ONTIMECOMPLETE.getValue());
                continue;
            }
            task.set("completionstatus", (Object)CompletionStatusEnum.OVERDUECOMPLETE.getValue());
        }
    }

    protected void downgradeOperation(int[] selRows) {
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u964d\u7ea7\u7684\u884c\u3002", (String)"PmMasterPlanEditPlugin_34", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        int curIndex = selRows[0];
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        DynamicObject task = (DynamicObject)entries.get(curIndex);
        DynamicObject proStage = task.getDynamicObject("projectstatus");
        DynamicObject wbs = task.getDynamicObject("wbs");
        if (wbs != null && wbs.getInt("level") == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4efb\u52a1\u4e3aWBS\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"PmMasterPlanEditPlugin_4", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        if (proStage != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4efb\u52a1\u4e3a\u9879\u76ee\u9636\u6bb5\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"PmMasterPlanEditPlugin_5", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject preTask = task.getDynamicObject("pretask");
        if (preTask != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4efb\u52a1\u5b58\u5728\u524d\u7f6e\u4efb\u52a1\uff0c\u4e0d\u80fd\u964d\u7ea7\u3002", (String)"PmMasterPlanEditPlugin_6", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
        }
        TreeEntryUtils.downgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)this.getAppId());
        DynamicObject row = this.getModel().getEntryRowEntity("taskentity", curIndex);
        if (row.getDate("planstarttime") != null) {
            this.settingParentPlanTime("planstarttime", curIndex);
        }
        if (row.getDate("planendtime") != null) {
            this.settingParentPlanTime("planendtime", curIndex);
        }
        if (row.getDate("aimfinishtime") != null) {
            this.settingParentPlanTime("aimfinishtime", curIndex);
        }
    }

    protected void deleteTaskEntry(BeforeDoOperationEventArgs args) {
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
        int[] selRows = grid.getSelectRows();
        if (null == selRows || selRows.length <= 0) {
            this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"PmMasterPlanEditPlugin_35", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean hasSub = false;
        for (int selRow : selRows) {
            DynamicObject proStage = (DynamicObject)this.getModel().getValue("projectstatus", selRow);
            DynamicObject wbs = (DynamicObject)this.getModel().getValue("wbs", selRow);
            DynamicObject workItem = (DynamicObject)this.getModel().getValue("workitem", selRow);
            if (wbs != null && wbs.getInt("level") == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e3aWBS\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"PmMasterPlanEditPlugin_36", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (proStage != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e3a\u9879\u76ee\u72b6\u6001\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"PmMasterPlanEditPlugin_9", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (workItem != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u5173\u8054\u7763\u5bfc\u4efb\u52a1\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"PmMasterPlanEditPlugin_21", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            BigDecimal percent = (BigDecimal)this.getModel().getValue("percent", selRow);
            if (percent.compareTo(new BigDecimal(100)) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5b8c\u6210\u767e\u5206\u6bd4\u4e3a100%\u7684\u4efb\u52a1\u3002", (String)"PmMasterPlanEditPlugin_37", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean isLeaf = (Boolean)this.getModel().getValue("isleaf", selRow);
            if (isLeaf) continue;
            hasSub = true;
            break;
        }
        if (!hasSub) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"PmMasterPlanEditPlugin_11", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_TASK_CONFIRM));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u4efb\u52a1\u7684\u540c\u65f6\u5c06\u5220\u9664\u5b50\u4efb\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmMasterPlanEditPlugin_12", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_TASK_CONFIRM));
        }
        args.setCancel(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (project != null && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)billStatus, (CharSequence)kd.pmgt.pmbs.common.enums.StatusEnum.TEMPSAVE.getValue())) {
            this.updateTaskEntity();
        }
        if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)billStatus, (CharSequence)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue())) {
            DynamicObjectCollection taskEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("taskentity");
            for (DynamicObject taskEntity : taskEntities) {
                String taskNumber = taskEntity.getString("number");
                ILocaleString taskName = taskEntity.getLocaleString("name");
                if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)taskNumber) || taskName == null) continue;
                taskEntity.set("number", (Object)taskName.getLocaleValue());
            }
            this.getModel().updateEntryCache(taskEntities);
            this.getView().updateView("taskentity");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(true);
    }

    protected void updateTaskEntity() {
        boolean needUpdate = false;
        StringBuilder tipsMsg = new StringBuilder();
        DynamicObjectCollection taskEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("taskentity");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject[] wbsArray = this.getWbsByProject(project);
        DynamicObject[] proStatusArray = this.getProStatus(project);
        Map<Long, DynamicObject> wbsMap = Arrays.stream(wbsArray).filter(wbs -> wbs.getDynamicObject("projectstatus") == null).collect(Collectors.toMap(it -> Long.parseLong(it.getPkValue().toString()), it -> it));
        Map<Long, DynamicObject> proStatusMap = Arrays.stream(proStatusArray).collect(Collectors.toMap(it -> Long.parseLong(it.getPkValue().toString()), it -> it));
        for (DynamicObject taskEntry : taskEntries) {
            boolean byProStatus;
            boolean byWbs;
            DynamicObject projectStatus = taskEntry.getDynamicObject("projectstatus");
            DynamicObject wbs2 = taskEntry.getDynamicObject("wbs");
            if (projectStatus == null && wbs2 == null) continue;
            boolean bl = byWbs = wbs2 != null && wbsMap.containsKey(Long.parseLong(wbs2.getPkValue().toString()));
            if (byWbs) {
                wbsMap.remove(Long.parseLong(wbs2.getPkValue().toString()));
            }
            boolean bl2 = byProStatus = projectStatus != null && proStatusMap.containsKey(Long.parseLong(projectStatus.getPkValue().toString()));
            if (byProStatus) {
                proStatusMap.remove(Long.parseLong(projectStatus.getPkValue().toString()));
            }
            if (!byWbs && !byProStatus) continue;
            if (wbs2 != null) {
                BigDecimal percent = wbs2.getBigDecimal("schedule");
                needUpdate = this.updateEntityPercent(needUpdate, tipsMsg, taskEntry, percent);
                continue;
            }
            BigDecimal statusPercent = projectStatus.getBigDecimal("statuspercent");
            needUpdate = this.updateEntityPercent(needUpdate, tipsMsg, taskEntry, statusPercent);
        }
        needUpdate = this.needAddTask(needUpdate, tipsMsg, taskEntries, wbsMap);
        if (needUpdate = this.needAddTask(needUpdate, tipsMsg, taskEntries, proStatusMap)) {
            this.getView().showTipNotification(tipsMsg.toString());
            this.getModel().updateEntryCache(taskEntries);
            this.getView().updateView("taskentity");
        }
    }

    private boolean needAddTask(boolean needUpdate, StringBuilder tipsMsg, DynamicObjectCollection taskEntries, Map<Long, DynamicObject> sourceMap) {
        if (sourceMap == null || sourceMap.isEmpty()) {
            return needUpdate;
        }
        Set numberSet = taskEntries.stream().filter(obj -> obj.get("number") != null).map(obj -> obj.getString("number")).collect(Collectors.toSet());
        long[] ids = DB.genLongIds((String)"t_pmpt_task", (int)sourceMap.size());
        int index = 0;
        for (Map.Entry<Long, DynamicObject> sourceObjectSet : sourceMap.entrySet()) {
            DynamicObject sourceObject = sourceObjectSet.getValue();
            DynamicObject taskEntry = taskEntries.addNew();
            taskEntry.set("id", (Object)ids[index]);
            if (sourceObject.getDynamicObject("projectstage") != null && numberSet.contains(sourceObject.getDynamicObject("projectstage").getString("number"))) continue;
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)sourceObject.getDynamicObjectType().getName(), (CharSequence)"pmas_prostatus")) {
                this.fillTaskEntryByProStage(sourceObject, taskEntry);
            }
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)sourceObject.getDynamicObjectType().getName(), (CharSequence)"pmbs_wbs")) {
                this.fillTaskEntryByWbs(sourceObject, taskEntry);
            }
            tipsMsg.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u5df2\u6dfb\u52a0\u5230\u4efb\u52a1\u6e05\u5355\u3002", (String)"PmMasterPlanEditPlugin_38", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), taskEntry.getString("name")));
            tipsMsg.append("\n");
            ++index;
        }
        return true;
    }

    private void fillTaskEntryByProStage(DynamicObject proStatus, DynamicObject taskEntry) {
        DynamicObject project;
        QFilter projectFilter;
        DynamicObject projectApproval;
        taskEntry.set("name", (Object)new LocaleString(proStatus.getString("stagename")));
        if (proStatus.getDynamicObject("projectstage") != null) {
            taskEntry.set("number", (Object)proStatus.getDynamicObject("projectstage").getString("number"));
        }
        taskEntry.set("projectstatus", (Object)proStatus);
        BigDecimal statusPercent = proStatus.getBigDecimal("statuspercent");
        taskEntry.set("percent", (Object)statusPercent);
        taskEntry.set("projectstatus", (Object)proStatus);
        taskEntry.set("enable", (Object)kd.pmgt.pmbs.common.enums.EnableEnum.ENABLE.getValue());
        if (BigDecimal.valueOf(100L).compareTo(statusPercent) == 0 && (projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"auditdate", (QFilter[])(projectFilter = new QFilter("pro", "=", (project = proStatus.getDynamicObject("project")).getPkValue())).toArray())) != null) {
            taskEntry.set("realendtime", (Object)projectApproval.getDate("auditdate"));
        }
    }

    private void fillTaskEntryByWbs(DynamicObject wbs, DynamicObject taskEntry) {
        QFilter projectFilter;
        DynamicObject projectApproval;
        taskEntry.set("name", wbs.get("name"));
        DynamicObject projectStatus = wbs.getDynamicObject("projectstatus");
        taskEntry.set("projectstatus", (Object)projectStatus);
        BigDecimal schedule = wbs.getBigDecimal("schedule");
        taskEntry.set("percent", (Object)schedule);
        taskEntry.set("wbs", (Object)wbs);
        taskEntry.set("number", (Object)wbs.getString("number"));
        taskEntry.set("relatedwbs", (Object)Boolean.TRUE);
        taskEntry.set("planstarttime", (Object)wbs.getDate("planstarttime"));
        taskEntry.set("planendtime", (Object)wbs.getDate("planendtime"));
        DynamicObject project = wbs.getDynamicObject("project");
        BigDecimal absoluteDuration = TaskUtil.getDaysBetweenTwoDate((Object)project.getPkValue(), (Date)wbs.getDate("planstarttime"), (Date)wbs.getDate("planendtime"), (String)this.getAppId());
        taskEntry.set("absoluteduration", (Object)absoluteDuration);
        taskEntry.set("enable", (Object)kd.pmgt.pmbs.common.enums.EnableEnum.ENABLE.getValue());
        QFilter taskSourceFilter = new QFilter("number", "=", (Object)TaskTypeEnum.KEYNODE.getValue());
        DynamicObject taskSource = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"tasktype"), (String)"id", (QFilter[])new QFilter[]{taskSourceFilter});
        taskEntry.set("tasktype", (Object)taskSource);
        if (projectStatus == null) {
            return;
        }
        if (BigDecimal.valueOf(100L).compareTo(schedule) == 0 && (projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"auditdate", (QFilter[])(projectFilter = new QFilter("pro", "=", project.getPkValue())).toArray())) != null) {
            taskEntry.set("realendtime", (Object)projectApproval.getDate("auditdate"));
        }
    }

    private DynamicObject[] getProStatus(DynamicObject project) {
        QFilter projectIdFilter = new QFilter("project", "=", project.getPkValue());
        String selectProperties = String.join((CharSequence)",", "project", "projectstage", "statuspercent");
        return BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)selectProperties, (QFilter[])projectIdFilter.toArray(), (String)"projectstage.serial");
    }

    private boolean updateEntityPercent(boolean needUpdate, StringBuilder tipsMsg, DynamicObject taskEntry, BigDecimal statusPercent) {
        BigDecimal schedule = taskEntry.getBigDecimal("percent");
        if (statusPercent.compareTo(schedule) != 0) {
            needUpdate = true;
            tipsMsg.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u7684\u5b8c\u6210\u767e\u5206\u6bd4\u5df2\u52a0\u8f7d\u4e3a\u6700\u65b0\u6570\u636e\u3002", (String)"PmMasterPlanEditPlugin_39", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), taskEntry.getString("name")));
            tipsMsg.append("\n");
            taskEntry.set("percent", (Object)statusPercent);
            if (statusPercent.compareTo(BigDecimal.valueOf(100L)) == 0) {
                taskEntry.set("realendtime", (Object)new Date());
            }
        }
        return needUpdate;
    }

    protected void upgradeOperation(int[] selRows) {
        int parentIndex;
        if (selRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5347\u7ea7\u7684\u884c\u3002", (String)"PmMasterPlanEditPlugin_40", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        int curIndex = selRows[0];
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        DynamicObject task = (DynamicObject)entries.get(curIndex);
        DynamicObject proStage = task.getDynamicObject("projectstatus");
        DynamicObject wbs = task.getDynamicObject("wbs");
        if (wbs != null && wbs.getInt("level") == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u4efb\u52a1\u4e3aWBS\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"PmMasterPlanEditPlugin_41", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        if (proStage != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4efb\u52a1\u4e3a\u9879\u76ee\u9636\u6bb5\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"PmMasterPlanEditPlugin_17", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject preTask = task.getDynamicObject("pretask");
        if (preTask != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u4efb\u52a1\u5b58\u5728\u524d\u7f6e\u4efb\u52a1\uff0c\u4e0d\u80fd\u5347\u7ea7\u3002", (String)"PmMasterPlanEditPlugin_18", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
        }
        String parentPk = task.getString("pid");
        for (int index = parentIndex = curIndex - 1; index >= 0; --index) {
            DynamicObject entry = (DynamicObject)entries.get(index);
            if (!kd.bos.dataentity.utils.StringUtils.equals((CharSequence)entry.getPkValue().toString(), (CharSequence)parentPk)) continue;
            parentIndex = index;
            break;
        }
        TreeEntryUtils.upgradeRow((IFormView)this.getView(), (IDataModel)this.getModel(), (int[])selRows, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)this.getAppId());
        this.settingTimeByChildren(parentIndex);
    }

    private void settingTimeByChildren(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        DynamicObject row = this.getModel().getEntryRowEntity("taskentity", rowIndex);
        long id = Long.parseLong(row.getPkValue().toString());
        if (id == 0L) {
            return;
        }
        Date firstStartTime = null;
        for (Object entry : entries) {
            Date planStartTime;
            Long parentId = entry.getLong("pid");
            if (parentId == 0L || id != parentId || null == (planStartTime = entry.getDate("planstarttime"))) continue;
            if (null == firstStartTime) {
                firstStartTime = planStartTime;
            }
            firstStartTime = planStartTime.compareTo(firstStartTime) < 0 ? planStartTime : firstStartTime;
        }
        if (null != firstStartTime) {
            this.getModel().setValue("planstarttime", firstStartTime, rowIndex);
        }
        Date lastEndTime = null;
        for (DynamicObject entry : entries) {
            Date planEndTime;
            Long parentId = entry.getLong("pid");
            if (parentId == 0L || id != parentId || null == (planEndTime = entry.getDate("planendtime"))) continue;
            if (null == lastEndTime) {
                lastEndTime = planEndTime;
            }
            lastEndTime = planEndTime.compareTo(lastEndTime) > 0 ? planEndTime : lastEndTime;
        }
        if (null != lastEndTime) {
            this.getModel().setValue("planendtime", lastEndTime, rowIndex);
        }
        Date lastAimfinishtime = null;
        for (DynamicObject entry : entries) {
            Date planAimfinishTime;
            Long parentId = entry.getLong("pid");
            if (parentId == 0L || id != parentId || null == (planAimfinishTime = entry.getDate("aimfinishtime"))) continue;
            if (null == lastAimfinishtime) {
                lastAimfinishtime = planAimfinishTime;
            }
            lastAimfinishtime = planAimfinishTime.compareTo(lastAimfinishtime) > 0 ? planAimfinishTime : lastAimfinishtime;
        }
        if (null != lastAimfinishtime) {
            this.getModel().setValue("aimfinishtime", lastAimfinishtime, rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("showProjectListCallBack".equalsIgnoreCase(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getView().getPageCache().remove("oldProject");
                String projectId = this.getView().getPageCache().get("projectPk");
                Long projectPk = Long.parseLong(projectId);
                this.getView().getPageCache().remove("projectPk");
                this.switchProject(projectPk);
            } else {
                String oldProject = this.getView().getPageCache().get("oldProject");
                if (oldProject != null) {
                    DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(oldProject), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"));
                    this.getModel().setValue("project", (Object)project);
                } else {
                    this.getModel().setValue("project", null);
                }
            }
        } else if (callBackId.equals(DELETE_TASK_CONFIRM)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
                int[] selRows = grid.getSelectRows();
                HashSet<Integer> selectRows = new HashSet<Integer>(16);
                for (int row : selRows) {
                    selectRows.add(row);
                    this.selectChildren(row, selectRows);
                }
                selRows = selectRows.stream().mapToInt(Integer::valueOf).toArray();
                this.deleteTaskCheck(selRows);
                HashSet<String> deletepks = new HashSet<String>(selRows.length);
                for (int selectRow : selRows) {
                    DynamicObject entry = this.getModel().getEntryRowEntity("taskentity", selectRow);
                    String pkvalue = entry.getPkValue().toString();
                    deletepks.add(pkvalue);
                }
                this.deletePreTask(deletepks);
                this.getModel().deleteEntryRows("taskentity", selRows);
                this.getModel().updateCache();
                this.rebuildTreeStructure();
                this.afterDeleteTask();
                this.getView().updateView("taskentity");
                int entryRowNum = this.getModel().getEntryEntity("taskentity").getRowCount();
                if (entryRowNum == 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"advconap2"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
                }
            }
        } else if ("importtask".equalsIgnoreCase(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.importTaskOperation();
            }
        } else if (NEW_TASK_CONFIRM.equalsIgnoreCase(callBackId)) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl("taskentity");
            int[] selRows = grid.getSelectRows();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                HashSet<String> deletepks = new HashSet<String>(selRows.length);
                for (int selectRow : selRows) {
                    DynamicObject entry = this.getModel().getEntryRowEntity("taskentity", selectRow);
                    String pidPkValue = entry.getString("pid");
                    deletepks.add(pidPkValue);
                }
                this.deletePreTask(deletepks);
            } else {
                this.getModel().deleteEntryRows("taskentity", selRows);
            }
            this.getModel().updateCache();
            this.rebuildTreeStructure();
            this.getView().updateView("taskentity");
        } else {
            new OperationStrategy(callBackId).confirmCallBack((AbstractPlacsBillAdapter)this, messageBoxClosedEvent);
        }
    }

    private void selectChildren(int row, Set<Integer> selectRows) {
        int count = this.getModel().getEntryRowCount("taskentity");
        String pkId = this.getModel().getEntryRowEntity("taskentity", row).getPkValue().toString();
        for (int index = row + 1; index < count; ++index) {
            DynamicObject task = this.getModel().getEntryRowEntity("taskentity", index);
            if (!task.getString("pid").equals(pkId)) continue;
            selectRows.add(index);
            this.selectChildren(index, selectRows);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("templatefile".equals(fieldName)) {
            PmPlanAchieveHelper.downLoadTemplateFile((IFormView)this.getView(), (String)"taskresultdocentry", (String)"attachtype");
        }
    }

    protected Date getDateAfterAddRelativeDays(Object projectId, Date preTaskPlanEndTime, Integer relativeDuration, String appId) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        return TaskUtil.getDateAfterAddRelativeDays((Object)projectId, (Object)org.getPkValue(), (Date)preTaskPlanEndTime, (int)relativeDuration, (String)appId);
    }

    protected BigDecimal getDaysBetweenTwoDate(Object projectId, Date planStartTime, Date planEndTime, String appId) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        return TaskUtil.getDaysBetweenTwoDate((Object)projectId, (Object)org.getPkValue(), (Date)planStartTime, (Date)planEndTime, (String)appId);
    }

    protected Date getDateAfterAddDays(Object projectId, Date planStartTime, Integer relativeDuration, String appId) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        return TaskUtil.getDateAfterAddDays((Object)projectId, (Object)org.getPkValue(), (Date)planStartTime, (int)relativeDuration, (String)appId);
    }

    protected void setDateEditRange() {
        DateEdit planStartTime = (DateEdit)this.getControl("planstarttime");
        DateEdit planEndTime = (DateEdit)this.getControl("planendtime");
        DateEdit aimFinishTime = (DateEdit)this.getControl("aimfinishtime");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        if (project != null && org != null) {
            Object projectId = project.getPkValue();
            Date firstDay = TaskUtil.getFirstDayByProAndOrg((Object)projectId, (Object)org.getPkValue(), (String)this.getAppId()).getTime();
            Date endDay = TaskUtil.getEndDayByProjectAndOrg((Object)projectId, (Object)org.getPkValue(), (String)this.getAppId()).getTime();
            planStartTime.setMinDate(firstDay);
            planStartTime.setMaxDate(endDay);
            planEndTime.setMinDate(firstDay);
            planEndTime.setMaxDate(endDay);
            aimFinishTime.setMinDate(firstDay);
            aimFinishTime.setMaxDate(endDay);
        }
    }
}

