/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.model.TaskConstant;
import kd.pccs.placs.common.enums.CompletionStatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.common.utils.poi.POIHelper;
import kd.pccs.placs.formplugin.ProMeetTaskMonitorListPlugin;

public class PmProMeetTaskMonitorListPlugin
extends ProMeetTaskMonitorListPlugin {
    protected static String[] COLUMNKEY = new String[]{"taskname", "tasknumber", "completionstatus", "meetassigncount", "tasksource", "project", "controllevelname", "majortypename", "tasktype", "absoluteduration", "percent", "completedescription", "pretaskname", "planstarttime", "planendtime", "realendtime", "responsiblepersonname", "responsibledeptname", "cooperationpersonsname", "cooperationdeptname"};
    protected String[] header = new String[]{ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"PmProMeetTaskMonitorListPlugin_0", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u7801", (String)"PmProMeetTaskMonitorListPlugin_1", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"PmProMeetTaskMonitorListPlugin_2", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f1a\u8bae\u51b3\u8bae", (String)"PmProMeetTaskMonitorListPlugin_2", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u6765\u6e90", (String)"PmProMeetTaskMonitorListPlugin_3", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9879\u76ee", (String)"PmProMeetTaskMonitorListPlugin_4", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ba1\u63a7\u7ea7\u522b", (String)"PmProMeetTaskMonitorListPlugin_5", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e13\u4e1a\u7c7b\u578b", (String)"PmProMeetTaskMonitorListPlugin_6", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b", (String)"PmProMeetTaskMonitorListPlugin_7", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edd\u5bf9\u5de5\u671f", (String)"PmProMeetTaskMonitorListPlugin_8", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fdb\u5ea6(%)", (String)"PmProMeetTaskMonitorListPlugin_9", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210\u60c5\u51b5\u8bf4\u660e", (String)"PmProMeetTaskMonitorListPlugin_10", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u524d\u7f6e\u4efb\u52a1", (String)"PmProMeetTaskMonitorListPlugin_11", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"PmProMeetTaskMonitorListPlugin_12", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"PmProMeetTaskMonitorListPlugin_13", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (String)"PmProMeetTaskMonitorListPlugin_14", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u4eba", (String)"PmProMeetTaskMonitorListPlugin_15", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d23\u4efb\u90e8\u95e8", (String)"PmProMeetTaskMonitorListPlugin_16", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u4eba", (String)"PmProMeetTaskMonitorListPlugin_17", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u534f\u529e\u90e8\u95e8", (String)"PmProMeetTaskMonitorListPlugin_18", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0])};

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if ("pm-export".equals(operateKey)) {
            this.doExportExcel(selectedRows);
        }
    }

    protected void doExportExcel(ListSelectedRowCollection selectedRows) {
        if (!selectedRows.isEmpty()) {
            DynamicObject[] tasks;
            JSONArray data = new JSONArray();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            ArrayList<Long> taskIds = new ArrayList<Long>();
            for (DynamicObject[] selectedRow : selectedRows) {
                Long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
                taskIds.add(primaryKeyValue);
            }
            for (DynamicObject task : tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)String.join((CharSequence)",", TaskConstant.AllProperty, "meetassigncount", "completionstatus"), (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)})) {
                JSONObject obj = new JSONObject();
                obj.put(COLUMNKEY[0], (Object)task.getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[1], (Object)task.getString("number"));
                obj.put(COLUMNKEY[2], (Object)CompletionStatusEnum.getEnumByValue((Object)task.get("completionstatus")).getName());
                obj.put(COLUMNKEY[3], (Object)task.getBigDecimal("meetassigncount").setScale(0, RoundingMode.HALF_UP));
                obj.put(COLUMNKEY[4], task.getDynamicObject("tasksource") == null ? null : task.getDynamicObject("tasksource").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[5], task.getDynamicObject("project") == null ? null : task.getDynamicObject("project").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[6], task.getDynamicObject("controllevel") == null ? null : task.getDynamicObject("controllevel").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[7], task.getDynamicObject("majortype") == null ? null : task.getDynamicObject("majortype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[8], task.getDynamicObject("tasktype") == null ? null : task.getDynamicObject("tasktype").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[9], (Object)task.getInt("absoluteduration"));
                obj.put(COLUMNKEY[10], (Object)task.getBigDecimal("percent").setScale(2));
                obj.put(COLUMNKEY[11], (Object)task.getString("completedescription"));
                obj.put(COLUMNKEY[12], task.getDynamicObject("pretask") == null ? null : task.getDynamicObject("pretask").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[13], (Object)sdf.format(task.getDate("planstarttime")));
                obj.put(COLUMNKEY[14], (Object)sdf.format(task.getDate("planendtime")));
                obj.put(COLUMNKEY[15], task.getDate("realendtime") == null ? null : sdf.format(task.getDate("realendtime")));
                obj.put(COLUMNKEY[16], task.getDynamicObject("responsibleperson") == null ? null : task.getDynamicObject("responsibleperson").getLocaleString("name").getLocaleValue_zh_CN());
                obj.put(COLUMNKEY[17], task.getDynamicObject("responsibledept") == null ? null : task.getDynamicObject("responsibledept").getLocaleString("name").getLocaleValue_zh_CN());
                DynamicObjectCollection cooPersons = task.getDynamicObjectCollection("multicooperationperson");
                List names = cooPersons.stream().map(o -> o.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
                obj.put(COLUMNKEY[18], (Object)String.join((CharSequence)";", names));
                DynamicObjectCollection cooDepts = task.getDynamicObjectCollection("multicooperationdept");
                List deptNames = cooDepts.stream().map(o -> o.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
                obj.put(COLUMNKEY[19], (Object)String.join((CharSequence)";", deptNames));
                data.add((Object)obj);
            }
            String url = POIHelper.exportExcel((String)this.getFileName(), (String)this.getSheetName(), (String[])this.getHeader(), (String[])COLUMNKEY, null, (JSONArray)data);
            this.getView().download(url);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"PmProMeetTaskMonitorListPlugin_23", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
        }
    }

    private String getFileName() {
        return ResManager.loadKDString((String)"\u9879\u76ee\u4f1a\u8bae\u8ddf\u8e2a", (String)"PmProMeetTaskMonitorListPlugin_20", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]);
    }

    private String getSheetName() {
        return ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868", (String)"PmProMeetTaskMonitorListPlugin_21", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]);
    }

    private String[] getHeader() {
        return this.header;
    }
}

