/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.common.enums.DefaultEnum;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.ProResultDocTrackListPlugin;
import kd.pmgt.pmbs.business.helper.ProjectHelper;
import pmgt.pmpt.business.PmPlanAchieveHelper;

public class PmProResultDocTrackListPlugin
extends ProResultDocTrackListPlugin
implements ListRowClickListener,
BeforeBindDataListener,
AfterBindDataListener {
    private static final String BILLLISTID = "billlistap";
    private static final String KEY_SEARCH = "search";
    private static final String CODE_QUERYCLICK = "queryclick";
    private static final String COL_RESULTNAME = "resultname";
    private static final String FEAS_REPORT_SEARCH = "feas_report_search";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{new QFilter("pro", "=", beforeF7ViewDetailEvent.getPkId())});
            if (bills.length > 0) {
                beforeF7ViewDetailEvent.setCancel(true);
                this.getView().showForm((FormShowParameter)ProjectHelper.getProjectDetailShowParameter((Object)bills[0].getPkValue()));
            }
        });
        BillList billlist = (BillList)this.getControl(BILLLISTID);
        billlist.addListRowClickListener((ListRowClickListener)this);
        billlist.addBeforeBindDataListener((BeforeBindDataListener)this);
        billlist.addAfterBindDataListener((AfterBindDataListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"project")) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project == null) {
                return;
            }
            this.getModel().setValue("org", (Object)project.getDynamicObject("pmascreateorg"));
            this.getModel().setValue("project", (Object)project);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Label label = (Label)this.getControl("labelap");
        if (label != null) {
            label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"PmProResultDocTrackListPlugin_0", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("textfield", (Object)"true");
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        if (null == currentListSelectedRow) {
            return;
        }
        Object taskId = currentListSelectedRow.getPrimaryKeyValue();
        this.showDoc(taskId);
    }

    protected void showDoc(Object taskId) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        DynamicObject sourceTask = task.getDynamicObject("sourcetask");
        QFilter sourceFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id", (QFilter[])new QFilter[]{sourceFilter});
        QFilter taskIn = new QFilter("task", "in", Arrays.stream(tasks).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter fininshed = new QFilter("percent", "=", (Object)100);
        DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)"task,percent", (QFilter[])new QFilter[]{taskIn, taskreportStatus, fininshed});
        if (taskReports.length > 0) {
            // empty if block
        }
        QFilter taskid = new QFilter("task", "=", task.getPkValue());
        QFilter[] filters = new QFilter[]{taskid, taskreportStatus};
        taskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)(ProgressReportConstant.AllProperty + "achieveentity.id,achieveentity.attachmentfield,achieveentity.resultname,achieveentity.desc,achieveentity.force,achieveentity.resultid,achieveentity.frequency,attachtype,templatefile"), (QFilter[])filters, (String)"modifytime desc");
        DynamicObjectCollection taskDocEntry = task.getDynamicObjectCollection("taskresultdocentry");
        this.setAchievementAttach(taskDocEntry, taskReports);
        this.getView().updateView("entryentity");
    }

    protected void setAchievementAttach(DynamicObjectCollection taskDocEntry, DynamicObject[] taskReports) {
        HashMap<String, DynamicObject> newMap = new HashMap<String, DynamicObject>();
        HashMap oldMap = new HashMap();
        for (int i = 0; i < taskReports.length; ++i) {
            DynamicObjectCollection huibaoEntrys = taskReports[i].getDynamicObjectCollection("achieveentity");
            if (i == 0) {
                for (DynamicObject entry : huibaoEntrys) {
                    newMap.put(entry.get("resultid").toString(), entry);
                }
                continue;
            }
            for (DynamicObject entry : huibaoEntrys) {
                String resultId = entry.get("resultid").toString();
                List resultIds = (List)oldMap.get(resultId);
                if (null != resultIds) {
                    resultIds.add(entry);
                    continue;
                }
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                list.add(entry);
                oldMap.put(resultId, list);
            }
        }
        this.getModel().deleteEntryData("entryentity");
        for (DynamicObject taskDoc : taskDocEntry) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            DynamicObject newEntry = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            this.setHistoryAchievement(taskDoc, rowIndex);
            if (null != newMap.get(taskDoc.getPkValue().toString())) {
                DynamicObject huibaoEntry = (DynamicObject)newMap.get(taskDoc.getPkValue().toString());
                newEntry.set("newattachment", (Object)huibaoEntry.getDynamicObjectCollection("attachmentfield"));
            }
            if (null == oldMap.get(taskDoc.getPkValue().toString())) continue;
            List huibaoentryS = (List)oldMap.get(taskDoc.getPkValue().toString());
            DynamicObjectCollection historyC = new DynamicObjectCollection();
            for (DynamicObject huibaoentry : huibaoentryS) {
                historyC.addAll((Collection)huibaoentry.getDynamicObjectCollection("attachmentfield"));
            }
            newEntry.set("historyattachment", (Object)historyC);
        }
    }

    protected void setHistoryAchievement(DynamicObject cg, int rowIndex) {
        this.getModel().setValue("cgresultname", cg.get(COL_RESULTNAME), rowIndex);
        this.getModel().setValue("cgattachtype", cg.get("attachtype"), rowIndex);
        this.getModel().setValue("cgtemplatefile", cg.get("templatefile"), rowIndex);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
    }

    protected void beforeProjectF7(BeforeF7SelectEvent beforeF7SelectEvent) {
        System.out.println();
    }

    public void afterBindData(EventObject e) {
        Object orgIdparma = this.getView().getFormShowParameter().getCustomParam("orgId");
        Object planTypeId = this.getView().getFormShowParameter().getCustomParam("planTypeId");
        Object proId = this.getView().getFormShowParameter().getCustomParam("proId");
        Object sourceOpen = this.getView().getFormShowParameter().getCustomParam("source");
        String beFirst = this.getPageCache().get("beFirst");
        if (null != orgIdparma && null != planTypeId && null != proId) {
            this.getModel().setValue("org", orgIdparma);
            this.getModel().setValue("project", proId);
            BillList billList = (BillList)this.getControl(BILLLISTID);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter majortype = new QFilter("majortype", "=", planTypeId);
            QFilter planVersion = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
            QFilter proPlan = new QFilter("project", "=", proId);
            DynamicObject[] plans = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"id,taskentity,taskentity.taskid", (QFilter[])new QFilter[]{majortype, planVersion, proPlan});
            HashSet<Object> allTaskids = new HashSet<Object>();
            for (DynamicObject plan : plans) {
                DynamicObjectCollection taskentries = plan.getDynamicObjectCollection("taskentity");
                if (taskentries == null || taskentries.size() <= 0) continue;
                for (DynamicObject entry : taskentries) {
                    Object id = entry.getPkValue();
                    allTaskids.add(id);
                }
            }
            QFilter projectFilter = new QFilter("id", "in", allTaskids);
            qFilters.add(projectFilter);
            billList.getFilterParameter().setQFilters(qFilters);
            billList.getFilterParameter().setOrderBy("majorname asc,name asc");
            billList.refreshData();
            this.getView().updateView("project");
            this.getView().updateView("org");
            this.getView().invokeOperation(KEY_SEARCH);
        } else if ("masterplan".equals(sourceOpen) && null != orgIdparma && null != proId && (beFirst == null || beFirst.equals("true"))) {
            this.getModel().setValue("org", orgIdparma);
            this.getModel().setValue("project", proId);
            this.getView().updateView("project");
            this.getView().updateView("org");
            this.getView().invokeOperation(KEY_SEARCH);
            this.getPageCache().put("beFirst", "false");
        }
        String entityId = this.getView().getParentView().getEntityId();
        if (entityId.equals("pmfs_reportbill") || entityId.equals("pmfs_majorapproval")) {
            Object orgId = this.getView().getFormShowParameter().getCustomParam("orgId");
            proId = this.getView().getFormShowParameter().getCustomParam("proId");
            this.getModel().setValue("org", orgId);
            this.getModel().setValue("project", proId);
            this.getView().updateView("project");
            this.getView().updateView("org");
            this.getPageCache().put(FEAS_REPORT_SEARCH, String.valueOf(Boolean.TRUE));
            this.getView().invokeOperation(KEY_SEARCH);
            this.getPageCache().put("pmFirst", "false");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (CODE_QUERYCLICK.equals(operateKey)) {
            String textField = (String)this.getModel().getValue("textfield");
            Label label = (Label)this.getControl("labelap");
            if (StringUtils.equals((CharSequence)textField, (CharSequence)"false")) {
                label.setText(ResManager.loadKDString((String)"\u6536\u8d77\u67e5\u8be2\u6761\u4ef6", (String)"PmProResultDocTrackListPlugin_0", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)"true");
            } else {
                label.setText(ResManager.loadKDString((String)"\u5c55\u5f00\u67e5\u8be2\u6761\u4ef6", (String)"PmProResultDocTrackListPlugin_1", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("textfield", (Object)"false");
            }
        } else if (KEY_SEARCH.equals(operateKey)) {
            this.doSearch(args);
        }
    }

    protected void doSearch(BeforeDoOperationEventArgs args) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"PmProResultDocTrackListPlugin_2", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
            return;
        }
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"PmProResultDocTrackListPlugin_3", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
            return;
        }
        BillList billList = (BillList)this.getControl(BILLLISTID);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter projectFilter = new QFilter("project.id", "=", project.getPkValue());
        qFilters.add(projectFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilters.add(statusFilter);
        QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)"1").and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
        qFilters.add(latestTaskFilter);
        QFilter txTypeFilter = this.getTxTypeFilter();
        qFilters.add(txTypeFilter);
        QFilter isForceFilter = new QFilter("taskresultdocentry.force", "=", (Object)DefaultEnum.YES.getValue());
        qFilters.add(isForceFilter);
        if (Boolean.parseBoolean(this.getPageCache().get(FEAS_REPORT_SEARCH))) {
            QFilter majorTypeFilter = new QFilter("majortype.number", "like", (Object)"%FEASIBILITYSTUDY_S").and("majortype.issysfield", "=", (Object)Boolean.TRUE);
            qFilters.add(majorTypeFilter);
            this.getPageCache().put(FEAS_REPORT_SEARCH, String.valueOf(Boolean.FALSE));
        }
        billList.getFilterParameter().setQFilters(qFilters);
        billList.getFilterParameter().setOrderBy("taskseq asc");
        billList.refreshData();
        this.configCellStyle();
    }

    protected void resultNameHyperLink(HyperLinkClickEvent args) {
        BillList taskBillList = (BillList)this.getControl(BILLLISTID);
        ListSelectedRowCollection rows = taskBillList.getCurrentListAllRowCollection();
        Optional<ListSelectedRow> currentRow = rows.stream().filter(row -> row.getRowKey() == args.getRowIndex()).findFirst();
        if (!currentRow.isPresent()) {
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        filters.add(statusFilter);
        Object taskid = currentRow.get().getPrimaryKeyValue();
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskid, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        DynamicObject sourceTask = task.getDynamicObject("sourcetask");
        QFilter sourceFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,taskresultdocentry", (QFilter[])new QFilter[]{sourceFilter});
        QFilter taskFilter = new QFilter("task", "in", Arrays.stream(tasks).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        filters.add(taskFilter);
        DynamicObject[] allTaskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)(ProgressReportConstant.AllProperty + "achieveentity.id,achieveentity.attachmentfield,achieveentity.resultname,achieveentity.desc,achieveentity.force,achieveentity.resultid,achieveentity.frequency,attachtype,templatefile"), (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"modifytime desc");
        filters.clear();
        Object entryId = currentRow.get().getEntryPrimaryKeyValue();
        ArrayList<Long> docEntryIdList = new ArrayList<Long>(10);
        taskFilter = new QFilter("task", "=", taskid);
        filters.add(taskFilter);
        filters.add(statusFilter);
        DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)(ProgressReportConstant.AllProperty + "achieveentity.id,achieveentity.attachmentfield,achieveentity.resultname,achieveentity.desc,achieveentity.force,achieveentity.resultid,achieveentity.frequency,attachtype,templatefile"), (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"modifytime desc");
        if (taskReports == null || taskReports.length == 0) {
            if (allTaskReports == null || allTaskReports.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5c1a\u672a\u5f00\u59cb\u6c47\u62a5\u3002", (String)"PmProResultDocTrackListPlugin_10", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u88ab\u8c03\u6574\uff0c\u4e14\u6700\u65b0\u4efb\u52a1\u6682\u65f6\u672a\u8fdb\u884c\u6c47\u62a5\uff0c\u5982\u9700\u4e0b\u8f7d\u6210\u679c\u6587\u6863\uff0c\u8bf7\u70b9\u4efb\u52a1\u540d\u79f0\u7a7f\u900f\u81f3\u201c\u4efb\u52a1\u67e5\u770b\u201d\u8fdb\u884c\u6c47\u62a5\u3002", (String)"PmProResultDocTrackListPlugin_11", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        for (DynamicObject report : taskReports) {
            DynamicObjectCollection entries = report.getDynamicObjectCollection("achieveentity");
            if (entries.isEmpty()) continue;
            for (DynamicObject resultDoc : entries) {
                if (!entryId.toString().equals(resultDoc.getString("resultid"))) continue;
                docEntryIdList.add((Long)resultDoc.getPkValue());
            }
        }
        if (docEntryIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6682\u672a\u4e0a\u4f20\u6587\u6863\uff0c\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"PmProResultDocTrackListPlugin_6", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        List results = new ArrayList();
        for (Long docEntryId : docEntryIdList) {
            if (!results.isEmpty()) break;
            String sqlText = "SELECT FBASEDATAID FROM T_PMPT_UPLOADDOC WHERE FENTRYID = ?";
            results = (List)DB.query((DBRoute)new DBRoute("cr"), (String)sqlText, (Object[])new Object[]{docEntryId}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> result = new ArrayList<String>(10);
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                    return result;
                }
            });
        }
        if (results == null || results.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6682\u672a\u4e0a\u4f20\u6587\u6863\uff0c\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"PmProResultDocTrackListPlugin_6", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        for (String baseDataId : results) {
            String sql = "SELECT FURL FROM T_BD_ATTACHMENT WHERE FID = ?";
            List files = (List)DB.query((DBRoute)new DBRoute("basedata"), (String)sql, (Object[])new Object[]{Long.parseLong(baseDataId)}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> result = new ArrayList<String>(10);
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                    return result;
                }
            });
            String attUrl = EncreptSessionUtils.encryptSession((String)UrlService.getAttachmentFullUrl((String)((String)files.get(0))));
            this.getView().download(attUrl);
        }
    }

    protected void configCellStyle() {
        BillList taskBillList = (BillList)this.getControl(BILLLISTID);
        ListSelectedRowCollection rows = taskBillList.getCurrentListAllRowCollection();
        if (rows.isEmpty()) {
            return;
        }
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            ListSelectedRow taskRow = rows.get(rowIndex);
            Object taskid = taskRow.getPrimaryKeyValue();
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(rowIndex);
            cellStyle.setFieldKey(COL_RESULTNAME);
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskid, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            QFilter sourceFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)"id,taskresultdocentry", (QFilter[])new QFilter[]{sourceFilter});
            ArrayList<String> entryIds = new ArrayList<String>();
            for (DynamicObject dynamicObject : tasks) {
                for (DynamicObject[] object : dynamicObject.getDynamicObjectCollection("taskresultdocentry")) {
                    entryIds.add(String.valueOf(object.getPkValue()));
                }
            }
            ArrayList<Object> docEntryIdList = new ArrayList<Object>(10);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            QFilter taskFilter = new QFilter("task", "in", Arrays.stream(tasks).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            filters.add(taskFilter);
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            filters.add(statusFilter);
            DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)(ProgressReportConstant.AllProperty + "achieveentity.id,achieveentity.attachmentfield,achieveentity.resultname,achieveentity.desc,achieveentity.force,achieveentity.resultid,achieveentity.frequency,attachtype,templatefile"), (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"modifytime desc");
            if (taskReports != null && taskReports.length != 0) {
                for (DynamicObject report : taskReports) {
                    if (report.getBigDecimal("percent").compareTo(new BigDecimal("100")) == 0) {
                        cellStyle.setBackColor("lightgreen");
                        break;
                    }
                    DynamicObjectCollection entries = report.getDynamicObjectCollection("achieveentity");
                    if (!entries.isEmpty()) {
                        for (DynamicObject resultDoc : entries) {
                            if (!entryIds.contains(resultDoc.getString("resultid"))) continue;
                            docEntryIdList.add(resultDoc.getPkValue());
                            break;
                        }
                    }
                    List results = new ArrayList();
                    if (!docEntryIdList.isEmpty()) {
                        SqlBuilder sqlBuilder = new SqlBuilder();
                        sqlBuilder.append("SELECT FBASEDATAID FROM T_PMPT_UPLOADDOC WHERE ", new Object[0]);
                        sqlBuilder.appendIn("FENTRYID", docEntryIdList);
                        results = (List)DB.query((DBRoute)new DBRoute("cr"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                            public List<String> handle(ResultSet rs) throws Exception {
                                ArrayList<String> result = new ArrayList<String>(10);
                                while (rs.next()) {
                                    result.add(rs.getString(1));
                                }
                                return result;
                            }
                        });
                    }
                    if (results.size() != 0) continue;
                    cellStyle.setBackColor("lightgrey");
                }
            } else {
                cellStyle.setBackColor("lightgrey");
            }
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
            cellStyles.add(cellStyle);
            taskBillList.setCellStyle(cellStyles);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if (COL_RESULTNAME.equals(fieldName)) {
            this.resultNameHyperLink(args);
        } else if ("name".equals(fieldName)) {
            BillList taskbilllist = (BillList)this.getControl(BILLLISTID);
            ListSelectedRow row = taskbilllist.getCurrentSelectedRowInfo();
            Long taskPk = (Long)row.getPrimaryKeyValue();
            if (taskPk != null) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("formId", "pmpt_reporttaskview");
                paramMap.put("pkId", String.valueOf(taskPk));
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\u3002", (String)"PmProResultDocTrackListPlugin_8", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        } else if ("cgtemplatefile".equals(fieldName)) {
            PmPlanAchieveHelper.downLoadTemplateFile((IFormView)this.getView(), (String)"entryentity", (String)"cgattachtype");
        }
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (org == null || project == null) {
            return;
        }
        BillList billList = (BillList)this.getControl(BILLLISTID);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter projectFilter = new QFilter("project.id", "=", project.getPkValue());
        qFilters.add(projectFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilters.add(statusFilter);
        QFilter latestTaskFilter = new QFilter("islatest", "=", (Object)"1").and("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("relationtask", "=", (Object)0);
        qFilters.add(latestTaskFilter);
        QFilter txTypeFilter = this.getTxTypeFilter();
        qFilters.add(txTypeFilter);
        QFilter isForceFilter = new QFilter("taskresultdocentry.force", "=", (Object)DefaultEnum.YES.getValue());
        qFilters.add(isForceFilter);
        if (Boolean.parseBoolean(this.getPageCache().get(FEAS_REPORT_SEARCH))) {
            QFilter majorTypeFilter = new QFilter("majortype.number", "like", (Object)"%FEASIBILITYSTUDY_S").and("majortype.issysfield", "=", (Object)Boolean.TRUE);
            qFilters.add(majorTypeFilter);
            this.getPageCache().put(FEAS_REPORT_SEARCH, String.valueOf(Boolean.FALSE));
        }
        billList.getFilterParameter().setQFilters(qFilters);
        billList.getFilterParameter().setOrderBy("taskseq asc");
    }

    public void afterBindData(AfterBindDataEvent afterBindDataEvent) {
        this.configCellStyle();
    }
}

