/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.common.enums.TransactionTypeEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.ProgressReportFormPlugin;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import pmgt.pmpt.business.PmPlanAchieveHelper;

public class PmProgressReportFormPlugin
extends ProgressReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid achieveentity = (EntryGrid)this.getControl("achieveentity");
        achieveentity.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid taskresultdocentry = (EntryGrid)this.getControl("taskresultdocentry");
        taskresultdocentry.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected ListFilterParameter setProjectListFilter() {
        ListFilterParameter listFilterParameter = super.setProjectListFilter();
        DynamicObject[] projects = ProjectPermissionHelper.getPermProjectByStatus((List)this.getAllPermOrgs(), (boolean)true, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"masterplan"), (String)"view", null);
        List projectPks = Arrays.stream(projects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        listFilterParameter.getQFilters().add(new QFilter("id", "in", projectPks));
        return listFilterParameter;
    }

    protected void addReport(Map customMap) {
        Object taskId = customMap.get("taskId");
        DynamicObject task = BusinessDataServiceHelper.loadSingle(taskId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"));
        this.getModel().setValue("task", task.getPkValue());
        DynamicObject projectStatus = task.getDynamicObject("projectstatus");
        BigDecimal percentValue = projectStatus == null ? task.getBigDecimal("percent") : projectStatus.getBigDecimal("statuspercent");
        this.getModel().setValue("percent", (Object)percentValue);
        QFilter taskReportNew = new QFilter("latest", "=", (Object)Character.valueOf('1'));
        QFilter taskIdFilter = new QFilter("task", "=", task.getPkValue());
        QFilter taskReportStatusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter[] filters = new QFilter[]{taskIdFilter, taskReportStatusFilter, taskReportNew};
        DynamicObject[] taskReportObjs = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])filters);
        if (null != taskReportObjs && taskReportObjs.length > 0) {
            this.getModel().setValue("completetime", (Object)taskReportObjs[0].getDate("completetime"));
        } else {
            this.getModel().setValue("completetime", (Object)task.getDate("planendtime"));
        }
        this.updateTips();
        this.hideSubmit(task);
        if (null != customMap.get("person")) {
            this.setFieldByPersonType(customMap.get("person"));
        }
        this.setAchievement(task, null);
        this.setReportRecordEntry(task);
        this.isComplete(task);
        this.modifyPerson(task, "add");
        this.getView().setVisible(Boolean.FALSE, new String[]{"achieverecord"});
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"resultdate")) {
            Object taskreportId = this.getModel().getValue("taskreport", rowIndex);
            Object taskId = this.getModel().getValue("historytask", rowIndex);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"));
            map.put("pkId", taskreportId);
            map.put("taskId", taskId);
            map.put("hyper", taskId);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"templatefile")) {
            PmPlanAchieveHelper.downLoadTemplateFile((IFormView)this.getView(), (String)"achieveentity", (String)"attachtype");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"meettemplatefile")) {
            PmPlanAchieveHelper.downLoadTemplateFile((IFormView)this.getView(), (String)"taskresultdocentry", (String)"meetattachtype");
        }
    }

    private void setAchievement(DynamicObject task, String key) {
        boolean showResultEntry = false;
        DynamicObjectCollection txCollections = task.getDynamicObjectCollection("transactiontype");
        for (DynamicObject tx : txCollections) {
            Long baseDataId = tx.getLong("fbasedataid_id");
            DynamicObject txType = BusinessDataServiceHelper.loadSingle((Object)baseDataId, (String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"transactiontype"));
            if (!Objects.equals(TransactionTypeEnum.RESULT.getValue(), txType.get("number"))) continue;
            showResultEntry = true;
        }
        if (showResultEntry) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
            DynamicObjectCollection taskDocEntry = task.getDynamicObjectCollection("taskresultdocentry");
            if (StringUtils.equals((CharSequence)key, (CharSequence)"editchengguo")) {
                DynamicObjectCollection huibaocgEntry = this.getModel().getEntryEntity("achieveentity");
                HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
                for (DynamicObject entry : huibaocgEntry) {
                    map.put(entry.get("resultid").toString(), entry);
                }
                this.getModel().deleteEntryData("achieveentity");
                for (DynamicObject taskDoc : taskDocEntry) {
                    int rowIndex = this.getModel().createNewEntryRow("achieveentity");
                    DynamicObject newEntry = this.getModel().getEntryRowEntity("achieveentity", rowIndex);
                    newEntry.set("resultname", taskDoc.get("resultname"));
                    newEntry.set("force", taskDoc.get("force"));
                    newEntry.set("desc", taskDoc.get("resultdescription"));
                    newEntry.set("frequency", taskDoc.get("frequency"));
                    newEntry.set("resultid", taskDoc.getPkValue());
                    newEntry.set("attachtype", taskDoc.get("attachtype"));
                    newEntry.set("templatefile", taskDoc.get("templatefile"));
                    if (null == map.get(taskDoc.getPkValue().toString())) continue;
                    DynamicObject oldentry = (DynamicObject)map.get(taskDoc.getPkValue().toString());
                    newEntry.set("attachmentfield", (Object)oldentry.getDynamicObjectCollection("attachmentfield"));
                }
            } else {
                this.getModel().deleteEntryData("achieveentity");
                for (DynamicObject taskDoc : taskDocEntry) {
                    int rowIndex = this.getModel().createNewEntryRow("achieveentity");
                    this.setAchievement(taskDoc, rowIndex);
                }
            }
            this.getView().updateView("achieveentity");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
        }
    }

    protected void setAchievement(DynamicObject cg, int rowIndex) {
        this.getModel().setValue("resultname", cg.get("resultname"), rowIndex);
        this.getModel().setValue("force", cg.get("force"), rowIndex);
        this.getModel().setValue("desc", cg.get("resultdescription"), rowIndex);
        this.getModel().setValue("frequency", cg.get("frequency"), rowIndex);
        this.getModel().setValue("resultid", cg.getPkValue(), rowIndex);
        this.getModel().setValue("attachtype", cg.get("attachtype"), rowIndex);
        this.getModel().setValue("templatefile", cg.get("templatefile"), rowIndex);
    }

    protected void setFieldByPersonType(Object person) {
        int personType = (Integer)person;
        FieldEdit completeTime = (FieldEdit)this.getView().getControl("completetime");
        FieldEdit percent = (FieldEdit)this.getView().getControl("percent");
        if (personType == 2) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"iscomplete", "percent", "completetime"});
            percent.setMustInput(false);
            completeTime.setMustInput(false);
        } else {
            percent.setMustInput(true);
            completeTime.setMustInput(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String key = e.getProperty().getName();
        Object newValue = changeSet.getNewValue();
        switch (key) {
            case "meetattachtype": {
                DynamicObject attachType = (DynamicObject)newValue;
                PmPlanAchieveHelper.setTemplateFile((IFormView)this.getView(), (Integer)rowIndex, (String)"meettemplatefile", (DynamicObject)attachType, (String)"resultname1", (String)"taskresultdocentry");
                break;
            }
        }
    }
}

