/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.utils.TimeUtils;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.ProjWorkCalendarEntityPlugin;
import kd.pccs.placs.formplugin.ProjWorkCalendarLoadService;
import kd.pccs.placs.formplugin.base.AbstractPlacsFormPlugin;
import org.apache.commons.lang.ArrayUtils;

public class PmProjWorkCalendarEntityPlugin
extends AbstractPlacsFormPlugin {
    private static final Log log = LogFactory.getLog(ProjWorkCalendarEntityPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"btnsave"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IPageCache pageCache = this.getPageCache();
        DynamicObject dynamicObject = this.getDynamicObject();
        String oldExpiringYearFrom = dynamicObject.getString("expiringyearfrom");
        String oldExpiringMonthFrom = dynamicObject.getString("expiringmonthfrom");
        String oldExpiringYearTo = dynamicObject.getString("expiringyearto");
        String oldExpiringMonthTo = dynamicObject.getString("expiringmonthto");
        if (StringUtils.isNotEmpty((CharSequence)oldExpiringYearFrom) && StringUtils.isNotEmpty((CharSequence)oldExpiringMonthFrom) && StringUtils.isNotEmpty((CharSequence)oldExpiringYearTo) && StringUtils.isNotEmpty((CharSequence)oldExpiringMonthTo)) {
            hashMap.put("oldexpiringyearfrom", oldExpiringYearFrom);
            hashMap.put("oldexpiringmonthfrom", oldExpiringMonthFrom);
            hashMap.put("oldexpiringyearto", oldExpiringYearTo);
            hashMap.put("oldexpiringmonthto", oldExpiringMonthTo);
            pageCache.put(hashMap);
        }
        IDataModel model = this.getModel();
        boolean[] arrayRestDays = this.getRestDays(model);
        String restDays = ArrayUtils.toString((Object)arrayRestDays);
        pageCache.put("oldRestDays", restDays);
        if (StringUtils.isNotEmpty((CharSequence)oldExpiringMonthFrom)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"expiringmonthfrom"});
        }
        if (StringUtils.isNotEmpty((CharSequence)oldExpiringYearFrom)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"expiringyearfrom"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (!(source instanceof AbstractOperate)) {
            return;
        }
        AbstractOperate op = (AbstractOperate)source;
        if ("save".equalsIgnoreCase(op.getOperateKey())) {
            if (!this.getModel().getDataChanged()) {
                args.cancel = true;
                this.getView().close();
                return;
            }
            if (this.validate()) {
                boolean taskFlag;
                IDataModel model = this.getModel();
                String oldRestDays = this.getPageCache().get("oldRestDays");
                Map all = this.getPageCache().getAll();
                String oldExpiringYearFrom = (String)all.get("oldexpiringyearfrom");
                String expiringYearFrom = this.getModel().getValue("expiringyearfrom").toString();
                boolean[] arrRestDays = this.getRestDays(model);
                String restDays = ArrayUtils.toString((Object)arrRestDays);
                String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
                if (StringUtils.isNotEmpty((CharSequence)orgId) && StringUtils.isNotEmpty((CharSequence)expiringYearFrom) && StringUtils.isEmpty((CharSequence)oldExpiringYearFrom)) {
                    taskFlag = this.findTask();
                    if (taskFlag && StringUtils.isEmpty((CharSequence)this.getPageCache().get("saveflag"))) {
                        this.openTips();
                    }
                    if (taskFlag && StringUtils.isEmpty((CharSequence)this.getPageCache().get("saveflag"))) {
                        args.setCancel(true);
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)oldExpiringYearFrom) && !oldRestDays.equals(restDays)) {
                    taskFlag = this.findTask();
                    if (taskFlag && StringUtils.isEmpty((CharSequence)this.getPageCache().get("saveflag"))) {
                        this.openTips();
                    }
                    if (taskFlag && !StringUtils.isEmpty((CharSequence)oldExpiringYearFrom) && StringUtils.isEmpty((CharSequence)this.getPageCache().get("saveflag"))) {
                        args.setCancel(true);
                    }
                }
                log.debug("\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
                this.editOrgId();
                this.generateDate();
            } else {
                args.cancel = true;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("closesetcalendartip".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            String priority = closedCallBackEvent.getReturnData().toString();
            this.getPageCache().put("saveflag", "0");
            this.getModel().setValue("priority", (Object)priority);
            this.getView().invokeOperation("save");
            this.getView().close();
        }
    }

    protected void editOrgId() {
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
        String defaultProject = (String)this.getView().getFormShowParameter().getCustomParam("version");
        String parentId = (String)this.getView().getFormShowParameter().getCustomParam("parentid");
        if (orgId.contains("proj")) {
            String proj = orgId.split("proj")[0];
            this.getModel().setValue("project", (Object)proj);
            this.getModel().setValue("projectorg", (Object)parentId);
            this.getModel().setValue("createorg", (Object)parentId);
        } else if (StringUtils.isBlank((CharSequence)orgId)) {
            this.getModel().setValue("org", (Object)orgId);
            this.getModel().setValue("createorg", (Object)orgId);
            this.getModel().setValue("version", (Object)defaultProject);
        } else {
            this.getModel().setValue("org", (Object)orgId);
            this.getModel().setValue("createorg", (Object)orgId);
        }
    }

    protected boolean validate() {
        if (!this.dateExclusionValidate()) {
            return false;
        }
        if (!this.amTimeValidate()) {
            return false;
        }
        if (!this.pmTimeValidate()) {
            return false;
        }
        return this.expiringDateValidate();
    }

    protected boolean dateExclusionValidate() {
        boolean[] isHalfWorkDay;
        boolean result = true;
        boolean[] isRestDay = this.getRestDays(this.getModel());
        if (isRestDay.length != (isHalfWorkDay = this.getHalfWorkDays(this.getModel())).length) {
            return true;
        }
        for (int i = 0; i < isRestDay.length; ++i) {
            if (!isRestDay[i] || !isHalfWorkDay[i]) continue;
            result = false;
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u56fa\u5b9a\u4f11\u606f\u65e5\u548c\u534a\u5929\u5de5\u4f5c\u65e5\u4e0d\u80fd\u52fe\u9009\u540c\u4e00\u5929\u3002", (String)"PmProjWorkCalendarEntityPlugin_0", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            break;
        }
        return result;
    }

    protected boolean amTimeValidate() {
        DynamicObject obj = this.getDynamicObject();
        if (this.nullToZero(obj, "hourofbegintimeam") || this.nullToZero(obj, "minofbegintimeam") || this.nullToZero(obj, "hourofendtimeam") || this.nullToZero(obj, "minofendtimeam")) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u5728\u5de5\u4f5c\u65e5\u4e0a\u5348\u5f55\u5165\u65f6\u95f4\u3002", (String)"PmProjWorkCalendarEntityPlugin_1", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean result = TimeUtils.compareHourAndMinute((int)obj.getInt("hourofbegintimeam"), (int)obj.getInt("minofbegintimeam"), (int)obj.getInt("hourofendtimeam"), (int)obj.getInt("minofendtimeam"));
        if (!result) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5de5\u4f5c\u65e5\u4e0a\u5348\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"PmProjWorkCalendarEntityPlugin_2", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    protected boolean pmTimeValidate() {
        DynamicObject obj = this.getDynamicObject();
        if (this.nullToZero(obj, "hourofbegintimepm") || this.nullToZero(obj, "minofbegintimepm") || this.nullToZero(obj, "hourofendtimepm") || this.nullToZero(obj, "minofendtimepm")) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5fc5\u987b\u5f55\u5165\u201c\u5de5\u4f5c\u65e5\u4e0b\u5348\u65f6\u95f4\u201d\u3002", (String)"PmProjWorkCalendarEntityPlugin_3", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean result = TimeUtils.compareHourAndMinute((int)obj.getInt("hourofbegintimepm"), (int)obj.getInt("minofbegintimepm"), (int)obj.getInt("hourofendtimepm"), (int)obj.getInt("minofendtimepm"));
        if (!result) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u5de5\u4f5c\u65e5\u4e0b\u5348\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"PmProjWorkCalendarEntityPlugin_4", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    protected boolean nullToZero(DynamicObject obj, String propertyName) {
        Object property = obj.get(propertyName);
        if (property == null || property.toString().length() == 0) {
            obj.set(propertyName, (Object)0);
            return true;
        }
        return false;
    }

    protected boolean expiringDateValidate() {
        DynamicObject obj = this.getDynamicObject();
        if (obj.get("expiringyearfrom") == null || obj.get("expiringmonthfrom") == null || obj.get("expiringyearto") == null || obj.get("expiringmonthto") == null) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u8bf7\u586b\u5199\u201c\u6709\u6548\u671f\u95f4\u201d\u3002", (String)"PmProjWorkCalendarEntityPlugin_5", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return false;
        }
        int yearFrom = obj.getInt("expiringyearfrom");
        int monthFrom = obj.getInt("expiringmonthfrom");
        int yearTo = obj.getInt("expiringyearto");
        int monthTo = obj.getInt("expiringmonthto");
        if (yearTo < yearFrom || yearTo == yearFrom && monthTo < monthFrom) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"PmProjWorkCalendarEntityPlugin_6", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return false;
        }
        IPageCache pageCache = this.getPageCache();
        Map all = pageCache.getAll();
        if (all != null && StringUtils.isNotEmpty((CharSequence)((CharSequence)all.get("oldexpiringyearto"))) && StringUtils.isNotEmpty((CharSequence)((CharSequence)all.get("oldexpiringmonthto")))) {
            int oldexpiringyearto = Integer.parseInt((String)all.get("oldexpiringyearto"));
            int oldexpiringmonthto = Integer.parseInt((String)all.get("oldexpiringmonthto"));
            if (yearTo < oldexpiringyearto || yearTo == oldexpiringyearto && monthTo < oldexpiringmonthto) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u4fee\u6539\u540e\u7684\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u4fee\u6539\u524d\u7684\u7ed3\u675f\u65f6\u95f4\u3002", (String)"PmProjWorkCalendarEntityPlugin_7", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected DynamicObject getDynamicObject() {
        IDataModel model = this.getModel();
        return model.getDataEntity();
    }

    protected void generateDate() {
        IDataModel model = this.getModel();
        model.getDataEntity();
        DynamicObject obj = model.getDataEntity();
        int yearFrom = obj.getInt("expiringyearfrom");
        int monthFrom = obj.getInt("expiringmonthfrom");
        int yearTo = obj.getInt("expiringyearto");
        int monthTo = obj.getInt("expiringmonthto");
        Calendar curDate = Calendar.getInstance();
        curDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        Calendar fromDate = Calendar.getInstance();
        fromDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        IPageCache pageCache = this.getPageCache();
        String oldExpiringYearFrom = pageCache.get("oldexpiringyearfrom");
        if (StringUtils.isEmpty((CharSequence)oldExpiringYearFrom)) {
            fromDate.setTime(curDate.getTime());
        } else {
            Calendar curDateFor = Calendar.getInstance();
            curDateFor.set(curDateFor.get(1), curDateFor.get(2), curDateFor.get(5), 0, 0, 0);
            fromDate.setTime(curDateFor.getTime());
        }
        Calendar toDate = Calendar.getInstance();
        toDate.set(yearTo, monthTo - 1, 1, 0, 0, 0);
        toDate.set(yearTo, monthTo - 1, toDate.getActualMaximum(5), 0, 0, 0);
        toDate.set(14, 0);
        fromDate.set(14, 0);
        boolean[] isRestDay = this.getRestDays(model);
        boolean[] isHalfWorkDay = this.getHalfWorkDays(model);
        int oldCalendarCount = this.removeDuplicateRecord(fromDate);
        int days = TimeUtils.daysBetween((Calendar)fromDate, (Calendar)toDate);
        if (days > 0) {
            model.batchCreateNewEntryRow("dateEntry", days);
            for (int i = 0; i < days; ++i) {
                int index = oldCalendarCount + i;
                model.setValue("workdate", (Object)fromDate.getTime(), index);
                if (isRestDay[fromDate.get(7) - 1]) {
                    model.setValue("datetype", (Object)"4", index);
                } else if (isHalfWorkDay[fromDate.get(7) - 1]) {
                    model.setValue("datetype", (Object)"2", index);
                } else {
                    model.setValue("datetype", (Object)"1", index);
                }
                fromDate.add(5, 1);
            }
        }
    }

    protected int removeDuplicateRecord(Calendar fromDate) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("dateEntry");
        Calendar oldCal = Calendar.getInstance();
        ArrayList<DynamicObject> oldCalendarList = new ArrayList<DynamicObject>();
        DynamicObjectCollection oldObjCol = model.getEntryEntity("dateEntry");
        for (int i = rowCount - 1; i >= 0; --i) {
            DynamicObject oldObj = (DynamicObject)oldObjCol.get(i);
            if (oldObj.getDate("workdate") == null) continue;
            oldCal.setTime(oldObj.getDate("workdate"));
            if (fromDate.before(oldCal) || TimeUtils.isSameDate((Calendar)fromDate, (Calendar)oldCal)) continue;
            oldCalendarList.add(oldObj);
        }
        model.deleteEntryData("dateEntry");
        int oldRecordCount = oldCalendarList.size();
        if (oldRecordCount > 0) {
            model.batchCreateNewEntryRow("dateEntry", oldRecordCount);
            int entryIndex = 0;
            for (int i = oldRecordCount - 1; i >= 0; --i) {
                DynamicObject oldObj = (DynamicObject)oldCalendarList.get(i);
                model.setValue("workdate", (Object)oldObj.getDate("workdate"), entryIndex);
                model.setValue("datetype", oldObj.get("datetype"), entryIndex);
                ++entryIndex;
            }
        }
        return oldRecordCount;
    }

    protected boolean[] getRestDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        return new boolean[]{obj.getBoolean("issunrest"), obj.getBoolean("ismonrest"), obj.getBoolean("istuerest"), obj.getBoolean("iswedrest"), obj.getBoolean("isthurest"), obj.getBoolean("isfrirest"), obj.getBoolean("issatrest")};
    }

    protected boolean[] getHalfWorkDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        return new boolean[]{obj.getBoolean("ishalfsunrest"), obj.getBoolean("ishalfmonrest"), obj.getBoolean("ishalftuerest"), obj.getBoolean("ishalfwedrest"), obj.getBoolean("ishalfthurest"), obj.getBoolean("ishalffrirest"), obj.getBoolean("ishalfsatrest")};
    }

    public boolean findTask() {
        Set taskIdSetByOrg;
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
        if (StringUtils.isNotEmpty((CharSequence)orgId) && orgId.contains("proj")) {
            return ProjWorkCalendarLoadService.queryProjectTask((String)this.getAppId(), (String)orgId);
        }
        return StringUtils.isNotEmpty((CharSequence)orgId) && (taskIdSetByOrg = TaskUtil.getTaskIdSetByOrgId((Object)orgId, (String)this.getAppId())) != null && taskIdSetByOrg.size() > 0;
    }

    public void openTips() {
        HashMap params = new HashMap(16);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closesetcalendartip");
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(MetaDataUtil.getEntityId((String)this.getAppId(), (String)"changecalendartips"));
        param.setCloseCallBack(closeCallBack);
        param.setCustomParams(params);
        this.getView().showForm(param);
    }
}

