/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.pccs.placs.formplugin.ProjWorkCalenderEditPlugin;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class PmProjWorkCalenderEditPlugin
extends ProjWorkCalenderEditPlugin {
    private static final String SEARCH_RESULT_LIST_POSITION = "search_result_list_position";
    private static final String ENTITY_ORG_STRUCTURE = "bos_org_structure";
    private static List<String> searchResult = new ArrayList<String>();
    private static Map<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>();

    protected List<QFilter> getProjectFilters(Long orgId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add(orgId);
        DynamicObject[] projects = ProjectPermissionHelper.getPermProjectByStatus(orgList, (boolean)true, (String)this.getView().getEntityId(), (String)"view", null);
        List projectPks = Arrays.stream(projects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        qFilters.add(new QFilter("id", "in", projectPks));
        qFilters.add(new QFilter("pmascreateorg", "=", (Object)orgId));
        return qFilters;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        treeNodeMap.clear();
        searchResult.clear();
    }

    public void queryTreeNodeChildren(TreeNodeEvent nodeEvent) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        Object parentNodeId = nodeEvent.getParentNodeId();
        TreeView tv = (TreeView)nodeEvent.getSource();
        if ("noOrg".equals(parentNodeId) || "outOrg".equals(parentNodeId)) {
            return;
        }
        String nodeIdStr = nodeEvent.getNodeId().toString();
        if (nodeIdStr.contains("proj")) {
            return;
        }
        long nodeId = Long.parseLong(nodeIdStr);
        String curNodeId = this.getPageCache().get(String.format("nodeid%s", nodeId));
        if (StringUtils.isNotEmpty((CharSequence)curNodeId)) {
            return;
        }
        List<Map<String, String>> prosOfOrg = this.querySubProjectOfOrg(nodeId + "");
        for (Map<String, String> map : prosOfOrg) {
            nodes.add(this.changeMapToTreeNode(map));
        }
        List orgs = OrgViewServiceHelper.getOVSubordinateOrgs((String)"15", (Long)nodeId);
        DynamicObject[] permProjects = this.getPermProject(orgs);
        Map<String, List<DynamicObject>> createOrgIdToProMap = Arrays.stream(permProjects).filter(obj -> obj.getDynamicObject("pmascreateorg") != null).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("pmascreateorg").getString("id")));
        List<Map<String, String>> orgTreeData = this.getOVSubordinateOrgs(nodeId);
        for (Map<String, String> map : orgTreeData) {
            String isleaf;
            String orgId = map.get("id");
            List<DynamicObject> createOrgIdToProList = createOrgIdToProMap.get(orgId);
            if (createOrgIdToProList != null && !createOrgIdToProList.isEmpty() && (isleaf = map.get("isleaf")).equals("1")) {
                map.put("isleaf", "0");
            }
            TreeNode curNode = this.changeMapToTreeNode(map);
            nodes.add(curNode);
        }
        this.getPageCache().put(String.format("nodeid%s", nodeId), String.valueOf(nodeId));
        tv.addNodes(nodes);
        if (parentNodeId != null && !"".equals(parentNodeId)) {
            tv.focusNode(this.getCurTreeNode(nodeIdStr));
        }
    }

    protected List<Map<String, String>> getOVSubordinateOrgs(long orgId) {
        if (orgId == 0L) {
            return new ArrayList<Map<String, String>>(0);
        }
        List subOrgs = OrgViewServiceHelper.getOrgChildrenTreeData((String)"15", (long)orgId);
        return subOrgs;
    }

    protected List<Map<String, String>> querySubProjectOfOrg(String orgId) {
        List<QFilter> projectFilters = this.getProjectFilters(Long.parseLong(orgId));
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)"bd_project", (String)"id,name", (QFilter[])projectFilters.toArray(new QFilter[projectFilters.size()]));
        ArrayList<Map<String, String>> projList = new ArrayList<Map<String, String>>(projects.length);
        for (int i = 0; i < projects.length; ++i) {
            DynamicObject project = projects[i];
            HashMap<String, String> map = new HashMap<String, String>();
            String id = project.getPkValue().toString();
            String projName = this.getProjectName(project);
            map.put("id", id + "proj");
            map.put("name", projName);
            map.put("parentid", orgId);
            map.put("isleaf", "1");
            projList.add(map);
        }
        return projList;
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String searchText = evt.getText();
        IPageCache pageCache = this.getPageCache();
        String searchKey = search.getKey();
        if (null == searchText || searchText.length() == 0) {
            return;
        }
        if ("treesearchap".equals(searchKey)) {
            TreeNode treeNode;
            String searchPos;
            IFormView view = this.getView();
            TreeView treeView = (TreeView)view.getControl("orgtree");
            String oldSearchText = pageCache.get("old_tree_search_text_key");
            if (oldSearchText == null || !oldSearchText.equals(searchText)) {
                pageCache.put("old_tree_search_text_key", searchText);
                searchResult = this.getProjectAndOrgByKey(searchText);
                searchPos = "0";
                pageCache.put(SEARCH_RESULT_LIST_POSITION, searchPos);
            } else {
                searchPos = pageCache.get(SEARCH_RESULT_LIST_POSITION);
            }
            if (searchResult == null || searchResult.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"PmProjWorkCalenderEditPlugin_1", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                return;
            }
            if (Integer.parseInt(searchPos) < searchResult.size() && (treeNode = this.searchExistsNodeFromLazyOrgTree(treeView, searchPos)) != null) {
                treeView.showNode(treeNode.getId());
                treeView.focusNode(treeNode);
                this.expandParentNode(treeNode, treeView);
            }
            if (Integer.parseInt(searchPos) + 1 >= searchResult.size()) {
                pageCache.put(SEARCH_RESULT_LIST_POSITION, "0");
            } else {
                pageCache.put(SEARCH_RESULT_LIST_POSITION, Integer.parseInt(searchPos) + 1 + "");
            }
        }
    }

    protected TreeNode searchExistsNodeFromLazyOrgTree(TreeView treeView, String searchPos) {
        String projectAndOrg = searchResult.get(Integer.parseInt(searchPos));
        if (projectAndOrg.contains("proj")) {
            TreeNode proTreeNode = treeNodeMap.get(projectAndOrg);
            if (proTreeNode != null) {
                return proTreeNode;
            }
            String proId = projectAndOrg.split("proj")[0];
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)proId, (String)"bd_project");
            String createorgId = project.getString("pmascreateorg.id");
            if (StringUtils.isNotEmpty((CharSequence)createorgId)) {
                QFilter curorgFilter = new QFilter("org", "=", (Object)Long.parseLong(createorgId));
                DynamicObject orgStruct = BusinessDataServiceHelper.loadSingle((String)ENTITY_ORG_STRUCTURE, (String)"isleaf,org,parent,longnumber", (QFilter[])new QFilter[]{curorgFilter, this.getOrgCommFilter()});
                String parentId = orgStruct.getString("parent.id");
                TreeNode treeNode = treeNodeMap.get(createorgId);
                if (treeNode == null) {
                    this.queryTreeNodeWithParent(treeView, orgStruct, parentId);
                }
                treeView.queryTreeNodeChildren(parentId, orgStruct.getString("org.id"));
                TreeNode afterQueryTreeNode = treeNodeMap.get(projectAndOrg);
                return afterQueryTreeNode;
            }
            return null;
        }
        QFilter curorgFilter = new QFilter("org", "=", (Object)Long.parseLong(projectAndOrg));
        DynamicObject orgStruct = BusinessDataServiceHelper.loadSingle((String)ENTITY_ORG_STRUCTURE, (String)"isleaf,org,parent,longnumber", (QFilter[])new QFilter[]{curorgFilter, this.getOrgCommFilter()});
        TreeNode treeNode = treeNodeMap.get(projectAndOrg);
        String parentId = orgStruct.getString("parent.id");
        if (treeNode != null) {
            treeView.queryTreeNodeChildren(parentId, orgStruct.getString("org.id"));
            return treeNode;
        }
        this.queryTreeNodeWithParent(treeView, orgStruct, parentId);
        treeView.queryTreeNodeChildren(parentId, orgStruct.getString("org.id"));
        TreeNode afterQueryTreeNode = treeNodeMap.get(projectAndOrg);
        return afterQueryTreeNode;
    }

    protected QFilter getOrgCommFilter() {
        QFilter commonFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter viewTypeFilter = new QFilter("view.treetype", "=", (Object)"15");
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        commonFilter.and(enableFilter).and(viewTypeFilter).and(freezeFilter.or(freezeFilter1));
        return commonFilter;
    }

    protected List<String> getProjectAndOrgByKey(String searchText) {
        List allPermOrgs = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)RequestContext.get().getUserId(), (String)this.getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac");
        DynamicObject[] allPermProject = this.getPermProject(allPermOrgs);
        List allPermProIdList = Arrays.stream(allPermProject).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        Long curUserOrg = RequestContext.get().getOrgId();
        ArrayList<Long> orgList = new ArrayList<Long>(1);
        orgList.add(curUserOrg);
        List subOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.parseLong("15"), orgList, (boolean)true);
        ArrayList<QFilter> orgFilterList = new ArrayList<QFilter>(10);
        ArrayList<QFilter> proFilterList = new ArrayList<QFilter>(10);
        QFilter subOrgFilter = new QFilter("id", "in", (Object)subOrgs);
        QFilter orgFilter = new QFilter("pmascreateorg", "in", (Object)subOrgs);
        QFilter nameFilter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue());
        QFilter proIdFilter = new QFilter("id", "in", allPermProIdList);
        proFilterList.add(statusFilter);
        proFilterList.add(enableFilter);
        proFilterList.add(nameFilter);
        proFilterList.add(proIdFilter);
        proFilterList.add(orgFilter);
        QFilter viewTypeFilter = new QFilter("view.treetype", "=", (Object)"15");
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        QFilter orgnameFilter = new QFilter("org.name", "like", (Object)("%" + searchText + "%"));
        orgFilterList.add(statusFilter);
        orgFilterList.add(enableFilter);
        orgFilterList.add(viewTypeFilter);
        orgFilterList.add(freezeFilter);
        orgFilterList.add(orgnameFilter);
        orgFilterList.add(subOrgFilter);
        DynamicObject[] orgStructs = BusinessDataServiceHelper.load((String)ENTITY_ORG_STRUCTURE, (String)"isleaf,org,parent,longnumber", (QFilter[])orgFilterList.toArray(new QFilter[orgFilterList.size()]));
        DynamicObject[] searchPros = BusinessDataServiceHelper.load((String)"bd_project", (String)"pmascreateorg, department", (QFilter[])proFilterList.toArray(new QFilter[proFilterList.size()]));
        List projectPks = Arrays.stream(searchPros).map(DataEntityBase::getPkValue).map(pk -> pk.toString() + "proj").collect(Collectors.toList());
        List orgPks = Arrays.stream(orgStructs).map(o -> o.getString("org.id")).collect(Collectors.toList());
        ArrayList<String> projectAndOrgList = new ArrayList<String>(projectPks.size() + orgPks.size());
        projectAndOrgList.addAll(projectPks);
        projectAndOrgList.addAll(orgPks);
        return projectAndOrgList;
    }

    protected void queryTreeNodeWithParent(TreeView treeView, DynamicObject orgStruct, String parentId) {
        TreeNode parentTreeNode = treeNodeMap.get(parentId);
        if (parentTreeNode == null) {
            DynamicObject[] orgStructObjs;
            String longNumber = orgStruct.getString("longnumber");
            String[] numbers = longNumber.split("!");
            ArrayList<String> longNumList = new ArrayList<String>(10);
            for (int i = 1; i < numbers.length - 1; ++i) {
                longNumList.add(numbers[i]);
            }
            QFilter viewFilter = new QFilter("view.number", "=", (Object)"15");
            QFilter numberFilter = new QFilter("org.number", "in", longNumList);
            for (DynamicObject orgStructObj : orgStructObjs = BusinessDataServiceHelper.load((String)ENTITY_ORG_STRUCTURE, (String)"isleaf,org,parent,longnumber", (QFilter[])new QFilter[]{viewFilter, numberFilter}, (String)"longnumber")) {
                String orgId = orgStructObj.getString("org.id");
                TreeNode curTreeNode = treeNodeMap.get(orgId);
                if (curTreeNode != null && curTreeNode.getChildren() != null && !curTreeNode.getChildren().isEmpty()) continue;
                String curParentId = orgStructObj.getString("parent.id");
                treeView.queryTreeNodeChildren(curParentId, orgId);
            }
        } else if (parentTreeNode.getChildren() == null || parentTreeNode.getChildren().isEmpty()) {
            QFilter viewFilter = new QFilter("view.number", "=", (Object)"15");
            QFilter numberFilter = new QFilter("org", "in", (Object)Long.parseLong(parentId));
            DynamicObject orgStructObj = BusinessDataServiceHelper.loadSingle((String)ENTITY_ORG_STRUCTURE, (String)"isleaf,org,parent,longnumber", (QFilter[])new QFilter[]{viewFilter, numberFilter});
            String curParentId = orgStructObj.getString("parent.id");
            treeView.queryTreeNodeChildren(curParentId, parentId);
        }
    }

    protected TreeNode changeMapToTreeNode(Map<String, String> map) {
        String nodeid;
        if (map.isEmpty()) {
            return null;
        }
        TreeNode node = new TreeNode();
        node.setId(map.get("id"));
        node.setText(map.get("name"));
        node.setParentid(map.get("parentid"));
        String isleaf = map.get("isleaf");
        if (isleaf == null) {
            isleaf = "0";
        }
        if ("0".equals(isleaf)) {
            node.setChildren(new ArrayList());
        }
        if ((nodeid = map.get("id")).contains("proj")) {
            node.setColor("blue");
        }
        treeNodeMap.put(map.get("id"), node);
        return node;
    }

    protected DynamicObject[] getPermProject(List<Long> orgList) {
        if (orgList.isEmpty()) {
            return new DynamicObject[0];
        }
        DynamicObject[] projects = ProjectPermissionHelper.getPermProjectByStatus(orgList, (boolean)true, (String)this.getView().getEntityId(), (String)"view", null);
        List projectPks = Arrays.stream(projects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        projects = BusinessDataServiceHelper.load((String)"bd_project", (String)"pmascreateorg, department", (QFilter[])new QFilter[]{new QFilter("id", "in", projectPks)});
        return projects;
    }

    protected void expandParentNode(TreeNode node, TreeView treeView) {
        TreeNode parentNode = treeNodeMap.get(node.getParentid());
        if (parentNode != null) {
            treeView.expand(parentNode.getId());
            this.expandParentNode(parentNode, treeView);
        }
    }

    public static DynamicObject queryCalendar(String orgId) {
        QFilter[] qf = new QFilter[2];
        if (orgId.contains("proj")) {
            if (StringUtils.isNotBlank((CharSequence)orgId.split("proj")[0])) {
                qf[0] = new QFilter("project", "=", (Object)Long.valueOf(orgId.split("proj")[0]));
            }
        } else if (StringUtils.isNotBlank((CharSequence)orgId)) {
            qf[0] = new QFilter("org", "=", (Object)Long.valueOf(orgId));
        }
        qf[1] = new QFilter("isindividuation", "=", (Object)"0");
        return BusinessDataServiceHelper.loadSingle((String)"pmpt_projworkcalendarset", (String)"id", (QFilter[])qf);
    }

    protected void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        String orgId = params.get("orgId").toString();
        if (StringUtils.isNotEmpty((CharSequence)orgId)) {
            DynamicObject calendar = PmProjWorkCalenderEditPlugin.queryCalendar(orgId);
            if (calendar != null) {
                param.setBillStatus(BillOperationStatus.EDIT);
                param.setPkId((Object)calendar.getString("id"));
            }
            param.setCustomParams(params);
            if (closeCallBack != null) {
                param.setCloseCallBack(closeCallBack);
            }
            this.getView().showForm((FormShowParameter)param);
        } else {
            param.setCustomParams(params);
            this.getView().showForm((FormShowParameter)param);
        }
    }
}

