/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pccs.placs.business.model.ProgressReportConstant;
import kd.pccs.placs.common.enums.PersonTypeEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.base.AbstractPlacsBillPlugin;

public class PmTaskBasicDataPlugin
extends AbstractPlacsBillPlugin {
    public static final int RESPONORSHARE_PEERSONTYPE = 1;
    public static final int COOPERATE_PERSONTYPE = 2;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"taskreport")) {
            this.doTaskReport(args);
        }
    }

    protected void doTaskReport(BeforeDoOperationEventArgs args) {
        QFilter taskReportPersonType;
        Object taskId = this.getModel().getDataEntity().getPkValue();
        QFilter latestFilter = new QFilter("latest", "=", (Object)Boolean.TRUE);
        QFilter taskIdFilter = new QFilter("task", "=", taskId);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] noCheckedReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)"id,task,percent,autocomplete", (QFilter[])new QFilter[]{latestFilter, taskIdFilter, statusFilter});
        List<String> noCReportIdList = Arrays.stream(noCheckedReports).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
        String[] noCReportIds = new String[noCReportIdList.size()];
        noCReportIdList.toArray(noCReportIds);
        Map bizProcessStatus = WorkflowServiceHelper.getBizProcessStatus((String[])noCReportIds);
        if (bizProcessStatus != null && !bizProcessStatus.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u6709\u8fdb\u5ea6\u6c47\u62a5\u8fdb\u5165\u5ba1\u6279\u6d41\uff0c\u8bf7\u5ba1\u6279\u901a\u8fc7\u540e\u518d\u8fdb\u884c\u6c47\u62a5\u3002", (String)"PmTaskBasicDataPlugin_0", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"));
        map.put("taskId", taskId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.setAppId(this.getAppId());
        QFilter taskid = new QFilter("task", "=", taskId);
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.TEMPSAVE.getValue()).or("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue());
        QFilter[] filters = null;
        String userId = RequestContext.get().getUserId();
        DynamicObject responPerson = (DynamicObject)this.getModel().getValue("responsibleperson");
        DynamicObjectCollection cooperatePersons = (DynamicObjectCollection)this.getModel().getValue("multicooperationperson");
        List<Object> coopersonIds = new ArrayList();
        if (cooperatePersons != null && !cooperatePersons.isEmpty()) {
            coopersonIds = cooperatePersons.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        DynamicObject sharer = (DynamicObject)this.getModel().getValue("sharer");
        if (null != responPerson && StringUtils.equals((CharSequence)responPerson.getString("id"), (CharSequence)userId) || null != sharer && StringUtils.equals((CharSequence)sharer.getString("id"), (CharSequence)userId)) {
            map.put("person", 1);
            taskReportPersonType = new QFilter("persontype", "=", (Object)PersonTypeEnum.RESPONSIBLEPERSON.getValue()).or("persontype", "=", (Object)PersonTypeEnum.SHARER.getValue());
            filters = new QFilter[]{taskid, taskreportStatus, taskReportPersonType};
        } else if (coopersonIds.contains(Long.parseLong(userId))) {
            map.put("person", 2);
            taskReportPersonType = new QFilter("persontype", "=", (Object)PersonTypeEnum.COOPERATIONPERSON.getValue());
            filters = new QFilter[]{taskid, taskreportStatus, taskReportPersonType};
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u4efb\u52a1\u7684\u8d23\u4efb\u4eba\u3001\u534f\u529e\u4eba\u548c\u5171\u4eab\u4eba\uff0c\u624d\u80fd\u6c47\u62a5\u8be5\u4efb\u52a1\u3002", (String)"PmTaskBasicDataPlugin_2", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject[] taskReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"taskreport"), (String)ProgressReportConstant.AllProperty, (QFilter[])filters);
        if (null != taskReports && taskReports.length > 0) {
            showParameter.setStatus(OperationStatus.EDIT);
            map.put("editreport", Boolean.TRUE);
            ((BillShowParameter)showParameter).setPkId(taskReports[0].getPkValue());
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            map.put("addreport", Boolean.TRUE);
        }
        showParameter.setCustomParams(map);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }
}

