/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.formplugin.WorkFlowFlexListPlugin;
import kd.pmgt.pmpt.formplugin.utils.PmTaskBizHelper;
import org.apache.commons.lang3.StringUtils;

public class PmWorkFlowFlexListPlugin
extends WorkFlowFlexListPlugin {
    private static Log log = LogFactory.getLog(WorkFlowFlexListPlugin.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                List<Object> pkIds;
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                String entityName = this.getEntityType().getName();
                if (entityName.contains("reporttaskview")) {
                    for (DynamicObject row : rows) {
                        BigDecimal overDays = PmTaskBizHelper.getOverDays(PmWorkFlowFlexListPlugin.this.getAppId(), row);
                        if (!row.getDataEntityType().getProperties().containsKey((Object)"realtimedeviation")) continue;
                        row.set("realtimedeviation", (Object)overDays);
                    }
                }
                long t1 = System.currentTimeMillis();
                if (entityName.contains("reporttaskview")) {
                    pkIds = new ArrayList();
                    rows.forEach(v -> pkIds.add(Long.valueOf(v.getPkValue().toString())));
                    QFilter latestFilter = new QFilter("latest", "=", (Object)Boolean.TRUE);
                    QFilter taskIdFilter = new QFilter("task", "in", pkIds);
                    QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
                    DynamicObject[] latestReports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)PmWorkFlowFlexListPlugin.this.getAppId(), (String)"taskreport"), (String)"id,percent,autocomplete,task", (QFilter[])new QFilter[]{latestFilter, taskIdFilter, statusFilter});
                    List latestReportIds = Arrays.stream(latestReports).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
                    if (!latestReportIds.isEmpty()) {
                        PmWorkFlowFlexListPlugin.this.getNextAuditors(latestReportIds);
                    }
                } else {
                    pkIds = rows.stream().filter(o -> !StatusEnum.CHECKED.getValue().equals(o.get("billstatus"))).map(o -> o.getPkValue().toString()).collect(Collectors.toList());
                    if (!pkIds.isEmpty()) {
                        PmWorkFlowFlexListPlugin.this.getNextAuditors(pkIds);
                    }
                }
                long t2 = System.currentTimeMillis();
                log.info("\u5ba1\u6838\u4eba\u6570\u636e\u52a0\u8f7dB \u7528\u65f6\uff1a " + (t2 - t1) + "ms");
                return rows;
            }
        });
    }

    private void getNextAuditors(List<String> pkIds) {
        String[] ids = new String[pkIds.size()];
        String nodeName = "";
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        for (Map.Entry entry : allPro.entrySet()) {
            List node = (List)entry.getValue();
            int count = 0;
            StringBuilder participantName = new StringBuilder();
            StringBuilder msg = new StringBuilder();
            try {
                for (BizProcessStatus e : node) {
                    nodeName = e.getCurrentNodeName();
                    String auditor = e.getParticipantName();
                    participantName.append(',');
                    if (e.getProcessStatus().equals("2")) {
                        participantName.append(ResManager.loadKDString((String)"\u6302\u8d77", (String)"PmWorkFlowFlexListPlugin_0", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
                    } else if (auditor != null && !"".equals(auditor.trim())) {
                        participantName.append(auditor);
                    }
                    if (++count != 3) continue;
                    participantName.append("...");
                    break;
                }
                if (StringUtils.isBlank((CharSequence)nodeName)) continue;
                msg.append(nodeName);
                if (StringUtils.isBlank((CharSequence)participantName)) continue;
                msg.append('/');
                msg.append(participantName.toString().replaceFirst(",", ""));
            }
            catch (Exception e) {
                log.info("ErWorkFlowFlexListForOtherPlugin>>>\u83b7\u53d6\u5ba1\u6279\u4eba\u51fa\u73b0\u5f02\u5e38: " + e.getMessage());
            }
        }
    }
}

