/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin.gantt;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import pmgt.pmpt.business.gantt.DhtmlxGanttBuilder;
import pmgt.pmpt.business.gantt.DhtmlxGanttDirector;
import pmgt.pmpt.business.gantt.GanttUtilsTools;
import pmgt.pmpt.business.gantt.PlanGanttBuilder;
import pmgt.pmpt.business.gantt.entity.DhtmlxGanttInfo;
import pmgt.pmpt.business.gantt.entity.DhtmlxParameters;
import pmgt.pmpt.business.gantt.entity.GanttCalendar;

public class DhtmlxGanttPlanPlugin
extends AbstractBillPlugIn
implements TabSelectListener {
    public void afterBindData(EventObject e) {
        this.setShowTab();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabkey = tabSelectEvent.getTabKey();
        if ("gantttab".equals(tabkey)) {
            this.buildGanttData();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("project".equals(key)) {
            this.setShowTab();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void customEvent(CustomEventArgs e) {
        e.getKey();
    }

    protected void setShowTab() {
        String status = this.getModel().getDataEntity().getString("billstatus");
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"gantttab"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"gantttab"});
        }
        if (entries.size() <= 0 && "C".equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"gantttab"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"gantttab"});
        }
    }

    protected void buildGanttData() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("taskentity");
        if (this.validBeforeViewGantt(entries)) {
            this.setDefaultGanttInfo();
            return;
        }
        DhtmlxGanttInfo ganttInfo = this.convertToGanttInfo(entries);
        if (ganttInfo != null) {
            CustomControl gantt = (CustomControl)this.getView().getControl("gantt");
            Object ganttsData = JSON.toJSON((Object)ganttInfo);
            gantt.setData(ganttsData);
        }
    }

    protected boolean validBeforeViewGantt(DynamicObjectCollection entries) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u672a\u9009\u62e9\u9879\u76ee\uff0c\u65e0\u6cd5\u6e32\u67d3\u7518\u7279\u56fe\u3002", (String)"DhtmlxGanttPlanPlugin_5", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (entries.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5206\u5f55\u65e0\u4efb\u52a1\uff0c\u65e0\u6cd5\u6e32\u67d3\u7518\u7279\u56fe\u3002", (String)"DhtmlxGanttPlanPlugin_6", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return true;
        }
        for (DynamicObject entriyRow : entries) {
            Date planStartTime = entriyRow.getDate("planstarttime");
            Date planEndTime = entriyRow.getDate("planendtime");
            if (planStartTime != null && planEndTime != null) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u201d\u548c\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u3002", (String)"DhtmlxGanttPlanPlugin_7", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    protected void setDefaultGanttInfo() {
        DhtmlxGanttInfo ganttInfo = new DhtmlxGanttInfo("loadTask");
        ganttInfo.getOtherProperties().setLock(true);
        ganttInfo.getOtherProperties().setSource("plan");
        CustomControl gantt = (CustomControl)this.getView().getControl("gantt");
        Object ganttsData = JSON.toJSON((Object)ganttInfo);
        gantt.setData(ganttsData);
    }

    protected DhtmlxGanttInfo convertToGanttInfo(DynamicObjectCollection tasks) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        PlanGanttBuilder planGanttBuilder = new PlanGanttBuilder(project, org, "loadTask");
        DhtmlxGanttDirector dhtmlxGanttDirector = new DhtmlxGanttDirector((DhtmlxGanttBuilder)planGanttBuilder, tasks);
        dhtmlxGanttDirector.construct();
        DhtmlxGanttInfo info = planGanttBuilder.build();
        info.getOtherProperties().setLock(true);
        info.getOtherProperties().setSource("plan");
        return info;
    }

    protected DhtmlxParameters convertToDhtmlxParamrters(DynamicObjectCollection tasks) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DhtmlxParameters otherProperties = new DhtmlxParameters();
        GanttCalendar calendar = GanttUtilsTools.converToCalendars((DynamicObject)project, (DynamicObject)org);
        otherProperties.setCalendar(calendar);
        otherProperties.setPersons(GanttUtilsTools.converToPerson((DynamicObjectCollection)tasks));
        otherProperties.setDepts(GanttUtilsTools.converToDepartment((DynamicObjectCollection)tasks));
        otherProperties.setLock(false);
        return otherProperties;
    }
}

