/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin.planexec;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.pccs.placs.business.utils.task.WorkHoursUtils;
import kd.pccs.placs.formplugin.WorkHoursBillListPlugin;
import org.apache.commons.lang3.StringUtils;

public class PmWorkHourBillListPlugin
extends WorkHoursBillListPlugin {
    private static final String OWNER_FILTER_VALUE = "103";
    private static final String PAGECACHE_OWNER = "pagecache_owner";
    private static final String OTHER_USER = "104";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn ownerUserFilter;
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (!filterColumnList.contains(ownerUserFilter = this.buildOwnerFilterColumn())) {
            ownerUserFilter.setDefaultValue(RequestContext.get().getUserId());
            ownerUserFilter.setConstantDefaultValue((Object)OWNER_FILTER_VALUE);
            filterColumnList.add(ownerUserFilter);
            this.getPageCache().put(PAGECACHE_OWNER, OWNER_FILTER_VALUE);
        }
        super.filterContainerInit(args);
    }

    public void setFilter(SetFilterEvent e) {
        String currenUserId = RequestContext.get().getUserId();
        List filters = e.getQFilters();
        QFilter qFilter = null;
        WorkHoursUtils unit = this.getUtil();
        List projManagerProjects = unit.getProjManagerProjects(currenUserId);
        List managerDepts = unit.getManagerDepts(currenUserId);
        boolean isProjMaster = !CollectionUtils.isEmpty((Collection)projManagerProjects);
        boolean isDeptManager = !CollectionUtils.isEmpty((Collection)managerDepts);
        String ownerValue = this.getPageCache().get(PAGECACHE_OWNER);
        if (isProjMaster || isDeptManager) {
            if (isProjMaster && (StringUtils.isBlank((CharSequence)ownerValue) || StringUtils.equals((CharSequence)OTHER_USER, (CharSequence)ownerValue))) {
                qFilter = new QFilter("project.id", "in", (Object)projManagerProjects);
            }
            if (isDeptManager && (StringUtils.isBlank((CharSequence)ownerValue) || StringUtils.equals((CharSequence)OTHER_USER, (CharSequence)ownerValue))) {
                if (qFilter == null) {
                    qFilter = new QFilter("depart.id", "in", (Object)managerDepts);
                } else {
                    qFilter.or(new QFilter("depart.id", "in", (Object)managerDepts));
                }
            }
            if (qFilter != null && StringUtils.isBlank((CharSequence)ownerValue)) {
                qFilter.or(new QFilter("owner.id", "=", (Object)Long.valueOf(currenUserId)));
            }
            if (qFilter != null) {
                filters.add(qFilter);
            }
        } else {
            QFilter qfilter = new QFilter("owner.id", "=", (Object)Long.valueOf(currenUserId));
            filters.add(qfilter);
        }
        e.setOrderBy("createtime desc,billno desc");
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        for (int i = customFiterList.size() - 1; i >= 0; --i) {
            List values;
            Map customFiter = (Map)customFiterList.get(i);
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.isEmpty() || !StringUtils.equals((CharSequence)"owner.id", (CharSequence)((String)fieldNames.get(0))) || (values = (List)customFiter.get("Value")) == null || values.isEmpty()) continue;
            if (values.get(0) == null || StringUtils.isBlank((CharSequence)values.get(0).toString())) {
                this.getPageCache().put(PAGECACHE_OWNER, null);
                break;
            }
            this.getPageCache().put(PAGECACHE_OWNER, values.get(0).toString());
            break;
        }
    }
}

