/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin.projectfilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.org.model.EnableEnum;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.utils.BuildCommonFilterList;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class ProPermComListPlugin
extends AbstractListPlugin {
    private static final String ISFIRSTINIT = "isfirstInit";

    protected String getOrgColName() {
        return "org.name";
    }

    protected String getOrgId() {
        return "org.id";
    }

    protected String getProMoreName() {
        return "project.id";
    }

    protected String getProColName() {
        return "project.name";
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List customQFilters = args.getCustomQFilters();
        FilterColumnSetFilterEvent args2 = (FilterColumnSetFilterEvent)args;
        if (fieldName.equals(this.getProColName())) {
            List orgs = args2.getCommonFilterValue(this.getOrgColName());
            ArrayList<Long> orgList = new ArrayList<Long>();
            if (orgs != null) {
                for (Object org : orgs) {
                    String orgStr = org.toString();
                    if (!StringUtils.isNotBlank((CharSequence)orgStr)) continue;
                    orgList.add(Long.valueOf(orgStr));
                }
            }
            DynamicObject[] projects = ProjectPermissionHelper.getPermProjectByStatus(orgList, (boolean)true, (String)((ListView)this.getView()).getBillFormId(), (String)"view", null);
            List projectPks = Arrays.stream(projects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            customQFilters.add(new QFilter("id", "in", projectPks));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String orgCache;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        String orgFlag = this.getPageCache().get("noOrg");
        if (fieldName.equals(this.getProMoreName()) || fieldName.equals(this.getProColName())) {
            DynamicObject[] projects;
            args.getQfilters().add(new QFilter("enable", "=", (Object)EnableEnum.Enable));
            args.getQfilters().add(new QFilter("status", "=", (Object)StatusEnum.Checked));
            QFilter billFilter = new QFilter("pro", "not in", (Object)0);
            billFilter.and(new QFilter("billstatus", "=", (Object)StatusEnum.Checked));
            if (orgFlag == null) {
                projects = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro", (QFilter[])new QFilter[]{billFilter});
            } else {
                billFilter.and(new QFilter("org", "=", (Object)Long.parseLong(orgFlag)));
                projects = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro", (QFilter[])new QFilter[]{billFilter});
            }
            List projectList = Arrays.stream(projects).filter(o -> o.getDynamicObject("pro") != null).collect(Collectors.toList());
            List projectIdList = projectList.stream().map(o -> o.getDynamicObject("pro").getPkValue()).collect(Collectors.toList());
            args.getQfilters().add(new QFilter("id", "in", projectIdList));
        } else if ((fieldName.equals(this.getOrgId()) || fieldName.equals(this.getOrgColName())) && StringUtils.isNotBlank((CharSequence)(orgCache = this.getPageCache().get("orgCache")))) {
            List orgComboItems = SerializationUtils.fromJsonStringToList((String)orgCache, ComboItem.class);
            List orgIds = orgComboItems.stream().map(o -> Long.parseLong(o.getValue())).collect(Collectors.toList());
            args.getQfilters().add(new QFilter("id", "in", orgIds));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterGridView filterGridView = (FilterGridView)filterContainer.getItems().get(1);
        String isFirstInit = this.getPageCache().get(ISFIRSTINIT);
        if (isFirstInit == null || Boolean.parseBoolean(isFirstInit)) {
            CommonFilterColumn orgFilterColumn = (CommonFilterColumn)filterGridView.getItems().get(0);
            long userId = RequestContext.get().getCurrUserId();
            List allPermOrgs = ProjectPermissionHelper.getAllPermOrgs((String)String.valueOf(userId), (String)this.getView().getFormShowParameter().getAppId(), (String)"pmpt_promeettaskmonitor", (String)"view");
            if (allPermOrgs.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", (Object)allPermOrgs);
                List orgComboItems = BuildCommonFilterList.buildComboItem((String)"bos_org", (QFilter)qFilter);
                orgFilterColumn.setComboItems(orgComboItems);
                orgFilterColumn.setMustInput(false);
                String orgCache = SerializationUtils.toJsonString((Object)orgComboItems);
                this.getPageCache().put("orgCache", orgCache);
            }
            CommonFilterColumn projectFilterColumn = (CommonFilterColumn)filterGridView.getItems().get(1);
            long orgId = RequestContext.get().getOrgId();
            QFilter billFilter = new QFilter("pro", "not in", (Object)0);
            billFilter.and(new QFilter("billstatus", "=", (Object)kd.pmgt.pmbs.common.enums.StatusEnum.CHECKED.getValue()));
            billFilter.and(new QFilter("org", "=", (Object)RequestContext.get().getOrgId()));
            DynamicObject[] projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro", (QFilter[])new QFilter[]{billFilter});
            DynamicObject[] projects = (DynamicObject[])Arrays.stream(projectApprovals).filter(o -> o.getDynamicObject("pro") != null).map(o -> o.getDynamicObject("pro")).toArray(DynamicObject[]::new);
            List comboItems = ProjectPermissionHelper.loadProComboItems((DynamicObject[])projects);
            projectFilterColumn.setComboItems(comboItems);
            projectFilterColumn.setMustInput(false);
            this.getPageCache().put("noOrg", String.valueOf(orgId));
            this.getPageCache().put(ISFIRSTINIT, "false");
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter == null) {
            return;
        }
        String fieldName = (String)((List)currentCommonFilter.get("FieldName")).get(0);
        if (fieldName.equals(this.getOrgId())) {
            Object value = ((List)currentCommonFilter.get("Value")).get(0);
            this.getPageCache().remove("noOrg");
            if (StringUtils.isBlank(value)) {
                this.getPageCache().put("noOrg", null);
            } else {
                this.getPageCache().put("noOrg", (String)value);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String noOrg = this.getPageCache().get("noOrg");
        if (noOrg == null) {
            e.setMainOrgQFilter(null);
        }
    }
}

