/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.BizJobHandler;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.business.utils.task.RiskColorUtil;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DateUtil;

public class PmUpdateTaskCompleteStatusTask
extends AbstractTask {
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        BizJobHandler bizJobHandler = (BizJobHandler)this.getMessageHandler();
        MessageInfo messageInfo = new MessageInfo();
        JobInfo jobInfo = bizJobHandler.convertMessage(messageInfo);
        String appId = jobInfo.getAppId();
        this.updateTaskCompleteStatus(appId);
        this.updateRiskWarningStatus(appId);
    }

    public void updateTaskCompleteStatus(String appId) {
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        StringBuilder seletors = new StringBuilder();
        seletors.append("id").append(",").append("completionstatus").append(",").append("planstarttime").append(",").append("planendtime");
        String maxsize = System.getProperty("orm.opt.in.maxsize");
        int length = Integer.parseInt(maxsize);
        int begin = 0;
        ORM orm = ORM.create();
        ArrayList<Long> taskIdList = new ArrayList<Long>(length);
        while (true) {
            DataSet rows = orm.queryDataSet("PmUpdateTaskCompleteStatusTask.updateTaskCompleteStatus", MetaDataUtil.getEntityId((String)appId, (String)"task"), seletors.toString(), new QFilter[]{statusFilter}, "", begin, length);
            for (Row row : rows) {
                Long taskId = row.getLong(0);
                taskIdList.add(taskId);
            }
            QFilter taskIdFilter = new QFilter("id", "in", taskIdList);
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)seletors.toString(), (QFilter[])new QFilter[]{taskIdFilter});
            this.updateTaskFieldValue(tasks);
            SaveServiceHelper.update((DynamicObject[])tasks);
            if (taskIdList.size() < length) break;
            begin += length;
            taskIdList.clear();
        }
    }

    protected void updateTaskFieldValue(DynamicObject[] tasks) {
        Date currentDate = new Date();
        for (DynamicObject task : tasks) {
            int result2;
            Date planEndTime;
            int result1;
            Date planStartTime = task.getDate("planstarttime");
            String compStatus = task.getString("completionstatus");
            if (planStartTime != null && (result1 = DateUtil.compareByDay((Date)planStartTime, (Date)currentDate)) != 1 && CompletionStatusEnum.UNSTART.getValue().equals(compStatus)) {
                task.set("completionstatus", (Object)CompletionStatusEnum.PROGRESSING.getValue());
            }
            if ((planEndTime = task.getDate("planendtime")) == null || (result2 = DateUtil.compareByDay((Date)planEndTime, (Date)currentDate)) != -1 || !CompletionStatusEnum.PROGRESSING.getValue().equals(compStatus) && !CompletionStatusEnum.ESTIMATEDELAY.getValue().equals(compStatus)) continue;
            task.set("completionstatus", (Object)CompletionStatusEnum.OVERDUE.getValue());
        }
    }

    public void updateRiskWarningStatus(String appId) {
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        StringBuilder seletors = new StringBuilder();
        seletors.append("id").append(",").append("tasktype").append(",").append("planendtime").append(",").append("riskcolor").append(",").append("islatest").append(",").append("sourcetask").append(",").append("prechangetask").append(",").append("project").append(',').append("belongplantype").append(',').append("planid");
        String maxsize = System.getProperty("orm.opt.in.maxsize");
        int length = Integer.parseInt(maxsize);
        int begin = 0;
        ORM orm = ORM.create();
        ArrayList<Long> taskIdList = new ArrayList<Long>(length);
        while (true) {
            DataSet rows = orm.queryDataSet("PmUpdateTaskCompleteStatusTask.updateRiskWarningStatus", MetaDataUtil.getEntityId((String)appId, (String)"task"), seletors.toString(), new QFilter[]{statusFilter}, "", begin, length);
            for (Row row : rows) {
                Long taskId = row.getLong(0);
                taskIdList.add(taskId);
            }
            QFilter taskIdFilter = new QFilter("id", "in", taskIdList);
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)seletors.toString(), (QFilter[])new QFilter[]{taskIdFilter});
            RiskColorUtil.setColor((String)appId, (DynamicObject[])tasks, (boolean)false);
            SaveServiceHelper.update((DynamicObject[])tasks);
            if (taskIdList.size() < length) break;
            begin += length;
            taskIdList.clear();
        }
    }
}

