/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.formplugin.utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pccs.placs.business.utils.task.TaskUtil;
import kd.pccs.placs.common.enums.PlanEnum;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import org.apache.commons.lang3.StringUtils;

public class PmTaskBizHelper {
    private static Log log = LogFactory.getLog(PmTaskBizHelper.class);

    public static BigDecimal getOverDays(String appId, DynamicObject row) {
        Boolean flag = Boolean.TRUE;
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)row.getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"task"));
        Date planendtime = object.getDate("planendtime");
        Date realEndTime = object.getDate("realendtime");
        DynamicObject project = object.getDynamicObject("project");
        DynamicObject relationtask = object.getDynamicObject("relationtask");
        if (null != relationtask) {
            project = relationtask.getDynamicObject("project");
        }
        Date endDate = null;
        endDate = realEndTime == null ? new Date() : realEndTime;
        if (endDate.compareTo(planendtime) <= 0) {
            flag = Boolean.FALSE;
        }
        BigDecimal days = BigDecimal.ZERO;
        if (flag.booleanValue()) {
            if (project != null) {
                days = PmTaskBizHelper.getWorkDaysBetweenTwoDaysByProject(project.getPkValue(), planendtime, endDate, object.getPkValue(), appId);
            } else {
                DynamicObject org = PmTaskBizHelper.getTaskBizOrgByPlanType(object, appId);
                if (null != org) {
                    days = PmTaskBizHelper.getWorkDaysBetweenTwoDaysByOrg(org.getPkValue(), planendtime, endDate, object.getPkValue(), appId);
                }
            }
        }
        return days;
    }

    public static Date taskIsCompletedThenGetCompleteDate(DynamicObject task, String appId) {
        DynamicObject sourceTask = task.getDynamicObject("sourcetask");
        DynamicObject[] tasks = null;
        if (sourceTask != null) {
            QFilter sourceFilter = new QFilter("sourcetask", "=", sourceTask.getPkValue());
            tasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"task"), (String)"id", (QFilter[])new QFilter[]{sourceFilter});
        } else {
            tasks = new DynamicObject[]{task};
        }
        QFilter taskFilter = new QFilter("task", "in", Arrays.stream(tasks).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        QFilter percentFilter = new QFilter("percent", "=", (Object)100);
        QFilter taskreportStatus = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] reports = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"taskreport"), (String)String.join((CharSequence)",", "completetime", "id", "billstatus"), (QFilter[])new QFilter[]{taskFilter, percentFilter, taskreportStatus});
        if (reports != null && reports.length > 0) {
            return reports[0].getDate("completetime");
        }
        return null;
    }

    public static BigDecimal getWorkDaysBetweenTwoDaysByProject(Object projectId, Date beginDate, Date endDate, Object busiDataId, String appId) {
        BigDecimal days = BigDecimal.ZERO;
        boolean beginIsWorkDay = TaskUtil.checkDateIsWorkDay((Date)beginDate, (Object)projectId, (int)1, (String)appId);
        boolean endDateIsWorkDay = TaskUtil.checkDateIsWorkDay((Date)endDate, (Object)projectId, (int)1, (String)appId);
        try {
            days = TaskUtil.getDaysBetweenTwoDate((Object)projectId, (Date)beginDate, (Date)endDate, (String)appId);
        }
        catch (Exception e) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String tips = String.format(ResManager.loadKDString((String)"id\u4e3a%1$s\u7684\u6570\u636e\uff0c\u5728\u83b7\u53d6\u65e5\u671f:%2$s\u4e0e\u65e5\u671f:%3$s\u4e4b\u95f4\u7684\u5de5\u4f5c\u65e5\u5931\u8d25\uff0c\u65e0\u5de5\u4f5c\u65e5\u3002", (String)"PmTaskBizHelper_2", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), busiDataId, sdf.format(beginDate), sdf.format(endDate));
            log.error(e.getCause() + "\r\n" + tips);
        }
        if (!beginIsWorkDay && !endDateIsWorkDay) {
            if (days.compareTo(BigDecimal.ZERO) > 0) {
                days = days.add(BigDecimal.ONE);
            }
        } else if (!beginIsWorkDay && endDateIsWorkDay) {
            days = days.add(BigDecimal.ONE);
        }
        return days;
    }

    public static BigDecimal getWorkDaysBetweenTwoDaysByOrg(Object orgId, Date beginDate, Date endDate, Object busiDataId, String appId) {
        BigDecimal days = BigDecimal.ZERO;
        boolean taskPlanendIsWork = TaskUtil.checkDateIsWorkDay((Date)beginDate, (Object)orgId, (int)2, (String)appId);
        boolean completetimeIsWork = TaskUtil.checkDateIsWorkDay((Date)endDate, (Object)orgId, (int)2, (String)appId);
        try {
            days = TaskUtil.getDaysBetweenTwoDateByOrg((Object)orgId, (Date)beginDate, (Date)endDate, (String)appId);
        }
        catch (Exception e) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String tips = String.format(ResManager.loadKDString((String)"\u83b7\u53d6id\u4e3a%1$s\u7684\u6570\u636e\uff0c\u5de5\u4f5c\u65e5\u83b7\u53d6\u5931\u8d25\u3002\u8bf7\u68c0\u67e5\u65e5\u671f\u8303\u56f4\uff1a%2$s\u81f3%3$s\u3002", (String)"PmTaskBizHelper_3", (String)"pmgt-pmpt-formplugin", (Object[])new Object[0]), busiDataId, sdf.format(beginDate), sdf.format(endDate));
            log.error(e.getCause() + "\r\n" + tips);
        }
        if (!taskPlanendIsWork && !completetimeIsWork) {
            if (days.compareTo(BigDecimal.ZERO) > 0) {
                days = days.add(BigDecimal.ONE);
            }
        } else if (!taskPlanendIsWork && completetimeIsWork) {
            days = days.add(BigDecimal.ONE);
        }
        return days;
    }

    public static DynamicObject getTaskBizOrgByPlanType(DynamicObject task, String appId) {
        DynamicObject belongplantype = task.getDynamicObject("belongplantype");
        DynamicObject org = null;
        if (null != belongplantype) {
            DynamicObject plan;
            QFilter statusFilter;
            QFilter idFilter;
            Long planId;
            DynamicObject relationtask;
            String belongtype = belongplantype.getString("number");
            if (StringUtils.equalsIgnoreCase((CharSequence)belongtype, (CharSequence)"TRANSACTIONPLAN_S")) {
                relationtask = task.getDynamicObject("relationtask");
                planId = 0L;
                planId = null != relationtask ? Long.valueOf(relationtask.getLong("planid")) : Long.valueOf(task.getLong("planid"));
                idFilter = new QFilter("id", "=", (Object)planId);
                statusFilter = new QFilter("planstatus", "=", (Object)PlanEnum.PUBLISHED.getValue());
                plan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"deptplan"), (String)"assigner,billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, planningcycle, timerange, STARTTIME, ENDTIME, name, version, sourceplan, prechangeplan, planstatus, planstatus1", (QFilter[])new QFilter[]{idFilter, statusFilter});
                if (null != plan) {
                    org = plan.getDynamicObject("org");
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)belongtype, (CharSequence)"PERSONALPLAN_S")) {
                relationtask = task.getDynamicObject("relationtask");
                planId = 0L;
                planId = null != relationtask ? Long.valueOf(relationtask.getLong("planid")) : Long.valueOf(task.getLong("planid"));
                idFilter = new QFilter("id", "=", (Object)planId);
                statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                plan = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"personplan"), (String)"billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, name, planningcycle, planstarttime, timerangestartdate, timerangeenddate, planperson,assigner", (QFilter[])new QFilter[]{idFilter, statusFilter});
                if (null != plan) {
                    org = plan.getDynamicObject("org");
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)belongtype, (CharSequence)"ASSIGNTASK_S")) {
                DynamicObject assigntask = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"assigntask"));
                DynamicObject relationtask2 = assigntask.getDynamicObject("relationtask");
                if (relationtask2 != null) {
                    relationtask2 = BusinessDataServiceHelper.loadSingle((Object)relationtask2.getPkValue(), (String)MetaDataUtil.getEntityId((String)appId, (String)"assigntask"));
                    org = relationtask2.getDynamicObject("creatororg");
                } else {
                    org = assigntask.getDynamicObject("creatororg");
                }
            }
        }
        return org;
    }
}

