/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmpt.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.placs.common.enums.StatusEnum;
import kd.pccs.placs.common.utils.ext.MetaDataUtil;
import kd.pccs.placs.opplugin.ProgressReportOp;
import kd.pmgt.pmbs.business.utils.ProjectSupervisionHelper;
import kd.pmgt.pmbs.common.enums.supervision.FinishStatusWarningEnum;
import kd.pmgt.pmbs.common.utils.StageStatusHelper;

public class PmProgressReportOp
extends ProgressReportOp {
    protected void updateRelateTaskData(List<DynamicObject> tasks) {
        LinkedList<DynamicObject> relateTaskList = new LinkedList<DynamicObject>();
        for (DynamicObject task : tasks) {
            String status;
            DynamicObject sourceTask = task.getDynamicObject("sourcetask");
            Object sourceTaskId = sourceTask == null ? task.getPkValue() : sourceTask.getPkValue();
            QFilter taskFilter = new QFilter("sourcetask", "=", sourceTaskId).or(new QFilter("id", "=", sourceTaskId));
            String properties = "assigner,projectstatus,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf, parent, controllevel, majortype, tasktype, achievementnode, pretask, logical, relativeduration, absoluteduration, planstarttime, planendtime, aimfinishtime, comptimedeviation, responsibleperson, responsibledept, cooperationperson, cooperationdept, comment, realendtime, resultdoc, prechangetask, version, realtimedeviation, belongplantype, sourcetask, completionstatus, percent, sharer, project, relationtask, islatest, taskseq, planid, riskcolor, responsiblepost, associatepost, templatetask, tasksource, expecttime, multicooperationperson, multicooperationdept, completedescription,taskresultdocentry,billstatus,meettask";
            DynamicObject[] allTaskOfPlan = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)properties, (QFilter[])new QFilter[]{taskFilter});
            Set taskIdSet = Arrays.stream(allTaskOfPlan).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            QFilter relationFilter = new QFilter("relationtask", "in", taskIdSet);
            DynamicObject[] relationTasks = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)this.getAppId(), (String)"task"), (String)properties, (QFilter[])new QFilter[]{relationFilter});
            BigDecimal percent = task.getBigDecimal("percent");
            Date expectTime = task.getDate("expecttime");
            Date realEndTime = task.getDate("realendtime");
            String completionStatus = task.getString("completionstatus");
            String completeDescription = task.getString("completedescription");
            BigDecimal realTimeDeviation = task.getBigDecimal("realtimedeviation");
            if (percent.intValue() == 100) {
                for (DynamicObject taskOfSomeVer : allTaskOfPlan) {
                    status = taskOfSomeVer.getString("status");
                    if (status.equalsIgnoreCase(StatusEnum.CHECKED.getValue())) continue;
                    taskOfSomeVer.set("percent", (Object)percent);
                    taskOfSomeVer.set("realendtime", (Object)realEndTime);
                    taskOfSomeVer.set("completionstatus", (Object)completionStatus);
                    taskOfSomeVer.set("completedescription", (Object)completeDescription);
                    taskOfSomeVer.set("realtimedeviation", (Object)realTimeDeviation);
                    relateTaskList.add(taskOfSomeVer);
                }
            } else {
                for (DynamicObject taskOfSomeVer : allTaskOfPlan) {
                    status = taskOfSomeVer.getString("status");
                    if (status.equalsIgnoreCase(StatusEnum.CHECKED.getValue())) continue;
                    taskOfSomeVer.set("percent", (Object)percent);
                    taskOfSomeVer.set("realendtime", null);
                    taskOfSomeVer.set("expecttime", (Object)expectTime);
                    taskOfSomeVer.set("completionstatus", (Object)completionStatus);
                    taskOfSomeVer.set("completedescription", (Object)completeDescription);
                    taskOfSomeVer.set("realtimedeviation", (Object)realTimeDeviation);
                    relateTaskList.add(taskOfSomeVer);
                }
            }
            if (percent.intValue() == 100) {
                for (DynamicObject relationTask : relationTasks) {
                    relationTask.set("percent", (Object)percent);
                    relationTask.set("realendtime", (Object)realEndTime);
                    relationTask.set("completionstatus", (Object)completionStatus);
                    relationTask.set("completedescription", (Object)completeDescription);
                    relationTask.set("realtimedeviation", (Object)realTimeDeviation);
                    relateTaskList.add(relationTask);
                }
            } else {
                for (DynamicObject relationTask : relationTasks) {
                    relationTask.set("percent", (Object)percent);
                    relationTask.set("realendtime", null);
                    relationTask.set("expecttime", (Object)expectTime);
                    relationTask.set("completionstatus", (Object)completionStatus);
                    relationTask.set("completedescription", (Object)completeDescription);
                    relationTask.set("realtimedeviation", (Object)realTimeDeviation);
                    relateTaskList.add(relationTask);
                }
            }
            this.updateProjectStage(task);
            StageStatusHelper.updateWbsSchedule((DynamicObject)task.getDynamicObject("project"), (DynamicObject)task.getDynamicObject("projectstatus"));
            this.updateWorkExecution(task);
        }
        SaveServiceHelper.save((DynamicObject[])relateTaskList.toArray(new DynamicObject[0]));
    }

    private void updateWorkExecution(DynamicObject task) {
        BigDecimal percent = task.getBigDecimal("percent");
        if (BigDecimal.valueOf(100L).compareTo(percent) != 0) {
            return;
        }
        DynamicObject workItem = task.getDynamicObject("workitem");
        if (workItem != null) {
            workItem = BusinessDataServiceHelper.loadSingle((Object)workItem.getPkValue(), (String)"pmbs_workexecution");
            String itemWarningLight = workItem.getString("itemwarninglight");
            boolean finished = Arrays.asList(FinishStatusWarningEnum.ONTIMEFINISH.getValue(), FinishStatusWarningEnum.OVERDUEFINISH.getValue()).contains(itemWarningLight);
            if (!finished) {
                Date realEndTime = task.getDate("realendtime");
                Date planEndTime = task.getDate("planendtime");
                workItem.set("actualendtime", (Object)realEndTime);
                String light = ProjectSupervisionHelper.getItemWarnLight((Date)planEndTime, (Date)realEndTime);
                workItem.set("itemwarninglight", (Object)light);
                SaveServiceHelper.update((DynamicObject)workItem);
            }
        }
    }

    protected void updateProjectStage(DynamicObject task) {
        DynamicObject projectStatus = task.getDynamicObject("projectstatus");
        if (projectStatus != null) {
            projectStatus.set("statuspercent", (Object)task.getBigDecimal("percent"));
            SaveServiceHelper.update((DynamicObject)projectStatus);
        }
    }
}

