/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ProjectExecstatusHelper {
    private static final Log logger = LogFactory.getLog(ProjectExecstatusHelper.class);

    public static Boolean checkReference(IFormView view) {
        try {
            DynamicObject project = (DynamicObject)view.getModel().getValue("project");
            QFilter projectFilter = new QFilter("project", "=", (Object)project.getLong("id"));
            QFilter statusFilter = new QFilter("billstatus", "not in", (Object)new String[]{StatusEnum.TEMPSAVE.getValue(), StatusEnum.CHECKED.getValue()});
            QFilter sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            DynamicObject[] approvalAmtModify = BusinessDataServiceHelper.load((String)"pmas_approval_amtmodify", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter});
            if (approvalAmtModify.length > 0) {
                String billNo = approvalAmtModify[0].getString("billNo");
                String billName = approvalAmtModify[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            DynamicObject[] pmasOutbudget = BusinessDataServiceHelper.load((String)"pmas_outbudget", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, sourceTypeFilter});
            if (pmasOutbudget.length > 0) {
                String billNo = pmasOutbudget[0].getString("billNo");
                String billName = pmasOutbudget[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.IN.getValue());
            DynamicObject[] pmasInbudget = BusinessDataServiceHelper.load((String)"pmas_inbudget", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, sourceTypeFilter});
            if (pmasInbudget.length > 0) {
                String billNo = pmasInbudget[0].getString("billNo");
                String billName = pmasInbudget[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
            DynamicObject[] pmasTotalBudget = BusinessDataServiceHelper.load((String)"pmas_totalbudget", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, sourceTypeFilter});
            if (pmasTotalBudget.length > 0) {
                String billNo = pmasTotalBudget[0].getString("billNo");
                String billName = pmasTotalBudget[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            QFilter paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
            DynamicObject[] outContract = BusinessDataServiceHelper.load((String)"pmct_outcontract", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (outContract.length > 0) {
                String billNo = outContract[0].getString("billNo");
                String billName = outContract[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
            DynamicObject[] inContract = BusinessDataServiceHelper.load((String)"pmct_incontract", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (inContract.length > 0) {
                String billNo = inContract[0].getString("billNo");
                String billName = inContract[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
            DynamicObject[] outContractSettle = BusinessDataServiceHelper.load((String)"pmct_outcontract_settle", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (outContractSettle.length > 0) {
                String billNo = outContractSettle[0].getString("billNo");
                String billName = outContractSettle[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
            DynamicObject[] inContractSettle = BusinessDataServiceHelper.load((String)"pmct_incontract_settle", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (inContractSettle.length > 0) {
                String billNo = inContractSettle[0].getString("billNo");
                String billName = inContractSettle[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            DynamicObject[] paymentApply = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter});
            if (paymentApply.length > 0) {
                String billNo = paymentApply[0].getString("billNo");
                String billName = paymentApply[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            DynamicObject[] costSplit = BusinessDataServiceHelper.load((String)"pmco_procostsplit", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter});
            if (costSplit.length > 0) {
                String billNo = costSplit[0].getString("billNo");
                String billName = costSplit[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
            DynamicObject[] inContractRevision = BusinessDataServiceHelper.load((String)"pmct_incontractrevision", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (inContractRevision.length > 0) {
                String billNo = inContractRevision[0].getString("billNo");
                String billName = inContractRevision[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
            DynamicObject[] outContractRevision = BusinessDataServiceHelper.load((String)"pmct_outcontractrevision", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (outContractRevision.length > 0) {
                String billNo = outContractRevision[0].getString("billNo");
                String billName = outContractRevision[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
            DynamicObject[] inContractClaim = BusinessDataServiceHelper.load((String)"pmct_inclaimbill", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (inContractClaim.length > 0) {
                String billNo = inContractClaim[0].getString("billNo");
                String billName = inContractClaim[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
            DynamicObject[] outContractClaim = BusinessDataServiceHelper.load((String)"pmct_outclaimbill", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (outContractClaim.length > 0) {
                String billNo = outContractClaim[0].getString("billNo");
                String billName = outContractClaim[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
            DynamicObject[] inAddAgreement = BusinessDataServiceHelper.load((String)"pmct_inaddagreement", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (inAddAgreement.length > 0) {
                String billNo = inAddAgreement[0].getString("billNo");
                String billName = inAddAgreement[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
            DynamicObject[] outAddAgreement = BusinessDataServiceHelper.load((String)"pmct_outaddagreement", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (outAddAgreement.length > 0) {
                String billNo = outAddAgreement[0].getString("billNo");
                String billName = outAddAgreement[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
            DynamicObject[] inFinalSettle = BusinessDataServiceHelper.load((String)"pmct_infinalsettle", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (inFinalSettle.length > 0) {
                String billNo = inFinalSettle[0].getString("billNo");
                String billName = inFinalSettle[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
            paydirectionFilter = new QFilter("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
            DynamicObject[] outFinalSettle = BusinessDataServiceHelper.load((String)"pmct_outfinalsettle", (String)"id,billno", (QFilter[])new QFilter[]{projectFilter, statusFilter, paydirectionFilter});
            if (outFinalSettle.length > 0) {
                String billNo = outFinalSettle[0].getString("billNo");
                String billName = outFinalSettle[0].getDynamicObjectType().getDisplayName().getLocaleValue();
                ProjectExecstatusHelper.showErrorMessage(billName, billNo, view);
                return false;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return true;
        }
        return true;
    }

    public static void showErrorMessage(String billName, String billNo, IFormView view) {
        view.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\uff08\u7f16\u53f7\uff1a%2$s\uff09\u5c1a\u5728\u5ba1\u6279\u4e2d\uff0c\u9879\u76ee\u4e0d\u5141\u8bb8\u8fdb\u884c\u201c\u8d22\u52a1\u5173\u95ed\u201d\u3002", (String)"ProjectExecstatusHelper_0", (String)"pmgt-pmsc-business", (Object[])new Object[0]), billName, billNo));
    }
}

