/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmsc.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmsc.formplugin.base.AbstractPmscBillPlugin;

public class ProjectAccountsAuditEditPlugin
extends AbstractPmscBillPlugin
implements BeforeF7SelectListener {
    private static final String ISREMOVEPROCESSED = "isremoveprocessed";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit auditLeader = (BasedataEdit)this.getControl("auditleader");
        auditLeader.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "project": {
                DynamicObject[] proAccountsAudits = BusinessDataServiceHelper.load((String)"pmsc_accounts_audit", (String)"project", (QFilter[])new QFilter[0]);
                DynamicObject proObject = this.getModel().getDataEntity(true).getDynamicObject("project");
                if (proAccountsAudits.length > 0) {
                    ArrayList<Object> projectId = new ArrayList<Object>(16);
                    for (DynamicObject projectAccountsAudit : proAccountsAudits) {
                        DynamicObject project = projectAccountsAudit.getDynamicObject("project");
                        if (project == null || proObject != null && proObject.getPkValue().equals(project.getPkValue())) continue;
                        projectId.add(project.getPkValue());
                    }
                    param.setCustomParam("projectId", projectId);
                }
                param.setCustomParam(ISREMOVEPROCESSED, (Object)"true");
                break;
            }
            case "auditleader": {
                QFilter qFilter;
                param.setF7Style(3);
                List qFilterList = param.getListFilterParameter().getQFilters();
                long currUserId = RequestContext.get().getCurrUserId();
                long projectId = 0L;
                Object projectObj = this.getModel().getValue("project");
                if (projectObj != null) {
                    DynamicObject project = (DynamicObject)projectObj;
                    projectId = Long.parseLong(project.getPkValue().toString());
                }
                if ((qFilter = UserOrgRangeHelper.loadUserOrgRanges((Long)currUserId, (Long)projectId)) == null) break;
                qFilterList.add(qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (name) {
            case "project": {
                this.projectChange();
                break;
            }
            case "thirdaudit": {
                Boolean newValue = (Boolean)changeSet[0].getNewValue();
                TextEdit auditUnit = (TextEdit)this.getControl("auditunit");
                auditUnit.setMustInput(newValue.booleanValue());
                break;
            }
            case "prostarttime": {
                this.checkDate("prostarttime", changeSet[0]);
                break;
            }
            case "proendtime": {
                this.checkDate("proendtime", changeSet[0]);
                break;
            }
        }
    }

    protected void checkDate(String timeField, ChangeData changeData) {
        if (StringUtils.equals((CharSequence)timeField, (CharSequence)"prostarttime")) {
            Date proStarTtime = (Date)changeData.getNewValue();
            Date proEndTime = (Date)this.getModel().getValue("proendtime");
            if (proStarTtime != null && proEndTime != null && proStarTtime.after(proEndTime)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9879\u76ee\u5f00\u5de5\u65f6\u95f4\u201d\u4e0d\u5f97\u665a\u4e8e\u201c\u9879\u76ee\u7ae3\u5de5\u65f6\u95f4\u201d\u3002", (String)"ProjectAccountsAuditEditPlugin_4", (String)"pmgt-pmsc-formplugin", (Object[])new Object[0]));
                Date oldValue = (Date)changeData.getOldValue();
                this.getModel().setValue("prostarttime", (Object)oldValue);
            }
        } else if (StringUtils.equals((CharSequence)timeField, (CharSequence)"proendtime")) {
            Date proEndTime = (Date)changeData.getNewValue();
            Date proStarTtime = (Date)this.getModel().getValue("prostarttime");
            if (proStarTtime != null && proEndTime != null && proEndTime.before(proStarTtime)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9879\u76ee\u7ae3\u5de5\u65f6\u95f4\u201d\u4e0d\u5f97\u65e9\u4e8e\u201c\u9879\u76ee\u5f00\u5de5\u65f6\u95f4\u201d\u3002", (String)"ProjectAccountsAuditEditPlugin_5", (String)"pmgt-pmsc-formplugin", (Object[])new Object[0]));
                Date oldValue = (Date)changeData.getOldValue();
                this.getModel().setValue("proendtime", (Object)oldValue);
            }
        }
    }

    private void projectChange() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            DynamicObject sysProject;
            QFilter statusFilter;
            DynamicObject projectApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"billno,probudgetctrl,overallctrlyear,projectctrlbudget, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, kind, pro, planbegindate, planenddate, department, prostatus, proaddress, purpose, currencyfield, parentpro, expincomeamount, sourceamount, outamount, inamount, syscreateorg, budgetperiod, budgetproname, budgetpronumber, accountorg, budgetstage, changereason, budgetctrl, budgetpro, promanager, proadmindivision, budgetcontrolmode, projectcostcontrol, assetratio, proctrltype, bugarea, leaderconttype, description, bugproname, isreport, reportorg, procondition, proproposal, repaudstatus, proleader, projcetbugamt, billname, splittype, projectapplydate,outteampartner,outroleobj,teamorg,teamcompany", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            DynamicObject compAccept = BusinessDataServiceHelper.loadSingle((String)"pmsc_pro_comp_acc", (String)"billno, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, billname, project, prostarttime, proendtime, prototalinvest, acceptleader, constructunit, kind, maincontent, acceptcomments", (QFilter[])new QFilter[]{proFilter, statusFilter = new QFilter("billstatus", "=", (Object)"C")});
            if (compAccept != null && compAccept.getDate("prostarttime") != null) {
                this.getModel().setValue("prostarttime", (Object)compAccept.getDate("prostarttime"));
            } else if (projectApp != null) {
                this.getModel().setValue("prostarttime", (Object)projectApp.getDate("planbegindate"));
            } else {
                sysProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
                if (sysProject != null) {
                    this.getModel().setValue("prostarttime", (Object)sysProject.getDate("planbegindate"));
                }
            }
            if (compAccept != null && compAccept.getDate("proendtime") != null) {
                this.getModel().setValue("proendtime", (Object)compAccept.getDate("proendtime"));
            } else if (projectApp != null) {
                this.getModel().setValue("proendtime", (Object)projectApp.getDate("planenddate"));
            } else {
                sysProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
                if (sysProject != null) {
                    this.getModel().setValue("proendtime", (Object)sysProject.getDate("planenddate"));
                }
            }
        }
    }
}

