/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmsc.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmsc.formplugin.base.AbstractPmscBillPlugin;

public class ProjectCompleteAcceptEditPlugin
extends AbstractPmscBillPlugin
implements BeforeF7SelectListener {
    private static final String ISREMOVEPROCESSED = "isremoveprocessed";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit acceptLeader = (BasedataEdit)this.getControl("acceptleader");
        acceptLeader.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "project": {
                DynamicObject[] proCompleteAccepts = BusinessDataServiceHelper.load((String)"pmsc_pro_comp_acc", (String)"project", (QFilter[])new QFilter[0]);
                DynamicObject proObject = this.getModel().getDataEntity(true).getDynamicObject("project");
                if (proCompleteAccepts.length > 0) {
                    ArrayList<Object> projectId = new ArrayList<Object>(16);
                    for (DynamicObject projectCompleteAccept : proCompleteAccepts) {
                        DynamicObject project = projectCompleteAccept.getDynamicObject("project");
                        if (project == null || proObject != null && proObject.getPkValue().equals(project.getPkValue())) continue;
                        projectId.add(project.getPkValue());
                    }
                    param.setCustomParam("projectId", projectId);
                }
                param.setCustomParam(ISREMOVEPROCESSED, (Object)"true");
                break;
            }
            case "acceptleader": {
                QFilter qFilter;
                param.setF7Style(3);
                List qFilterList = param.getListFilterParameter().getQFilters();
                long currUserId = RequestContext.get().getCurrUserId();
                long projectId = 0L;
                Object projectObj = this.getModel().getValue("project");
                if (projectObj != null) {
                    DynamicObject project = (DynamicObject)projectObj;
                    projectId = Long.parseLong(project.getPkValue().toString());
                }
                if ((qFilter = UserOrgRangeHelper.loadUserOrgRanges((Long)currUserId, (Long)projectId)) == null) break;
                qFilterList.add(qFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (name) {
            case "project": {
                this.projectChange();
                break;
            }
            case "prostarttime": {
                if (newValue == null) break;
                Date newDate = (Date)newValue;
                Date endTime = (Date)this.getModel().getValue("proendtime");
                if (endTime == null || !newDate.after(endTime)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9879\u76ee\u5f00\u5de5\u65f6\u95f4\u201d\u4e0d\u5f97\u665a\u4e8e\u201c\u9879\u76ee\u7ae3\u5de5\u65f6\u95f4\u201d\u3002", (String)"ProjectCompleteAcceptEditPlugin_4", (String)"pmgt-pmsc-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("prostarttime", oldValue);
                break;
            }
            case "proendtime": {
                if (newValue == null) break;
                Date newDate = (Date)newValue;
                Date startTime = (Date)this.getModel().getValue("prostarttime");
                if (startTime == null || !newDate.before(startTime)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9879\u76ee\u7ae3\u5de5\u65f6\u95f4\u201d\u4e0d\u5f97\u65e9\u4e8e\u201c\u9879\u76ee\u5f00\u5de5\u65f6\u95f4\u201d\u3002", (String)"ProjectCompleteAcceptEditPlugin_5", (String)"pmgt-pmsc-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("proendtime", oldValue);
                break;
            }
        }
    }

    private void projectChange() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            DynamicObject projectApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"billno,probudgetctrl,overallctrlyear,projectctrlbudget, billstatus, creator, modifier, auditor, auditdate, modifytime, createtime, org, kind, pro, planbegindate, planenddate, department, prostatus, proaddress, purpose, currencyfield, parentpro, expincomeamount, sourceamount, outamount, inamount, syscreateorg, budgetperiod, budgetproname, budgetpronumber, accountorg, budgetstage, changereason, budgetctrl, budgetpro, promanager, proadmindivision, budgetcontrolmode, projectcostcontrol, assetratio, proctrltype, bugarea, leaderconttype, description, bugproname, isreport, reportorg, procondition, proproposal, repaudstatus, proleader, projcetbugamt, billname, splittype, projectapplydate,outteampartner,outroleobj,teamorg,teamcompany", (QFilter[])new QFilter[]{new QFilter("pro", "=", project.getPkValue())});
            if (projectApp != null) {
                this.getModel().setValue("kind", (Object)projectApp.getDynamicObject("kind"));
                this.getModel().setValue("prototalinvest", (Object)projectApp.getBigDecimal("projcetbugamt"));
                this.getModel().setValue("prostarttime", (Object)projectApp.getDate("planbegindate"));
                this.getModel().setValue("proendtime", (Object)projectApp.getDate("planenddate"));
            } else {
                DynamicObject sysProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
                if (sysProject != null) {
                    this.getModel().setValue("kind", (Object)sysProject.getDynamicObject("group"));
                    this.getModel().setValue("prostarttime", (Object)sysProject.getDate("planbegindate"));
                    this.getModel().setValue("proendtime", (Object)sysProject.getDate("planenddate"));
                }
            }
        }
    }
}

