/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmsc.formplugin;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmsc.formplugin.base.AbstractPmscBillPlugin;

public class ProjectExecstatusBudgetCtrlPlugin
extends AbstractPmscBillPlugin {
    private static final Log logger = LogFactory.getLog(ProjectExecstatusBudgetCtrlPlugin.class);

    protected DynamicObject getProApproval() {
        Long projectId = (Long)this.getModel().getValue("project_id");
        if (projectId == 0L) {
            return null;
        }
        QFilter projectIdFilter = new QFilter("pro", "=", (Object)projectId);
        DynamicObject proApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{projectIdFilter});
        return proApproval;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"newstatus", (CharSequence)propName)) {
            this.clearProBudgetInfo();
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            if (newValue != null) {
                DynamicObject newStatus = (DynamicObject)newValue;
                String financialCloseId = ProjectStatusEnum.FINANCIAL_CLOSE.getId();
                if (StringUtils.equals((CharSequence)financialCloseId, (CharSequence)newStatus.getString("id"))) {
                    DynamicObject proApproval = this.getProApproval();
                    if (proApproval == null) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"budgetsplitpanel", "outbudgetpanel"});
                        return;
                    }
                    this.updateBudgetInfo(proApproval);
                }
            }
        } else if (StringUtils.equals((CharSequence)"project", (CharSequence)propName)) {
            this.getModel().deleteEntryData("outbudgetusedentry");
            this.getModel().deleteEntryData("budgetsplitentry");
            DynamicObject proApproval = this.getProApproval();
            if (proApproval == null) {
                return;
            }
            this.getModel().setValue("projectapplydate", proApproval.get("projectapplydate"));
            DynamicObject newStatus = this.getModel().getDataEntity().getDynamicObject("newstatus");
            if (newStatus == null) {
                return;
            }
            if (StringUtils.equals((CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getId(), (CharSequence)newStatus.getString("id"))) {
                this.updateBudgetInfo(proApproval);
            }
        }
    }

    protected void updateBudgetInfo(DynamicObject proApproval) {
        int amtPrecision = 10;
        DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("currency");
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        Long projectId = this.getModel().getDataEntity().getLong("project_id");
        QFilter projectFilter = new QFilter("tproject", "=", (Object)projectId);
        QFilter budgetTypeFilter = new QFilter("tbudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{budgetTypeFilter, projectFilter});
        if (totalBudgetCtrl != null) {
            this.fullOutBudgetEntryByCtrl(totalBudgetCtrl, proApproval);
            String controlMode = this.getModel().getDataEntity().getString("budgetcontrolmode");
            if (!BudgetCtlModeEnum.NOTCONTROL.getValue().equals(controlMode)) {
                this.fullBudgetSplitEntry(amtPrecision, projectId, proApproval);
            }
        } else {
            this.fullEntryByBudgetPerform(amtPrecision, proApproval);
        }
    }

    private void fullOutBudgetEntryByCtrl(DynamicObject totalBudgetCtrl, DynamicObject proApproval) {
        try {
            this.getModel().setValue("projcetbugamt", proApproval.get("projcetbugamt"));
            this.getModel().setValue("prooutbudgetsumamt", totalBudgetCtrl.get("tbudgetamt"));
            Long projectId = this.getModel().getDataEntity().getLong("project_id");
            QFilter projectFilter = new QFilter("yproject", "=", (Object)projectId);
            QFilter budgetTypeFilter = new QFilter("ybudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            Date currentYear = (Date)this.getModel().getValue("year");
            if (currentYear == null) {
                currentYear = new Date();
            }
            int year = Integer.parseInt(sdf.format(currentYear));
            QFilter yearFilter = new QFilter("YEAR(yyear)", "=", (Object)year);
            DynamicObject yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{budgetTypeFilter, projectFilter, yearFilter});
            if (yearBudgetCtrl != null) {
                this.getModel().setValue("outamount", yearBudgetCtrl.get("ybudgetamt"));
            }
            this.getModel().setValue("proyearbudgetamt", proApproval.get("proyearbudgetamt"));
            DynamicObjectCollection budgetCtrlDetail = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
            DynamicObjectCollection outBudgetUsedEntryCol = this.getModel().getEntryEntity("outbudgetusedentry");
            DynamicObjectType objectType = outBudgetUsedEntryCol.getDynamicObjectType();
            for (DynamicObject detail : budgetCtrlDetail) {
                outBudgetUsedEntryCol.add((Object)this.buildBudgetEntryByCtrlDetail(detail, objectType));
            }
            this.getModel().updateEntryCache(outBudgetUsedEntryCol);
            if (yearBudgetCtrl != null) {
                DynamicObjectCollection details = yearBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
                Map<Long, DynamicObject> detailsMap = details.stream().collect(Collectors.toMap(dyn -> dyn.getDynamicObject("budget").getLong("id"), dyn -> dyn, (existing, replacement) -> existing));
                DynamicObjectCollection outBudgetUseEntry = this.getModel().getEntryEntity("outbudgetusedentry");
                for (DynamicObject entity : outBudgetUseEntry) {
                    DynamicObject proBudget = entity.getDynamicObject("outprobudgetitem");
                    if (!detailsMap.containsKey(proBudget.getLong("id"))) continue;
                    DynamicObject detail = detailsMap.get(proBudget.getLong("id"));
                    entity.set("yearbudgetamt", detail.get("budgetamt"));
                    entity.set("yearuseamt", detail.get("usageamt"));
                    entity.set("yearmainamt", (Object)detail.getBigDecimal("budgetamt").subtract(detail.getBigDecimal("usageamt")));
                }
            }
            this.getModel().updateEntryCache(outBudgetUsedEntryCol);
            this.getView().updateView("outbudgetusedentry");
            TreeEntryGrid x = (TreeEntryGrid)this.getControl("outbudgetusedentry");
            x.setCollapse(false);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void fullEntryByBudgetPerform(int amtPrecision, DynamicObject proApproval) {
        DynamicObject outBudgetObj;
        HashMap<String, DynamicObject> outBudgetItemNameMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, Integer> outBudgetItemNameMaxRowIndexMap = new HashMap<String, Integer>(16);
        HashMap<String, BigDecimal> outBudgetItemNameMaxSplitAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> outBudgetItemNameTotalSplitAmtMap = new HashMap<String, BigDecimal>(16);
        QFilter outBudgetItemFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        Object projectId = this.getModel().getValue("project_id");
        QFilter projectFilter = new QFilter("project", "=", projectId);
        DynamicObject[] outBudgetItemIdArr = BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"id", (QFilter[])new QFilter[]{projectFilter, outBudgetItemFilter});
        Object[] ids = Arrays.stream(outBudgetItemIdArr).map(dyn -> dyn.getLong("id")).toArray();
        DynamicObject[] outBudgetItemArr = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectbudgetperform"));
        DynamicObjectCollection outBudgetUsedEntryCol = this.getModel().getEntryEntity("outbudgetusedentry");
        DynamicObjectType objectType = outBudgetUsedEntryCol.getDynamicObjectType();
        for (DynamicObject budget : outBudgetItemArr) {
            outBudgetUsedEntryCol.add((Object)this.buildBudgetEntry(budget, objectType));
            outBudgetItemNameMap.put(budget.getString("name"), budget);
            outBudgetItemNameMaxRowIndexMap.put(budget.getString("name"), 0);
            outBudgetItemNameMaxSplitAmtMap.put(budget.getString("name"), BigDecimal.ZERO);
            outBudgetItemNameTotalSplitAmtMap.put(budget.getString("name"), BigDecimal.ZERO);
        }
        this.getModel().updateEntryCache(outBudgetUsedEntryCol);
        this.getView().updateView("outbudgetusedentry");
        TreeEntryGrid x = (TreeEntryGrid)this.getControl("outbudgetusedentry");
        x.setCollapse(false);
        this.getModel().setValue("projcetbugamt", proApproval.get("projcetbugamt"));
        this.getModel().setValue("proyearbudgetamt", proApproval.get("proyearbudgetamt"));
        this.getModel().setValue("splittype", proApproval.get("splittype"));
        QFilter isValidFilter = new QFilter("isvalid", "=", (Object)"1");
        outBudgetItemFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
        DynamicObject validTotalBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudget", (QFilter[])new QFilter[]{isValidFilter, projectFilter, outBudgetItemFilter});
        if (validTotalBudget != null) {
            this.getModel().setValue("prooutbudgetsumamt", validTotalBudget.get("totalamount"));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date currentYear = (Date)this.getModel().getValue("year");
        if (currentYear == null) {
            currentYear = new Date();
        }
        int year = Integer.parseInt(sdf.format(currentYear));
        QFilter yearFilter = new QFilter("YEAR(year)", "=", (Object)year);
        outBudgetItemFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject validBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_outbudget", (QFilter[])new QFilter[]{isValidFilter, projectFilter, outBudgetItemFilter, yearFilter});
        if (validBudget == null) {
            return;
        }
        this.getModel().setValue("outamount", validBudget.get("totalamount"));
        BigDecimal proYearBudgetAmt = this.getModel().getDataEntity().getBigDecimal("proyearbudgetamt");
        BigDecimal outAmt = this.getModel().getDataEntity().getBigDecimal("outamount");
        DynamicObjectCollection outBudgetUseEntry = this.getModel().getEntryEntity("outbudgetusedentry");
        BigDecimal yearRemainAmt = outBudgetUseEntry.stream().map(dyn -> dyn.getBigDecimal("yearmainamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("returnbalance", (Object)proYearBudgetAmt.subtract(outAmt).add(yearRemainAmt));
        DynamicObjectCollection realBudgetEntryCol = validBudget.getDynamicObjectCollection("realbudgetentry");
        if (realBudgetEntryCol.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("budgetsplitentry", realBudgetEntryCol.size());
        IDataModel dataModel = this.getModel();
        for (int i = 0; i < realBudgetEntryCol.size(); ++i) {
            DynamicObject realBudgetEntry = (DynamicObject)realBudgetEntryCol.get(i);
            dataModel.setValue("splitoutitem", realBudgetEntry.get("realbudgetitem"), i);
            dataModel.setValue("splitoutitemname", realBudgetEntry.get("realprobudgetname"), i);
            dataModel.setValue("splitundertakeorg", realBudgetEntry.get("realundertakeorg"), i);
            dataModel.setValue("splitundertakeperiod", realBudgetEntry.get("realundertakeperiod"), i);
            dataModel.setValue("splitproname", realBudgetEntry.get("realproname"), i);
            dataModel.setValue("splitpronumber", realBudgetEntry.get("realpronumber"), i);
            dataModel.setValue("splitproid", realBudgetEntry.get("realproid"), i);
            BigDecimal realUndertakeAmt = realBudgetEntry.getBigDecimal("realundertakeamt");
            dataModel.setValue("splitundertakeamt", (Object)realUndertakeAmt, i);
            outBudgetObj = (DynamicObject)outBudgetItemNameMap.get(realBudgetEntry.getString("realprobudgetname"));
            if (outBudgetObj == null) continue;
            BigDecimal performAmt = outBudgetObj.getBigDecimal("performamt");
            BigDecimal budgetAmt = outBudgetObj.getBigDecimal("budgetamount");
            if (budgetAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal splitUseAmt = performAmt.multiply(realUndertakeAmt).divide(budgetAmt, amtPrecision, RoundingMode.HALF_UP);
            BigDecimal maxRowAmt = (BigDecimal)outBudgetItemNameMaxSplitAmtMap.get(realBudgetEntry.getString("realprobudgetname"));
            if (maxRowAmt.compareTo(splitUseAmt) <= 0) {
                outBudgetItemNameMaxRowIndexMap.put(realBudgetEntry.getString("realprobudgetname"), i);
                outBudgetItemNameMaxSplitAmtMap.put(realBudgetEntry.getString("realprobudgetname"), splitUseAmt);
            }
            BigDecimal totalSplitAmt = (BigDecimal)outBudgetItemNameTotalSplitAmtMap.get(realBudgetEntry.getString("realprobudgetname"));
            outBudgetItemNameTotalSplitAmtMap.put(realBudgetEntry.getString("realprobudgetname"), totalSplitAmt.add(splitUseAmt));
            dataModel.setValue("splitusedamt", (Object)splitUseAmt, i);
        }
        for (Map.Entry entry : outBudgetItemNameTotalSplitAmtMap.entrySet()) {
            BigDecimal performAmt;
            BigDecimal diffAmt;
            BigDecimal totalSplitAmt = (BigDecimal)entry.getValue();
            outBudgetObj = (DynamicObject)outBudgetItemNameMap.get(entry.getKey());
            Long parent = outBudgetObj.getLong("parent");
            if (parent != null && parent != 0L || (diffAmt = (performAmt = outBudgetObj.getBigDecimal("performamt")).subtract(totalSplitAmt)).compareTo(BigDecimal.ZERO) == 0) continue;
            Integer maxRowIndex = (Integer)outBudgetItemNameMaxRowIndexMap.get(entry.getKey());
            BigDecimal maxSplitAmt = (BigDecimal)outBudgetItemNameMaxSplitAmtMap.get(entry.getKey());
            dataModel.setValue("splitusedamt", (Object)maxSplitAmt.add(diffAmt), maxRowIndex.intValue());
        }
    }

    protected DynamicObject buildBudgetEntry(DynamicObject budget, DynamicObjectType dynamicObjectType) {
        DynamicObject budgetEntry = new DynamicObject(dynamicObjectType);
        budgetEntry.set("id", budget.getPkValue());
        if (budget.get("parent") != null) {
            budgetEntry.set("pid", (Object)budget.getLong("parent"));
        }
        budgetEntry.set("outprobudgetitem", (Object)budget);
        BigDecimal budgetAmount = budget.getBigDecimal("budgetamount");
        BigDecimal performAmt = budget.getBigDecimal("performamt");
        budgetEntry.set("outbudgetamt", (Object)budgetAmount);
        budgetEntry.set("outuseamt", (Object)performAmt);
        BigDecimal remainAmt = budgetAmount.subtract(performAmt);
        budgetEntry.set("outremainamt", (Object)remainAmt);
        if (budgetAmount.compareTo(BigDecimal.ZERO) != 0) {
            budgetEntry.set("outremainrate", (Object)remainAmt.divide(budgetAmount, 10, RoundingMode.HALF_UP));
        }
        budgetEntry.set("outbudgetitem", budget.get("budgetitem"));
        return budgetEntry;
    }

    protected DynamicObject buildBudgetEntryByCtrlDetail(DynamicObject detail, DynamicObjectType dynamicObjectType) {
        DynamicObject budgetEntry = new DynamicObject(dynamicObjectType);
        DynamicObject proBudget = detail.getDynamicObject("budget");
        budgetEntry.set("id", proBudget.getPkValue());
        if (proBudget.get("parent") != null) {
            budgetEntry.set("pid", (Object)proBudget.getLong("parent"));
        }
        budgetEntry.set("outprobudgetitem", (Object)proBudget);
        BigDecimal budgetAmount = detail.getBigDecimal("budgetamt");
        BigDecimal performAmt = detail.getBigDecimal("usageamt");
        budgetEntry.set("outbudgetamt", (Object)budgetAmount);
        budgetEntry.set("outuseamt", (Object)performAmt);
        BigDecimal remainAmt = budgetAmount.subtract(performAmt);
        budgetEntry.set("outremainamt", (Object)remainAmt);
        if (budgetAmount.compareTo(BigDecimal.ZERO) != 0) {
            budgetEntry.set("outremainrate", (Object)remainAmt.divide(budgetAmount, 10, RoundingMode.HALF_UP));
        }
        budgetEntry.set("outbudgetitem", detail.get("budgetitem"));
        return budgetEntry;
    }

    private void clearProBudgetInfo() {
        this.getModel().deleteEntryData("outbudgetusedentry");
        this.getModel().deleteEntryData("budgetsplitentry");
        this.getModel().setValue("projcetbugamt", null);
        this.getModel().setValue("prooutbudgetsumamt", null);
        this.getModel().setValue("proyearbudgetamt", null);
        this.getModel().setValue("outamount", null);
        this.getModel().setValue("returnbalance", null);
    }

    private void fullBudgetSplitEntry(int amtPrecision, Long projectId, DynamicObject approval) {
        BigDecimal proYearBudgetAmt = this.getModel().getDataEntity().getBigDecimal("proyearbudgetamt");
        BigDecimal outAmt = this.getModel().getDataEntity().getBigDecimal("outamount");
        DynamicObjectCollection outBudgetUseEntry = this.getModel().getEntryEntity("outbudgetusedentry");
        BigDecimal yearRemainAmt = outBudgetUseEntry.stream().map(dyn -> dyn.getBigDecimal("yearmainamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("returnbalance", (Object)proYearBudgetAmt.subtract(outAmt).add(yearRemainAmt));
        QFilter isValidFilter = new QFilter("isvalid", "=", (Object)"1");
        QFilter projectFilter = new QFilter("project", "=", (Object)projectId);
        DynamicObject budgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{isValidFilter, projectFilter});
        if (budgetRecord == null) {
            return;
        }
        DynamicObjectCollection realBudgetEntryCol = budgetRecord.getDynamicObjectCollection("realbudgetentry");
        if (realBudgetEntryCol.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("budgetsplitentry", realBudgetEntryCol.size());
        IDataModel dataModel = this.getModel();
        String splitType = approval.getString("splittype");
        HashMap<Object, BigDecimal> budgetItemSplitSumMap = new HashMap<Object, BigDecimal>(16);
        for (int i = 0; i < realBudgetEntryCol.size(); ++i) {
            DynamicObject realBudgetEntry = (DynamicObject)realBudgetEntryCol.get(i);
            dataModel.setValue("splitoutitem", realBudgetEntry.get("realbudgetitem"), i);
            dataModel.setValue("splitoutitemname", realBudgetEntry.get("realprobudgetname"), i);
            dataModel.setValue("splitundertakeorg", realBudgetEntry.get("realundertakeorg"), i);
            dataModel.setValue("splitundertakeperiod", realBudgetEntry.get("realundertakeperiod"), i);
            dataModel.setValue("splitproname", realBudgetEntry.get("realproname"), i);
            dataModel.setValue("splitpronumber", realBudgetEntry.get("realpronumber"), i);
            dataModel.setValue("splitproid", realBudgetEntry.get("realproid"), i);
            BigDecimal realUndertakeAmt = realBudgetEntry.getBigDecimal("realundertakeamt");
            dataModel.setValue("splitundertakeamt", (Object)realUndertakeAmt, i);
            String key = StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType) ? realBudgetEntry.getDynamicObject("realbudgetitem").getString("id") : realBudgetEntry.getDynamicObject("realbudgetitem").getString("id") + realBudgetEntry.get("realprobudgetname");
            if (budgetItemSplitSumMap.containsKey(key)) {
                BigDecimal underTakeAmtSum = (BigDecimal)budgetItemSplitSumMap.get(key);
                budgetItemSplitSumMap.replace(key, underTakeAmtSum.add(realUndertakeAmt));
                continue;
            }
            budgetItemSplitSumMap.put(key, realUndertakeAmt);
        }
        DynamicObjectCollection outBudgetUsedEntry = this.getModel().getEntryEntity("outbudgetusedentry");
        HashMap<String, BigDecimal> outBudgetEntryAmtMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> budgetItemEntryAmtMap = new HashMap<String, BigDecimal>();
        for (DynamicObject entity : outBudgetUsedEntry) {
            BigDecimal value;
            String key;
            if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
                key = entity.getDynamicObject("outbudgetitem").getString("id");
                value = entity.getBigDecimal("yearuseamt");
                budgetItemEntryAmtMap.put(key, value);
                continue;
            }
            key = entity.getDynamicObject("outbudgetitem").getString("id") + entity.getDynamicObject("outprobudgetitem").getString("name");
            value = entity.getBigDecimal("yearuseamt");
            outBudgetEntryAmtMap.put(key, value);
        }
        DynamicObjectCollection splitEntry = this.getModel().getEntryEntity("budgetsplitentry");
        for (int i = 0; i < splitEntry.size(); ++i) {
            BigDecimal underTakeAmt;
            BigDecimal underTakeAmtSum;
            BigDecimal useAmt;
            String key;
            DynamicObject split = (DynamicObject)splitEntry.get(i);
            if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
                key = split.getDynamicObject("splitoutitem").getString("id");
                useAmt = new BigDecimal(BigInteger.ZERO);
                if (budgetItemEntryAmtMap.containsKey(key)) {
                    useAmt = (BigDecimal)budgetItemEntryAmtMap.get(key);
                }
                underTakeAmtSum = split.getBigDecimal("splitundertakeamt");
                if (budgetItemSplitSumMap.containsKey(key)) {
                    underTakeAmtSum = (BigDecimal)budgetItemSplitSumMap.get(key);
                }
                underTakeAmt = split.getBigDecimal("splitundertakeamt");
                this.getModel().setValue("splitusedamt", (Object)useAmt.multiply(underTakeAmt.divide(underTakeAmtSum, 10, RoundingMode.HALF_UP)), i);
                continue;
            }
            key = split.getDynamicObject("splitoutitem").getString("id") + split.getString("splitoutitemname");
            useAmt = new BigDecimal(BigInteger.ZERO);
            if (outBudgetEntryAmtMap.containsKey(key)) {
                useAmt = (BigDecimal)outBudgetEntryAmtMap.get(key);
            }
            underTakeAmtSum = split.getBigDecimal("splitundertakeamt");
            if (budgetItemSplitSumMap.containsKey(key)) {
                underTakeAmtSum = (BigDecimal)budgetItemSplitSumMap.get(key);
            }
            underTakeAmt = split.getBigDecimal("splitundertakeamt");
            this.getModel().setValue("splitusedamt", (Object)useAmt.multiply(underTakeAmt.divide(underTakeAmtSum, 10, RoundingMode.HALF_UP)), i);
        }
        if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
            this.setDateMask("YYYY");
        } else {
            this.setDateMask("YYYY-MM");
        }
    }

    private void setDateMask(String mask) {
        IClientViewProxy view = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        view.invokeControlMethod("budgetsplitentry", "setColEditorProp", new Object[]{"splitundertakeperiod", "mask", mask});
        this.getView().updateView("budgetsplitentry");
    }
}

