/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmsc.formplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectExecstatusHelper;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;
import kd.pmgt.pmsc.formplugin.base.AbstractPmscBillPlugin;

public class ProjectExecstatusEditPlugin
extends AbstractPmscBillPlugin
implements BeforeF7SelectListener {
    private static final String PROSTATUS_FORM_KEY = "bd_projectstatus";
    private static final String NUMBER = "number";

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (name) {
            case "project": {
                this.changeProject(changeData);
                break;
            }
            case "newstatus": {
                this.changeNewStatus(changeData);
                break;
            }
        }
    }

    private void changeNewStatus(ChangeData changeData) {
        DynamicObjectCollection entryEntity;
        DynamicObject preStatus;
        Boolean checkResult;
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        boolean addEntry = true;
        if (newValue != null && StringUtils.equals((CharSequence)newValue.getString(NUMBER), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue()) && Boolean.FALSE.equals(checkResult = ProjectExecstatusHelper.checkReference((IFormView)this.getView()))) {
            this.getModel().beginInit();
            this.getModel().setValue("newstatus", null);
            this.getModel().endInit();
            return;
        }
        if (newValue != null && StringUtils.equals((CharSequence)newValue.getString(NUMBER), (CharSequence)ProjectStatusEnum.BUSSINESS_CLOSE.getValue()) && !(preStatus = (DynamicObject)this.getModel().getValue("prestatus")).getString(NUMBER).equals(ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u5728\u8d22\u52a1\u5173\u95ed\u7684\u524d\u63d0\u4e0b\uff0c\u624d\u5141\u8bb8\u4e1a\u52a1\u5173\u95ed\u3002", (String)"ProjectExecstatusEditPlugin_17", (String)"pmgt-pmsc-formplugin", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue("newstatus", null);
            this.getModel().endInit();
            return;
        }
        if (newValue != null && (StringUtils.equals((CharSequence)newValue.getString(NUMBER), (CharSequence)ProjectStatusEnum.BUSSINESS_CLOSE.getValue()) || StringUtils.equals((CharSequence)newValue.getString(NUMBER), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue()))) {
            QFilter proStageNumFilter;
            DynamicObject project;
            QFilter projectPkFilter;
            DynamicObject[] stageObj;
            entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity != null && !entryEntity.isEmpty()) {
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", i);
                    String stageNumber = entry.getDynamicObject("projectstage").getString(NUMBER);
                    if (!StringUtils.equals((CharSequence)stageNumber, (CharSequence)ProjectStageEnum.IMPLEMENTATIONSTAGE_S.getValue())) continue;
                    this.getModel().beginInit();
                    this.getModel().setValue("stagenewstatus", (Object)newValue, i);
                    this.getModel().endInit();
                    this.getView().updateView("stagenewstatus", i);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"stagenewstatus"});
                    addEntry = false;
                }
            }
            if (addEntry && (stageObj = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval", (QFilter[])new QFilter[]{projectPkFilter = new QFilter("project", "=", (project = (DynamicObject)this.getModel().getValue("project")).getPkValue()), proStageNumFilter = new QFilter("projectstage.number", "=", (Object)ProjectStageEnum.IMPLEMENTATIONSTAGE_S.getValue())})) != null && stageObj.length > 0) {
                int index = this.getModel().getEntryRowCount("entryentity");
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("projectstage", (Object)stageObj[0].getDynamicObject("projectstage"), index);
                this.getModel().setValue("stageprestatus", (Object)stageObj[0].getDynamicObject("projectstatus"), index);
                this.getModel().beginInit();
                this.getModel().setValue("stagenewstatus", (Object)newValue, index);
                this.getModel().endInit();
                this.getView().updateView("stagenewstatus", index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"stagenewstatus"});
            }
        } else {
            entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity != null && entryEntity.size() > 0) {
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", i);
                    String stageNumber = entry.getDynamicObject("projectstage").getString(NUMBER);
                    DynamicObject newStatus = entry.getDynamicObject("stagenewstatus");
                    if (newStatus == null || !StringUtils.equals((CharSequence)stageNumber, (CharSequence)ProjectStageEnum.IMPLEMENTATIONSTAGE_S.getValue()) || !StringUtils.equals((CharSequence)newStatus.getString(NUMBER), (CharSequence)ProjectStatusEnum.BUSSINESS_CLOSE.getValue()) && !StringUtils.equals((CharSequence)newStatus.getString(NUMBER), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) continue;
                    this.getModel().beginInit();
                    this.getModel().setValue("stagenewstatus", null, i);
                    this.getModel().endInit();
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"stagenewstatus"});
                    this.getView().updateView("stagenewstatus", i);
                }
            }
        }
    }

    private void changeProject(ChangeData changeData) {
        DynamicObject project = (DynamicObject)changeData.getNewValue();
        this.getModel().deleteEntryData("entryentity");
        if (project == null) {
            this.getModel().setValue("prestatus", null);
            this.getModel().setValue("newstatus", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"newstatus"});
        } else {
            QFilter statusFilter = new QFilter("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            QFilter execFilter = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
            String selectProperties = String.join((CharSequence)",", "billno");
            DynamicObject[] projectExecStatusArray = BusinessDataServiceHelper.load((String)"pmsc_projectexecstatus", (String)selectProperties, (QFilter[])new QFilter[]{statusFilter, projectFilter, execFilter}, (String)"auditdate desc");
            if (projectExecStatusArray.length > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u5b58\u5728\u672a\u5ba1\u6838\u7684\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u5355\u201c%s\u201d\u3002", (String)"ProjectExecstatusEditPlugin_14", (String)"pmgt-pmsc-formplugin", (Object[])new Object[0]), projectExecStatusArray[0].getString("billno")));
                this.getModel().setValue("project", null);
                return;
            }
            DynamicObject proStatus = project.getDynamicObject("prostatus");
            this.getModel().setValue("prestatus", (Object)proStatus);
            if (proStatus != null && StringUtils.equals((CharSequence)proStatus.getString(NUMBER), (CharSequence)ProjectStatusEnum.BUSSINESS_CLOSE.getValue())) {
                DynamicObject newStatus = BusinessDataServiceHelper.loadSingle((String)PROSTATUS_FORM_KEY, (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())});
                this.getModel().setValue("newstatus", (Object)newStatus);
                this.getView().setEnable(Boolean.FALSE, new String[]{"newstatus"});
            } else {
                this.getModel().setValue("newstatus", null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"newstatus"});
            }
            DynamicObject projectApproval = BudgetCtrlHelper.getProjectApproval((DynamicObject)project);
            if (projectApproval != null) {
                this.getModel().setValue("currency", projectApproval.get("currencyfield"));
                this.getModel().setValue("budgetcontrolmode", projectApproval.get("budgetcontrolmode"));
            }
            projectFilter = new QFilter("project", "=", project.getPkValue());
            DynamicObjectCollection proStageCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            selectProperties = String.join((CharSequence)",", "projectstage", "statuspercent");
            DynamicObject[] proStatusArray = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)selectProperties, (QFilter[])projectFilter.toArray(), (String)"projectstage.serial");
            if (proStatusArray.length > 0) {
                long[] ids = DB.genLongIds((String)"t_pmsc_projectstatusentry", (int)proStatusArray.length);
                for (int i = 0; i < proStatusArray.length; ++i) {
                    proStatus = proStatusArray[i];
                    DynamicObject proStageEntry = proStageCollection.addNew();
                    proStageEntry.set("id", (Object)ids[i]);
                    DynamicObject currentEntryProjectStage = proStatus.getDynamicObject("projectstage");
                    proStageEntry.set("projectstage", (Object)currentEntryProjectStage);
                    proStageEntry.set("previouspercent", (Object)proStatus.getBigDecimal("statuspercent"));
                    proStageEntry.set("latestpercent", (Object)proStatus.getBigDecimal("statuspercent"));
                }
                this.getModel().updateEntryCache(proStageCollection);
                this.getView().updateView("entryentity");
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit control = (BasedataEdit)this.getControl("newstatus");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit controlP = (BasedataEdit)this.getControl("project");
        controlP.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit controlN = (BasedataEdit)this.getControl("stagenewstatus");
        controlN.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String propName = beforeF7SelectEvent.getProperty().getName();
        List exluproStatus = Stream.of(ProjectStatusEnum.APPROVAL_SUCC.getValue(), ProjectStatusEnum.APPROVAL_FAIL.getValue()).collect(Collectors.toList());
        switch (propName) {
            case "newstatus": {
                DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
                DynamicObject preStatus = this.getModel().getDataEntity().getDynamicObject("prestatus");
                if (project == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"ProjectExecstatusEditPlugin_1", (String)"pmgt-pmsc-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter statusFilter = null;
                if (preStatus != null) {
                    if (StringUtils.equals((CharSequence)preStatus.getString(NUMBER), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
                        QFilter qFilter = new QFilter(NUMBER, "=", (Object)ProjectStatusEnum.BUSSINESS_CLOSE.getValue());
                        qFilter.or(NUMBER, "=", (Object)ProjectStatusEnum.APPROVAL_IN.getValue());
                        DynamicObject[] newStatus = BusinessDataServiceHelper.load((String)PROSTATUS_FORM_KEY, (String)"id", (QFilter[])new QFilter[]{qFilter});
                        if (newStatus.length > 0) {
                            Set statusIds = Arrays.stream(newStatus).map(o -> Long.parseLong(o.getPkValue().toString())).collect(Collectors.toSet());
                            statusFilter = new QFilter("id", "in", statusIds);
                        }
                    }
                    exluproStatus.add(preStatus.getString(NUMBER));
                }
                QFilter filter = new QFilter(NUMBER, "not in", exluproStatus);
                if (statusFilter != null) {
                    filter.and(statusFilter);
                }
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        Object year;
        super.beforeBindData(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue()) && (year = this.getModel().getValue("year")) == null) {
            this.getModel().setValue("year", (Object)new Date());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (project != null && StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue())) {
            DynamicObject proStatus = project.getDynamicObject("prostatus");
            if (proStatus != null && StringUtils.equals((CharSequence)proStatus.getString(NUMBER), (CharSequence)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u5df2\u4e1a\u52a1\u5173\u95ed\uff0c\u65e0\u6cd5\u518d\u66f4\u6539\u5176\u4ed6\u72b6\u6001\u3002", (String)"ProjectExecstatusEditPlugin_15", (String)"pmgt-pmsc-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("project", null);
            } else {
                this.getModel().setValue("prestatus", (Object)proStatus);
                if (proStatus != null && StringUtils.equals((CharSequence)proStatus.getString(NUMBER), (CharSequence)ProjectStatusEnum.BUSSINESS_CLOSE.getValue())) {
                    DynamicObject newStatus = BusinessDataServiceHelper.loadSingle((String)PROSTATUS_FORM_KEY, (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)ProjectStatusEnum.FINANCIAL_CLOSE.getValue())});
                    this.getModel().setValue("newstatus", (Object)newStatus);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"newstatus"});
                }
            }
        }
        if (project != null && StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.TEMPSAVE.getValue())) {
            this.updateProjectStageStatusEntry();
        }
        this.getModel().setDataChanged(false);
    }

    protected void updateProjectStageStatusEntry() {
        boolean needSave = false;
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObjectCollection projectStageStatusEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject projectStageStatusEntry : projectStageStatusEntries) {
            BigDecimal statusPercent;
            DynamicObject projectStage = projectStageStatusEntry.getDynamicObject("projectstage");
            QFilter projectFilter = new QFilter("project", "=", project.getPkValue());
            QFilter projectStageFilter = new QFilter("projectstage", "=", projectStage.getPkValue());
            String selectProperties = String.join((CharSequence)",", "statuspercent");
            DynamicObject projectStatus = BusinessDataServiceHelper.loadSingle((String)"pmas_prostatus", (String)selectProperties, (QFilter[])new QFilter[]{projectFilter, projectStageFilter});
            BigDecimal previousPercent = projectStageStatusEntry.getBigDecimal("previouspercent");
            if (previousPercent.compareTo(statusPercent = projectStatus != null ? projectStatus.getBigDecimal("statuspercent") : BigDecimal.ZERO) == 0) continue;
            needSave = true;
            projectStageStatusEntry.set("previouspercent", (Object)statusPercent);
        }
        this.getModel().updateEntryCache(projectStageStatusEntries);
        this.getView().updateView("entryentity");
        if (needSave) {
            SaveServiceHelper.update((DynamicObject)this.getModel().getDataEntity());
        }
    }
}

