/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmsc.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtrlEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.StageStatusHelper;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;

public class ProjectExecstatusOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ProjectExecstatusOp.class);
    public static final String BUDGET_CONTROL_MODE = "budgetcontrolmode";
    public static final String OUTBUDGET_FORMID = "pmas_outbudget";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("newstatus");
        e.getFieldKeys().add("prestatus");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("pmsc_projectexecstatus");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("budgetpronumber");
        e.getFieldKeys().add("budgetproname");
        e.getFieldKeys().add("budgetpro");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("projectstage");
        e.getFieldKeys().add("stageprestatus");
        e.getFieldKeys().add("stagenewstatus");
        e.getFieldKeys().add("previouspercent");
        e.getFieldKeys().add("latestpercent");
        e.getFieldKeys().add("budgetentry");
        e.getFieldKeys().add("budgetout");
        e.getFieldKeys().add("budgetitem");
        e.getFieldKeys().add("amount");
        e.getFieldKeys().add("budgetbalance");
        e.getFieldKeys().add("undertakeorg");
        e.getFieldKeys().add("entrypronumber");
        e.getFieldKeys().add("entryproid");
        e.getFieldKeys().add("undertakeperiod");
        e.getFieldKeys().add("returnbalance");
        e.getFieldKeys().add("budgetsplitentry");
        e.getFieldKeys().add("splitremindamt");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                String operateKey = this.getOperateKey();
                if ("submit".equals(operateKey)) {
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        String budgetControlMode;
                        DynamicObject data = dataEntity.getDataEntity();
                        DynamicObject project = data.getDynamicObject("project");
                        QFilter projectFilter = new QFilter("pro", "=", project.getPkValue());
                        DynamicObject approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{projectFilter});
                        if (approval == null || (budgetControlMode = approval.getString(ProjectExecstatusOp.BUDGET_CONTROL_MODE)).equals(BudgetCtlModeEnum.NOTCONTROL.getValue())) continue;
                        BigDecimal entriesBalance = data.getDynamicObjectCollection("budgetsplitentry").stream().map(actualBudgetEntry -> actualBudgetEntry.getBigDecimal("splitremindamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        BigDecimal returnBalance = data.getBigDecimal("returnbalance");
                        Long projectId = project.getLong("id");
                        QFilter tProjectFilter = new QFilter("tproject", "=", (Object)projectId);
                        QFilter budgetTypeFilter = new QFilter("tbudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
                        DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{budgetTypeFilter, tProjectFilter});
                        if (totalBudgetCtrl == null || returnBalance.compareTo(entriesBalance) == 0) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u7b97\u5269\u4f59\u91d1\u989d\u5408\u8ba1\u503c\u5fc5\u987b\u7b49\u4e8e\u53ef\u8fd4\u8fd8\u91d1\u989d\u3002", (String)"ProjectExecstatusOp_15", (String)"pmgt-pmsc-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "save": 
            case "submit": {
                for (DynamicObject object : dataEntities) {
                    BigDecimal entriesBalance;
                    BigDecimal budgetBalance;
                    DynamicObject project = (DynamicObject)object.get("project");
                    if (project == null) continue;
                    QFilter filter = new QFilter("project", "=", project.getPkValue());
                    DynamicObjectCollection execStatus = QueryServiceHelper.query((String)"pmsc_projectexecstatus", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{filter});
                    if (!execStatus.isEmpty()) {
                        for (DynamicObject status : execStatus) {
                            if (StringUtils.equals((CharSequence)status.getString("billstatus"), (CharSequence)StatusEnum.CHECKED.getValue()) || status.get("id").equals(object.getPkValue())) continue;
                            e.setCancelMessage(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u5355\uff0c\u65e0\u6cd5\u518d\u6b21\u53d8\u66f4\u72b6\u6001\u3002", (String)"ProjectExecstatusOp_8", (String)"pmgt-pmsc-opplugin", (Object[])new Object[0]));
                            e.setCancel(true);
                            return;
                        }
                    }
                    if (!StringUtils.equals((CharSequence)"submit", (CharSequence)operationKey) || (budgetBalance = object.getBigDecimal("budgetbalance")).compareTo(entriesBalance = object.getDynamicObjectCollection("budgetentry").stream().map(actualBudgetEntry -> actualBudgetEntry.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)) == 0) continue;
                    e.setCancelMessage(ResManager.loadKDString((String)"\u603b\u9884\u7b97\u4f59\u989d\u4e0e\u8fd4\u8fd8\u4f59\u989d\u5408\u8ba1\u4e0d\u7b26\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u63d0\u4ea4\u3002", (String)"ProjectExecstatusOp_9", (String)"pmgt-pmsc-opplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                break;
            }
            case "unaudit": {
                for (DynamicObject object : dataEntities) {
                    DynamicObject project = (DynamicObject)object.get("project");
                    QFilter filter = new QFilter("project.id", "=", project.getPkValue());
                    DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"pmsc_projectexecstatus", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"createtime desc");
                    if (dynamicObjects.length <= 0 || object.getPkValue().equals(dynamicObjects[0].getPkValue())) continue;
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u65b0\u7248\u672c\u7684\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ProjectExecstatusOp_10", (String)"pmgt-pmsc-opplugin", (Object[])new Object[0]), object.getString("billno")));
                    e.setCancel(true);
                    return;
                }
                break;
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                for (DynamicObject dataEntity : dataEntities) {
                    DynamicObject project = dataEntity.getDynamicObject("project");
                    DynamicObject newStatusObj = dataEntity.getDynamicObject("newstatus");
                    if (newStatusObj != null && ProjectStatusEnum.FINANCIAL_CLOSE.getId().equals(newStatusObj.getPkValue().toString())) {
                        DynamicObject projectApproval = BudgetCtrlHelper.getProjectApproval((DynamicObject)project);
                        if (projectApproval == null) continue;
                        String budgetControlMode = projectApproval.getString(BUDGET_CONTROL_MODE);
                        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
                            DynamicObject billObj = this.getBillObj(projectApproval, project);
                            this.newExecuteOccupyAmount(billObj, "audit");
                        } else if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                            this.returnBudget(dataEntity, BudgetCtrlEnum.CLOSE);
                        }
                    }
                    QFilter projectFilter = new QFilter("project.id", "=", project.getPkValue());
                    DynamicObjectCollection projectStatusEntry = dataEntity.getDynamicObjectCollection("entryentity");
                    if (projectStatusEntry == null || projectStatusEntry.isEmpty()) continue;
                    ArrayList<DynamicObject> projectStageStatusList = new ArrayList<DynamicObject>();
                    for (DynamicObject projectStatus : projectStatusEntry) {
                        DynamicObject projectStage = projectStatus.getDynamicObject("projectstage");
                        QFilter projectStageFilter = new QFilter("projectstage", "=", projectStage.getPkValue());
                        String selectProperties = String.join((CharSequence)",", "projectstatus", "statuspercent");
                        DynamicObject projectStageStatus = BusinessDataServiceHelper.loadSingle((String)"pmas_prostatus", (String)selectProperties, (QFilter[])new QFilter[]{projectFilter, projectStageFilter});
                        projectStageStatus.set("statuspercent", (Object)projectStatus.getBigDecimal("latestpercent"));
                        projectStageStatusList.add(projectStageStatus);
                        StageStatusHelper.updateWbsSchedule((DynamicObject)project, (DynamicObject)projectStageStatus);
                    }
                    if (projectStageStatusList.isEmpty()) continue;
                    SaveServiceHelper.update((DynamicObject[])projectStageStatusList.toArray(new DynamicObject[0]));
                }
                break;
            }
            case "unaudit": {
                for (DynamicObject dataEntity : dataEntities) {
                    DynamicObject projectApproval;
                    DynamicObject project = dataEntity.getDynamicObject("project");
                    DynamicObject newStatusObj = dataEntity.getDynamicObject("newstatus");
                    if (newStatusObj != null && ProjectStatusEnum.FINANCIAL_CLOSE.getId().equals(newStatusObj.getPkValue().toString()) && (projectApproval = BudgetCtrlHelper.getProjectApproval((DynamicObject)project)) != null) {
                        String budgetControlMode = projectApproval.getString(BUDGET_CONTROL_MODE);
                        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
                            DynamicObject billObj = this.getBillObj(projectApproval, project);
                            this.newReoccupyAmount(billObj, "unaudit");
                        } else if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                            this.returnBudget(dataEntity, BudgetCtrlEnum.UNCLOSE);
                        }
                    }
                    QFilter projectFilter = new QFilter("project.id", "=", project.getPkValue());
                    DynamicObjectCollection projectStatusEntry = dataEntity.getDynamicObjectCollection("entryentity");
                    if (projectStatusEntry == null || projectStatusEntry.isEmpty()) continue;
                    ArrayList<DynamicObject> projectStageStatusList = new ArrayList<DynamicObject>();
                    for (DynamicObject projectStatus : projectStatusEntry) {
                        DynamicObject projectStage = projectStatus.getDynamicObject("projectstage");
                        QFilter projectStageFilter = new QFilter("projectstage", "=", projectStage.getPkValue());
                        String selectProperties = String.join((CharSequence)",", "projectstatus", "statuspercent");
                        DynamicObject projectStageStatus = BusinessDataServiceHelper.loadSingle((String)"pmas_prostatus", (String)selectProperties, (QFilter[])new QFilter[]{projectFilter, projectStageFilter});
                        projectStageStatus.set("statuspercent", (Object)projectStatus.getBigDecimal("previouspercent"));
                        projectStageStatusList.add(projectStageStatus);
                        StageStatusHelper.updateWbsSchedule((DynamicObject)project, (DynamicObject)projectStageStatus);
                    }
                    if (projectStageStatusList.isEmpty()) continue;
                    SaveServiceHelper.update((DynamicObject[])projectStageStatusList.toArray(new DynamicObject[0]));
                }
                break;
            }
        }
    }

    private DynamicObject getBillObj(DynamicObject projectApprovalObj, DynamicObject project) {
        DynamicObject billObj = null;
        QFilter proFilter = new QFilter("project", "=", project.getPkValue());
        QFilter budgetTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject[] proBudgets = BusinessDataServiceHelper.load((String)OUTBUDGET_FORMID, (String)"id", (QFilter[])new QFilter[]{proFilter, statusFilter, budgetTypeFilter});
        if (proBudgets.length <= 1) {
            billObj = projectApprovalObj;
        } else {
            QFilter validFilter = new QFilter("isvalid", "=", (Object)"1");
            billObj = BusinessDataServiceHelper.loadSingle((String)OUTBUDGET_FORMID, (String)"id, budgetcontrolmode", (QFilter[])new QFilter[]{proFilter, validFilter, budgetTypeFilter});
        }
        return billObj;
    }

    private void newReoccupyAmount(DynamicObject billObj, String operate) {
        String budgetControlMode = billObj.getString(BUDGET_CONTROL_MODE);
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
            try {
                String msg1 = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u5355%1$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%2$s\uff1a", (String)"ProjectExecstatusOp_19", (String)"pmgt-pmsc-opplugin", (Object[])new Object[0]), operate, "unauditclose");
                QFilter qFilter = new QFilter("relatebillid", "=", (Object)billObj.getPkValue().toString());
                DynamicObject newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
                BudgetCtrlHelper.returnBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"unauditclose", (String)msg1);
                String msg2 = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u5355%1$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%2$s\uff1a", (String)"ProjectExecstatusOp_20", (String)"pmgt-pmsc-opplugin", (Object[])new Object[0]), operate, "submitoccupy");
                BudgetCtrlHelper.requestBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg2);
            }
            catch (Exception e) {
                String msg3 = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u5355%1$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%2$s\uff1a\u5f02\u5e38\u3002", (String)"ProjectExecstatusOp_21", (String)"pmgt-pmsc-opplugin", (Object[])new Object[0]), operate, "submitoccupy");
                logger.error(msg3);
                logger.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void newExecuteOccupyAmount(DynamicObject billObj, String operate) {
        String budgetControlMode = billObj.getString(BUDGET_CONTROL_MODE);
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
            try {
                String msg1 = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u5355%1$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u6267\u884c\uff0c\u6267\u884c\u64cd\u4f5c%2$s\uff1a", (String)"ProjectExecstatusOp_13", (String)"pmgt-pmsc-opplugin", (Object[])new Object[0]), operate, "auditclose");
                QFilter qFilter = new QFilter("relatebillid", "=", (Object)billObj.getPkValue().toString());
                DynamicObject newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
                BudgetCtrlHelper.requestBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"auditclose", (boolean)true, (String)msg1);
                String msg2 = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u53d8\u66f4\u5355%1$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u5173\u95ed\u63a5\u53e3\u201cBgControlService.closeBudget\u201d\uff0c\u5173\u95ed\u64cd\u4f5c%2$s\uff1a", (String)"ProjectExecstatusOp_14", (String)"pmgt-pmsc-opplugin", (Object[])new Object[0]), operate, "auditclosereturn");
                BudgetCtrlHelper.closeBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"auditclosereturn", (String)msg2);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void returnBudget(DynamicObject dataEntity, BudgetCtrlEnum type) {
        DynamicObject project = dataEntity.getDynamicObject("project");
        DynamicObject projectApproval = BudgetCtrlHelper.getProjectApproval((DynamicObject)project);
        DynamicObjectCollection currentBudgetEntries = (dataEntity = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmsc_projectexecstatus")).getDynamicObjectCollection("budgetsplitentry");
        if (currentBudgetEntries.isEmpty()) {
            return;
        }
        DynamicObjectCollection budgetOutEntries = projectApproval.getDynamicObjectCollection("realbudgetentry");
        budgetOutEntries.clear();
        for (DynamicObject currentEntry : currentBudgetEntries) {
            DynamicObject entry = budgetOutEntries.addNew();
            entry.set("realbudgetitem", (Object)currentEntry.getDynamicObject("splitoutitem"));
            entry.set("realundertakeamt", (Object)currentEntry.getBigDecimal("splitremindamt"));
            entry.set("realundertakeorg", (Object)currentEntry.getDynamicObject("splitundertakeorg"));
            entry.set("realpronumber", (Object)currentEntry.getString("splitpronumber"));
            entry.set("realproid", (Object)currentEntry.getLong("splitproid"));
            entry.set("realundertakeperiod", (Object)currentEntry.getDate("splitundertakeperiod"));
        }
        BudgetCtrlHelper.invokeAdjustInterface((DynamicObject)projectApproval, (BudgetCtrlEnum)type);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                for (DynamicObject object : dataEntities) {
                    DynamicObjectCollection entryEntity;
                    Object proId = ((DynamicObject)object.get("project")).getPkValue();
                    DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)proId, (String)"bd_project");
                    if (object.get("newstatus") != null) {
                        DynamicObject newStatus = (DynamicObject)object.get("newstatus");
                        String reason = null;
                        if (StringUtils.equals((CharSequence)newStatus.getString("number"), (CharSequence)ProjectStatusEnum.BUSSINESS_CLOSE.getValue())) {
                            reason = "02";
                        }
                        StageStatusHelper.changeProStatus((DynamicObject)project, (DynamicObject)newStatus, (String)reason);
                    }
                    if ((entryEntity = object.getDynamicObjectCollection("entryentity")) == null || entryEntity.isEmpty()) continue;
                    for (DynamicObject entry : entryEntity) {
                        DynamicObject projectStage = entry.getDynamicObject("projectstage");
                        DynamicObject newStatus = entry.getDynamicObject("stagenewstatus");
                        if (newStatus == null) continue;
                        StageStatusHelper.changeStatus((DynamicObject)project, (ProjectStageEnum)ProjectStageEnum.getEnumByValue((Object)projectStage.getString("number")), (ProjectStatusEnum)ProjectStatusEnum.getEnumByValue((Object)newStatus.getString("number")), (boolean)false);
                    }
                }
                break;
            }
            case "unaudit": {
                for (DynamicObject object : dataEntities) {
                    DynamicObjectCollection entryEntity;
                    Object proId = ((DynamicObject)object.get("project")).getPkValue();
                    DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)proId, (String)"bd_project");
                    if (object.get("newstatus") != null) {
                        DynamicObject preStatus = (DynamicObject)object.get("prestatus");
                        StageStatusHelper.changeProStatus((DynamicObject)project, (DynamicObject)preStatus, null);
                    }
                    if ((entryEntity = object.getDynamicObjectCollection("entryentity")) == null || entryEntity.isEmpty()) continue;
                    for (DynamicObject entry : entryEntity) {
                        DynamicObject projectStage = entry.getDynamicObject("projectstage");
                        DynamicObject preStatus = entry.getDynamicObject("stageprestatus");
                        if (preStatus == null) continue;
                        StageStatusHelper.changeStatus((DynamicObject)project, (ProjectStageEnum)ProjectStageEnum.getEnumByValue((Object)projectStage.getString("number")), (ProjectStatusEnum)ProjectStatusEnum.getEnumByValue((Object)preStatus.getString("number")), (boolean)false);
                    }
                }
                break;
            }
        }
    }
}

