/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.helper;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.qmc.mobqc.business.helper.PermissionHelper;
import kd.qmc.mobqc.business.webservicehelper.SpeechRecognitionHelper;
import kd.qmc.mobqc.common.util.RegExpUtils;
import kd.qmc.qcbd.business.commonmodel.helper.BizTypeHelper;
import kd.scmc.msmob.common.consts.DateRange;
import kd.scmc.msmob.common.utils.DateUtils;
import kd.scmc.msmob.pojo.FilterCondition;

public class ListPluginHelper {
    public static QFilter getBizTypeFilter(String pcEntityKey) {
        QFilter qfilterBizType = null;
        QFilter qfilters = new QFilter("billformid", "=", (Object)pcEntityKey);
        DynamicObject[] colls = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"id", (QFilter[])qfilters.toArray());
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)pcEntityKey);
        if (!(mainEntityType instanceof BillEntityType)) {
            return qfilterBizType;
        }
        BillEntityType billEntityType = (BillEntityType)mainEntityType;
        HashSet allBizTypes = new HashSet(16);
        for (DynamicObject coll : colls) {
            Set bizTypes = BizTypeHelper.getAllBizTypes((String)pcEntityKey, (Long)coll.getLong("id"), (String)billEntityType.getBillTypePara());
            if (bizTypes == null) continue;
            allBizTypes.addAll(bizTypes);
        }
        if (!allBizTypes.isEmpty()) {
            qfilterBizType = new QFilter("id", "in", allBizTypes);
        }
        return qfilterBizType;
    }

    public static void addFilterFromParam(MobileFormShowParameter param, List<FilterCondition> qFilters, String paramKey, String filterKey, String entityKey) {
        String key = (String)param.getCustomParam(paramKey);
        if (!StringUtils.isEmpty((CharSequence)key) && RegExpUtils.isNumber((String)key)) {
            FilterCondition filterCondition = new FilterCondition(filterKey, "=", (Object)SpeechRecognitionHelper.getFilterParamName(key, entityKey));
            qFilters.add(filterCondition);
        }
    }

    public static void addQcOrgFilter(IFormView view, List<FilterCondition> filters) {
        MobileFormShowParameter param = (MobileFormShowParameter)view.getFormShowParameter();
        Object orgIdObj = param.getCustomParam("orgid");
        if (orgIdObj == null) {
            return;
        }
        Long orgID = Long.parseLong(String.valueOf(orgIdObj));
        FilterCondition condition = new FilterCondition("org.id", "=", (Object)orgID);
        filters.add(condition);
    }

    public static void addAllPermOrgsFilter(List<FilterCondition> qFilters, String entityNum) {
        long userId = RequestContext.get().getCurrUserId();
        List<Long> allPermOrgsFromUser = PermissionHelper.getAllPermOrgsFromUser(userId, entityNum);
        if (allPermOrgsFromUser != null) {
            FilterCondition condition = new FilterCondition("org", "in", allPermOrgsFromUser);
            qFilters.add(condition);
        }
    }

    public static void setDataRangeFilter(IDataModel model, List<FilterCondition> filters, String key) {
        Date bizBeginTimeValue = (Date)model.getValue("daterangefield_startdate");
        Date bizEndTimeValue = (Date)model.getValue("daterangefield_enddate");
        Date date = bizEndTimeValue = bizEndTimeValue == null ? null : DateUtils.getDayEndTime((Date)bizEndTimeValue);
        if (bizBeginTimeValue != null && bizEndTimeValue != null) {
            DateRange dateRange = new DateRange();
            dateRange.setStartDate(bizBeginTimeValue);
            dateRange.setEndDate(bizEndTimeValue);
            FilterCondition condition = new FilterCondition(key, (Object)dateRange);
            filters.add(condition);
        }
    }
}

