/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.helper;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.qmc.mobqc.business.qmctpl.MobQmcBillListPlugin;

public class PermissionHelper {
    private static Log log = LogFactory.getLog(PermissionHelper.class);
    private static final String MODIFY = "modify";

    public static boolean checkPermission(Long userId, Long orgId, String appId, String entityNum, String permItemId) {
        log.info("\u8c03\u7528PermissionServiceHelper\u65b9\u6cd5\u3010checkPermission\u3011\u4f20\u5165\u53c2\u6570userId\u3010{}\u3011\uff0corgId\u3010{}\u3011\uff0cappId\u3010{}\u3011\uff0centityNum\u3010{}\u3011\uff0cpermItemId\u3010{}\u3011", new Object[]{userId, orgId, appId, entityNum, permItemId});
        int hasPermResult = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"15", (String)appId, (String)entityNum, (String)permItemId);
        log.info("\u8c03\u7528PermissionServiceHelper\u65b9\u6cd5\u3010checkPermission\u3011hasPermResult\u3010{}\u3011", (Object)hasPermResult);
        return hasPermResult == 1;
    }

    public static boolean checkPermission(Long orgId, String appId, String entityKey, String permItemId) {
        log.info("\u8c03\u7528PermissionServiceHelper\u65b9\u6cd5\u3010checkPermission\u3011\u4f20\u5165\u53c2\u6570\uff0corgId\u3010{}\u3011\uff0cappId\u3010{}\u3011\uff0centityKey\u3010{}\u3011\uff0cpermItemId\u3010{}\u3011", new Object[]{orgId, appId, entityKey, permItemId});
        int hasPermResult = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (Long)orgId, (String)"15", (String)appId, (String)entityKey, (String)permItemId);
        log.info("\u8c03\u7528PermissionServiceHelper\u65b9\u6cd5\u3010checkPermission\u3011hasPermResult\u3010{}\u3011", (Object)hasPermResult);
        return hasPermResult == 1;
    }

    public static List<Long> getAllPermOrgsFromUser(Long userId, String entityNum) {
        MainEntityType entityNumMeta = EntityMetadataCache.getDataEntityType((String)entityNum);
        String appNumber = EntityMetadataCache.getAppInfo((String)entityNumMeta.getAppId()).getId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)appNumber, (String)entityNum, (String)"47150e89000000ac");
        if (allPermOrgs.hasAllOrgPerm() && allPermOrgs.getHasPermOrgs().isEmpty()) {
            return null;
        }
        return allPermOrgs.getHasPermOrgs();
    }

    public static boolean checkMutexAndModify(MobQmcBillListPlugin plugin, String billStatus, Long billId, Long orgId) {
        if (!PermissionHelper.checkModify(plugin, billStatus, orgId)) {
            return false;
        }
        if (plugin.isAddModificationMutex(billStatus)) {
            StringBuilder errMsg = new StringBuilder();
            String pcEntityKey = plugin.getPcEntityKey();
            boolean networkExclusive = MutexHelper.require((String)pcEntityKey, (Object)billId, (String)MODIFY, (boolean)Boolean.TRUE, (StringBuilder)errMsg);
            if (!networkExclusive) {
                long userId = RequestContext.get().getCurrUserId();
                QFilter qFilter = new QFilter("objectid", "=", (Object)String.valueOf(billId)).and("entitykey", "=", (Object)pcEntityKey).and("operationkey", "=", (Object)MODIFY).and("user", "=", (Object)userId);
                boolean exists = QueryServiceHelper.exists((String)"bos_datalock", (QFilter[])qFilter.toArray());
                if (exists) {
                    plugin.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5df2\u5728\u5176\u4ed6\u9875\u7b7e\u4e2d\u6253\u5f00\u5f53\u524d\u5355\u636e\uff0c\u5982\u9700\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u70b9\u51fb\u786e\u8ba4\u5f3a\u5236\u8e22\u51fa\u3002", (String)"PermissionHelper_0", (String)"qmc-mobqc-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("release"));
                } else {
                    plugin.getView().showConfirm(String.valueOf(errMsg), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("mutex"));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean checkModify(MobQmcBillListPlugin plugin, String billStatus, Long orgId) {
        boolean hasModifyPerm;
        if (plugin.isCheckModifyPerm(billStatus) && !(hasModifyPerm = PermissionHelper.checkPermission(orgId, plugin.getPcAppId(), plugin.getPcEntityKey(), "4715a0df000000ac"))) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002\u662f\u5426\u8fdb\u5165\u67e5\u770b\u9875\u9762\uff1f", (String)"PermissionHelper_1", (String)"qmc-mobqc-business", (Object[])new Object[0]);
            plugin.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MODIFY));
            return false;
        }
        return true;
    }
}

