/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;

public class QFilterHelper {
    private static final String IDENT_EQ_KEY = "1";
    private static final Integer IDENT_EQ_VAL = 1;

    public static QFilter buildFilterByParams(Map<String, Map<String, String>> filterParams, String filterFieldKey, String queryField) {
        QFilter qFilter = null;
        if (filterParams == null || filterParams.size() == 0) {
            return qFilter;
        }
        Map<String, String> filterInfo = filterParams.get(filterFieldKey);
        if (filterInfo == null || filterInfo.size() == 0) {
            return qFilter;
        }
        String dataType = filterInfo.get("datatype");
        String value = filterInfo.get("value");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return qFilter;
        }
        if ("text".equals(dataType)) {
            if (value.contains(",")) {
                String[] txtValueArr = value.split(",");
                qFilter = new QFilter(queryField, "in", (Object)txtValueArr);
            } else {
                String txtValue = value.replaceAll(" ", "");
                if (txtValue.length() > 0) {
                    qFilter = new QFilter(queryField, "=", (Object)value);
                }
            }
        } else if ("basedata".equals(dataType)) {
            long id = Long.parseLong(value);
            qFilter = new QFilter(queryField, "=", (Object)id);
        } else if ("multibasedata".equals(dataType)) {
            String[] ids = value.split(",");
            ArrayList<Long> idList = new ArrayList<Long>(10);
            for (String id : ids) {
                idList.add(Long.valueOf(id));
            }
            qFilter = new QFilter(queryField, "in", idList);
        } else if ("qty".equals(dataType)) {
            BigDecimal qty = new BigDecimal(value);
            qFilter = new QFilter(queryField, "=", (Object)qty);
        }
        return qFilter;
    }

    public static QFilter buildMultiSelectFilter(IDataModel model, String filterFieldKey, String queryField) {
        DynamicObjectCollection multiSelBaseDatas = (DynamicObjectCollection)model.getValue(filterFieldKey);
        if (multiSelBaseDatas == null) {
            return null;
        }
        int multiBDSize = multiSelBaseDatas.size();
        QFilter multiSelBDFilter = null;
        if (multiBDSize == 1) {
            long baseDataId = ((DynamicObject)multiSelBaseDatas.get(0)).getDynamicObject(1).getLong("id");
            multiSelBDFilter = new QFilter(queryField, "=", (Object)baseDataId);
        } else if (multiBDSize > 1) {
            ArrayList<Long> multiSelBDIds = new ArrayList<Long>(10);
            for (DynamicObject baseDataDy : multiSelBaseDatas) {
                long baseDataId = baseDataDy.getDynamicObject(1).getLong("id");
                multiSelBDIds.add(baseDataId);
            }
            multiSelBDFilter = new QFilter(queryField, "in", multiSelBDIds);
        }
        return multiSelBDFilter;
    }

    public static QFilter buildTextFilter(IDataModel model, String separator, String filterFieldKey, String queryField) {
        String txtValue = (String)model.getValue(filterFieldKey);
        if (StringUtils.isEmpty((CharSequence)txtValue)) {
            return null;
        }
        String txtValueTmp = txtValue.replaceAll(" ", "");
        if (txtValueTmp.length() == 0) {
            return null;
        }
        String[] txtValueArr = txtValue.split(separator);
        return new QFilter(queryField, "in", (Object)txtValueArr);
    }

    public static QFilter getIdentEqFilter() {
        return QFilterHelper.getDefaultFilter("=");
    }

    public static QFilter getIdentNotEqFilter() {
        return QFilterHelper.getDefaultFilter("!=");
    }

    public static QFilter getDefaultFilter(String operatorKey) {
        return new QFilter(IDENT_EQ_KEY, operatorKey, (Object)IDENT_EQ_VAL);
    }
}

