/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.qmc.mobqc.business.design.factory.BillCalcFactory;
import kd.qmc.mobqc.business.design.factory.ClacManager;
import kd.qmc.mobqc.business.design.factory.ICaleFiedMap;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.pojo.ChangedField;

public class QmcBillCalculateHelper {
    private static final Log log = LogFactory.getLog(QmcBillCalculateHelper.class);

    public static DynamicObject calcMainEntry(String entryEntity, DynamicObject bill, List<ChangedField> changedFields, ICaleFiedMap iCaleFiedMap) {
        log.info("QtyAndUnitHelper\u6784\u9020\u5668\u7684\u5165\u53c2\u3010bill\u3011=\u3010{}\u3011\uff0c\u3010entryPropArgsList\u3011=\u3010{}\u3011", (Object)bill, changedFields);
        if (bill == null) {
            String errorMsg = ResManager.loadKDString((String)"QmcBillCalculateHelper.calcMainEntry\u65b9\u6cd5\u7684\u5165\u53c2\u3010bill\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QmcBillCalculateHelper_0", (String)"qmc-mobqc-business", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (changedFields == null || changedFields.isEmpty()) {
            return bill;
        }
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection(entryEntity);
        if (billEntry == null || billEntry.isEmpty()) {
            return bill;
        }
        Map<ChangedField, Object> changedFieldMap = QmcBillCalculateHelper.preCalculate(changedFields, billEntry);
        for (ChangedField entryPropArgs : changedFields) {
            String fieldKey = entryPropArgs.getFieldKey();
            if (StringUtils.isEmpty((CharSequence)fieldKey) || !MetaUtils.isExistEntryFieldKey((DynamicObject)bill, (String)entryEntity, (String)fieldKey)) continue;
            int rowIndex = entryPropArgs.getRowIndex();
            ClacManager propChangedCalcManager = BillCalcFactory.createPropChangedCalcManager(fieldKey, iCaleFiedMap);
            if (propChangedCalcManager == null) continue;
            propChangedCalcManager.calculate(bill, rowIndex);
        }
        QmcBillCalculateHelper.afterPropChangedCalc(billEntry, changedFieldMap);
        return bill;
    }

    private static Map<ChangedField, Object> preCalculate(List<ChangedField> changedFields, DynamicObjectCollection billEntry) {
        HashMap<ChangedField, Object> changedFieldMap = new HashMap<ChangedField, Object>(16);
        for (ChangedField entryPropArgs : changedFields) {
            String fieldKey = entryPropArgs.getFieldKey();
            int rowIndex = entryPropArgs.getRowIndex();
            Object filedValue = ((DynamicObject)billEntry.get(rowIndex)).get(fieldKey);
            changedFieldMap.put(entryPropArgs, filedValue);
        }
        return changedFieldMap;
    }

    private static void afterPropChangedCalc(DynamicObjectCollection billEntry, Map<ChangedField, Object> changedFieldMap) {
        for (Map.Entry<ChangedField, Object> changedFieldEntry : changedFieldMap.entrySet()) {
            ChangedField changedField = changedFieldEntry.getKey();
            String fieldKey = changedField.getFieldKey();
            int rowIndex = changedField.getRowIndex();
            Object fieldValue = changedFieldEntry.getValue();
            DynamicObject entryRow = (DynamicObject)billEntry.get(rowIndex);
            entryRow.set(fieldKey, fieldValue);
        }
    }
}

