/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class QmcLicenseServiceHelper {
    private static Log logger = LogFactory.getLog(QmcLicenseServiceHelper.class);

    public static void checkOpenMobForm(PreOpenFormEventArgs evt) {
        MobileFormShowParameter frmParam = (MobileFormShowParameter)evt.getFormShowParameter();
        String mobFormKey = frmParam.getFormId();
        if (StringUtils.isBlank((CharSequence)mobFormKey)) {
            return;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("mobform.number", "=", (Object)mobFormKey);
        String selectProp = StringQMCUtil.getCombStr((String)",", (String[])new String[]{"mobform", "pcentityobject"});
        DynamicObject dataSrcConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"mob_datasourceconfig", (String)selectProp, (QFilter[])qFilter.toArray());
        DynamicObject pcEntityObject = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)dataSrcConfig, (String)"pcentityobject");
        if (pcEntityObject == null) {
            return;
        }
        MainEntityType pcBillEntityType = MetadataServiceHelper.getDataEntityType((String)pcEntityObject.getString("number"));
        String pcBillFormId = pcBillEntityType.getName();
        AppInfo pcInfo = AppMetadataCache.getAppInfo((String)pcBillEntityType.getAppId());
        long userID = UserServiceHelper.getCurrentUserId();
        LicenseCheckResult checkResult = LicenseServiceHelper.checkByAppAndBizObj((String)pcInfo.getId(), (String)pcBillFormId, (Long)userID);
        if (!checkResult.getHasLicense().booleanValue()) {
            evt.setCancelMessage(checkResult.getMsg());
            evt.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
            evt.setCancel(true);
            logger.info("checkOpenMobForm:" + checkResult.getMsg());
        }
    }
}

