/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.helper;

import java.math.BigDecimal;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.qmc.mobqc.business.design.factory.ICaleFiedMap;
import kd.qmc.mobqc.common.constant.BigDecimalConstants;
import kd.qmc.mobqc.common.errorcode.QmcBillErrorCode;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.scmc.msmob.common.utils.CommonUtils;
import kd.scmc.msmob.common.utils.MetaUtils;

public class QtyAndUnitHelper {
    private DynamicObject bill;
    private String mainEntryKey;
    private ICaleFiedMap mICaleFiedMap;

    public QtyAndUnitHelper(DynamicObject bill, String mainEntryKey, ICaleFiedMap iCaleFiedMap) {
        if (bill == null || StringUtils.isEmpty((CharSequence)mainEntryKey) || iCaleFiedMap == null) {
            String errorMsg = ResManager.loadKDString((String)"QtyAndUnitHelper\u6784\u9020\u5668\u7684\u5165\u53c2\u3010bill\u3011\u548c\u3010mainEntryKey\u3011\u548c\u3010ICaleFiedMap\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxAlgorithmHelper_0", (String)"qmc-mobqc-business", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        this.bill = bill;
        this.mainEntryKey = mainEntryKey;
        this.mICaleFiedMap = iCaleFiedMap;
    }

    private void setValue(String entryKey, String fieldKey, Object value, int entryRow) {
        DynamicObjectCollection entryColl = this.bill.getDynamicObjectCollection(entryKey);
        if (entryColl == null || entryColl.isEmpty()) {
            return;
        }
        DynamicObject row = (DynamicObject)entryColl.get(entryRow);
        row.set(fieldKey, value);
    }

    private Object getValue(String fieldKey) {
        return this.bill.get(fieldKey);
    }

    private Object getValue(String entryKey, String fieldKey, int entryRow) {
        DynamicObjectCollection entryColl = this.bill.getDynamicObjectCollection(entryKey);
        if (entryColl == null || entryColl.isEmpty()) {
            return null;
        }
        DynamicObject row = (DynamicObject)entryColl.get(entryRow);
        return row.get(fieldKey);
    }

    public void calcBaseQtyByQty(int rowIndex) {
        DynamicObject materialcfg = (DynamicObject)this.getValue(this.mainEntryKey, this.mICaleFiedMap.getFieldByFixF("materialcfg"), rowIndex);
        if (materialcfg == null) {
            return;
        }
        DynamicObject material = (DynamicObject)this.getValue(this.mainEntryKey, this.mICaleFiedMap.getFieldByFixF("materialid"), rowIndex);
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)this.getValue(this.mainEntryKey, this.mICaleFiedMap.getFieldByFixF("baseunit"), rowIndex);
        if (baseUnit == null) {
            return;
        }
        DynamicObject unit = (DynamicObject)this.getValue(this.mainEntryKey, this.mICaleFiedMap.getFieldByFixF("unit"), rowIndex);
        if (unit == null) {
            return;
        }
        BigDecimal qty = (BigDecimal)this.getValue(this.mainEntryKey, this.mICaleFiedMap.getFieldByFixF("qty"), rowIndex);
        BigDecimal baseQty = this.getDestQtyBySrcQty(material, unit, baseUnit, qty);
        if (baseQty == null) {
            baseQty = BigDecimal.ZERO;
        }
        this.showBigDecimalErrorTip(this.mICaleFiedMap.getFieldByFixF("baseqty"), baseQty);
        this.setValue(this.mainEntryKey, this.mICaleFiedMap.getFieldByFixF("baseqty"), baseQty, rowIndex);
    }

    public void calcByQty(int rowIndex) {
        this.calcBaseQtyByQty(rowIndex);
    }

    private BigDecimal getDestQtyBySrcQty(DynamicObject material, DynamicObject srcUnit, DynamicObject destUnit, BigDecimal srcQty) {
        BigDecimal baseQty = BaseUnitQtyConVertUtil.getQtyConvert((Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)material), (Long)DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)srcUnit), (BigDecimal)srcQty, (DynamicObject)destUnit);
        return baseQty;
    }

    public void showBigDecimalErrorTip(String qtyKey, BigDecimal qty) {
        String displayName = null;
        String langName = RequestContext.get().getLang().name();
        if (MetaUtils.isExistFieldKey((DynamicObject)this.bill, (String)qtyKey)) {
            DynamicProperty property = this.bill.getDynamicObjectType().getProperty(qtyKey);
            displayName = (String)property.getDisplayName().get((Object)langName);
        } else if (MetaUtils.isExistEntryFieldKey((DynamicObject)this.bill, (String)this.mainEntryKey, (String)qtyKey)) {
            DynamicObjectCollection billEntry = this.bill.getDynamicObjectCollection(this.mainEntryKey);
            if (billEntry == null || billEntry.isEmpty()) {
                return;
            }
            DynamicProperty property = ((DynamicObject)billEntry.get(0)).getDynamicObjectType().getProperty(qtyKey);
            displayName = (String)property.getDisplayName().get((Object)langName);
        }
        if (displayName != null && qty.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new QmcBillErrorCode().getERROR_MAX_BY_DISPLAYNAME(displayName)));
        }
    }
}

