/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.helper.change;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.qmc.mobqc.business.qmctpl.IMobSubEntryPage;
import kd.qmc.mobqc.business.qmctpl.IMobSubRowPage;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.EntryMappingIndex;
import kd.scmc.msmob.business.helper.change.IEntryPage;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.business.helper.change.VisitingContext;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;
import kd.scmc.msmob.business.helper.change.context.RowAddedContext;
import kd.scmc.msmob.business.helper.change.context.RowDeletedContext;
import kd.scmc.msmob.business.helper.change.extension.EntryPageFieldsExtension;
import kd.scmc.msmob.business.helper.change.extension.EntryRowAddedExtension;
import kd.scmc.msmob.business.helper.change.extension.EntryRowDeletedExtension;
import kd.scmc.msmob.business.helper.change.extension.PropertyChangedExtension;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowDeletedHandler;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;
import kd.scmc.msmob.pojo.DataSourceConfig;

public class QmcDataChangedHandlerHelper {
    private static Log logger = LogFactory.getLog(QmcDataChangedHandlerHelper.class);

    public static <P extends AbstractMobFormPlugin> Map<String, String> getRelationshipOfEntryPage(P plugin) {
        Map relationship = ((IEntryPage)plugin).getRelationship();
        String mobileEntityId = ((IMobilePage)plugin).getPcEntityStorageView().getEntityId();
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)((IMobilePage)plugin));
        String pcFormId = dataSourceConfig.getPcEntityKey();
        PluginProxy pluginProxy = PluginProxy.create(EntryPageFieldsExtension.class, (String)"mpscmm.msmob.tpl.extension.entry.fields");
        List maps = pluginProxy.callReplace(p -> {
            Map fieldRelationship = p.getFieldRelationship(mobileEntityId, pcFormId, ((IMobilePage)plugin).getVisitingContext().getPcEntryName());
            return fieldRelationship;
        });
        if (maps != null) {
            maps.forEach(stringStringMap -> {
                if (stringStringMap != null) {
                    relationship.putAll(stringStringMap);
                }
            });
        }
        return relationship;
    }

    private static <P extends AbstractMobFormPlugin & IMobSubRowPage> Map<String, String> getRelationshipOfSubEntryPage(P plugin) {
        Map relationship = ((IEntryPage)plugin).getRelationship();
        String mobileEntityId = plugin.getView().getEntityId();
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)((IMobilePage)plugin));
        String pcFormId = dataSourceConfig.getPcEntityKey();
        PluginProxy pluginProxy = PluginProxy.create(EntryPageFieldsExtension.class, (String)"mpscmm.msmob.tpl.extension.entry.fields");
        List maps = pluginProxy.callReplace(p -> {
            Map fieldRelationship = p.getFieldRelationship(mobileEntityId, pcFormId, ((IMobSubRowPage)plugin).getPcSubEntryName());
            return fieldRelationship;
        });
        if (maps != null) {
            maps.forEach(stringStringMap -> {
                if (stringStringMap != null) {
                    relationship.putAll(stringStringMap);
                }
            });
        }
        return relationship;
    }

    public static <P extends AbstractMobFormPlugin & IMobSubRowPage, H extends IPropertyChangedHandler> void onSubEntryPagePropertyChanged(P plugin, H handler, PropertyChangedArgs e, int changeSubEntryRowIndex) {
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        String mobileFieldName = e.getProperty().getName();
        IFormView pcEntityStorageView = ((IMobilePage)plugin).getPcEntityStorageView();
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)((IMobilePage)plugin));
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IFormView)pcEntityStorageView, (String)dataSourceConfig.getPcEntityKey());
        VisitingContext visitingContext = ((IMobilePage)plugin).getVisitingContext();
        PropertyChangedContext context = new PropertyChangedContext(pcEntityFromCache, visitingContext);
        context.setPropertyChangedArgs(e);
        context.setRowIndex(changeSubEntryRowIndex);
        context.setNewValue(newValue);
        context.setOldValue(oldValue);
        context.setMobileFieldName(mobileFieldName);
        context.setMain(false);
        Map<String, String> relationship = QmcDataChangedHandlerHelper.getRelationshipOfSubEntryPage(plugin);
        String pcFieldName = relationship.get(mobileFieldName);
        if (DataChangedHandlerHelper.equals((Object)oldValue, (Object)newValue, (String)pcFieldName) || StringUtils.isBlank((CharSequence)pcFieldName)) {
            return;
        }
        context.setPcEntryName(visitingContext.getPcEntryName());
        context.setPcFieldName(pcFieldName);
        DynamicObject subEntryData = QmcDataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, visitingContext, 0);
        subEntryData.set(pcFieldName, newValue);
        context.setChangePcData(subEntryData);
        if (handler != null) {
            handler.onPropertyChanged(context);
        }
        QmcDataChangedHandlerHelper.invokeSubEntryPropertyChangedExtension(plugin, context);
        DynamicObject calculatedResult = context.getCalculatedResult();
        EntityCacheHelper.savePcEntityToPageCache((IFormView)pcEntityStorageView, (DynamicObject)calculatedResult);
        QmcDataChangedHandlerHelper.setSubEntryPageFieldsFromCache(plugin, changeSubEntryRowIndex);
    }

    public static <P extends AbstractMobFormPlugin & IMobSubRowPage> DataSourceConfig setSubEntryPageFieldsFromCache(P plugin, int subRowIndex) {
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)((IMobilePage)plugin));
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IMobilePage)((IMobilePage)plugin));
        Map<String, String> relationship = QmcDataChangedHandlerHelper.getRelationshipOfSubEntryPage(plugin);
        DynamicObject visitingDataByContext = QmcDataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, ((IMobilePage)plugin).getVisitingContext(), 0);
        IDataModel model = plugin.getView().getModel();
        model.beginInit();
        for (Map.Entry<String, String> fieldKey : relationship.entrySet()) {
            String pcFieldName = fieldKey.getValue();
            Object pcValue = QmcDataChangedHandlerHelper.findField(visitingDataByContext, pcFieldName);
            Control control = plugin.getControl(fieldKey.getKey());
            if (pcValue instanceof MulBasedataDynamicObjectCollection && control instanceof AttachmentEdit) {
                int size = ((MulBasedataDynamicObjectCollection)pcValue).size();
                Object[] attachIds = new Object[size];
                for (int i = 0; i < size; ++i) {
                    Object attachId;
                    DynamicObject attachDynObj = (DynamicObject)((MulBasedataDynamicObjectCollection)pcValue).get(i);
                    attachIds[i] = attachId = attachDynObj.getDynamicObject("fbasedataid").getPkValue();
                }
                model.setValue(fieldKey.getKey(), (Object)attachIds);
                continue;
            }
            model.setValue(fieldKey.getKey(), pcValue);
        }
        model.endInit();
        plugin.getView().updateView();
        return dataSourceConfig;
    }

    public static <P extends AbstractMobFormPlugin & IMobSubEntryPage> DataSourceConfig setSubFormEntryPageFieldsFromCache(P plugin, int rowIndex) {
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)((IMobilePage)plugin));
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IMobilePage)((IMobilePage)plugin));
        Map<String, String> relationship = QmcDataChangedHandlerHelper.getRelationshipOfSubEntryPage(plugin);
        IDataModel model = plugin.getView().getModel();
        DynamicObjectCollection pcEntrys = pcEntityFromCache.getDynamicObjectCollection(((IMobSubRowPage)plugin).getPcEntryName());
        DynamicObject pcEntry = (DynamicObject)pcEntrys.get(rowIndex);
        DynamicObjectCollection pcSubEntrys = pcEntry.getDynamicObjectCollection(((IMobSubRowPage)plugin).getPcSubEntryName());
        String mobEntryKey = ((IMobSubRowPage)plugin).getSubEntryEntityMob();
        int size = pcSubEntrys.size();
        EntryGrid entryCtl = (EntryGrid)plugin.getControl(mobEntryKey);
        if (null != entryCtl) {
            AbstractGrid.GridState entryState = entryCtl.getEntryState();
            int entryPageIndex = entryState.getCurrentPageIndex();
            logger.info("entryPageIndex :" + entryPageIndex);
            Integer pageRows = entryState.getPageRows();
            logger.info("pageRows :" + pageRows);
            model.deleteEntryData(mobEntryKey);
            if (size <= 0) {
                return dataSourceConfig;
            }
            model.batchCreateNewEntryRow(mobEntryKey, size);
            IDataEntityProperty propSubEntryID = model.getProperty("mobsubentryid");
            DynamicObjectCollection mobileEntry = model.getDataEntity(true).getDynamicObjectCollection(mobEntryKey);
            model.beginInit();
            for (int i = 0; i < pcSubEntrys.size(); ++i) {
                DynamicObject pcSubEntry = (DynamicObject)pcSubEntrys.get(i);
                DynamicObject mobEntryRow = (DynamicObject)mobileEntry.get(i);
                for (Map.Entry<String, String> fieldKey : relationship.entrySet()) {
                    String pcFieldName = fieldKey.getValue();
                    String mobFieldName = fieldKey.getKey();
                    Object pcValue = QmcDataChangedHandlerHelper.findField(pcSubEntry, pcFieldName);
                    mobEntryRow.set(mobFieldName, pcValue);
                }
                if (propSubEntryID == null) continue;
                model.setValue(propSubEntryID.getName(), pcSubEntry.getPkValue(), i);
            }
            model.endInit();
            int focusRow = (entryPageIndex - 1) * pageRows + pageRows / 2;
            logger.info("focusRow :" + focusRow);
            plugin.getView().updateView();
            QmcDataChangedHandlerHelper.setFocus(plugin, mobEntryKey, focusRow);
        }
        return dataSourceConfig;
    }

    public static <P extends AbstractFormPlugin & IMobSubEntryPage, H extends IEntryRowDeletedHandler> RowDeletedContext deleteFormSubEntry(P plugin, H handler, String mobileSubEntryKey, int deletedRowIndex, DataSourceConfig dataSourceConfig) {
        int deletedPcRowIndex = ((IMobilePage)plugin).getIndex(deletedRowIndex);
        plugin.getView().getModel().deleteEntryRow(mobileSubEntryKey, deletedRowIndex);
        DynamicObject pcEntity = EntityCacheHelper.getPcEntityFromCache((IFormView)((IMobilePage)plugin).getPcEntityStorageView(), (String)dataSourceConfig.getPcEntityKey());
        DynamicObject visitingDataByContext = QmcDataChangedHandlerHelper.getDataByContextLevel(pcEntity, ((IMobilePage)plugin).getVisitingContext(), 0);
        if (null == visitingDataByContext) {
            return null;
        }
        String pcSubEntryKey = ((IMobSubRowPage)plugin).getPcSubEntryName();
        DynamicObjectCollection billEntry = visitingDataByContext.getDynamicObjectCollection(pcSubEntryKey);
        DynamicObject deletedSubEntry = (DynamicObject)billEntry.get(deletedPcRowIndex);
        RowDeletedContext rowDeletedContext = new RowDeletedContext(pcEntity, pcSubEntryKey, deletedSubEntry, deletedPcRowIndex, ((IMobilePage)plugin).getVisitingContext());
        if (handler != null) {
            handler.onEntryRowDeleted(rowDeletedContext);
        }
        QmcDataChangedHandlerHelper.invokeSubEntryDeletedExtension(plugin, rowDeletedContext);
        DynamicObject billentryDeleteEntry = billEntry.stream().filter(dynamicObject -> dynamicObject.getPkValue() == deletedSubEntry.getPkValue()).findAny().orElse(null);
        if (billentryDeleteEntry != null && ((DynamicObject)billEntry.get(deletedPcRowIndex)).getPkValue().equals(deletedSubEntry.getPkValue())) {
            billEntry.remove(deletedPcRowIndex);
        }
        DataEntityState dataEntityState = pcEntity.getDataEntityState();
        dataEntityState.setRemovedItems(Boolean.TRUE);
        for (int i = 0; i < billEntry.size(); ++i) {
            DynamicObject entryData = (DynamicObject)billEntry.get(i);
            entryData.set("seq", (Object)(i + 1));
        }
        EntityCacheHelper.savePcEntityToPageCache((IFormView)((IMobilePage)plugin).getPcEntityStorageView(), (DynamicObject)rowDeletedContext.getCalculatedResult());
        return rowDeletedContext;
    }

    public static <P extends AbstractMobFormPlugin & IMobSubEntryPage, H extends IEntryRowDeletedHandler> void deleteFormSubEntry(P plugin, H handler, String mobileEntryKey, int deletedRowIndex) {
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)((IMobilePage)plugin));
        RowDeletedContext rowDeletedContext = QmcDataChangedHandlerHelper.deleteFormSubEntry(plugin, handler, mobileEntryKey, deletedRowIndex, dataSourceConfig);
        QmcDataChangedHandlerHelper.setSubFormEntryPageFieldsFromCache(plugin, ((IMobSubRowPage)plugin).getEntryRowIndex());
    }

    public static <P extends AbstractMobFormPlugin & IMobSubEntryPage, H extends IEntryRowAddedHandler> void afterFormSubEntryAddedOperation(P plugin, H handler, String mobileEntryKey, AfterDoOperationEventArgs args) {
        VisitingContext visitingContext;
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)((IMobilePage)plugin));
        String pcEntityKey = dataSourceConfig.getPcEntityKey();
        String pcSubEntryKey = ((IMobSubRowPage)plugin).getPcSubEntryName();
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IMobilePage)((IMobilePage)plugin));
        DynamicObject entryHolder = QmcDataChangedHandlerHelper.getDataByContextLevel(pcEntityFromCache, visitingContext = ((IMobilePage)plugin).getVisitingContext(), 0);
        if (Objects.isNull(entryHolder)) {
            return;
        }
        DynamicObjectCollection pcEntryCollection = entryHolder.getDynamicObjectCollection(pcSubEntryKey);
        DynamicObject newPcEntryRow = pcEntryCollection.addNew();
        int currentEntryRowCount = pcEntryCollection.getRowCount();
        long generatedNewEntryId = DB.genLongId((String)pcEntityKey);
        newPcEntryRow.set("id", (Object)generatedNewEntryId);
        if (newPcEntryRow.containsProperty("seq")) {
            newPcEntryRow.set("seq", (Object)currentEntryRowCount);
        }
        RowAddedContext rowAddedContext = new RowAddedContext(pcEntityFromCache, ((IMobilePage)plugin).getVisitingContext());
        rowAddedContext.setArgs(args);
        rowAddedContext.setPcEntityKey(pcEntityKey);
        rowAddedContext.setPcEntryKey(pcSubEntryKey);
        rowAddedContext.setMobileEntryKey(mobileEntryKey);
        rowAddedContext.setNewEntryRowData(newPcEntryRow);
        if (handler != null) {
            handler.onEntryRowAdded(rowAddedContext);
        }
        QmcDataChangedHandlerHelper.invokeSubEntryRowAddedExtension(plugin, rowAddedContext);
        newPcEntryRow.getDataEntityState().setBizChanged(false);
        EntityCacheHelper.savePcEntityToPageCache((IFormView)((IMobilePage)plugin).getPcEntityStorageView(), (DynamicObject)pcEntityFromCache);
        QmcDataChangedHandlerHelper.setSubFormEntryPageFieldsFromCache(plugin, ((IMobSubRowPage)plugin).getEntryRowIndex());
        plugin.getView().getModel().setEntryCurrentRowIndex(mobileEntryKey, pcEntryCollection.size() - 1);
    }

    public static <P extends AbstractFormPlugin, H extends IEntryRowAddedHandler> void afterBatchPcEntryAddedOperation(P plugin, H handler, String mobileEntryKey, List<Integer> newPcEntryRowIndexs, AfterDoOperationEventArgs args) {
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)((IMobilePage)plugin));
        String pcEntityKey = dataSourceConfig.getPcEntityKey();
        String pcEntryKey = DataChangedHandlerHelper.getPcEntryNameByMobileEntryName((String)mobileEntryKey, (DataSourceConfig)dataSourceConfig);
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IFormView)((IMobilePage)plugin).getPcEntityStorageView(), (String)pcEntityKey);
        VisitingContext visitingContext = ((IMobilePage)plugin).getVisitingContext();
        DynamicObject entryHolder = QmcDataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, visitingContext);
        DynamicObjectCollection pcEntryCollection = entryHolder.getDynamicObjectCollection(pcEntryKey);
        for (Integer newPcEntryRowIndex : newPcEntryRowIndexs) {
            DynamicObject newPcEntryRow = (DynamicObject)pcEntryCollection.get(newPcEntryRowIndex.intValue());
            RowAddedContext rowAddedContext = new RowAddedContext(pcEntityFromCache, ((IMobilePage)plugin).getVisitingContext());
            rowAddedContext.setArgs(args);
            rowAddedContext.setPcEntityKey(pcEntityKey);
            rowAddedContext.setPcEntryKey(pcEntryKey);
            rowAddedContext.setMobileEntryKey(mobileEntryKey);
            rowAddedContext.setNewEntryRowData(newPcEntryRow);
            if (handler != null) {
                handler.onEntryRowAdded(rowAddedContext);
            }
            QmcDataChangedHandlerHelper.invokeEntryRowAddedExtension(plugin, rowAddedContext);
            newPcEntryRow.getDataEntityState().setBizChanged(false);
        }
        DataSourceHelper.loadPcEntityToMobilePage(plugin, (DynamicObject)pcEntityFromCache, (boolean)false);
        plugin.getView().getModel().setEntryCurrentRowIndex(mobileEntryKey, pcEntryCollection.size() - 1);
    }

    public static DynamicObject getVisitingDataByContext(DynamicObject pcEntityFromCache, VisitingContext visitingContext) {
        return QmcDataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, visitingContext, 0);
    }

    private static DynamicObject getVisitingDataByContext(DynamicObject pcEntityFromCache, VisitingContext visitingContext, int index) {
        if (visitingContext == null || visitingContext.getEntryMappingIndices().isEmpty()) {
            return pcEntityFromCache;
        }
        List entryMappingIndices = visitingContext.getEntryMappingIndices();
        if (index == entryMappingIndices.size()) {
            return pcEntityFromCache;
        }
        EntryMappingIndex entryMappingIndex = (EntryMappingIndex)entryMappingIndices.get(index);
        DynamicObject dynamicObject = (DynamicObject)pcEntityFromCache.getDynamicObjectCollection(entryMappingIndex.getPcEntryName()).get(entryMappingIndex.getEntryIndex());
        return QmcDataChangedHandlerHelper.getVisitingDataByContext(dynamicObject, visitingContext, index + 1);
    }

    private static DynamicObject getDataByContextLevel(DynamicObject pcEntityFromCache, VisitingContext visitingContext, int index) {
        if (visitingContext == null || visitingContext.getEntryMappingIndices().isEmpty()) {
            return pcEntityFromCache;
        }
        List entryMappingIndices = visitingContext.getEntryMappingIndices();
        if (index <= entryMappingIndices.size()) {
            EntryMappingIndex entryMappingIndex = (EntryMappingIndex)entryMappingIndices.get(index);
            return (DynamicObject)pcEntityFromCache.getDynamicObjectCollection(entryMappingIndex.getPcEntryName()).get(entryMappingIndex.getEntryIndex());
        }
        return null;
    }

    private static void invokeEntryRowAddedExtension(AbstractFormPlugin plugin, RowAddedContext context) {
        PluginProxy pluginProxy = PluginProxy.create(EntryRowAddedExtension.class, (String)"mpscmm.msmob.tpl.extension.entry.added");
        pluginProxy.callReplace(p -> {
            p.afterEntryAddedOperation(plugin.getView().getEntityId(), context.getPcEntityName(), context.getPcEntryKey(), plugin, context);
            return null;
        });
    }

    private static Object findField(DynamicObject data, String pcFieldName) {
        if (data.containsProperty(pcFieldName)) {
            return data.get(pcFieldName);
        }
        DynamicObject parent = (DynamicObject)data.getParent();
        if (parent == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bbe\u7f6e\u5b57\u6bb5\u3010%s\u3011\u7684\u503c", (String)"QmcDataChangedHandlerHelper_0", (String)"qmc-mobqc-business", (Object[])new Object[0]), pcFieldName));
        }
        return QmcDataChangedHandlerHelper.findField(parent, pcFieldName);
    }

    private static void invokeSubEntryPropertyChangedExtension(AbstractFormPlugin plugin, PropertyChangedContext context) {
        PluginProxy pluginProxy = PluginProxy.create(PropertyChangedExtension.class, (String)"mpscmm.msmob.tpl.extension.property.changed");
        pluginProxy.callReplace(p -> {
            p.onPropertyChanged(plugin.getView().getEntityId(), context.getPcEntityName(), plugin, context);
            return null;
        });
    }

    private static void invokeSubEntryRowAddedExtension(AbstractFormPlugin plugin, RowAddedContext context) {
        PluginProxy pluginProxy = PluginProxy.create(EntryRowAddedExtension.class, (String)"mpscmm.msmob.tpl.extension.entry.added");
        pluginProxy.callReplace(p -> {
            p.afterEntryAddedOperation(plugin.getView().getEntityId(), context.getPcEntityName(), context.getPcEntryKey(), plugin, context);
            return null;
        });
    }

    private static void invokeSubEntryDeletedExtension(AbstractFormPlugin plugin, RowDeletedContext context) {
        PluginProxy pluginProxy = PluginProxy.create(EntryRowDeletedExtension.class, (String)"mpscmm.msmob.tpl.extension.entry.deleted");
        pluginProxy.callReplace(p -> {
            p.onEntryDeleted(plugin.getView().getEntityId(), context.getPcEntityName(), context.getPcEntryKey(), plugin, context);
            return null;
        });
    }

    public static void setFocus(AbstractMobFormPlugin plugin, String entryKey) {
        EntryGrid entryCtl = (EntryGrid)plugin.getControl(entryKey);
        if (null != entryCtl) {
            AbstractGrid.GridState entryState = entryCtl.getEntryState();
            int entryPageIndex = entryState.getCurrentPageIndex();
            logger.info("setFocus : entryPageIndex :" + entryPageIndex);
            Integer pageRows = entryState.getPageRows();
            logger.info("setFocus : pageRows :" + pageRows);
            int focusRow = (entryPageIndex - 1) * pageRows + pageRows / 2;
            logger.info("setFocus : focusRow :" + focusRow);
            QmcDataChangedHandlerHelper.setFocus(plugin, entryKey, focusRow);
        }
    }

    public static void setFocus(AbstractMobFormPlugin plugin, String entryKey, int focusRow) {
        logger.info("setFocus2 : focusRow :" + focusRow);
        EntryGrid entryCtl = (EntryGrid)plugin.getControl(entryKey);
        if (null != entryCtl) {
            entryCtl.setPageIndex(1);
        }
    }
}

