/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.helper.entryrow;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.ext.scmc.operation.entryrowop.model.EntryRowOpArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.BadDealBillSplitEntryRowServiceHelper;
import kd.qmc.qcbd.common.util.MainEntityTypeUtil;
import kd.scmc.msmob.business.helper.EntityCacheHelper;

public class PcEntryRowOpHelper {
    public static <P extends AbstractFormPlugin> List<Integer> executeEntryRowOp(P plugin, Map<String, Object> returnData, String pcEntityKey, String entryKey, int selectRowIndex) {
        int i;
        int rowcount = (Integer)returnData.get("rowcount");
        String addType = returnData.get("createtype").toString();
        String actionId = returnData.get("actionid").toString();
        String pcEntryKey = returnData.get("entrykey").toString();
        JSONArray fieldDataJsonArr = JSON.parseArray((String)returnData.get("fielddata").toString());
        String copyColumnKey = "copyrow";
        if ("entryrowsplit_callback".equals(actionId)) {
            copyColumnKey = "splitrow";
        }
        IFormView mainView = plugin.getView();
        int entryRowCount = mainView.getModel().getEntryRowCount(entryKey);
        int index = StringUtils.equals((CharSequence)"1", (CharSequence)addType) ? selectRowIndex + 1 : entryRowCount;
        DynamicObjectCollection entryLks = null;
        DynamicObject pcBillDyo = EntityCacheHelper.getPcEntityFromCache((IFormView)mainView, (String)pcEntityKey);
        DynamicObjectCollection pcEntrys = pcBillDyo.getDynamicObjectCollection(pcEntryKey);
        DynamicObject curPcEntry = (DynamicObject)pcEntrys.get(selectRowIndex);
        if (PcEntryRowOpHelper.isDrawByBotp(pcBillDyo, pcEntryKey)) {
            entryLks = curPcEntry.getDynamicObjectCollection(pcEntryKey + "_lk");
        }
        ArrayList<Integer> newEntryRowIndexs = new ArrayList<Integer>(rowcount - 1);
        long[] ids = ORM.create().genLongIds(String.format("%s.%s", pcEntityKey, pcEntryKey), rowcount - 1);
        for (i = 0; i < rowcount - 1; ++i) {
            DynamicObject newEntry = new DynamicObject(pcEntrys.getDynamicObjectType());
            newEntry.set("id", (Object)ids[i]);
            for (Object fieldObject : fieldDataJsonArr) {
                boolean isCopy;
                JSONObject fieldSettingMap = (JSONObject)fieldObject;
                String currentMetaDataKey = fieldSettingMap.getString("currentmetadatakey");
                String entryKeyParam = currentMetaDataKey.split("\\.")[0];
                if (!pcEntryKey.equals(entryKeyParam) || !(isCopy = fieldSettingMap.getBoolean(copyColumnKey).booleanValue())) continue;
                String fieldKey = currentMetaDataKey.split("\\.")[1];
                Control control = mainView.getControl(fieldKey);
                if (control instanceof DateRangeEdit) {
                    String startDateFieldKey = ((DateRangeEdit)control).getStartDateFieldKey();
                    String endDateFieldKey = ((DateRangeEdit)control).getEndDateFieldKey();
                    Object startDateField = curPcEntry.get(startDateFieldKey);
                    newEntry.set(startDateFieldKey, startDateField);
                    Object endDateField = curPcEntry.get(endDateFieldKey);
                    newEntry.set(endDateFieldKey, endDateField);
                    continue;
                }
                Object srcValue = curPcEntry.get(fieldKey);
                newEntry.set(fieldKey, srcValue);
            }
            PcEntryRowOpHelper.setEntryRelation(newEntry, pcEntryKey, entryLks);
            newEntryRowIndexs.add(index + i);
            pcEntrys.add(index + i, newEntry);
        }
        for (i = 0; i < pcEntrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)pcEntrys.get(i);
            entry.set("seq", (Object)(i + 1));
        }
        EntryRowOpArgs args = new EntryRowOpArgs();
        args.setView(mainView);
        args.setEntryKey(pcEntryKey);
        args.setSrcRowIndex(selectRowIndex);
        args.setNewRowIndex(newEntryRowIndexs);
        if (MainEntityTypeUtil.isInherit((String)pcEntityKey, (String)"qcp_baddealpbill").booleanValue()) {
            BadDealBillSplitEntryRowServiceHelper.calQtyTypeFields((DynamicObject)pcBillDyo, (EntryRowOpArgs)args);
        }
        EntityCacheHelper.savePcEntityToPageCache((IFormView)mainView, (DynamicObject)pcBillDyo);
        EntityCacheHelper.onPluginDestroyed(plugin);
        return newEntryRowIndexs;
    }

    private static boolean isDrawByBotp(DynamicObject bill, String entryKey) {
        LinkSetElement linkSet;
        boolean isDrawByBotp = false;
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryKey);
        if (!CollectionUtils.isEmpty((Collection)entrys) && Objects.nonNull(linkSet = ConvertMetaServiceHelper.loadLinkSet((String)bill.getDataEntityType().getName()))) {
            List linkItems = linkSet.getItems();
            String linkEntityKey = entryKey + "_lk";
            if (!CollectionUtils.isEmpty((Collection)linkItems)) {
                for (LinkSetItemElement item : linkItems) {
                    if (!entryKey.equals(item.getParentEntityKey())) continue;
                    linkEntityKey = item.getLinkEntityKey();
                    break;
                }
            }
            DynamicObject entryObj = null;
            if (entrys.size() > 0) {
                entryObj = (DynamicObject)entrys.get(0);
            }
            if (entryObj != null && entryObj.getDataEntityType().getProperties().containsKey((Object)linkEntityKey)) {
                for (DynamicObject entry : entrys) {
                    DynamicObjectCollection linkColl = entry.getDynamicObjectCollection(linkEntityKey);
                    if (CollectionUtils.isEmpty((Collection)linkColl)) continue;
                    isDrawByBotp = true;
                    break;
                }
            }
        }
        return isDrawByBotp;
    }

    private static void setEntryRelation(DynamicObject entry, String pcEntryKey, DynamicObjectCollection entryLks) {
        if (!CollectionUtils.isEmpty((Collection)entryLks)) {
            DynamicObjectCollection newEntryLk = entry.getDynamicObjectCollection(pcEntryKey + "_lk");
            for (DynamicObject entryLk : entryLks) {
                DynamicObject newLk = new DynamicObject(entryLk.getDynamicObjectType());
                newLk.set(pcEntryKey + "_lk_stableid", entryLk.get(pcEntryKey + "_lk_stableid"));
                newLk.set(pcEntryKey + "_lk_sbillid", entryLk.get(pcEntryKey + "_lk_sbillid"));
                newLk.set(pcEntryKey + "_lk_sid", entryLk.get(pcEntryKey + "_lk_sid"));
                newEntryLk.add((Object)newLk);
            }
        }
    }
}

