/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.qmctpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.qmc.mobqc.business.design.factory.ICaleFiedMap;
import kd.qmc.mobqc.business.design.icalefield.BaseCaleFiedMap;
import kd.qmc.mobqc.business.helper.change.QmcDataChangedHandlerHelper;
import kd.qmc.mobqc.business.helper.context.BeforeSelectChangedContext;
import kd.qmc.mobqc.business.qmctpl.form.MobQmcBillBeforeF7Select;
import kd.qmc.mobqc.business.qmctpl.handler.IBeforeF7SelectHandler;
import kd.qmc.mobqc.business.qmctpl.handler.QmcBeforeF7SelectHandler;
import kd.qmc.mobqc.business.qmctpl.handler.QmcMainPropertyChangedHandler;
import kd.qmc.mobqc.common.util.BotpUtils;
import kd.qmc.mobqc.common.util.FormUtils;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.business.helper.change.VisitingContext;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class MobQmcBillEntryPlugin
extends EntryEditTplPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"material", "qty", "unit", "org", "billid", "pcentitykey"};
    private static final String[] F7_FIELD_KEYS = new String[]{"material", "unit"};
    private static final String[] BUTTON = new String[]{"warehousescan", "locationscan"};
    private QmcMainPropertyChangedHandler propertyChangedTYHandler = null;
    private List<IBeforeF7SelectHandler> beforef7SelectHandlers = new ArrayList<IBeforeF7SelectHandler>();

    public MobQmcBillEntryPlugin() {
        this.registerPropertyChangedHandler(this.getQmcMainPropertyChangedHandler());
    }

    protected ICaleFiedMap getCaleFieldMap() {
        return new BaseCaleFiedMap();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])F7_FIELD_KEYS);
        this.addClickListeners(BUTTON);
        Tab tab = (Tab)this.getView().getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BotpUtils.setEnableByBotp((IFormView)this.getView(), (Boolean)this.isDrawByBotp(), (String[])new String[]{"material", "unit", "biztype"});
    }

    public void click(EventObject e) {
        String key;
        this.beforClick(e);
        super.click(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "godownuo": 
            case "goupop": {
                this.refreshSubForm();
                break;
            }
            case "warehousescan": 
            case "locationscan": {
                this.getPageCache().put("scan_key", key);
                break;
            }
        }
    }

    private void beforClick(EventObject e) {
        int currentRow = Integer.parseInt(this.getPageCache().get("row"));
        this.getPageCache().put("oldrow", String.valueOf(currentRow));
    }

    public void tabSelected(TabSelectEvent evt) {
        Control ctl = (Control)evt.getSource();
        String ctlKey = ctl.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)ctlKey, (CharSequence)"tabap")) {
            this.tabSelectedSubInfo(evt);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object codeStr = result.get("qrcode_str");
            String code = codeStr == null ? "" : String.valueOf(codeStr);
            String scanKey = this.getView().getPageCache().get("scan_key");
            this.handleScan(scanKey, code);
        }
    }

    public void handleScan(String scanKey, String code) {
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        IPageCache pageCache = this.getView().getPageCache();
        VisitingContext visitingContext = this.getVisitingContext();
        BeforeSelectChangedContext context = new BeforeSelectChangedContext(bill, visitingContext);
        context.setBeforeF7SelectEvent(evt);
        int rowIndex = Integer.parseInt(pageCache.get("row"));
        context.setRowIndex(rowIndex);
        context.setPcEntryName(visitingContext.getPcEntryName());
        String mobileFieldName = evt.getProperty().getName();
        context.setMobileFieldName(mobileFieldName);
        Map<String, String> relationship = QmcDataChangedHandlerHelper.getRelationshipOfEntryPage(this);
        String pcFieldName = relationship.get(mobileFieldName);
        context.setPcFieldName(pcFieldName);
        String pcEntityKey = this.getPcEntityKey();
        MobQmcBillBeforeF7Select selector = new MobQmcBillBeforeF7Select(this.getView());
        selector.initBeforeF7Select(this.getCaleFieldMap());
        selector.beforeF7Select(context, pcEntityKey, rowIndex, bill);
        List<IBeforeF7SelectHandler> beforeHandlers = this.getBeforeF7SelectHandler();
        for (IBeforeF7SelectHandler handler : beforeHandlers) {
            if (handler instanceof QmcBeforeF7SelectHandler) {
                ((QmcBeforeF7SelectHandler)handler).initData(this.getView());
            }
            handler.beforeBizF7Select(evt, context);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void addFieldKeys(List<String> fieldKeyList, String[] fieldArray) {
        for (String field : fieldArray) {
            fieldKeyList.add(field);
        }
    }

    public final void registerPropertyChangedQmcHandler(IPropertyChangedHandler propertyChangedHandler) {
        QmcMainPropertyChangedHandler handler = this.getQmcMainPropertyChangedHandler();
        if (handler != null) {
            handler.registerPropertyChangedHandler(propertyChangedHandler);
        }
    }

    protected boolean isDrawByBotp() {
        IFormView storageView = this.getPcEntityStorageView();
        String pcEntityKey = this.getPcEntityKey();
        return BotpUtils.isDrawByBotp((IFormView)storageView, (String)pcEntityKey);
    }

    private QmcMainPropertyChangedHandler getQmcMainPropertyChangedHandler() {
        QmcMainPropertyChangedHandler handler = this.propertyChangedTYHandler;
        if (handler == null) {
            this.propertyChangedTYHandler = handler = new QmcMainPropertyChangedHandler();
        }
        return handler;
    }

    private List<IPropertyChangedHandler> getPropertyChangedQmcHandlers() {
        List<IPropertyChangedHandler> props = new ArrayList<IPropertyChangedHandler>(16);
        QmcMainPropertyChangedHandler handler = this.getQmcMainPropertyChangedHandler();
        if (handler != null) {
            props = handler.getPropertyChangedHandler();
        }
        return props;
    }

    private void refreshSubForm() {
        int oldRow;
        int currentRow = Integer.parseInt(this.getPageCache().get("row"));
        if (currentRow == (oldRow = Integer.parseInt(this.getPageCache().get("oldrow")))) {
            return;
        }
        String cacheFlexSubInfo = this.getPageCache().get("cache_felx_subinfo");
        String cacheSubFormkey = this.getPageCache().get("cache_sub_formkey");
        this.getPageCache().remove("cache_felx_subinfo");
        this.getPageCache().remove("cache_sub_formkey");
        this.selectTabSubInfo(cacheFlexSubInfo, cacheSubFormkey);
    }

    private void tabSelectedSubInfo(TabSelectEvent evt) {
        if (!(evt.getSource() instanceof Tab)) {
            return;
        }
        String tabKey = evt.getTabKey();
        Tab tab = (Tab)evt.getSource();
        String oldTab = this.getPageCache().get("cache_entry_oldtab");
        String curTab = tab.getCurrentTab();
        if (!StringUtils.equalsIgnoreCase((CharSequence)curTab, (CharSequence)oldTab)) {
            this.getPageCache().remove("cache_felx_subinfo");
            this.getPageCache().remove("cache_sub_formkey");
        }
        this.getPageCache().put("cache_entry_oldtab", tabKey);
    }

    protected void selectTabSubInfo(String felxSubInfo, String subFormKey) {
        IFormView view = this.getView();
        String cacheFlexSubInfo = this.getPageCache().get("cache_felx_subinfo");
        String cacheSubFormkey = this.getPageCache().get("cache_sub_formkey");
        if (StringUtils.equalsIgnoreCase((CharSequence)cacheFlexSubInfo, (CharSequence)felxSubInfo) && StringUtils.equalsIgnoreCase((CharSequence)cacheSubFormkey, (CharSequence)subFormKey)) {
            return;
        }
        this.getPageCache().put("cache_felx_subinfo", felxSubInfo);
        this.getPageCache().put("cache_sub_formkey", subFormKey);
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setCustomParam("mob_entry_pageid", (Object)this.getView().getPageId());
        parameter.setCustomParam("isedit", (Object)(this instanceof IMobBillEditable));
        parameter.setFormId(subFormKey);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(felxSubInfo);
        view.showForm((FormShowParameter)parameter);
    }

    public final void registerBeforeF7SelectHandler(IBeforeF7SelectHandler beforeF7SelectHandler) {
        this.beforef7SelectHandlers.add(beforeF7SelectHandler);
    }

    public final List<IBeforeF7SelectHandler> getBeforeF7SelectHandler() {
        return this.beforef7SelectHandlers;
    }
}

