/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.qmctpl;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.qmc.mobqc.business.design.factory.ICaleFiedMap;
import kd.qmc.mobqc.business.design.icalefield.BaseCaleFiedMap;
import kd.qmc.mobqc.business.helper.QmcLicenseServiceHelper;
import kd.qmc.mobqc.business.helper.context.BeforeSelectChangedContext;
import kd.qmc.mobqc.business.qmctpl.form.MobQmcBillBeforeF7Select;
import kd.qmc.mobqc.business.qmctpl.form.MobQmcBillHandelQrCode;
import kd.qmc.mobqc.business.qmctpl.handler.IBeforeF7SelectHandler;
import kd.qmc.mobqc.business.qmctpl.handler.QmcBeforeF7SelectHandler;
import kd.qmc.mobqc.common.util.BotpUtils;
import kd.qmc.mobqc.common.util.FormUtils;
import kd.qmc.qcbd.common.util.StringQMCUtil;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.business.helper.change.VisitingContext;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import kd.scmc.msmob.plugin.tpl.basetpl.MobPushTargetBillInfoPlugin;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.PropertyNode;

public class MobQmcBillInfoPlugin
extends MobPushTargetBillInfoPlugin
implements PagerClickListener,
BeforeF7SelectListener {
    private static final String[] F7_FIELD_KEYS = new String[]{"material", "biztype", "transactype"};
    private List<IBeforeF7SelectHandler> beforef7SelectHandlers = new ArrayList<IBeforeF7SelectHandler>();

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        QmcLicenseServiceHelper.checkOpenMobForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entry = (CardEntry)this.getControl("entryentity");
        entry.addPagerClickListener((PagerClickListener)this);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])F7_FIELD_KEYS);
    }

    public final void registerBeforeF7SelectHandler(IBeforeF7SelectHandler beforeF7SelectHandler) {
        this.beforef7SelectHandlers.add(beforeF7SelectHandler);
    }

    public final List<IBeforeF7SelectHandler> getBeforeF7SelectHandler() {
        return this.beforef7SelectHandlers;
    }

    protected ICaleFiedMap getCaleFieldMap() {
        return new BaseCaleFiedMap();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean isDraw = this.isDrawByBotp();
        if (isDraw) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"newentryop"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"scanbtn"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"scan"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void pagerClick(PagerClickEvent e) {
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String action = e.getActionId();
        String refreshCallbackActionid = this.getPageCache().get("refresh_callback_actionid");
        if (refreshCallbackActionid == null) {
            refreshCallbackActionid = "";
        }
        if (StringQMCUtil.inside((String)action, (String[])new String[]{"callback", "viewCallBack", "closeCurPage", refreshCallbackActionid}).booleanValue()) {
            super.closedCallBack(e);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        VisitingContext visitingContext = this.getVisitingContext();
        BeforeSelectChangedContext context = new BeforeSelectChangedContext(bill, visitingContext);
        context.setBeforeF7SelectEvent(event);
        String mobileFieldName = event.getProperty().getName();
        context.setMobileFieldName(mobileFieldName);
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)this);
        Map fieldMapping = dataSourceConfig.getFieldMapping();
        PropertyNode pcPropertyNode = (PropertyNode)fieldMapping.get(mobileFieldName);
        if (pcPropertyNode == null) {
            return;
        }
        String pcFieldName = pcPropertyNode.getFieldKey();
        context.setPcFieldName(pcFieldName);
        String pcEntityKey = this.getPcEntityKey();
        MobQmcBillBeforeF7Select selector = new MobQmcBillBeforeF7Select(this.getView());
        selector.initBeforeF7Select(this.getCaleFieldMap());
        selector.beforeF7Select(context, pcEntityKey, 0, bill);
        List<IBeforeF7SelectHandler> beforeHandlers = this.getBeforeF7SelectHandler();
        for (IBeforeF7SelectHandler handler : beforeHandlers) {
            if (handler instanceof QmcBeforeF7SelectHandler) {
                ((QmcBeforeF7SelectHandler)handler).initData(this.getView());
            }
            handler.beforeBizF7Select(event, context);
        }
    }

    protected boolean isDrawByBotp() {
        IFormView view = this.getView();
        String pcEntityKey = this.getPcEntityKey();
        return BotpUtils.isDrawByBotp((IFormView)view, (String)pcEntityKey);
    }

    public String getEntryFormKey() {
        String entryKey = this.getEntryEntity();
        String entryViewFormKey = this.getEntryViewFormKey(entryKey);
        if (this instanceof IMobBillEditable) {
            entryViewFormKey = this.getEntryEditFormKey(entryKey);
        }
        return entryViewFormKey;
    }

    protected void handleQrCode(Object code) {
        super.handleQrCode(code);
        String pcEntityKey = this.getPcEntityKey();
        String entryKey = this.getEntryEntity();
        IEntryRowAddedHandler entryRowAddedHandler = this.getEntryRowAddedHandler();
        MobQmcBillHandelQrCode.handleQrCode(code, pcEntityKey, entryKey, this, entryRowAddedHandler);
    }

    public void setBillStatus() {
        super.setBillStatus();
        String billStatus = (String)this.getModel().getValue("billStatus");
        if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonunaudit"});
        }
    }

    public String getEditFormId() {
        return this.getBillEditFormKey();
    }

    protected void showForm(String editFormKey, String viewFormKey, CloseCallBack closeCallBack) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if (this instanceof IMobBillEditable) {
            parameter.setFormId(editFormKey);
        } else {
            parameter.setFormId(viewFormKey);
        }
        if (null != closeCallBack) {
            parameter.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)parameter);
    }
}

