/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.qmctpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.IFormMutexService;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.mobqc.business.helper.ListPluginHelper;
import kd.qmc.mobqc.business.helper.PermissionHelper;
import kd.qmc.mobqc.business.helper.QmcLicenseServiceHelper;
import kd.qmc.mobqc.business.qmctpl.args.QmcBillListEventArgs;
import kd.qmc.mobqc.business.webservicehelper.SpeechRecognitionHelper;
import kd.qmc.mobqc.common.util.FormUtils;
import kd.qmc.mobqc.common.util.RegExpUtils;
import kd.qmc.qcbd.business.commonmodel.helper.BizTypeHelper;
import kd.scmc.msmob.common.enums.BillSortType;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.common.utils.DateUtils;
import kd.scmc.msmob.common.utils.PropertyValueUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillListTplPlugin;
import kd.scmc.msmob.pojo.FilterCondition;

public class MobQmcBillListPlugin
extends MobBillListTplPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(MobQmcBillListPlugin.class);
    private static final String BILLID = "billid";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    protected String[] paramKey = new String[]{"org", "warehouse", "material"};
    protected String[] filterKey = new String[]{"org.name", "billentry.warehouse.name", "billentry.material.masterid.name"};
    protected String[] entityKey = new String[]{"bos_org", "bd_warehouse", "bd_material"};
    private QmcBillListEventArgs mBillListArgs = null;

    public QmcBillListEventArgs getBillListArg() {
        return new QmcBillListEventArgs();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        QmcLicenseServiceHelper.checkOpenMobForm(e);
    }

    public void afterCreateNewData(EventObject e) {
        Boolean setDefDate = FormUtils.getMobCtlVisbile((String)this.getFormKey(), (String)"daterangefield");
        this.getView().getFormShowParameter().setCustomParam("set_def_date", (Object)String.valueOf(setDefDate));
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit bizType = (MulBasedataEdit)this.getView().getControl("mulbasedatafield");
        if (bizType != null) {
            bizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!PropertyValueUtils.isValueChanged((PropertyChangedArgs)e, (int)0)) {
            return;
        }
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        if (this.mBillListArgs == null) {
            this.mBillListArgs = this.getBillListArg();
        }
        if (this.mBillListArgs.getUpdateDataProp().contains(propName)) {
            model.beginInit();
            this.updateData();
            model.endInit();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propKey = e.getProperty().getName();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgIdObj = param.getCustomParam("orgid");
        if (orgIdObj == null) {
            e.setCancel(true);
            return;
        }
        Long orgID = Long.parseLong(String.valueOf(orgIdObj));
        QFilter qFilter = null;
        switch (propKey) {
            case "mulbasedatafield": {
                qFilter = this.getBizTypeFilter();
                break;
            }
        }
        if (qFilter != null) {
            e.addCustomQFilter(qFilter);
        }
    }

    public void setDefaultDate() {
        MobileFormShowParameter param;
        Object toDoDate;
        String setDefDate = (String)this.getView().getFormShowParameter().getCustomParam("set_def_date");
        if (StringUtils.equalsIgnoreCase((CharSequence)setDefDate, (CharSequence)"true")) {
            super.setDefaultDate();
        }
        if ("todoDate".equals(toDoDate = (param = (MobileFormShowParameter)this.getView().getFormShowParameter()).getCustomParam("todoDate"))) {
            this.setToDoBizDateRange();
            this.getModel().setValue("combofield", (Object)"B");
        }
        if (param.getCustomParam(START_DATE) == null || param.getCustomParam(END_DATE) == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date startDate = sdf.parse((String)param.getCustomParam(START_DATE));
            Date endDate = sdf.parse((String)param.getCustomParam(END_DATE));
            this.getModel().setValue("daterangefield_startdate", (Object)startDate);
            this.getModel().setValue("daterangefield_enddate", (Object)endDate);
        }
        catch (ParseException exception) {
            logger.warn("\u65e5\u671f\u53c2\u6570\u683c\u5f0f\u5f02\u5e38\uff0c\u4f7f\u7528\u6a21\u677f\u9ed8\u8ba4\u65e5\u671f\u8fc7\u6ee4\u3002\u5f02\u5e38\u5f00\u59cb\u65f6\u95f4\uff1a" + param.getCustomParam(START_DATE) + "\u5f02\u5e38\u7ed3\u675f\u65f6\u95f4\uff1a" + param.getCustomParam(END_DATE));
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String arg = e.getEventArgs();
        String key = e.getKey();
        logger.info(String.format("eventName:%s||Key:%s||eventArgs:%s", eventName, key, arg));
        super.customEvent(e);
    }

    protected Map<String, BillSortType> getSortMap() {
        Map sortMap = super.getSortMap();
        sortMap.put("createtime", BillSortType.DESC);
        return sortMap;
    }

    public List<FilterCondition> getFilters() {
        List filters = super.getFilters();
        ListPluginHelper.addQcOrgFilter(this.getView(), filters);
        ListPluginHelper.addAllPermOrgsFilter(filters, this.getPcEntityKey());
        this.addFilters(filters);
        return filters;
    }

    public void entryRowClick(RowClickEvent e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control source = (Control)e.getSource();
        String entryKey = source.getKey();
        if (entryKey.equals(this.getEntryEntity())) {
            int rowIndex = e.getRow();
            String pcEntityKey = this.getPcEntityKey();
            Long billId = (Long)model.getValue("mobid", rowIndex);
            String billNo = (String)model.getValue("billno", rowIndex);
            String status = (String)model.getValue("billstatus", rowIndex);
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("billno", billNo);
            pageCache.put(BILLID, billId == null ? "0" : billId.toString());
            String mainBizOrgKey = this.getMainBizOrgKey();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mainBizOrgKey)) {
                String errMsg = ResManager.loadKDString((String)"\u3010\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u6807\u8bc6\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MobQmcBillListPlugin_0", (String)"qmc-mobqc-business", (Object[])new Object[0]);
                view.showErrorNotification(errMsg);
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)billId);
            DynamicObject billEntity = QueryServiceHelper.queryOne((String)pcEntityKey, (String)("billstatus," + mainBizOrgKey), (QFilter[])qFilter.toArray());
            if (billEntity == null) {
                String errMsg = this.getDeletedErrMsg(billNo);
                view.showErrorNotification(errMsg);
                this.updateData();
                return;
            }
            if (!status.equals(billEntity.getString("billstatus"))) {
                String errMsg = this.getChangedErrMsg(billNo);
                view.showErrorNotification(errMsg);
                this.updateData();
                return;
            }
            long orgId = billEntity.getLong(mainBizOrgKey);
            String billStatus = billEntity.getString("billstatus");
            pageCache.put("billstatus", billStatus);
            if (!PermissionHelper.checkMutexAndModify(this, billStatus, billId, orgId)) {
                return;
            }
            this.showBillPage(billId, billNo, orgId, billStatus, this.isCheckModifyPerm());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        IPageCache pageCache = this.getView().getPageCache();
        String billIdStr = pageCache.get(BILLID);
        Long billId = Long.valueOf(billIdStr);
        Long orgId = Long.valueOf(param.getCustomParam("orgid").toString());
        String billno = pageCache.get("billno");
        String billstatus = pageCache.get("billstatus");
        if ("release".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            IFormMutexService mutexService = (IFormMutexService)this.getView().getService(IFormMutexService.class);
            mutexService.destoryLockingPage(this.getPcEntityKey(), (Object)billId, "modify", true);
            MutexHelper.release((String)this.getPcEntityKey(), (String)"modify", (String)billIdStr);
            StringBuilder errMsg = new StringBuilder();
            MutexHelper.require((String)this.getPcEntityKey(), (Object)billId, (String)"modify", (StringBuilder)errMsg);
            this.showBillPage(billId, billno, orgId, billstatus, this.isCheckModifyPerm());
        }
    }

    private void addFilters(List<FilterCondition> qFilters) {
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        for (int i = 0; i < this.paramKey.length; ++i) {
            ListPluginHelper.addFilterFromParam(param, qFilters, this.paramKey[i], this.filterKey[i], this.entityKey[i]);
        }
    }

    private void addFilterFromParam(MobileFormShowParameter param, List<FilterCondition> qFilters, String paramKey, String filterKey, String entityKey) {
        String key = (String)param.getCustomParam(paramKey);
        if (!StringUtils.isEmpty((CharSequence)key) && RegExpUtils.isNumber((String)key)) {
            FilterCondition filterCondition = new FilterCondition(filterKey, "=", (Object)SpeechRecognitionHelper.getFilterParamName(key, entityKey));
            qFilters.add(filterCondition);
        }
    }

    private void setToDoBizDateRange() {
        IDataModel model = this.getModel();
        Date currDate = new Date();
        Date endDateTime = DateUtils.getDayEndTime((Date)currDate);
        Date startDateTime = DateUtils.getStartTimeOfPastThreeMonths((Date)currDate);
        model.setValue("daterangefield_startdate", (Object)startDateTime);
        model.setValue("daterangefield_enddate", (Object)endDateTime);
    }

    private QFilter getBizTypeFilter() {
        QFilter qfilterBizType = null;
        String pcEntityKey = this.getPcEntityKey();
        QFilter qfilters = new QFilter("billformid", "=", (Object)pcEntityKey);
        DynamicObject[] colls = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"id", (QFilter[])qfilters.toArray());
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)pcEntityKey);
        if (!(mainEntityType instanceof BillEntityType)) {
            return qfilterBizType;
        }
        BillEntityType billEntityType = (BillEntityType)mainEntityType;
        HashSet allBizTypes = new HashSet(16);
        for (DynamicObject coll : colls) {
            Set bizTypes = BizTypeHelper.getAllBizTypes((String)pcEntityKey, (Long)coll.getLong("id"), (String)billEntityType.getBillTypePara());
            if (bizTypes == null) continue;
            allBizTypes.addAll(bizTypes);
        }
        if (!allBizTypes.isEmpty()) {
            qfilterBizType = new QFilter("id", "in", allBizTypes);
        }
        return qfilterBizType;
    }

    private void addQcOrgFilter(List<FilterCondition> filters) {
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgIdObj = param.getCustomParam("orgid");
        if (orgIdObj == null) {
            return;
        }
        Long orgID = Long.parseLong(String.valueOf(orgIdObj));
        FilterCondition condition = new FilterCondition("org.id", "=", (Object)orgID);
        filters.add(condition);
    }

    private void addAllPermOrgsFilter(List<FilterCondition> qFilters) {
        long userId = RequestContext.get().getCurrUserId();
        List<Long> allPermOrgsFromUser = PermissionHelper.getAllPermOrgsFromUser(userId, this.getPcEntityKey());
        if (allPermOrgsFromUser != null) {
            FilterCondition condition = new FilterCondition("org", "in", allPermOrgsFromUser);
            qFilters.add(condition);
        }
    }

    private void showBillPage(Long billId, String billNo, long orgId, String billStatus, boolean checkModifyPerm) {
        IFormView view = this.getView();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgIdAppHome = param.getCustomParam("orgid");
        showParameter.setCustomParam(BILLID, (Object)billId);
        showParameter.setCustomParam("billno", (Object)billNo);
        showParameter.setCustomParam("orgid", orgIdAppHome);
        showParameter.setCustomParam("mainOrg", (Object)orgId);
        showParameter.setCustomParam("isFromList", (Object)Boolean.TRUE);
        showParameter.setCustomParam("checkModifyPerm", (Object)checkModifyPerm);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            this.setEditPageShowParameter(showParameter);
            String formKey = showParameter.getFormId();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formKey)) {
                showParameter.setFormId(this.getBillEditFormKey());
            }
        } else {
            this.setViewPageShowParameter(showParameter);
            String formKey = showParameter.getFormId();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formKey)) {
                showParameter.setFormId(this.getBillViewFormKey());
            }
        }
        showParameter.setClientParam("requestBeforeClose", (Object)true);
        view.showForm((FormShowParameter)showParameter);
    }
}

