/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.qmctpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.qmc.mobqc.business.helper.ListPluginHelper;
import kd.qmc.mobqc.business.qmctpl.args.QmcBillListEventArgs;
import kd.qmc.mobqc.common.util.FormUtils;
import kd.scmc.msmob.common.enums.BillSortType;
import kd.scmc.msmob.common.utils.PropertyValueUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.botp.BotpSrcBillPlugin;
import kd.scmc.msmob.pojo.FilterCondition;

public class MobQmcBotpSrcBillPlugin
extends BotpSrcBillPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(MobQmcBotpSrcBillPlugin.class);
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    protected String[] paramKey = new String[]{"org", "warehouse", "material"};
    protected String[] filterKey = new String[]{"org.name", "billentry.warehouse.name", "billentry.material.masterid.name"};
    protected String[] entityKey = new String[]{"bos_org", "bd_warehouse", "bd_material"};
    private QmcBillListEventArgs mBillListArgs = null;

    public QmcBillListEventArgs getBillListArg() {
        return new QmcBillListEventArgs();
    }

    public void afterCreateNewData(EventObject e) {
        Boolean setDefDate = FormUtils.getMobCtlVisbile((String)this.getFormKey(), (String)"daterangefield");
        this.getView().getFormShowParameter().setCustomParam("set_def_date", (Object)String.valueOf(setDefDate));
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit bizType = (MulBasedataEdit)this.getView().getControl("mulbasedatafield");
        if (bizType != null) {
            bizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!PropertyValueUtils.isValueChanged((PropertyChangedArgs)e, (int)0)) {
            return;
        }
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        if (this.mBillListArgs == null) {
            this.mBillListArgs = this.getBillListArg();
        }
        if (this.mBillListArgs.getUpdateDataProp().contains(propName)) {
            model.beginInit();
            this.updateData();
            model.endInit();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String arg = e.getEventArgs();
        String key = e.getKey();
        logger.info(String.format("eventName:%s||Key:%s||eventArgs:%s", eventName, key, arg));
        super.customEvent(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propKey = e.getProperty().getName();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgIdObj = param.getCustomParam("orgid");
        if (orgIdObj == null) {
            e.setCancel(true);
            return;
        }
        QFilter qFilter = null;
        switch (propKey) {
            case "mulbasedatafield": {
                qFilter = ListPluginHelper.getBizTypeFilter(this.getPcEntityKey());
                break;
            }
        }
        if (qFilter != null) {
            e.addCustomQFilter(qFilter);
        }
    }

    public void setDefaultDate() {
        MobileFormShowParameter formShowParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String setDefDate = (String)formShowParameter.getCustomParam("set_def_date");
        if (StringUtils.equalsIgnoreCase((CharSequence)setDefDate, (CharSequence)"true")) {
            super.setDefaultDate();
        }
        if (formShowParameter.getCustomParam(START_DATE) == null || formShowParameter.getCustomParam(END_DATE) == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date startDate = sdf.parse((String)formShowParameter.getCustomParam(START_DATE));
            Date endDate = sdf.parse((String)formShowParameter.getCustomParam(END_DATE));
            this.getModel().setValue("daterangefield_startdate", (Object)startDate);
            this.getModel().setValue("daterangefield_enddate", (Object)endDate);
        }
        catch (ParseException exception) {
            logger.warn("\u65e5\u671f\u53c2\u6570\u683c\u5f0f\u5f02\u5e38\uff0c\u4f7f\u7528\u6a21\u677f\u9ed8\u8ba4\u65e5\u671f\u8fc7\u6ee4\u3002\u5f02\u5e38\u5f00\u59cb\u65f6\u95f4\uff1a" + formShowParameter.getCustomParam(START_DATE) + "\u5f02\u5e38\u7ed3\u675f\u65f6\u95f4\uff1a" + formShowParameter.getCustomParam(END_DATE));
        }
    }

    protected Map<String, BillSortType> getSortMap() {
        Map sortMap = super.getSortMap();
        sortMap.put("createtime", BillSortType.DESC);
        return sortMap;
    }

    public List<FilterCondition> getFilters() {
        List filters = super.getFilters();
        ListPluginHelper.addQcOrgFilter(this.getView(), filters);
        ListPluginHelper.addAllPermOrgsFilter(filters, this.getPcEntityKey());
        this.addFilters(filters);
        return filters;
    }

    private void addFilters(List<FilterCondition> qFilters) {
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        for (int i = 0; i < this.paramKey.length; ++i) {
            ListPluginHelper.addFilterFromParam(param, qFilters, this.paramKey[i], this.filterKey[i], this.entityKey[i]);
        }
    }
}

