/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.business.qmctpl.form;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.qmc.mobqc.business.design.factory.ICaleFiedMap;
import kd.qmc.mobqc.business.helper.context.BeforeSelectChangedContext;
import kd.qmc.qcbd.business.commonmodel.helper.BizTypeHelper;
import kd.qmc.qcbd.common.util.ControlUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class MobQmcBillBeforeF7Select {
    private IFormView view = null;
    private ICaleFiedMap iCaleFiedMap = null;

    public MobQmcBillBeforeF7Select(IFormView view) {
        this.view = view;
    }

    private IFormView getView() {
        return this.view;
    }

    private ICaleFiedMap getICaleFiedMap() {
        return this.iCaleFiedMap;
    }

    public void initBeforeF7Select(ICaleFiedMap iCaleFiedMap) {
        this.iCaleFiedMap = iCaleFiedMap;
    }

    public void beforeF7Select(BeforeSelectChangedContext context, String pcEntityKey, int rowIndex, DynamicObject bill) {
        BeforeF7SelectEvent evt = context.getBeforeF7SelectEvent();
        String fieldKey = evt.getProperty().getName();
        String pcFieldName = context.getPcFieldName();
        String fixFieldKey = this.getFixFieldKey(pcFieldName);
        if (fixFieldKey == null || StringUtils.isBlank((CharSequence)fixFieldKey)) {
            return;
        }
        DynamicObject pcEntityData = context.getCalculatedResult();
        DynamicObject entryData = this.getEntryData(context, pcEntityData);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        switch (fieldKey) {
            case "biztype": {
                BizTypeHelper.selectBizType((DynamicObject)pcEntityData, (ListShowParameter)showParameter);
                break;
            }
            case "transactype": {
                this.beforeTransactypeF7(pcEntityData, showParameter);
                break;
            }
            case "material": {
                this.selectMaterialCFG(evt, pcEntityKey, rowIndex, bill);
                break;
            }
            case "unit": {
                this.selectUnit(context, entryData, qFilters);
                break;
            }
        }
    }

    private String getFixFieldKey(String pcFieldName) {
        String fixFieldKey = "";
        if (this.getICaleFiedMap() != null) {
            fixFieldKey = this.getICaleFiedMap().getFieldByCalcF(pcFieldName);
        }
        return fixFieldKey;
    }

    private DynamicObject getEntryData(BeforeSelectChangedContext context, DynamicObject pcEntityData) {
        DynamicObject entryData = null;
        if (StringUtils.isNotBlank((CharSequence)context.getPcEntryName())) {
            DynamicObjectCollection entryDatas = pcEntityData.getDynamicObjectCollection(context.getPcEntryName());
            entryData = (DynamicObject)entryDatas.get(context.getRowIndex());
        }
        return entryData;
    }

    private void selectUnit(BeforeSelectChangedContext context, DynamicObject entryData, List<QFilter> qFilters) {
        BeforeF7SelectEvent evt = context.getBeforeF7SelectEvent();
        String pcMaterialField = this.getICaleFiedMap().getFieldByFixF("materialid");
        DynamicObject materialObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryData, (String)pcMaterialField);
        ControlUtil.unitCheck((BeforeF7SelectEvent)evt, (IFormView)this.getView(), (DynamicObject)materialObj);
    }

    private void selectMaterialCFG(BeforeF7SelectEvent evt, String pcEntityKey, int rowIndex, DynamicObject bill) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        DynamicObject bizTypeObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bill, (String)"biztype");
        if (null == bizTypeObj) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"MobQmcBillBeforeF7Select_0", (String)"qmc-mobqc-business", (Object[])new Object[0]));
            qFilters.add(new QFilter("id", "=", (Object)-1L));
            evt.setCancel(true);
            return;
        }
        Long bizTypeId = bizTypeObj.getLong("id");
        DynamicObject org = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bill, (String)"org");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_inspect_cfg", (Long)org.getLong("id"));
        baseDataFilter.and(new QFilter("entryentity.inspecttype.id", "=", (Object)bizTypeId));
        qFilters.add(baseDataFilter);
    }

    private void beforeTransactypeF7(DynamicObject pcEntityData, ListShowParameter showParameter) {
        DynamicObject bizType = pcEntityData.getDynamicObject("biztype");
        if (Objects.nonNull(bizType)) {
            showParameter.getListFilterParameter().setFilter(new QFilter("biztypeid", "=", bizType.getPkValue()));
        } else {
            showParameter.getListFilterParameter().setFilter(new QFilter("biztypeid", "=", (Object)-1));
        }
    }
}

