/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.mobqc.formplugin.apphome;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.RefreshResultType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.qmc.mobqc.business.helper.OrgHelper;
import kd.qmc.mobqc.business.qmctpl.home.handle.MobQmcHomePageBuilder;
import kd.qmc.mobqc.common.util.DateUtils;
import kd.qmc.mobqc.formplugin.apphome.AppHomeClick;
import kd.scmc.msmob.common.design.homepage.handle.HomePageBuilder;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.common.utils.ScanResultParseUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.home.AbstractMobAppHomeBaseTplPlugin;

public class AppHomePlugin
extends AbstractMobAppHomeBaseTplPlugin {
    private static final String ROUTE_META = "sys.meta";
    private static final String USER_ORG_UNIT = "userOrgUnit";
    private String[] buttons = new String[]{"mobqc_applyqcp_list", "mobqc_inspectqcp_list", "mobqc_joininspqcp_list", "mobqc_baddealqcp_list", "submit_apply_qcp_flex", "submit_inspect_qcp_flex", "linktoagereport", "scan"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.buttons);
    }

    protected HomePageBuilder getHomePageBuilder() {
        return new MobQmcHomePageBuilder(this.getView());
    }

    public void initEntityPermItem() {
    }

    public void refreshData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            this.buildHomePage(orgId);
        }
        ((MobileFormView)this.getView()).setRefreshResult("\u5237\u65b0\u6210\u529f", Integer.valueOf(3000), RefreshResultType.Success);
    }

    public void setToDoBusinessCard(Long orgId) {
        Date startDate = (Date)this.getModel().getValue("todobusiness_startdate");
        Date endDate = (Date)this.getModel().getValue("todobusiness_enddate");
        Label inspApplyQcpLab = (Label)this.getControl("submit_apply_qcp_count");
        Label inspQcpLab = (Label)this.getControl("submit_inspect_qcp_count");
        if (orgId == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"todostatisticsflex"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"todostatisticsflex"});
        ArrayList<String> pcFormKeys = new ArrayList<String>(10);
        pcFormKeys.add("mobqc_applyqcp_list");
        pcFormKeys.add("mobqc_inspectqcp_list");
        Map<String, Boolean> permissionMap = this.checkPermission(orgId);
        if (permissionMap.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"todostatisticsflex"});
            return;
        }
        block8: for (String pcFormKey : pcFormKeys) {
            Boolean permResult = permissionMap.get(pcFormKey);
            switch (pcFormKey) {
                case "mobqc_applyqcp_list": {
                    this.setToDoViewShow(permResult, "mobqc_applyqcp_list");
                    if (permResult == null) break;
                    int billCount = this.getBillCount(orgId, "qcp_inspecapply", startDate, endDate);
                    if (inspApplyQcpLab == null) continue block8;
                    inspApplyQcpLab.setText(billCount + "");
                    break;
                }
                case "mobqc_inspectqcp_list": {
                    this.setToDoViewShow(permResult, "mobqc_inspectqcp_list");
                    if (permResult == null) break;
                    int billCount = this.getBillCount(orgId, "qcp_incominginspct", startDate, endDate);
                    if (inspQcpLab == null) continue block8;
                    inspQcpLab.setText(billCount + "");
                    break;
                }
            }
        }
    }

    public void setAgEndBusinessDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 0);
        Date endDate = calendar.getTime();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        calendar.add(2, -3);
        Date startDate = calendar.getTime();
        this.getModel().setValue("todobusiness_startdate", (Object)startDate);
        this.getModel().setValue("todobusiness_enddate", (Object)endDate);
    }

    public void click(EventObject evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification("\u8bf7\u8f93\u5165\u8d28\u68c0\u7ec4\u7ec7\u3002");
            return;
        }
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String orgNo = org.getString("number");
        Long orgId = org.getLong("id");
        HashMap<String, Object> customParams = new HashMap<String, Object>(3);
        customParams.put("orgBillNo", orgNo);
        customParams.put("orgid", orgId);
        IFormView view = this.getView();
        AppHomeClick appHomeClick = new AppHomeClick(view);
        appHomeClick.click(key, org);
        switch (key) {
            case "submit_apply_qcp_flex": {
                this.openToDoListPage(view, customParams, "mobqc_applyqcp_list");
                break;
            }
            case "submit_inspect_qcp_flex": {
                this.openToDoListPage(view, customParams, "mobqc_inspectqcp_list");
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        IPageCache pageCache = this.getView().getPageCache();
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object codeStr = result.get("qrcode_str");
            String scanKey = pageCache.get("scan_key");
            if ("scan".equals(scanKey)) {
                this.handleScan(codeStr);
            }
        }
    }

    public void handleScan(Object barCode) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org.getLong("id");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "clickScanCallBack");
        ScanResultParseUtils.scanResultParseByType((IFormView)this.getView(), (Object)barCode, (Long)orgId, (CloseCallBack)closeCallBack);
    }

    public Map<String, Boolean> checkPermission(Long org) {
        return new HashMap<String, Boolean>(16);
    }

    public Long setOrg(Long orgId) {
        IDataModel model = this.getModel();
        RequestContext requestContext = RequestContext.get();
        Object org = this.getModel().getValue("org");
        long curOrgId = org == null ? orgId.longValue() : ((Long)((DynamicObject)org).getPkValue()).longValue();
        long userId = requestContext.getCurrUserId();
        List qcPermOrgIdList = OrgHelper.getPermQcOrgIds((long)userId);
        this.getPageCache().put(USER_ORG_UNIT, JSON.toJSONString((Object)qcPermOrgIdList));
        Long qcOrgId = curOrgId;
        if (qcPermOrgIdList.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458\uff01", (String)"AppHomePlugin_0", (String)"qmc-mobqc-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return null;
        }
        DataSet orgFunc = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)ROUTE_META), (String)"SELECT forgfunc FROM t_meta_bizapp where fnumber='mobqc'");
        String type = "06";
        for (Row row : orgFunc) {
            String orgType = row.getString("forgfunc");
            if (!StringUtils.isNotBlank((CharSequence)orgType)) continue;
            type = orgType;
        }
        List qcPermOrgs = OrgUnitServiceHelper.filterOrgDuty((List)qcPermOrgIdList, (String)type);
        if (qcPermOrgs == null || qcPermOrgs.isEmpty()) {
            if (!qcPermOrgIdList.contains(curOrgId)) {
                qcOrgId = (Long)qcPermOrgIdList.get(0);
            }
        } else if (!qcPermOrgs.contains(curOrgId)) {
            qcOrgId = (Long)qcPermOrgs.get(0);
        }
        model.setValue("org", (Object)qcOrgId);
        return qcOrgId;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("clickScanCallBack".equals(actionId)) {
            this.rescan(e);
        }
    }

    public void rescan(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData instanceof String && "rescan".equals(returnData)) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("method", "scanQRCode");
            HashMap<String, Integer> args = new HashMap<String, Integer>(8);
            args.put("needResult", 1);
            map.put("args", args);
            this.getView().executeClientCommand("callYZJApi", new Object[]{map});
        }
    }

    public String getShowBillKey() {
        return "mobqc_commonapp";
    }

    private void openToDoListPage(IFormView view, Map<String, Object> customParams, String mobListFormKey) {
        customParams.put("todoDate", "todoDate");
        PageUtils.showFormPage((IFormView)view, (String)mobListFormKey, customParams, null);
    }

    private void setToDoViewShow(Boolean permResult, String modelKey) {
        switch (modelKey) {
            case "mobqc_applyqcp_list": {
                this.getView().setVisible(permResult, new String[]{"submit_apply_qcp_flex"});
                break;
            }
            case "mobqc_inspectqcp_list": {
                this.getView().setVisible(permResult, new String[]{"submit_inspect_qcp_flex"});
                break;
            }
        }
    }

    private int getBillCount(Long orgId, String entityName, Date startDate, Date endDate) {
        Date custEndDate = DateUtils.getDayEndTime((Date)endDate);
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("billstatus", "=", (Object)"B"));
        qFilter.and(new QFilter("createtime", ">=", (Object)startDate));
        qFilter.and(new QFilter("createtime", "<=", (Object)custEndDate));
        DataSet billCount = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)"id,billno,createtime", (QFilter[])new QFilter[]{qFilter}, null).distinct();
        int count = billCount.count("id", false);
        return count;
    }
}

